/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.SQLException;
import java.util.Map;
import org.mariadb.jdbc.CallParameter;
import org.mariadb.jdbc.CallableProcedureStatement;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.internal.com.read.resultset.SelectResultSet;
import org.mariadb.jdbc.internal.com.send.parameters.NullParameter;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.util.dao.CloneableCallableStatement;
import org.mariadb.jdbc.internal.util.exceptions.ExceptionFactory;

public class MariaDbProcedureStatement
extends CallableProcedureStatement
implements CloneableCallableStatement {
    private SelectResultSet outputResultSet = null;

    public MariaDbProcedureStatement(String query, MariaDbConnection connection, String procedureName, String database, int resultSetType, int resultSetConcurrency, ExceptionFactory exceptionFactory) throws SQLException {
        super(connection, query, resultSetType, resultSetConcurrency, exceptionFactory, database, procedureName);
    }

    private void setInputOutputParameterMap() {
        if (this.outputParameterMapper == null) {
            int len = 0;
            if (this.serverPrepareResult == null) {
                for (Integer key : this.params.keySet()) {
                    if (key + 1 <= len) continue;
                    len = key + 1;
                }
            } else {
                len = this.serverPrepareResult.getParamCount();
            }
            this.outputParameterMapper = new int[len];
            for (int i2 = 0; i2 < this.outputParameterMapper.length; ++i2) {
                this.outputParameterMapper[i2] = -1;
            }
            int currentOutputMapper = 1;
            for (Map.Entry entry : this.params.entrySet()) {
                this.outputParameterMapper[((Integer)entry.getKey()).intValue()] = ((CallParameter)entry.getValue()).isOutput() ? currentOutputMapper++ : -1;
            }
        }
    }

    @Override
    protected SelectResultSet getOutputResult() throws SQLException {
        if (this.outputResultSet == null) {
            if (this.fetchSize != 0) {
                this.results.loadFully(false, this.protocol);
                this.outputResultSet = this.results.getCallableResultSet();
                if (this.outputResultSet != null) {
                    this.outputResultSet.next();
                    return this.outputResultSet;
                }
            }
            throw new SQLException("No output result.");
        }
        return this.outputResultSet;
    }

    @Override
    public MariaDbProcedureStatement clone(MariaDbConnection connection) throws CloneNotSupportedException {
        MariaDbProcedureStatement clone = (MariaDbProcedureStatement)super.clone(connection);
        clone.outputResultSet = null;
        return clone;
    }

    private void retrieveOutputResult() throws SQLException {
        this.outputResultSet = this.results.getCallableResultSet();
        if (this.outputResultSet != null) {
            this.outputResultSet.next();
        }
    }

    @Override
    public void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        if (this.params.containsKey(parameterIndex - 1)) {
            ((CallParameter)this.params.get(parameterIndex - 1)).setInput(true);
        } else {
            CallParameter param = new CallParameter();
            param.setInput(true);
            this.params.put(parameterIndex - 1, param);
        }
        super.setParameter(parameterIndex, holder);
    }

    @Override
    public boolean execute() throws SQLException {
        this.lock.lock();
        try {
            this.validAllParameters();
            super.executeInternal(this.fetchSize);
            this.retrieveOutputResult();
            boolean bl2 = this.results != null && this.results.getResultSet() != null;
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void validAllParameters() throws SQLException {
        this.setInputOutputParameterMap();
        for (Map.Entry entry : this.params.entrySet()) {
            if (((CallParameter)entry.getValue()).isInput()) continue;
            super.setParameter((Integer)entry.getKey() + 1, new NullParameter());
        }
        this.validParameters();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this.hasInOutParameters == null) {
            this.setParametersVariables();
        }
        if (!this.hasInOutParameters.booleanValue()) {
            return super.executeBatch();
        }
        throw new SQLException("executeBatch not permit for procedure with output parameter");
    }
}

