/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.mariadb.jdbc.CallableFunctionStatement;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.internal.com.read.resultset.SelectResultSet;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.util.dao.CloneableCallableStatement;
import org.mariadb.jdbc.internal.util.exceptions.ExceptionFactory;

public class MariaDbFunctionStatement
extends CallableFunctionStatement
implements CloneableCallableStatement {
    private SelectResultSet outputResultSet = null;

    public MariaDbFunctionStatement(MariaDbConnection connection, String databaseName, String functionName, String arguments, int resultSetType, int resultSetConcurrency, ExceptionFactory exceptionFactory) throws SQLException {
        super(connection, "SELECT " + functionName + (arguments == null ? "()" : arguments), resultSetType, resultSetConcurrency, exceptionFactory, databaseName, functionName);
        super.initFunctionData(this.getParameterCount() + 1);
    }

    @Override
    protected SelectResultSet getResult() throws SQLException {
        if (this.outputResultSet == null) {
            throw new SQLException("No output result");
        }
        return this.outputResultSet;
    }

    @Override
    public MariaDbFunctionStatement clone(MariaDbConnection connection) throws CloneNotSupportedException {
        MariaDbFunctionStatement clone = (MariaDbFunctionStatement)super.clone(connection);
        clone.outputResultSet = null;
        return clone;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.lock.lock();
        try {
            super.execute();
            this.retrieveOutputResult();
            if (this.results != null && this.results.getResultSet() == null) {
                int n2 = 0;
                return n2;
            }
            int n3 = this.getUpdateCount();
            return n3;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void retrieveOutputResult() throws SQLException {
        this.outputResultSet = this.results.getResultSet();
        if (this.outputResultSet != null) {
            this.outputResultSet.next();
        }
    }

    @Override
    public void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        super.setParameter(parameterIndex - 1, holder);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.lock.lock();
        try {
            super.execute();
            this.retrieveOutputResult();
            if (this.results != null && this.results.getResultSet() == null) {
                SelectResultSet selectResultSet = this.results.getResultSet();
                return selectResultSet;
            }
            SelectResultSet selectResultSet = SelectResultSet.createEmptyResultSet();
            return selectResultSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.lock.lock();
        try {
            super.execute();
            this.retrieveOutputResult();
            boolean bl2 = this.results != null && this.results.getResultSet() == null;
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }
}

