/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.tools;

public class MessageUtil {
    public static String unescapeUnicode(String message) {
        StringBuffer sb = new StringBuffer();
        if (message == null) {
            return null;
        }
        int sz = message.length();
        StringBuffer unicode = new StringBuffer(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i2 = 0; i2 < sz; ++i2) {
            char ch = message.charAt(i2);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    sb.append((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Unable to parse Unicode value: " + unicode);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                if (ch == 'u') {
                    inUnicode = true;
                    continue;
                }
                sb.append(ch);
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String filterNonPrintableCharacters(String text) {
        int len = text.length();
        StringBuffer sb = new StringBuffer(len);
        for (int i2 = 0; i2 < len; ++i2) {
            char ch = text.charAt(i2);
            if (ch < ' ' || ch == '\u007f') {
                sb.append(' ');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

