/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.tools;

import org.krysalis.barcode4j.tools.UnitConv;

public class Length {
    public static final String INCH = "in";
    public static final String POINT = "pt";
    public static final String CM = "cm";
    public static final String MM = "mm";
    private double value;
    private String unit;

    public Length(double value, String unit) {
        this.value = value;
        this.unit = unit.toLowerCase();
    }

    public Length(String text, String defaultUnit) {
        this.parse(text, defaultUnit);
    }

    public Length(String text) {
        this(text, null);
    }

    protected void parse(String text, String defaultUnit) {
        String s2 = text.trim();
        if (s2.length() == 0) {
            throw new IllegalArgumentException("Length is empty");
        }
        StringBuffer sb = new StringBuffer(s2.length());
        int mode = 0;
        int i2 = 0;
        while (i2 < s2.length()) {
            char c2 = s2.charAt(i2);
            if (mode == 0) {
                if (Character.isDigit(c2) || c2 == '.' || c2 == ',') {
                    if (c2 == ',') {
                        c2 = '.';
                    }
                    sb.append(c2);
                    ++i2;
                    continue;
                }
                this.value = Double.parseDouble(sb.toString());
                sb.setLength(0);
                mode = 1;
                continue;
            }
            if (mode == 1) {
                if (Character.isWhitespace(c2)) {
                    ++i2;
                    continue;
                }
                mode = 2;
                continue;
            }
            if (mode != 2) continue;
            if (Character.isWhitespace(c2)) break;
            sb.append(c2);
            ++i2;
        }
        if (mode == 0) {
            this.value = Double.parseDouble(sb.toString());
            mode = 1;
        }
        if (mode != 2) {
            if (mode > 0 && defaultUnit != null) {
                this.unit = defaultUnit.toLowerCase();
                return;
            }
            throw new IllegalArgumentException("Invalid length specified. Expected '<value> <unit>' (ex. 1.7mm) but got: " + text);
        }
        this.unit = sb.toString().toLowerCase();
    }

    public String getUnit() {
        return this.unit;
    }

    public double getValue() {
        return this.value;
    }

    public double getValueAsMillimeter() {
        if (this.unit.equals(MM)) {
            return this.value;
        }
        if (this.unit.equals(CM)) {
            return this.value * 10.0;
        }
        if (this.unit.equals(POINT)) {
            return UnitConv.pt2mm(this.value);
        }
        if (this.unit.equals(INCH)) {
            return UnitConv.in2mm(this.value);
        }
        throw new IllegalStateException("Don't know how to convert " + this.unit + " to mm");
    }

    public String toString() {
        return this.getValue() + this.getUnit();
    }
}

