/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.upcean;

import org.krysalis.barcode4j.BarGroup;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.ClassicBarcodeLogicHandler;
import org.krysalis.barcode4j.impl.upcean.UPCEANLogicImpl;

public class UPCALogicImpl
extends UPCEANLogicImpl {
    public UPCALogicImpl(ChecksumMode mode) {
        super(mode);
    }

    public static void validateMessage(String msg) {
        UPCEANLogicImpl.validateMessage(msg);
        if (msg.length() < 11 || msg.length() > 12) {
            throw new IllegalArgumentException("Message must be 11 or 12 characters long. Message: " + msg);
        }
    }

    public static String handleChecksum(String msg, ChecksumMode mode) {
        if (mode == ChecksumMode.CP_AUTO) {
            if (msg.length() == 11) {
                mode = ChecksumMode.CP_ADD;
            } else if (msg.length() == 12) {
                mode = ChecksumMode.CP_CHECK;
            } else {
                throw new RuntimeException("Internal error");
            }
        }
        if (mode == ChecksumMode.CP_ADD) {
            if (msg.length() != 11) {
                throw new IllegalArgumentException("Message must be 11 characters long");
            }
            return msg + UPCALogicImpl.calcChecksum(msg);
        }
        if (mode == ChecksumMode.CP_CHECK) {
            char expected;
            if (msg.length() != 12) {
                throw new IllegalArgumentException("Message must be 12 characters long");
            }
            char check = msg.charAt(11);
            if (check != (expected = UPCALogicImpl.calcChecksum(msg.substring(0, 11)))) {
                throw new IllegalArgumentException("Checksum is bad (" + check + "). Expected: " + expected);
            }
            return msg;
        }
        if (mode == ChecksumMode.CP_IGNORE) {
            if (msg.length() != 12) {
                throw new IllegalArgumentException("Message must be 12 characters long");
            }
            return msg;
        }
        throw new UnsupportedOperationException("Unknown checksum mode: " + mode);
    }

    private String handleChecksum(String msg) {
        return UPCALogicImpl.handleChecksum(msg, this.getChecksumMode());
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler logic, String msg) {
        int i2;
        String supp = UPCALogicImpl.retrieveSupplemental(msg);
        String s2 = UPCALogicImpl.removeSupplemental(msg);
        UPCALogicImpl.validateMessage(s2);
        String canonicalMessage = s2 = this.handleChecksum(s2);
        if (supp != null) {
            canonicalMessage = canonicalMessage + "+" + supp;
        }
        logic.startBarcode(canonicalMessage, canonicalMessage);
        this.drawSideGuard(logic);
        char lead = s2.charAt(0);
        logic.startBarGroup(BarGroup.UPC_EAN_LEAD, new Character(lead).toString());
        this.encodeChar(logic, lead, 0);
        logic.endBarGroup();
        logic.startBarGroup(BarGroup.UPC_EAN_GROUP, s2.substring(1, 6));
        for (i2 = 1; i2 < 6; ++i2) {
            this.encodeChar(logic, s2.charAt(i2), 0);
        }
        logic.endBarGroup();
        this.drawCenterGuard(logic);
        logic.startBarGroup(BarGroup.UPC_EAN_GROUP, s2.substring(6, 11));
        for (i2 = 6; i2 < 11; ++i2) {
            this.encodeChar(logic, s2.charAt(i2), 2);
        }
        logic.endBarGroup();
        char check = s2.charAt(11);
        logic.startBarGroup(BarGroup.UPC_EAN_CHECK, new Character(check).toString());
        this.encodeChar(logic, check, 2);
        logic.endBarGroup();
        this.drawSideGuard(logic);
        if (supp != null) {
            this.drawSupplemental(logic, supp);
        }
        logic.endBarcode();
    }
}

