/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.upcean;

import org.krysalis.barcode4j.BarGroup;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.ClassicBarcodeLogicHandler;
import org.krysalis.barcode4j.impl.upcean.UPCEANLogicImpl;

public class EAN8LogicImpl
extends UPCEANLogicImpl {
    public EAN8LogicImpl(ChecksumMode mode) {
        super(mode);
    }

    public static void validateMessage(String msg) {
        UPCEANLogicImpl.validateMessage(msg);
        if (msg.length() < 7 || msg.length() > 8) {
            throw new IllegalArgumentException("Message must be 7 or 8 characters long. Message: " + msg);
        }
    }

    private String handleChecksum(String msg) {
        ChecksumMode mode = this.getChecksumMode();
        if (mode == ChecksumMode.CP_AUTO) {
            if (msg.length() == 7) {
                mode = ChecksumMode.CP_ADD;
            } else if (msg.length() == 8) {
                mode = ChecksumMode.CP_CHECK;
            } else {
                throw new RuntimeException("Internal error");
            }
        }
        if (mode == ChecksumMode.CP_ADD) {
            if (msg.length() > 7) {
                throw new IllegalArgumentException("Message is too long (max. 7 characters)");
            }
            if (msg.length() < 7) {
                throw new IllegalArgumentException("Message must be 7 characters long");
            }
            return msg + EAN8LogicImpl.calcChecksum(msg);
        }
        if (mode == ChecksumMode.CP_CHECK) {
            char expected;
            if (msg.length() > 8) {
                throw new IllegalArgumentException("Message is too long (max. 8 characters)");
            }
            if (msg.length() < 8) {
                throw new IllegalArgumentException("Message must be 8 characters long");
            }
            char check = msg.charAt(7);
            if (check != (expected = EAN8LogicImpl.calcChecksum(msg.substring(0, 7)))) {
                throw new IllegalArgumentException("Checksum is bad (" + check + "). Expected: " + expected);
            }
            return msg;
        }
        if (mode == ChecksumMode.CP_IGNORE) {
            return msg;
        }
        throw new UnsupportedOperationException("Unknown checksum mode: " + mode);
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler logic, String msg) {
        int i2;
        String supp = EAN8LogicImpl.retrieveSupplemental(msg);
        String s2 = EAN8LogicImpl.removeSupplemental(msg);
        EAN8LogicImpl.validateMessage(s2);
        String canonicalMessage = s2 = this.handleChecksum(s2);
        if (supp != null) {
            canonicalMessage = canonicalMessage + "+" + supp;
        }
        logic.startBarcode(canonicalMessage, canonicalMessage);
        this.drawSideGuard(logic);
        logic.startBarGroup(BarGroup.UPC_EAN_GROUP, s2.substring(0, 4));
        for (i2 = 0; i2 < 4; ++i2) {
            this.encodeChar(logic, s2.charAt(i2), 0);
        }
        logic.endBarGroup();
        this.drawCenterGuard(logic);
        logic.startBarGroup(BarGroup.UPC_EAN_GROUP, s2.substring(4, 8));
        for (i2 = 4; i2 < 7; ++i2) {
            this.encodeChar(logic, s2.charAt(i2), 2);
        }
        char check = s2.charAt(7);
        logic.startBarGroup(BarGroup.UPC_EAN_CHECK, new Character(check).toString());
        this.encodeChar(logic, check, 2);
        logic.endBarGroup();
        logic.endBarGroup();
        this.drawSideGuard(logic);
        if (supp != null) {
            this.drawSupplemental(logic, supp);
        }
        logic.endBarcode();
    }
}

