/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.postnet;

import org.krysalis.barcode4j.BarGroup;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.ClassicBarcodeLogicHandler;

public class POSTNETLogicImpl {
    private static final byte[][] CHARSET = new byte[][]{{2, 2, 1, 1, 1}, {1, 1, 1, 2, 2}, {1, 1, 2, 1, 2}, {1, 1, 2, 2, 1}, {1, 2, 1, 1, 2}, {1, 2, 1, 2, 1}, {1, 2, 2, 1, 1}, {2, 1, 1, 1, 2}, {2, 1, 1, 2, 1}, {2, 1, 2, 1, 1}};
    private static final char DASH = '-';
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private boolean displayChecksum = false;

    public POSTNETLogicImpl(ChecksumMode mode, boolean displayChecksum) {
        this.checksumMode = mode;
        this.displayChecksum = displayChecksum;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public static char calcChecksum(String msg) {
        int tmp = 0;
        for (int i2 = 0; i2 < msg.length(); ++i2) {
            if (POSTNETLogicImpl.isIgnoredChar(msg.charAt(i2)) || (tmp += Character.digit(msg.charAt(i2), 10)) <= 9) continue;
            tmp -= 10;
        }
        return Character.forDigit((10 - tmp) % 10, 10);
    }

    public static boolean validateChecksum(String msg) {
        char expected;
        char actual = msg.charAt(msg.length() - 1);
        return actual == (expected = POSTNETLogicImpl.calcChecksum(msg.substring(0, msg.length() - 1)));
    }

    private static boolean isValidChar(char ch) {
        return Character.isDigit(ch) || POSTNETLogicImpl.isIgnoredChar(ch);
    }

    public static boolean isIgnoredChar(char c2) {
        return c2 == '-';
    }

    public static String removeIgnoredCharacters(String msg) {
        StringBuffer sb = new StringBuffer(msg.length());
        for (int i2 = 0; i2 < msg.length(); ++i2) {
            char ch = msg.charAt(i2);
            if (!POSTNETLogicImpl.isValidChar(ch)) {
                throw new IllegalArgumentException("Invalid character: " + ch);
            }
            if (POSTNETLogicImpl.isIgnoredChar(ch)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    private int heightAt(char ch, int index) {
        int chidx = Character.digit(ch, 10);
        if (chidx >= 0) {
            byte height = CHARSET[chidx][index];
            return height;
        }
        throw new IllegalArgumentException("Invalid character: " + ch);
    }

    protected void encodeChar(ClassicBarcodeLogicHandler logic, char c2) {
        if (POSTNETLogicImpl.isIgnoredChar(c2)) {
            return;
        }
        logic.startBarGroup(BarGroup.MSG_CHARACTER, new Character(c2).toString());
        for (int i2 = 0; i2 < 5; i2 = (int)((byte)(i2 + 1))) {
            int height = this.heightAt(c2, i2);
            logic.addBar(true, height);
            this.addIntercharacterGap(logic);
        }
        logic.endBarGroup();
    }

    private void addIntercharacterGap(ClassicBarcodeLogicHandler logic) {
        logic.addBar(false, -1);
    }

    private String handleChecksum(StringBuffer sb) {
        if (this.getChecksumMode() == ChecksumMode.CP_ADD) {
            if (this.displayChecksum) {
                sb.append(POSTNETLogicImpl.calcChecksum(sb.toString()));
                return sb.toString();
            }
            String msg = sb.toString();
            sb.append(POSTNETLogicImpl.calcChecksum(msg));
            return msg;
        }
        if (this.getChecksumMode() == ChecksumMode.CP_CHECK) {
            if (!POSTNETLogicImpl.validateChecksum(sb.toString())) {
                throw new IllegalArgumentException("Message '" + sb.toString() + "' has a bad checksum. Expected: " + POSTNETLogicImpl.calcChecksum(sb.substring(0, sb.length() - 1)));
            }
            if (this.displayChecksum) {
                return sb.toString();
            }
            return sb.substring(0, sb.length() - 1);
        }
        if (this.getChecksumMode() == ChecksumMode.CP_IGNORE) {
            return sb.toString();
        }
        if (this.getChecksumMode() == ChecksumMode.CP_AUTO) {
            return sb.toString();
        }
        throw new UnsupportedOperationException("Unknown checksum mode: " + this.getChecksumMode());
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler logic, String msg) {
        StringBuffer sb = new StringBuffer(msg);
        String formattedMsg = this.handleChecksum(sb);
        logic.startBarcode(sb.toString(), formattedMsg);
        logic.addBar(true, 2);
        this.addIntercharacterGap(logic);
        for (int i2 = 0; i2 < sb.length(); ++i2) {
            char ch = sb.charAt(i2);
            if (!POSTNETLogicImpl.isValidChar(ch)) {
                throw new IllegalArgumentException("Invalid character: " + ch);
            }
            this.encodeChar(logic, ch);
        }
        logic.addBar(true, 2);
        logic.endBarcode();
    }
}

