/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.datamatrix;

import java.awt.Dimension;
import org.krysalis.barcode4j.impl.datamatrix.SymbolShapeHint;

public class DataMatrixSymbolInfo {
    public static final DataMatrixSymbolInfo[] PROD_SYMBOLS = new DataMatrixSymbolInfo[]{new DataMatrixSymbolInfo(false, 3, 5, 8, 8, 1), new DataMatrixSymbolInfo(false, 5, 7, 10, 10, 1), new DataMatrixSymbolInfo(true, 5, 7, 16, 6, 1), new DataMatrixSymbolInfo(false, 8, 10, 12, 12, 1), new DataMatrixSymbolInfo(true, 10, 11, 14, 6, 2), new DataMatrixSymbolInfo(false, 12, 12, 14, 14, 1), new DataMatrixSymbolInfo(true, 16, 14, 24, 10, 1), new DataMatrixSymbolInfo(false, 18, 14, 16, 16, 1), new DataMatrixSymbolInfo(false, 22, 18, 18, 18, 1), new DataMatrixSymbolInfo(true, 22, 18, 16, 10, 2), new DataMatrixSymbolInfo(false, 30, 20, 20, 20, 1), new DataMatrixSymbolInfo(true, 32, 24, 16, 14, 2), new DataMatrixSymbolInfo(false, 36, 24, 22, 22, 1), new DataMatrixSymbolInfo(false, 44, 28, 24, 24, 1), new DataMatrixSymbolInfo(true, 49, 28, 22, 14, 2), new DataMatrixSymbolInfo(false, 62, 36, 14, 14, 4), new DataMatrixSymbolInfo(false, 86, 42, 16, 16, 4), new DataMatrixSymbolInfo(false, 114, 48, 18, 18, 4), new DataMatrixSymbolInfo(false, 144, 56, 20, 20, 4), new DataMatrixSymbolInfo(false, 174, 68, 22, 22, 4), new DataMatrixSymbolInfo(false, 204, 84, 24, 24, 4, 102, 42), new DataMatrixSymbolInfo(false, 280, 112, 14, 14, 16, 140, 56), new DataMatrixSymbolInfo(false, 368, 144, 16, 16, 16, 92, 36), new DataMatrixSymbolInfo(false, 456, 192, 18, 18, 16, 114, 48), new DataMatrixSymbolInfo(false, 576, 224, 20, 20, 16, 144, 56), new DataMatrixSymbolInfo(false, 696, 272, 22, 22, 16, 174, 68), new DataMatrixSymbolInfo(false, 816, 336, 24, 24, 16, 136, 56), new DataMatrixSymbolInfo(false, 1050, 408, 18, 18, 36, 175, 68), new DataMatrixSymbolInfo(false, 1304, 496, 20, 20, 36, 163, 62), new DataMatrixSymbolInfo144()};
    private static DataMatrixSymbolInfo[] symbols = PROD_SYMBOLS;
    public boolean rectangular;
    public int dataCapacity;
    public int errorCodewords;
    public int matrixWidth;
    public int matrixHeight;
    public int dataRegions;
    public int rsBlockData;
    public int rsBlockError;

    public static void overrideSymbolSet(DataMatrixSymbolInfo[] override) {
        symbols = override;
    }

    public DataMatrixSymbolInfo(boolean rectangular, int dataCapacity, int errorCodewords, int matrixWidth, int matrixHeight, int dataRegions) {
        this(rectangular, dataCapacity, errorCodewords, matrixWidth, matrixHeight, dataRegions, dataCapacity, errorCodewords);
    }

    public DataMatrixSymbolInfo(boolean rectangular, int dataCapacity, int errorCodewords, int matrixWidth, int matrixHeight, int dataRegions, int rsBlockData, int rsBlockError) {
        this.rectangular = rectangular;
        this.dataCapacity = dataCapacity;
        this.errorCodewords = errorCodewords;
        this.matrixWidth = matrixWidth;
        this.matrixHeight = matrixHeight;
        this.dataRegions = dataRegions;
        this.rsBlockData = rsBlockData;
        this.rsBlockError = rsBlockError;
    }

    public static DataMatrixSymbolInfo lookup(int dataCodewords) {
        return DataMatrixSymbolInfo.lookup(dataCodewords, SymbolShapeHint.FORCE_NONE, true);
    }

    public static DataMatrixSymbolInfo lookup(int dataCodewords, SymbolShapeHint shape) {
        return DataMatrixSymbolInfo.lookup(dataCodewords, shape, true);
    }

    public static DataMatrixSymbolInfo lookup(int dataCodewords, boolean allowRectangular, boolean fail) {
        SymbolShapeHint shape = allowRectangular ? SymbolShapeHint.FORCE_NONE : SymbolShapeHint.FORCE_SQUARE;
        return DataMatrixSymbolInfo.lookup(dataCodewords, shape, fail);
    }

    public static DataMatrixSymbolInfo lookup(int dataCodewords, SymbolShapeHint shape, boolean fail) {
        return DataMatrixSymbolInfo.lookup(dataCodewords, shape, null, null, fail);
    }

    public static DataMatrixSymbolInfo lookup(int dataCodewords, SymbolShapeHint shape, Dimension minSize, Dimension maxSize, boolean fail) {
        int c2 = symbols.length;
        for (int i2 = 0; i2 < c2; ++i2) {
            DataMatrixSymbolInfo symbol = symbols[i2];
            if (shape == SymbolShapeHint.FORCE_SQUARE && symbol.rectangular || shape == SymbolShapeHint.FORCE_RECTANGLE && !symbol.rectangular || minSize != null && (symbol.getSymbolWidth() < minSize.width || symbol.getSymbolHeight() < minSize.height) || maxSize != null && (symbol.getSymbolWidth() > maxSize.width || symbol.getSymbolHeight() > maxSize.height) || dataCodewords > symbol.dataCapacity) continue;
            return symbol;
        }
        if (fail) {
            throw new IllegalArgumentException("Can't find a symbol arrangement that matches the message. Data codewords: " + dataCodewords);
        }
        return null;
    }

    public int getHorzDataRegions() {
        switch (this.dataRegions) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 2;
            }
            case 16: {
                return 4;
            }
            case 36: {
                return 6;
            }
        }
        throw new IllegalStateException("Cannot handle this number of data regions");
    }

    public int getVertDataRegions() {
        switch (this.dataRegions) {
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 16: {
                return 4;
            }
            case 36: {
                return 6;
            }
        }
        throw new IllegalStateException("Cannot handle this number of data regions");
    }

    public int getSymbolDataWidth() {
        return this.getHorzDataRegions() * this.matrixWidth;
    }

    public int getSymbolDataHeight() {
        return this.getVertDataRegions() * this.matrixHeight;
    }

    public int getSymbolWidth() {
        return this.getSymbolDataWidth() + this.getHorzDataRegions() * 2;
    }

    public int getSymbolHeight() {
        return this.getSymbolDataHeight() + this.getVertDataRegions() * 2;
    }

    public int getCodewordCount() {
        return this.dataCapacity + this.errorCodewords;
    }

    public int getInterleavedBlockCount() {
        return this.dataCapacity / this.rsBlockData;
    }

    public int getDataLengthForInterleavedBlock(int index) {
        return this.rsBlockData;
    }

    public int getErrorLengthForInterleavedBlock(int index) {
        return this.rsBlockError;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.rectangular ? "Rectangular Symbol:" : "Square Symbol:");
        sb.append(" data region " + this.matrixWidth + "x" + this.matrixHeight);
        sb.append(", symbol size " + this.getSymbolWidth() + "x" + this.getSymbolHeight());
        sb.append(", symbol data size " + this.getSymbolDataWidth() + "x" + this.getSymbolDataHeight());
        sb.append(", codewords " + this.dataCapacity + "+" + this.errorCodewords);
        return sb.toString();
    }

    private static class DataMatrixSymbolInfo144
    extends DataMatrixSymbolInfo {
        public DataMatrixSymbolInfo144() {
            super(false, 1558, 620, 22, 22, 36);
            this.rsBlockData = -1;
            this.rsBlockError = 62;
        }

        public int getInterleavedBlockCount() {
            return 10;
        }

        public int getDataLengthForInterleavedBlock(int index) {
            return index <= 8 ? 156 : 155;
        }
    }
}

