/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.code128;

import java.util.StringTokenizer;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.ClassicBarcodeLogicHandler;
import org.krysalis.barcode4j.impl.code128.CheckDigit;
import org.krysalis.barcode4j.impl.code128.Code128LogicImpl;
import org.krysalis.barcode4j.impl.code128.DefaultCode128Encoder;
import org.krysalis.barcode4j.impl.code128.EAN128AI;

public class EAN128LogicImpl {
    private static final byte MAX_LENGTH = 48;
    private static final byte TYPENumTestCheckDigit = 4;
    private static final byte TYPENumReplaceCheckDigit = 5;
    private static final byte TYPENumAddCheckDigit = 6;
    private EAN128AI[] ais = null;
    private char groupSeparator = (char)29;
    private char checkDigitMarker = (char)240;
    private boolean omitBrackets = false;
    private String msgCache = null;
    private StringBuffer code128Msg = new StringBuffer(48);
    private StringBuffer humanReadableMsg = new StringBuffer(48);
    private int[] encodedMsg = new int[0];
    private IllegalArgumentException exception = null;
    private boolean checksumADD = true;
    private boolean checksumCHECK = true;

    public EAN128LogicImpl(ChecksumMode mode, String template, char fnc1) {
        this.setChecksumMode(mode);
        this.setTemplate(template);
        this.groupSeparator = fnc1;
    }

    public EAN128LogicImpl(ChecksumMode mode, String template) {
        this.setChecksumMode(mode);
        this.setTemplate(template);
    }

    protected void setMessage(String msg) {
        if (msg == null || !msg.equals(this.msgCache)) {
            this.code128Msg.setLength(0);
            this.humanReadableMsg.setLength(0);
            this.exception = null;
            if (msg == null) {
                this.msgCache = null;
            } else {
                this.msgCache = msg;
                this.code128Msg.append('\u00f1');
                this.addAIs(msg);
                DefaultCode128Encoder encoder = new DefaultCode128Encoder();
                this.encodedMsg = encoder.encode(this.getCode128Msg());
            }
        } else if (this.exception != null) {
            throw this.exception;
        }
    }

    public String getMessage() {
        return this.msgCache;
    }

    public int[] getEncodedMessage(String msg) {
        this.setMessage(msg);
        return this.encodedMsg;
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler logic, String msg) {
        this.setMessage(msg);
        Code128LogicImpl c128 = new Code128LogicImpl();
        logic.startBarcode(msg, this.getHumanReadableMsg());
        for (int i2 = 0; i2 < this.encodedMsg.length; ++i2) {
            c128.encodeChar(logic, this.encodedMsg[i2]);
        }
        int checksum = this.encodedMsg[0];
        for (int i3 = 1; i3 < this.encodedMsg.length; ++i3) {
            checksum += i3 * this.encodedMsg[i3];
        }
        c128.encodeChar(logic, checksum %= 103);
        c128.encodeStop(logic);
        logic.endBarcode();
    }

    public void addAIs(String msg) {
        int offset = 0;
        int i2 = 0;
        EAN128AI ai2 = null;
        while (offset < msg.length()) {
            if (this.ais == null) {
                ai2 = null;
            } else {
                try {
                    ai2 = this.ais[i2++];
                }
                catch (IndexOutOfBoundsException e2) {
                    throw this.getException("Message has more AIs than template (template has " + this.ais.length + ")");
                }
            }
            offset = this.addAI(msg, offset, ai2);
        }
    }

    private int findGroupSeparator(String msg, int start) {
        int retGS = msg.indexOf(this.groupSeparator, start);
        if (this.groupSeparator == '\u00f1') {
            return retGS;
        }
        int retF = msg.indexOf(241, start);
        if (retGS <= 0) {
            return retF;
        }
        if (retF <= 0) {
            return retGS;
        }
        return Math.min(retGS, retF);
    }

    public int addAI(String msg, int offset, EAN128AI ai2) {
        if (msg == null) {
            throw this.getException("Message is empty!");
        }
        try {
            if (ai2 == null) {
                ai2 = EAN128AI.getAI(msg, offset);
            }
        }
        catch (Exception e2) {
            throw this.getException(e2.getMessage());
        }
        byte lenID = ai2.lenID;
        byte lenMin = ai2.lenMinAll;
        byte lenMax = ai2.lenMaxAll;
        if (!this.omitBrackets) {
            this.humanReadableMsg.append('(');
        }
        this.humanReadableMsg.append(msg.substring(offset, offset + lenID));
        this.code128Msg.append(msg.substring(offset, offset + lenID));
        if (!this.omitBrackets) {
            this.humanReadableMsg.append(')');
        }
        boolean doChecksumADD = false;
        int[] startA = new int[ai2.type.length + 1];
        startA[0] = offset;
        int newOffset = this.findGroupSeparator(msg, offset);
        if (newOffset < 0) {
            newOffset = msg.length();
        }
        if (newOffset < offset + lenID + lenMin) {
            if (this.checksumADD && ai2.canDoChecksumADD && newOffset == offset + lenID + lenMin - 1) {
                doChecksumADD = true;
            } else {
                if ((ai2.fixed || lenMin == lenMax) && newOffset < msg.length()) {
                    throw this.getException("FNC1 not allowed in fixed length field: \"" + msg.substring(offset + lenID, Math.min(msg.length(), offset + lenID + lenMax)) + "\"!");
                }
                throw this.getException("Field \"" + msg.substring(offset + lenID, newOffset) + "\" too short! Length should be " + lenMin + " at least!");
            }
        }
        if (newOffset > offset + lenID + lenMax) {
            if (ai2.fixed || lenMin == lenMax) {
                newOffset = offset + lenID + lenMax;
            } else {
                throw this.getException("Variable length field \"" + msg.substring(offset + lenID, newOffset) + "\" too long! Length should be " + lenMax + " at the most!");
            }
        }
        int start = offset + lenID;
        for (byte i2 = 0; i2 < ai2.type.length; i2 = (byte)(i2 + 1)) {
            startA[i2 + 1] = start;
            int end = ai2.lenMin[i2] == ai2.lenMax[i2] ? start + ai2.lenMin[i2] : newOffset - ai2.minLenAfterVariableLen;
            if (doChecksumADD && i2 == ai2.type.length - 1) {
                char c2 = CheckDigit.calcCheckdigit(msg, startA[ai2.checkDigitStart[i2]], start, (byte)1);
                this.humanReadableMsg.append(c2);
                this.code128Msg.append(c2);
                if (newOffset < msg.length() && this.isGroupSeparator(msg.charAt(newOffset))) {
                    ++newOffset;
                }
            } else {
                this.checkType(ai2, i2, msg, start, end, startA[ai2.checkDigitStart[i2]]);
            }
            start = end;
        }
        if (newOffset < msg.length() && this.isGroupSeparator(msg.charAt(newOffset))) {
            ++newOffset;
        }
        if (!ai2.fixed && newOffset < msg.length()) {
            this.code128Msg.append('\u00f1');
        }
        return newOffset;
    }

    private boolean isGroupSeparator(char ch) {
        return ch == this.groupSeparator || ch == '\u00f1';
    }

    private void checkType(EAN128AI ai2, byte idx, String msg, int start, int end, int cdStart) {
        byte type = ai2.type[idx];
        if (type == 4) {
            throw this.getException("This AI is not allowed by configuration! (" + ai2.toString() + ")");
        }
        if (type == 2) {
            for (int i2 = end - 1; i2 >= start; --i2) {
                if (msg.charAt(i2) <= '\u0080' && !Character.isDigit(msg.charAt(i2))) continue;
                throw this.getException("Character '" + msg.charAt(i2) + "' must be a valid ASCII byte but not number!", msg.substring(start, i2));
            }
        } else if (type == 0) {
            for (int i3 = end - 1; i3 >= start; --i3) {
                if (msg.charAt(i3) <= '\u0080') continue;
                throw this.getException("Character '" + msg.charAt(i3) + "' must be a valid ASCII byte!", msg.substring(start, i3));
            }
        } else {
            if (ai2.isCheckDigit(idx) && this.checksumCHECK) {
                char cd1 = CheckDigit.calcCheckdigit(msg, cdStart, start, (byte)1);
                char cd2 = msg.charAt(start);
                if (cd2 == this.checkDigitMarker) {
                    cd2 = cd1;
                }
                if (cd1 != cd2) {
                    throw this.getException("Checkdigit is wrong! Correct is " + cd1 + " but I found " + cd2 + "!");
                }
                this.humanReadableMsg.append(cd1);
                this.code128Msg.append(cd1);
                return;
            }
            for (int i4 = end - 1; i4 >= start; --i4) {
                if (Character.isDigit(msg.charAt(i4))) continue;
                throw this.getException("Character '" + msg.charAt(i4) + "' must be a Digit!", msg.substring(start, i4));
            }
            if (type == 3) {
                char cm1 = msg.charAt(start + 2);
                char cm2 = msg.charAt(start + 3);
                char cd1 = msg.charAt(start + 4);
                char cd2 = msg.charAt(start + 5);
                if (cm1 == '0' && cm2 == '0' || cm1 == '1' && cm2 > '2' || cm1 > '1') {
                    throw this.getException("Illegal Month \"" + cm1 + cm2 + "\"!", msg.substring(start, start + 2));
                }
                if (cd1 == '3' && cd2 > '1' || cd1 > '3') {
                    throw this.getException("Illegal Day \"" + cd1 + cd2 + "\"!", msg.substring(start, start + 4));
                }
            }
        }
        this.humanReadableMsg.append(msg.substring(start, end));
        this.code128Msg.append(msg.substring(start, end));
    }

    private char getIDChar(String msg, int offset) {
        char ret;
        try {
            ret = msg.charAt(offset);
        }
        catch (Exception e2) {
            throw this.getException("Unable to read last ID: Message too short!");
        }
        if (!Character.isDigit(ret)) {
            throw this.getException("Unable to read last ID: Characters must be numerical!");
        }
        return ret;
    }

    private IllegalArgumentException getException(String text) {
        return this.getException(text, "");
    }

    private IllegalArgumentException getException(String text, String msgOk) {
        if (msgOk == null) {
            msgOk = "";
        }
        if (this.humanReadableMsg.length() > 1 || msgOk.length() > 0) {
            text = text + " Accepted start of Message: \"" + this.humanReadableMsg.toString() + msgOk + "\"";
        }
        this.exception = new IllegalArgumentException(text);
        return this.exception;
    }

    public String getCode128Msg() {
        return this.code128Msg.toString();
    }

    public String getHumanReadableMsg() {
        return this.humanReadableMsg.toString();
    }

    public String toString() {
        return this.getHumanReadableMsg();
    }

    public void setChecksumMode(ChecksumMode mode) {
        if (mode == ChecksumMode.CP_AUTO) {
            this.checksumADD = true;
            this.checksumCHECK = true;
        } else if (mode == ChecksumMode.CP_ADD) {
            this.checksumADD = true;
            this.checksumCHECK = false;
        } else if (mode == ChecksumMode.CP_CHECK) {
            this.checksumADD = false;
            this.checksumCHECK = false;
        } else {
            this.checksumADD = false;
            this.checksumCHECK = false;
            throw new RuntimeException("Internal error");
        }
    }

    public char getGroupSeparator() {
        return this.groupSeparator;
    }

    public void setGroupSeparator(char c2) {
        this.groupSeparator = c2;
    }

    public void setTemplate(String string) {
        EAN128AI[] newTemplates = null;
        if (string == null || string.trim().length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(string, "()", false);
        int count = st.countTokens();
        if (count % 2 != 0) {
            throw new IllegalArgumentException("Cannot parse template: \"" + string);
        }
        newTemplates = new EAN128AI[count /= 2];
        for (int i2 = 0; i2 < count; ++i2) {
            newTemplates[i2] = EAN128AI.parseSpec(st.nextToken(), st.nextToken());
        }
        this.ais = newTemplates;
    }

    public char getCheckDigitMarker() {
        return this.checkDigitMarker;
    }

    public void setCheckDigitMarker(char c2) {
        this.checkDigitMarker = c2;
    }

    public boolean isOmitBrackets() {
        return this.omitBrackets;
    }

    public void setOmitBrackets(boolean b2) {
        this.omitBrackets = b2;
    }
}

