/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.code128;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class EAN128AI {
    public static final byte CONSTLenMax = 48;
    public static final byte TYPEAlphaNum = 0;
    public static final byte TYPENum = 1;
    public static final byte TYPEAlpha = 2;
    public static final byte TYPENumDate = 3;
    public static final byte TYPEError = 4;
    public static final byte TYPECD = 5;
    private static final String[] typeToString;
    String id;
    byte lenID;
    byte lenMinAll;
    byte lenMaxAll;
    byte minLenAfterVariableLen;
    byte[] lenMin;
    byte[] lenMax;
    byte[] type;
    byte[] checkDigitStart;
    boolean fixed = false;
    boolean canDoChecksumADD = false;
    private static String[] fixedLenTable;
    private static byte[] fixedLenValueTable;
    private static EAN128AI dft;
    private static Object[] aiTable;
    private static boolean propertiesLoaded;

    private static void initFixedLen(String aiName, byte aiLen) {
        byte lenID = (byte)aiName.length();
        EAN128AI ai2 = new EAN128AI(aiName, "an" + aiLen, lenID, 0, aiLen);
        try {
            EAN128AI.setAI(aiName, ai2);
        }
        catch (Exception e2) {
            System.err.println(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void loadProperties() throws Exception {
        block9: {
            if (propertiesLoaded) {
                return;
            }
            String bundlename = "EAN128AIs";
            String filename = "EAN128AIs.properties";
            AIProperties p2 = new AIProperties();
            try {
                InputStream is = EAN128AI.class.getResourceAsStream("EAN128AIs.properties");
                if (is == null) {
                    is = EAN128AI.class.getClassLoader().getResourceAsStream("EAN128AIs.properties");
                }
                if (is != null) {
                    try {
                        p2.load(is);
                        break block9;
                    }
                    finally {
                        is.close();
                    }
                }
                String rbName = EAN128AI.class.getPackage().getName() + "." + "EAN128AIs";
                ResourceBundle rb = ResourceBundle.getBundle(rbName);
                Enumeration<String> keys = rb.getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    ((Properties)p2).put(key, rb.getObject(key));
                }
            }
            catch (Exception e2) {
                System.err.println("EAN128AIs.properties could not be loaded!");
                e2.printStackTrace();
            }
        }
        propertiesLoaded = true;
    }

    private EAN128AI(String id, byte lenID, byte[] type, byte[] lenMin, byte[] lenMax, byte[] checkDigitStart) {
        this.id = id;
        this.lenID = lenID;
        this.type = type;
        this.lenMin = lenMin;
        this.lenMax = lenMax;
        this.checkDigitStart = checkDigitStart;
        this.minLenAfterVariableLen = 0;
        this.lenMaxAll = 0;
        this.lenMinAll = 0;
        int idxVarLen = type.length;
        int idxFirstChecksum = -1;
        for (int i2 = 0; i2 < type.length; ++i2) {
            this.lenMinAll = (byte)(this.lenMinAll + lenMin[i2]);
            this.lenMaxAll = (byte)(this.lenMaxAll + lenMax[i2]);
            if (i2 > idxVarLen) {
                this.minLenAfterVariableLen = (byte)(this.minLenAfterVariableLen + lenMin[i2]);
            }
            if (lenMin[i2] != lenMax[i2]) {
                if (idxVarLen < type.length) {
                    throw new IllegalArgumentException("Only one Part with var len!");
                }
                idxVarLen = i2;
            }
            if (idxFirstChecksum != -1 || type[i2] != 5) continue;
            idxFirstChecksum = i2;
        }
        this.canDoChecksumADD = idxFirstChecksum == type.length - 1 && this.lenMinAll == this.lenMaxAll;
    }

    private EAN128AI(String id, String spec, byte lenID, byte type, byte len) {
        this(id, lenID, new byte[]{type}, new byte[]{len}, new byte[]{len}, new byte[]{0});
        this.fixed = true;
    }

    private static void checkFixed(EAN128AI aiNew, EAN128AI aiOld) {
        if (aiOld.fixed && !aiNew.fixed) {
            if (aiNew.lenMaxAll != aiNew.lenMinAll || aiNew.lenID + aiNew.lenMinAll != aiOld.lenID + aiOld.lenMinAll) {
                throw new IllegalArgumentException("AI \"" + aiNew.toString() + "\" must have fixed len: " + aiOld.lenID + "+" + aiOld.lenMinAll);
            }
            aiNew.fixed = true;
        }
    }

    private static void SetAIHere(EAN128AI ai2, Object[] aitParent) {
        for (int idx = 0; idx <= 9; ++idx) {
            EAN128AI.SetAIHere(ai2, aitParent, idx);
        }
    }

    private static void SetAIHere(EAN128AI aiNew, Object[] aitParent, int idx) {
        Object tmp = aitParent[idx];
        if (tmp instanceof EAN128AI) {
            EAN128AI aiOld = (EAN128AI)tmp;
            if (aiNew.type[0] == 4) {
                aiOld.type[0] = 4;
            } else {
                EAN128AI.checkFixed(aiNew, aiOld);
                aitParent[idx] = aiNew;
            }
        } else {
            EAN128AI.SetAIHere(aiNew, (Object[])tmp);
        }
    }

    private static void setAI(String aiName, EAN128AI ai2) {
        int aiLastRelevantIdx;
        Object[] aitParent = aiTable;
        for (aiLastRelevantIdx = aiName.length() - 1; aiLastRelevantIdx >= 0 && !Character.isDigit(aiName.charAt(aiLastRelevantIdx)); --aiLastRelevantIdx) {
        }
        for (int i2 = 0; i2 <= aiLastRelevantIdx; ++i2) {
            int idx = aiName.charAt(i2) - 48;
            if (i2 == aiLastRelevantIdx) {
                EAN128AI.SetAIHere(ai2, aitParent, idx);
                continue;
            }
            Object[] tmp = aitParent[idx];
            if (tmp instanceof EAN128AI) {
                aitParent[idx] = tmp = new Object[]{tmp, tmp, tmp, tmp, tmp, tmp, tmp, tmp, tmp, tmp};
            }
            aitParent = tmp;
        }
    }

    public static EAN128AI parseSpec(String ai2, String spec) {
        EAN128AI ret = EAN128AI.parseSpecPrivate(ai2, spec);
        EAN128AI.checkAI(ret);
        return ret;
    }

    private static void parseSpecPrivate(int i2, String spec, byte[] type, byte[] lenMin, byte[] lenMax, byte[] checkDigitStart) {
        int startLen = 0;
        checkDigitStart[i2] = 1;
        lenMax[i2] = -1;
        lenMin[i2] = -1;
        if (spec.startsWith("an")) {
            type[i2] = 0;
            startLen = 2;
        } else if (spec.startsWith("a")) {
            type[i2] = 2;
            startLen = 1;
        } else {
            if (spec.startsWith("cd")) {
                type[i2] = 5;
                if (spec.length() > 2) {
                    checkDigitStart[i2] = Byte.parseByte(spec.substring(2));
                }
                lenMax[i2] = 1;
                lenMin[i2] = 1;
                return;
            }
            if (spec.startsWith("n")) {
                type[i2] = 1;
                startLen = 1;
            } else if (spec.startsWith("d")) {
                type[i2] = 3;
                lenMax[i2] = 6;
                lenMin[i2] = 6;
                startLen = 1;
            } else {
                if (spec.startsWith("e")) {
                    type[i2] = 4;
                    lenMax[i2] = 0;
                    lenMin[i2] = 0;
                    return;
                }
                throw new IllegalArgumentException("Unknown type!");
            }
        }
        int hyphenIdx = spec.indexOf(45, startLen);
        if (hyphenIdx < 0) {
            lenMin[i2] = lenMax[i2] = EAN128AI.parseByte(spec.substring(startLen), lenMin[i2], spec);
        } else if (hyphenIdx == startLen) {
            lenMin[i2] = 1;
            lenMax[i2] = EAN128AI.parseByte(spec.substring(startLen + 1), lenMax[i2], spec);
        } else {
            lenMin[i2] = EAN128AI.parseByte(spec.substring(startLen, hyphenIdx), lenMin[i2], spec);
            lenMax[i2] = EAN128AI.parseByte(spec.substring(hyphenIdx + 1), lenMax[i2], spec);
        }
        if (type[i2] == 3 && (lenMin[i2] != 6 || lenMax[i2] != 6)) {
            throw new IllegalArgumentException("Date field (" + spec + ") must have length 6!");
        }
    }

    private static byte parseByte(String val, byte dft, String spec) {
        try {
            return Byte.parseByte(val);
        }
        catch (Exception e2) {
            if (dft == -1) {
                throw new IllegalArgumentException("Can't read field length from \"" + spec + "\"");
            }
            return dft;
        }
    }

    private static EAN128AI parseSpecPrivate(String ai2, String spec) {
        try {
            byte lenID = (byte)ai2.trim().length();
            spec = spec.trim();
            StringTokenizer st = new StringTokenizer(spec, "+", false);
            int count = st.countTokens();
            byte[] type = new byte[count];
            byte[] checkDigitStart = new byte[count];
            byte[] lenMin = new byte[count];
            byte[] lenMax = new byte[count];
            for (int i2 = 0; i2 < count; ++i2) {
                EAN128AI.parseSpecPrivate(i2, st.nextToken(), type, lenMin, lenMax, checkDigitStart);
            }
            return new EAN128AI(ai2, lenID, type, lenMin, lenMax, checkDigitStart);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e2) {
            throw new IllegalArgumentException("Cannot Parse AI: \"" + ai2 + "\" spec: \"" + spec + "\" ");
        }
    }

    public static boolean checkAI(EAN128AI ai2) {
        EAN128AI aiCompare = EAN128AI.getAIPrivate(ai2.id + "0000", 0);
        EAN128AI.checkFixed(ai2, aiCompare);
        return true;
    }

    public static EAN128AI getAI(String msg, int msgStart) throws Exception {
        EAN128AI.loadProperties();
        return EAN128AI.getAIPrivate(msg, msgStart);
    }

    private static EAN128AI getAIPrivate(String msg, int msgStart) {
        EAN128AI ret = dft;
        Object o2 = aiTable;
        for (int i2 = 0; i2 < msg.length() - msgStart; ++i2) {
            int c2 = EAN128AI.getIDChar(msg, msgStart + i2) - 48;
            if ((o2 = o2[c2]) == null) {
                return dft;
            }
            if (!(o2 instanceof EAN128AI)) continue;
            ret = (EAN128AI)o2;
            break;
        }
        return ret;
    }

    private static char getIDChar(String msg, int msgStart) {
        char ret;
        try {
            ret = msg.charAt(msgStart);
        }
        catch (Exception e2) {
            throw new IllegalArgumentException("Unable to read AI: Message too short!");
        }
        if (!Character.isDigit(ret)) {
            throw new IllegalArgumentException("Unable to read AI: Characters must be numerical!");
        }
        return ret;
    }

    public static final boolean isCheckDigitType(byte type) {
        return type == 5;
    }

    public final boolean isCheckDigit(byte idx) {
        return EAN128AI.isCheckDigitType(this.type[idx]);
    }

    public static final String getType(byte type) {
        String ret = "?";
        try {
            ret = typeToString[type];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append('(').append(this.id).append(")");
        for (int i2 = 0; i2 < this.lenMin.length; ++i2) {
            if (i2 != 0) {
                ret.append('+');
            }
            ret.append(EAN128AI.getType(this.type[i2]));
            if (this.type[i2] >= 4) continue;
            ret.append(this.lenMin[i2]);
            if (this.lenMin[i2] == this.lenMax[i2]) continue;
            ret.append('-').append(this.lenMax[i2]);
        }
        ret.append(this.fixed ? " (fixed)" : "");
        return ret.toString();
    }

    static {
        int i2;
        typeToString = new String[]{"an", "n", "a", "d", "e", "cd"};
        fixedLenTable = new String[]{"00", "01", "02", "03", "04", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "31", "32", "33", "34", "35", "36", "41"};
        fixedLenValueTable = new byte[]{20, 16, 16, 16, 18, 8, 8, 8, 8, 8, 8, 8, 8, 8, 4, 10, 10, 10, 10, 10, 10, 16};
        dft = EAN128AI.parseSpecPrivate("xx", "an1-48");
        aiTable = new Object[]{dft, dft, dft, dft, dft, dft, dft, dft, dft, dft};
        propertiesLoaded = false;
        for (i2 = 0; i2 <= 9; ++i2) {
            EAN128AI.initFixedLen("23" + i2, (byte)(1 + 9 * i2));
        }
        for (i2 = fixedLenValueTable.length - 1; i2 >= 0; --i2) {
            EAN128AI.initFixedLen(fixedLenTable[i2], (byte)(fixedLenValueTable[i2] - 2));
        }
    }

    private static class AIProperties
    extends Properties {
        private AIProperties() {
        }

        public synchronized Object put(Object arg0, Object arg1) {
            EAN128AI ai2 = EAN128AI.parseSpecPrivate((String)arg0, (String)arg1);
            try {
                EAN128AI.setAI((String)arg0, ai2);
            }
            catch (Exception e2) {
                System.err.println(e2);
            }
            return super.put(arg0, arg1);
        }
    }
}

