/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.tz;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.tz.CachedDateTimeZone;
import org.joda.time.tz.FixedDateTimeZone;
import org.joda.time.tz.ZoneInfoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeZoneBuilder {
    private final ArrayList<RuleSet> iRuleSets = new ArrayList(10);

    public static DateTimeZone readFrom(InputStream inputStream, String string) throws IOException {
        if (inputStream instanceof DataInput) {
            return DateTimeZoneBuilder.readFrom((DataInput)((Object)inputStream), string);
        }
        return DateTimeZoneBuilder.readFrom(new DataInputStream(inputStream), string);
    }

    public static DateTimeZone readFrom(DataInput dataInput, String string) throws IOException {
        switch (dataInput.readUnsignedByte()) {
            case 70: {
                DateTimeZone dateTimeZone = new FixedDateTimeZone(string, dataInput.readUTF(), (int)DateTimeZoneBuilder.readMillis(dataInput), (int)DateTimeZoneBuilder.readMillis(dataInput));
                if (((DateTimeZone)dateTimeZone).equals(DateTimeZone.UTC)) {
                    dateTimeZone = DateTimeZone.UTC;
                }
                return dateTimeZone;
            }
            case 67: {
                return CachedDateTimeZone.forZone(PrecalculatedZone.readFrom(dataInput, string));
            }
            case 80: {
                return PrecalculatedZone.readFrom(dataInput, string);
            }
        }
        throw new IOException("Invalid encoding");
    }

    static void writeMillis(DataOutput dataOutput, long l2) throws IOException {
        long l3;
        if (l2 % 1800000L == 0L && (l3 = l2 / 1800000L) << 58 >> 58 == l3) {
            dataOutput.writeByte((int)(l3 & 0x3FL));
            return;
        }
        if (l2 % 60000L == 0L && (l3 = l2 / 60000L) << 34 >> 34 == l3) {
            dataOutput.writeInt(0x40000000 | (int)(l3 & 0x3FFFFFFFL));
            return;
        }
        if (l2 % 1000L == 0L && (l3 = l2 / 1000L) << 26 >> 26 == l3) {
            dataOutput.writeByte(0x80 | (int)(l3 >> 32 & 0x3FL));
            dataOutput.writeInt((int)(l3 & 0xFFFFFFFFFFFFFFFFL));
            return;
        }
        dataOutput.writeByte(l2 < 0L ? 255 : 192);
        dataOutput.writeLong(l2);
    }

    static long readMillis(DataInput dataInput) throws IOException {
        int n2 = dataInput.readUnsignedByte();
        switch (n2 >> 6) {
            default: {
                n2 = n2 << 26 >> 26;
                return (long)n2 * 1800000L;
            }
            case 1: {
                n2 = n2 << 26 >> 2;
                n2 |= dataInput.readUnsignedByte() << 16;
                n2 |= dataInput.readUnsignedByte() << 8;
                return (long)(n2 |= dataInput.readUnsignedByte()) * 60000L;
            }
            case 2: {
                long l2 = (long)n2 << 58 >> 26;
                l2 |= (long)(dataInput.readUnsignedByte() << 24);
                l2 |= (long)(dataInput.readUnsignedByte() << 16);
                l2 |= (long)(dataInput.readUnsignedByte() << 8);
                return (l2 |= (long)dataInput.readUnsignedByte()) * 1000L;
            }
            case 3: 
        }
        return dataInput.readLong();
    }

    private static DateTimeZone buildFixedZone(String string, String string2, int n2, int n3) {
        if ("UTC".equals(string) && string.equals(string2) && n2 == 0 && n3 == 0) {
            return DateTimeZone.UTC;
        }
        return new FixedDateTimeZone(string, string2, n2, n3);
    }

    public DateTimeZoneBuilder addCutover(int n2, char c2, int n3, int n4, int n5, boolean bl2, int n6) {
        if (this.iRuleSets.size() > 0) {
            OfYear ofYear = new OfYear(c2, n3, n4, n5, bl2, n6);
            RuleSet ruleSet = this.iRuleSets.get(this.iRuleSets.size() - 1);
            ruleSet.setUpperLimit(n2, ofYear);
        }
        this.iRuleSets.add(new RuleSet());
        return this;
    }

    public DateTimeZoneBuilder setStandardOffset(int n2) {
        this.getLastRuleSet().setStandardOffset(n2);
        return this;
    }

    public DateTimeZoneBuilder setFixedSavings(String string, int n2) {
        this.getLastRuleSet().setFixedSavings(string, n2);
        return this;
    }

    public DateTimeZoneBuilder addRecurringSavings(String string, int n2, int n3, int n4, char c2, int n5, int n6, int n7, boolean bl2, int n8) {
        if (n3 <= n4) {
            OfYear ofYear = new OfYear(c2, n5, n6, n7, bl2, n8);
            Recurrence recurrence = new Recurrence(ofYear, string, n2);
            Rule rule = new Rule(recurrence, n3, n4);
            this.getLastRuleSet().addRule(rule);
        }
        return this;
    }

    private RuleSet getLastRuleSet() {
        if (this.iRuleSets.size() == 0) {
            this.addCutover(Integer.MIN_VALUE, 'w', 1, 1, 0, false, 0);
        }
        return this.iRuleSets.get(this.iRuleSets.size() - 1);
    }

    public DateTimeZone toDateTimeZone(String string, boolean bl2) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Transition> arrayList = new ArrayList<Transition>();
        DSTZone dSTZone = null;
        long l2 = Long.MIN_VALUE;
        int n2 = 0;
        int n3 = this.iRuleSets.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            RuleSet ruleSet = this.iRuleSets.get(i2);
            Transition transition = ruleSet.firstTransition(l2);
            if (transition == null) continue;
            this.addTransition(arrayList, transition);
            l2 = transition.getMillis();
            n2 = transition.getSaveMillis();
            ruleSet = new RuleSet(ruleSet);
            while (!((transition = ruleSet.nextTransition(l2, n2)) == null || this.addTransition(arrayList, transition) && dSTZone != null)) {
                l2 = transition.getMillis();
                n2 = transition.getSaveMillis();
                if (dSTZone != null || i2 != n3 - 1) continue;
                dSTZone = ruleSet.buildTailZone(string);
            }
            l2 = ruleSet.getUpperLimit(n2);
        }
        if (arrayList.size() == 0) {
            if (dSTZone != null) {
                return dSTZone;
            }
            return DateTimeZoneBuilder.buildFixedZone(string, "UTC", 0, 0);
        }
        if (arrayList.size() == 1 && dSTZone == null) {
            Transition transition = (Transition)arrayList.get(0);
            return DateTimeZoneBuilder.buildFixedZone(string, transition.getNameKey(), transition.getWallOffset(), transition.getStandardOffset());
        }
        PrecalculatedZone precalculatedZone = PrecalculatedZone.create(string, bl2, arrayList, dSTZone);
        if (precalculatedZone.isCachable()) {
            return CachedDateTimeZone.forZone(precalculatedZone);
        }
        return precalculatedZone;
    }

    private boolean addTransition(ArrayList<Transition> arrayList, Transition transition) {
        int n2 = arrayList.size();
        if (n2 == 0) {
            arrayList.add(transition);
            return true;
        }
        Transition transition2 = arrayList.get(n2 - 1);
        if (!transition.isTransitionFrom(transition2)) {
            return false;
        }
        int n3 = 0;
        if (n2 >= 2) {
            n3 = arrayList.get(n2 - 2).getWallOffset();
        }
        int n4 = transition2.getWallOffset();
        long l2 = transition2.getMillis() + (long)n3;
        long l3 = transition.getMillis() + (long)n4;
        if (l3 != l2) {
            arrayList.add(transition);
            return true;
        }
        arrayList.remove(n2 - 1);
        return this.addTransition(arrayList, transition);
    }

    public void writeTo(String string, OutputStream outputStream) throws IOException {
        if (outputStream instanceof DataOutput) {
            this.writeTo(string, (DataOutput)((Object)outputStream));
        } else {
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            this.writeTo(string, dataOutputStream);
            dataOutputStream.flush();
        }
    }

    public void writeTo(String string, DataOutput dataOutput) throws IOException {
        DateTimeZone dateTimeZone = this.toDateTimeZone(string, false);
        if (dateTimeZone instanceof FixedDateTimeZone) {
            dataOutput.writeByte(70);
            dataOutput.writeUTF(dateTimeZone.getNameKey(0L));
            DateTimeZoneBuilder.writeMillis(dataOutput, dateTimeZone.getOffset(0L));
            DateTimeZoneBuilder.writeMillis(dataOutput, dateTimeZone.getStandardOffset(0L));
        } else {
            if (dateTimeZone instanceof CachedDateTimeZone) {
                dataOutput.writeByte(67);
                dateTimeZone = ((CachedDateTimeZone)dateTimeZone).getUncachedZone();
            } else {
                dataOutput.writeByte(80);
            }
            ((PrecalculatedZone)dateTimeZone).writeTo(dataOutput);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PrecalculatedZone
    extends DateTimeZone {
        private static final long serialVersionUID = 7811976468055766265L;
        private final long[] iTransitions;
        private final int[] iWallOffsets;
        private final int[] iStandardOffsets;
        private final String[] iNameKeys;
        private final DSTZone iTailZone;

        static PrecalculatedZone readFrom(DataInput dataInput, String string) throws IOException {
            int n2;
            int n3 = dataInput.readUnsignedShort();
            String[] stringArray = new String[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                stringArray[n2] = dataInput.readUTF();
            }
            n2 = dataInput.readInt();
            long[] lArray = new long[n2];
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            String[] stringArray2 = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                lArray[i2] = DateTimeZoneBuilder.readMillis(dataInput);
                nArray[i2] = (int)DateTimeZoneBuilder.readMillis(dataInput);
                nArray2[i2] = (int)DateTimeZoneBuilder.readMillis(dataInput);
                try {
                    int n4 = n3 < 256 ? dataInput.readUnsignedByte() : dataInput.readUnsignedShort();
                    stringArray2[i2] = stringArray[n4];
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new IOException("Invalid encoding");
                }
            }
            DSTZone dSTZone = null;
            if (dataInput.readBoolean()) {
                dSTZone = DSTZone.readFrom(dataInput, string);
            }
            return new PrecalculatedZone(string, lArray, nArray, nArray2, stringArray2, dSTZone);
        }

        static PrecalculatedZone create(String string, boolean bl2, ArrayList<Transition> arrayList, DSTZone dSTZone) {
            String[][] stringArray;
            int n2 = arrayList.size();
            if (n2 == 0) {
                throw new IllegalArgumentException();
            }
            long[] lArray = new long[n2];
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            String[] stringArray2 = new String[n2];
            String[][] stringArray3 = null;
            for (int i2 = 0; i2 < n2; ++i2) {
                stringArray = arrayList.get(i2);
                if (!stringArray.isTransitionFrom((Transition)stringArray3)) {
                    throw new IllegalArgumentException(string);
                }
                lArray[i2] = stringArray.getMillis();
                nArray[i2] = stringArray.getWallOffset();
                nArray2[i2] = stringArray.getStandardOffset();
                stringArray2[i2] = stringArray.getNameKey();
                stringArray3 = stringArray;
            }
            String[] stringArray4 = new String[5];
            stringArray = new DateFormatSymbols(Locale.ENGLISH).getZoneStrings();
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                String[] stringArray5 = stringArray[i3];
                if (stringArray5 == null || stringArray5.length != 5 || !string.equals(stringArray5[0])) continue;
                stringArray4 = stringArray5;
            }
            ISOChronology iSOChronology = ISOChronology.getInstanceUTC();
            for (int i4 = 0; i4 < stringArray2.length - 1; ++i4) {
                String string2 = stringArray2[i4];
                String string3 = stringArray2[i4 + 1];
                long l2 = nArray[i4];
                long l3 = nArray[i4 + 1];
                long l4 = nArray2[i4];
                long l5 = nArray2[i4 + 1];
                Period period = new Period(lArray[i4], lArray[i4 + 1], PeriodType.yearMonthDay(), iSOChronology);
                if (l2 == l3 || l4 != l5 || !string2.equals(string3) || period.getYears() != 0 || period.getMonths() <= 4 || period.getMonths() >= 8 || !string2.equals(stringArray4[2]) || !string2.equals(stringArray4[4])) continue;
                if (ZoneInfoLogger.verbose()) {
                    System.out.println("Fixing duplicate name key - " + string3);
                    System.out.println("     - " + new DateTime(lArray[i4], (Chronology)iSOChronology) + " - " + new DateTime(lArray[i4 + 1], (Chronology)iSOChronology));
                }
                if (l2 > l3) {
                    stringArray2[i4] = (string2 + "-Summer").intern();
                    continue;
                }
                if (l2 >= l3) continue;
                stringArray2[i4 + 1] = (string3 + "-Summer").intern();
                ++i4;
            }
            if (dSTZone != null && dSTZone.iStartRecurrence.getNameKey().equals(dSTZone.iEndRecurrence.getNameKey())) {
                if (ZoneInfoLogger.verbose()) {
                    System.out.println("Fixing duplicate recurrent name key - " + dSTZone.iStartRecurrence.getNameKey());
                }
                dSTZone = dSTZone.iStartRecurrence.getSaveMillis() > 0 ? new DSTZone(dSTZone.getID(), dSTZone.iStandardOffset, dSTZone.iStartRecurrence.renameAppend("-Summer"), dSTZone.iEndRecurrence) : new DSTZone(dSTZone.getID(), dSTZone.iStandardOffset, dSTZone.iStartRecurrence, dSTZone.iEndRecurrence.renameAppend("-Summer"));
            }
            return new PrecalculatedZone(bl2 ? string : "", lArray, nArray, nArray2, stringArray2, dSTZone);
        }

        private PrecalculatedZone(String string, long[] lArray, int[] nArray, int[] nArray2, String[] stringArray, DSTZone dSTZone) {
            super(string);
            this.iTransitions = lArray;
            this.iWallOffsets = nArray;
            this.iStandardOffsets = nArray2;
            this.iNameKeys = stringArray;
            this.iTailZone = dSTZone;
        }

        @Override
        public String getNameKey(long l2) {
            long[] lArray = this.iTransitions;
            int n2 = Arrays.binarySearch(lArray, l2);
            if (n2 >= 0) {
                return this.iNameKeys[n2];
            }
            if ((n2 ^= 0xFFFFFFFF) < lArray.length) {
                if (n2 > 0) {
                    return this.iNameKeys[n2 - 1];
                }
                return "UTC";
            }
            if (this.iTailZone == null) {
                return this.iNameKeys[n2 - 1];
            }
            return this.iTailZone.getNameKey(l2);
        }

        @Override
        public int getOffset(long l2) {
            long[] lArray = this.iTransitions;
            int n2 = Arrays.binarySearch(lArray, l2);
            if (n2 >= 0) {
                return this.iWallOffsets[n2];
            }
            if ((n2 ^= 0xFFFFFFFF) < lArray.length) {
                if (n2 > 0) {
                    return this.iWallOffsets[n2 - 1];
                }
                return 0;
            }
            if (this.iTailZone == null) {
                return this.iWallOffsets[n2 - 1];
            }
            return this.iTailZone.getOffset(l2);
        }

        @Override
        public int getStandardOffset(long l2) {
            long[] lArray = this.iTransitions;
            int n2 = Arrays.binarySearch(lArray, l2);
            if (n2 >= 0) {
                return this.iStandardOffsets[n2];
            }
            if ((n2 ^= 0xFFFFFFFF) < lArray.length) {
                if (n2 > 0) {
                    return this.iStandardOffsets[n2 - 1];
                }
                return 0;
            }
            if (this.iTailZone == null) {
                return this.iStandardOffsets[n2 - 1];
            }
            return this.iTailZone.getStandardOffset(l2);
        }

        @Override
        public boolean isFixed() {
            return false;
        }

        @Override
        public long nextTransition(long l2) {
            long[] lArray = this.iTransitions;
            int n2 = Arrays.binarySearch(lArray, l2);
            int n3 = n2 = n2 >= 0 ? n2 + 1 : ~n2;
            if (n2 < lArray.length) {
                return lArray[n2];
            }
            if (this.iTailZone == null) {
                return l2;
            }
            long l3 = lArray[lArray.length - 1];
            if (l2 < l3) {
                l2 = l3;
            }
            return this.iTailZone.nextTransition(l2);
        }

        @Override
        public long previousTransition(long l2) {
            long l3;
            long[] lArray = this.iTransitions;
            int n2 = Arrays.binarySearch(lArray, l2);
            if (n2 >= 0) {
                if (l2 > Long.MIN_VALUE) {
                    return l2 - 1L;
                }
                return l2;
            }
            if ((n2 ^= 0xFFFFFFFF) < lArray.length) {
                long l4;
                if (n2 > 0 && (l4 = lArray[n2 - 1]) > Long.MIN_VALUE) {
                    return l4 - 1L;
                }
                return l2;
            }
            if (this.iTailZone != null && (l3 = this.iTailZone.previousTransition(l2)) < l2) {
                return l3;
            }
            l3 = lArray[n2 - 1];
            if (l3 > Long.MIN_VALUE) {
                return l3 - 1L;
            }
            return l2;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof PrecalculatedZone) {
                PrecalculatedZone precalculatedZone = (PrecalculatedZone)object;
                return this.getID().equals(precalculatedZone.getID()) && Arrays.equals(this.iTransitions, precalculatedZone.iTransitions) && Arrays.equals(this.iNameKeys, precalculatedZone.iNameKeys) && Arrays.equals(this.iWallOffsets, precalculatedZone.iWallOffsets) && Arrays.equals(this.iStandardOffsets, precalculatedZone.iStandardOffsets) && (this.iTailZone == null ? null == precalculatedZone.iTailZone : this.iTailZone.equals(precalculatedZone.iTailZone));
            }
            return false;
        }

        public void writeTo(DataOutput dataOutput) throws IOException {
            int n2;
            int n3 = this.iTransitions.length;
            HashSet<String> hashSet = new HashSet<String>();
            for (n2 = 0; n2 < n3; ++n2) {
                hashSet.add(this.iNameKeys[n2]);
            }
            n2 = hashSet.size();
            if (n2 > 65535) {
                throw new UnsupportedOperationException("String pool is too large");
            }
            String[] stringArray = new String[n2];
            Iterator iterator = hashSet.iterator();
            int n4 = 0;
            while (iterator.hasNext()) {
                stringArray[n4] = (String)iterator.next();
                ++n4;
            }
            dataOutput.writeShort(n2);
            for (n4 = 0; n4 < n2; ++n4) {
                dataOutput.writeUTF(stringArray[n4]);
            }
            dataOutput.writeInt(n3);
            block3: for (n4 = 0; n4 < n3; ++n4) {
                DateTimeZoneBuilder.writeMillis(dataOutput, this.iTransitions[n4]);
                DateTimeZoneBuilder.writeMillis(dataOutput, this.iWallOffsets[n4]);
                DateTimeZoneBuilder.writeMillis(dataOutput, this.iStandardOffsets[n4]);
                String string = this.iNameKeys[n4];
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (!stringArray[i2].equals(string)) continue;
                    if (n2 < 256) {
                        dataOutput.writeByte(i2);
                        continue block3;
                    }
                    dataOutput.writeShort(i2);
                    continue block3;
                }
            }
            dataOutput.writeBoolean(this.iTailZone != null);
            if (this.iTailZone != null) {
                this.iTailZone.writeTo(dataOutput);
            }
        }

        public boolean isCachable() {
            if (this.iTailZone != null) {
                return true;
            }
            long[] lArray = this.iTransitions;
            if (lArray.length <= 1) {
                return false;
            }
            double d2 = 0.0;
            int n2 = 0;
            for (int i2 = 1; i2 < lArray.length; ++i2) {
                long l2 = lArray[i2] - lArray[i2 - 1];
                if (l2 >= 63158400000L) continue;
                d2 += (double)l2;
                ++n2;
            }
            if (n2 > 0) {
                double d3 = d2 / (double)n2;
                if ((d3 /= 8.64E7) >= 25.0) {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class DSTZone
    extends DateTimeZone {
        private static final long serialVersionUID = 6941492635554961361L;
        final int iStandardOffset;
        final Recurrence iStartRecurrence;
        final Recurrence iEndRecurrence;

        static DSTZone readFrom(DataInput dataInput, String string) throws IOException {
            return new DSTZone(string, (int)DateTimeZoneBuilder.readMillis(dataInput), Recurrence.readFrom(dataInput), Recurrence.readFrom(dataInput));
        }

        DSTZone(String string, int n2, Recurrence recurrence, Recurrence recurrence2) {
            super(string);
            this.iStandardOffset = n2;
            this.iStartRecurrence = recurrence;
            this.iEndRecurrence = recurrence2;
        }

        public String getNameKey(long l2) {
            return this.findMatchingRecurrence(l2).getNameKey();
        }

        public int getOffset(long l2) {
            return this.iStandardOffset + this.findMatchingRecurrence(l2).getSaveMillis();
        }

        public int getStandardOffset(long l2) {
            return this.iStandardOffset;
        }

        public boolean isFixed() {
            return false;
        }

        public long nextTransition(long l2) {
            long l3;
            long l4;
            int n2 = this.iStandardOffset;
            Recurrence recurrence = this.iStartRecurrence;
            Recurrence recurrence2 = this.iEndRecurrence;
            try {
                l4 = recurrence.next(l2, n2, recurrence2.getSaveMillis());
                if (l2 > 0L && l4 < 0L) {
                    l4 = l2;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l4 = l2;
            }
            catch (ArithmeticException arithmeticException) {
                l4 = l2;
            }
            try {
                l3 = recurrence2.next(l2, n2, recurrence.getSaveMillis());
                if (l2 > 0L && l3 < 0L) {
                    l3 = l2;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l3 = l2;
            }
            catch (ArithmeticException arithmeticException) {
                l3 = l2;
            }
            return l4 > l3 ? l3 : l4;
        }

        public long previousTransition(long l2) {
            long l3;
            long l4;
            ++l2;
            int n2 = this.iStandardOffset;
            Recurrence recurrence = this.iStartRecurrence;
            Recurrence recurrence2 = this.iEndRecurrence;
            try {
                l4 = recurrence.previous(l2, n2, recurrence2.getSaveMillis());
                if (l2 < 0L && l4 > 0L) {
                    l4 = l2;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l4 = l2;
            }
            catch (ArithmeticException arithmeticException) {
                l4 = l2;
            }
            try {
                l3 = recurrence2.previous(l2, n2, recurrence.getSaveMillis());
                if (l2 < 0L && l3 > 0L) {
                    l3 = l2;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l3 = l2;
            }
            catch (ArithmeticException arithmeticException) {
                l3 = l2;
            }
            return (l4 > l3 ? l4 : l3) - 1L;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof DSTZone) {
                DSTZone dSTZone = (DSTZone)object;
                return this.getID().equals(dSTZone.getID()) && this.iStandardOffset == dSTZone.iStandardOffset && this.iStartRecurrence.equals(dSTZone.iStartRecurrence) && this.iEndRecurrence.equals(dSTZone.iEndRecurrence);
            }
            return false;
        }

        public void writeTo(DataOutput dataOutput) throws IOException {
            DateTimeZoneBuilder.writeMillis(dataOutput, this.iStandardOffset);
            this.iStartRecurrence.writeTo(dataOutput);
            this.iEndRecurrence.writeTo(dataOutput);
        }

        private Recurrence findMatchingRecurrence(long l2) {
            long l3;
            long l4;
            int n2 = this.iStandardOffset;
            Recurrence recurrence = this.iStartRecurrence;
            Recurrence recurrence2 = this.iEndRecurrence;
            try {
                l4 = recurrence.next(l2, n2, recurrence2.getSaveMillis());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l4 = l2;
            }
            catch (ArithmeticException arithmeticException) {
                l4 = l2;
            }
            try {
                l3 = recurrence2.next(l2, n2, recurrence.getSaveMillis());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l3 = l2;
            }
            catch (ArithmeticException arithmeticException) {
                l3 = l2;
            }
            return l4 > l3 ? recurrence : recurrence2;
        }
    }

    private static final class RuleSet {
        private static final int YEAR_LIMIT;
        private int iStandardOffset;
        private ArrayList<Rule> iRules;
        private String iInitialNameKey;
        private int iInitialSaveMillis;
        private int iUpperYear;
        private OfYear iUpperOfYear;

        RuleSet() {
            this.iRules = new ArrayList(10);
            this.iUpperYear = Integer.MAX_VALUE;
        }

        RuleSet(RuleSet ruleSet) {
            this.iStandardOffset = ruleSet.iStandardOffset;
            this.iRules = new ArrayList<Rule>(ruleSet.iRules);
            this.iInitialNameKey = ruleSet.iInitialNameKey;
            this.iInitialSaveMillis = ruleSet.iInitialSaveMillis;
            this.iUpperYear = ruleSet.iUpperYear;
            this.iUpperOfYear = ruleSet.iUpperOfYear;
        }

        public int getStandardOffset() {
            return this.iStandardOffset;
        }

        public void setStandardOffset(int n2) {
            this.iStandardOffset = n2;
        }

        public void setFixedSavings(String string, int n2) {
            this.iInitialNameKey = string;
            this.iInitialSaveMillis = n2;
        }

        public void addRule(Rule rule) {
            if (!this.iRules.contains(rule)) {
                this.iRules.add(rule);
            }
        }

        public void setUpperLimit(int n2, OfYear ofYear) {
            this.iUpperYear = n2;
            this.iUpperOfYear = ofYear;
        }

        public Transition firstTransition(long l2) {
            Transition transition;
            if (this.iInitialNameKey != null) {
                return new Transition(l2, this.iInitialNameKey, this.iStandardOffset + this.iInitialSaveMillis, this.iStandardOffset);
            }
            ArrayList<Rule> arrayList = new ArrayList<Rule>(this.iRules);
            long l3 = Long.MIN_VALUE;
            int n2 = 0;
            Transition transition2 = null;
            while ((transition = this.nextTransition(l3, n2)) != null) {
                l3 = transition.getMillis();
                if (l3 == l2) {
                    transition2 = new Transition(l2, transition);
                    break;
                }
                if (l3 > l2) {
                    if (transition2 == null) {
                        for (Rule rule : arrayList) {
                            if (rule.getSaveMillis() != 0) continue;
                            transition2 = new Transition(l2, rule, this.iStandardOffset);
                            break;
                        }
                    }
                    if (transition2 != null) break;
                    transition2 = new Transition(l2, transition.getNameKey(), this.iStandardOffset, this.iStandardOffset);
                    break;
                }
                transition2 = new Transition(l2, transition);
                n2 = transition.getSaveMillis();
            }
            this.iRules = arrayList;
            return transition2;
        }

        public Transition nextTransition(long l2, int n2) {
            long l3;
            ISOChronology iSOChronology = ISOChronology.getInstanceUTC();
            Rule rule = null;
            long l4 = Long.MAX_VALUE;
            Iterator<Rule> iterator = this.iRules.iterator();
            while (iterator.hasNext()) {
                Rule rule2 = iterator.next();
                long l5 = rule2.next(l2, this.iStandardOffset, n2);
                if (l5 <= l2) {
                    iterator.remove();
                    continue;
                }
                if (l5 > l4) continue;
                rule = rule2;
                l4 = l5;
            }
            if (rule == null) {
                return null;
            }
            if (((Chronology)iSOChronology).year().get(l4) >= YEAR_LIMIT) {
                return null;
            }
            if (this.iUpperYear < Integer.MAX_VALUE && l4 >= (l3 = this.iUpperOfYear.setInstant(this.iUpperYear, this.iStandardOffset, n2))) {
                return null;
            }
            return new Transition(l4, rule, this.iStandardOffset);
        }

        public long getUpperLimit(int n2) {
            if (this.iUpperYear == Integer.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            return this.iUpperOfYear.setInstant(this.iUpperYear, this.iStandardOffset, n2);
        }

        public DSTZone buildTailZone(String string) {
            if (this.iRules.size() == 2) {
                Rule rule = this.iRules.get(0);
                Rule rule2 = this.iRules.get(1);
                if (rule.getToYear() == Integer.MAX_VALUE && rule2.getToYear() == Integer.MAX_VALUE) {
                    return new DSTZone(string, this.iStandardOffset, rule.iRecurrence, rule2.iRecurrence);
                }
            }
            return null;
        }

        static {
            long l2 = DateTimeUtils.currentTimeMillis();
            YEAR_LIMIT = ISOChronology.getInstanceUTC().year().get(l2) + 100;
        }
    }

    private static final class Transition {
        private final long iMillis;
        private final String iNameKey;
        private final int iWallOffset;
        private final int iStandardOffset;

        Transition(long l2, Transition transition) {
            this.iMillis = l2;
            this.iNameKey = transition.iNameKey;
            this.iWallOffset = transition.iWallOffset;
            this.iStandardOffset = transition.iStandardOffset;
        }

        Transition(long l2, Rule rule, int n2) {
            this.iMillis = l2;
            this.iNameKey = rule.getNameKey();
            this.iWallOffset = n2 + rule.getSaveMillis();
            this.iStandardOffset = n2;
        }

        Transition(long l2, String string, int n2, int n3) {
            this.iMillis = l2;
            this.iNameKey = string;
            this.iWallOffset = n2;
            this.iStandardOffset = n3;
        }

        public long getMillis() {
            return this.iMillis;
        }

        public String getNameKey() {
            return this.iNameKey;
        }

        public int getWallOffset() {
            return this.iWallOffset;
        }

        public int getStandardOffset() {
            return this.iStandardOffset;
        }

        public int getSaveMillis() {
            return this.iWallOffset - this.iStandardOffset;
        }

        public boolean isTransitionFrom(Transition transition) {
            if (transition == null) {
                return true;
            }
            return this.iMillis > transition.iMillis && (this.iWallOffset != transition.iWallOffset || !this.iNameKey.equals(transition.iNameKey));
        }
    }

    private static final class Rule {
        final Recurrence iRecurrence;
        final int iFromYear;
        final int iToYear;

        Rule(Recurrence recurrence, int n2, int n3) {
            this.iRecurrence = recurrence;
            this.iFromYear = n2;
            this.iToYear = n3;
        }

        public int getFromYear() {
            return this.iFromYear;
        }

        public int getToYear() {
            return this.iToYear;
        }

        public OfYear getOfYear() {
            return this.iRecurrence.getOfYear();
        }

        public String getNameKey() {
            return this.iRecurrence.getNameKey();
        }

        public int getSaveMillis() {
            return this.iRecurrence.getSaveMillis();
        }

        public long next(long l2, int n2, int n3) {
            long l3;
            ISOChronology iSOChronology = ISOChronology.getInstanceUTC();
            int n4 = n2 + n3;
            long l4 = l2;
            int n5 = l2 == Long.MIN_VALUE ? Integer.MIN_VALUE : ((Chronology)iSOChronology).year().get(l2 + (long)n4);
            if (n5 < this.iFromYear) {
                l4 = ((Chronology)iSOChronology).year().set(0L, this.iFromYear) - (long)n4;
                --l4;
            }
            if ((l3 = this.iRecurrence.next(l4, n2, n3)) > l2 && (n5 = ((Chronology)iSOChronology).year().get(l3 + (long)n4)) > this.iToYear) {
                l3 = l2;
            }
            return l3;
        }
    }

    private static final class Recurrence {
        final OfYear iOfYear;
        final String iNameKey;
        final int iSaveMillis;

        static Recurrence readFrom(DataInput dataInput) throws IOException {
            return new Recurrence(OfYear.readFrom(dataInput), dataInput.readUTF(), (int)DateTimeZoneBuilder.readMillis(dataInput));
        }

        Recurrence(OfYear ofYear, String string, int n2) {
            this.iOfYear = ofYear;
            this.iNameKey = string;
            this.iSaveMillis = n2;
        }

        public OfYear getOfYear() {
            return this.iOfYear;
        }

        public long next(long l2, int n2, int n3) {
            return this.iOfYear.next(l2, n2, n3);
        }

        public long previous(long l2, int n2, int n3) {
            return this.iOfYear.previous(l2, n2, n3);
        }

        public String getNameKey() {
            return this.iNameKey;
        }

        public int getSaveMillis() {
            return this.iSaveMillis;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Recurrence) {
                Recurrence recurrence = (Recurrence)object;
                return this.iSaveMillis == recurrence.iSaveMillis && this.iNameKey.equals(recurrence.iNameKey) && this.iOfYear.equals(recurrence.iOfYear);
            }
            return false;
        }

        public void writeTo(DataOutput dataOutput) throws IOException {
            this.iOfYear.writeTo(dataOutput);
            dataOutput.writeUTF(this.iNameKey);
            DateTimeZoneBuilder.writeMillis(dataOutput, this.iSaveMillis);
        }

        Recurrence rename(String string) {
            return new Recurrence(this.iOfYear, string, this.iSaveMillis);
        }

        Recurrence renameAppend(String string) {
            return this.rename((this.iNameKey + string).intern());
        }
    }

    private static final class OfYear {
        final char iMode;
        final int iMonthOfYear;
        final int iDayOfMonth;
        final int iDayOfWeek;
        final boolean iAdvance;
        final int iMillisOfDay;

        static OfYear readFrom(DataInput dataInput) throws IOException {
            return new OfYear((char)dataInput.readUnsignedByte(), dataInput.readUnsignedByte(), dataInput.readByte(), dataInput.readUnsignedByte(), dataInput.readBoolean(), (int)DateTimeZoneBuilder.readMillis(dataInput));
        }

        OfYear(char c2, int n2, int n3, int n4, boolean bl2, int n5) {
            if (c2 != 'u' && c2 != 'w' && c2 != 's') {
                throw new IllegalArgumentException("Unknown mode: " + c2);
            }
            this.iMode = c2;
            this.iMonthOfYear = n2;
            this.iDayOfMonth = n3;
            this.iDayOfWeek = n4;
            this.iAdvance = bl2;
            this.iMillisOfDay = n5;
        }

        public long setInstant(int n2, int n3, int n4) {
            int n5 = this.iMode == 'w' ? n3 + n4 : (this.iMode == 's' ? n3 : 0);
            ISOChronology iSOChronology = ISOChronology.getInstanceUTC();
            long l2 = ((Chronology)iSOChronology).year().set(0L, n2);
            l2 = ((Chronology)iSOChronology).monthOfYear().set(l2, this.iMonthOfYear);
            l2 = ((Chronology)iSOChronology).millisOfDay().set(l2, this.iMillisOfDay);
            l2 = this.setDayOfMonth(iSOChronology, l2);
            if (this.iDayOfWeek != 0) {
                l2 = this.setDayOfWeek(iSOChronology, l2);
            }
            return l2 - (long)n5;
        }

        public long next(long l2, int n2, int n3) {
            int n4 = this.iMode == 'w' ? n2 + n3 : (this.iMode == 's' ? n2 : 0);
            ISOChronology iSOChronology = ISOChronology.getInstanceUTC();
            long l3 = ((Chronology)iSOChronology).monthOfYear().set(l2 += (long)n4, this.iMonthOfYear);
            l3 = ((Chronology)iSOChronology).millisOfDay().set(l3, 0);
            l3 = ((Chronology)iSOChronology).millisOfDay().add(l3, this.iMillisOfDay);
            l3 = this.setDayOfMonthNext(iSOChronology, l3);
            if (this.iDayOfWeek == 0) {
                if (l3 <= l2) {
                    l3 = ((Chronology)iSOChronology).year().add(l3, 1);
                    l3 = this.setDayOfMonthNext(iSOChronology, l3);
                }
            } else if ((l3 = this.setDayOfWeek(iSOChronology, l3)) <= l2) {
                l3 = ((Chronology)iSOChronology).year().add(l3, 1);
                l3 = ((Chronology)iSOChronology).monthOfYear().set(l3, this.iMonthOfYear);
                l3 = this.setDayOfMonthNext(iSOChronology, l3);
                l3 = this.setDayOfWeek(iSOChronology, l3);
            }
            return l3 - (long)n4;
        }

        public long previous(long l2, int n2, int n3) {
            int n4 = this.iMode == 'w' ? n2 + n3 : (this.iMode == 's' ? n2 : 0);
            ISOChronology iSOChronology = ISOChronology.getInstanceUTC();
            long l3 = ((Chronology)iSOChronology).monthOfYear().set(l2 += (long)n4, this.iMonthOfYear);
            l3 = ((Chronology)iSOChronology).millisOfDay().set(l3, 0);
            l3 = ((Chronology)iSOChronology).millisOfDay().add(l3, this.iMillisOfDay);
            l3 = this.setDayOfMonthPrevious(iSOChronology, l3);
            if (this.iDayOfWeek == 0) {
                if (l3 >= l2) {
                    l3 = ((Chronology)iSOChronology).year().add(l3, -1);
                    l3 = this.setDayOfMonthPrevious(iSOChronology, l3);
                }
            } else if ((l3 = this.setDayOfWeek(iSOChronology, l3)) >= l2) {
                l3 = ((Chronology)iSOChronology).year().add(l3, -1);
                l3 = ((Chronology)iSOChronology).monthOfYear().set(l3, this.iMonthOfYear);
                l3 = this.setDayOfMonthPrevious(iSOChronology, l3);
                l3 = this.setDayOfWeek(iSOChronology, l3);
            }
            return l3 - (long)n4;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof OfYear) {
                OfYear ofYear = (OfYear)object;
                return this.iMode == ofYear.iMode && this.iMonthOfYear == ofYear.iMonthOfYear && this.iDayOfMonth == ofYear.iDayOfMonth && this.iDayOfWeek == ofYear.iDayOfWeek && this.iAdvance == ofYear.iAdvance && this.iMillisOfDay == ofYear.iMillisOfDay;
            }
            return false;
        }

        public void writeTo(DataOutput dataOutput) throws IOException {
            dataOutput.writeByte(this.iMode);
            dataOutput.writeByte(this.iMonthOfYear);
            dataOutput.writeByte(this.iDayOfMonth);
            dataOutput.writeByte(this.iDayOfWeek);
            dataOutput.writeBoolean(this.iAdvance);
            DateTimeZoneBuilder.writeMillis(dataOutput, this.iMillisOfDay);
        }

        private long setDayOfMonthNext(Chronology chronology, long l2) {
            try {
                l2 = this.setDayOfMonth(chronology, l2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.iMonthOfYear == 2 && this.iDayOfMonth == 29) {
                    while (!chronology.year().isLeap(l2)) {
                        l2 = chronology.year().add(l2, 1);
                    }
                    l2 = this.setDayOfMonth(chronology, l2);
                }
                throw illegalArgumentException;
            }
            return l2;
        }

        private long setDayOfMonthPrevious(Chronology chronology, long l2) {
            try {
                l2 = this.setDayOfMonth(chronology, l2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.iMonthOfYear == 2 && this.iDayOfMonth == 29) {
                    while (!chronology.year().isLeap(l2)) {
                        l2 = chronology.year().add(l2, -1);
                    }
                    l2 = this.setDayOfMonth(chronology, l2);
                }
                throw illegalArgumentException;
            }
            return l2;
        }

        private long setDayOfMonth(Chronology chronology, long l2) {
            if (this.iDayOfMonth >= 0) {
                l2 = chronology.dayOfMonth().set(l2, this.iDayOfMonth);
            } else {
                l2 = chronology.dayOfMonth().set(l2, 1);
                l2 = chronology.monthOfYear().add(l2, 1);
                l2 = chronology.dayOfMonth().add(l2, this.iDayOfMonth);
            }
            return l2;
        }

        private long setDayOfWeek(Chronology chronology, long l2) {
            int n2 = chronology.dayOfWeek().get(l2);
            int n3 = this.iDayOfWeek - n2;
            if (n3 != 0) {
                if (this.iAdvance) {
                    if (n3 < 0) {
                        n3 += 7;
                    }
                } else if (n3 > 0) {
                    n3 -= 7;
                }
                l2 = chronology.dayOfWeek().add(l2, n3);
            }
            return l2;
        }
    }
}

