/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.field.MillisDurationField;
import org.joda.time.field.PreciseDateTimeField;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;
import org.joda.time.format.DateTimeParserInternalParser;
import org.joda.time.format.DateTimePrinter;
import org.joda.time.format.DateTimePrinterInternalPrinter;
import org.joda.time.format.FormatUtils;
import org.joda.time.format.InternalParser;
import org.joda.time.format.InternalParserDateTimeParser;
import org.joda.time.format.InternalPrinter;
import org.joda.time.format.InternalPrinterDateTimePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeFormatterBuilder {
    private ArrayList<Object> iElementPairs = new ArrayList();
    private Object iFormatter;

    public DateTimeFormatter toFormatter() {
        Object object = this.getFormatter();
        InternalPrinter internalPrinter = null;
        if (this.isPrinter(object)) {
            internalPrinter = (InternalPrinter)object;
        }
        InternalParser internalParser = null;
        if (this.isParser(object)) {
            internalParser = (InternalParser)object;
        }
        if (internalPrinter != null || internalParser != null) {
            return new DateTimeFormatter(internalPrinter, internalParser);
        }
        throw new UnsupportedOperationException("Both printing and parsing not supported");
    }

    public DateTimePrinter toPrinter() {
        Object object = this.getFormatter();
        if (this.isPrinter(object)) {
            InternalPrinter internalPrinter = (InternalPrinter)object;
            return InternalPrinterDateTimePrinter.of(internalPrinter);
        }
        throw new UnsupportedOperationException("Printing is not supported");
    }

    public DateTimeParser toParser() {
        Object object = this.getFormatter();
        if (this.isParser(object)) {
            InternalParser internalParser = (InternalParser)object;
            return InternalParserDateTimeParser.of(internalParser);
        }
        throw new UnsupportedOperationException("Parsing is not supported");
    }

    public boolean canBuildFormatter() {
        return this.isFormatter(this.getFormatter());
    }

    public boolean canBuildPrinter() {
        return this.isPrinter(this.getFormatter());
    }

    public boolean canBuildParser() {
        return this.isParser(this.getFormatter());
    }

    public void clear() {
        this.iFormatter = null;
        this.iElementPairs.clear();
    }

    public DateTimeFormatterBuilder append(DateTimeFormatter dateTimeFormatter) {
        if (dateTimeFormatter == null) {
            throw new IllegalArgumentException("No formatter supplied");
        }
        return this.append0(dateTimeFormatter.getPrinter0(), dateTimeFormatter.getParser0());
    }

    public DateTimeFormatterBuilder append(DateTimePrinter dateTimePrinter) {
        this.checkPrinter(dateTimePrinter);
        return this.append0(DateTimePrinterInternalPrinter.of(dateTimePrinter), null);
    }

    public DateTimeFormatterBuilder append(DateTimeParser dateTimeParser) {
        this.checkParser(dateTimeParser);
        return this.append0(null, DateTimeParserInternalParser.of(dateTimeParser));
    }

    public DateTimeFormatterBuilder append(DateTimePrinter dateTimePrinter, DateTimeParser dateTimeParser) {
        this.checkPrinter(dateTimePrinter);
        this.checkParser(dateTimeParser);
        return this.append0(DateTimePrinterInternalPrinter.of(dateTimePrinter), DateTimeParserInternalParser.of(dateTimeParser));
    }

    public DateTimeFormatterBuilder append(DateTimePrinter dateTimePrinter, DateTimeParser[] dateTimeParserArray) {
        int n2;
        if (dateTimePrinter != null) {
            this.checkPrinter(dateTimePrinter);
        }
        if (dateTimeParserArray == null) {
            throw new IllegalArgumentException("No parsers supplied");
        }
        int n3 = dateTimeParserArray.length;
        if (n3 == 1) {
            if (dateTimeParserArray[0] == null) {
                throw new IllegalArgumentException("No parser supplied");
            }
            return this.append0(DateTimePrinterInternalPrinter.of(dateTimePrinter), DateTimeParserInternalParser.of(dateTimeParserArray[0]));
        }
        InternalParser[] internalParserArray = new InternalParser[n3];
        for (n2 = 0; n2 < n3 - 1; ++n2) {
            internalParserArray[n2] = DateTimeParserInternalParser.of(dateTimeParserArray[n2]);
            if (internalParserArray[n2] != null) continue;
            throw new IllegalArgumentException("Incomplete parser array");
        }
        internalParserArray[n2] = DateTimeParserInternalParser.of(dateTimeParserArray[n2]);
        return this.append0(DateTimePrinterInternalPrinter.of(dateTimePrinter), new MatchingParser(internalParserArray));
    }

    public DateTimeFormatterBuilder appendOptional(DateTimeParser dateTimeParser) {
        this.checkParser(dateTimeParser);
        InternalParser[] internalParserArray = new InternalParser[]{DateTimeParserInternalParser.of(dateTimeParser), null};
        return this.append0(null, new MatchingParser(internalParserArray));
    }

    private void checkParser(DateTimeParser dateTimeParser) {
        if (dateTimeParser == null) {
            throw new IllegalArgumentException("No parser supplied");
        }
    }

    private void checkPrinter(DateTimePrinter dateTimePrinter) {
        if (dateTimePrinter == null) {
            throw new IllegalArgumentException("No printer supplied");
        }
    }

    private DateTimeFormatterBuilder append0(Object object) {
        this.iFormatter = null;
        this.iElementPairs.add(object);
        this.iElementPairs.add(object);
        return this;
    }

    private DateTimeFormatterBuilder append0(InternalPrinter internalPrinter, InternalParser internalParser) {
        this.iFormatter = null;
        this.iElementPairs.add(internalPrinter);
        this.iElementPairs.add(internalParser);
        return this;
    }

    public DateTimeFormatterBuilder appendLiteral(char c2) {
        return this.append0(new CharacterLiteral(c2));
    }

    public DateTimeFormatterBuilder appendLiteral(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Literal must not be null");
        }
        switch (string.length()) {
            case 0: {
                return this;
            }
            case 1: {
                return this.append0(new CharacterLiteral(string.charAt(0)));
            }
        }
        return this.append0(new StringLiteral(string));
    }

    public DateTimeFormatterBuilder appendDecimal(DateTimeFieldType dateTimeFieldType, int n2, int n3) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (n3 < n2) {
            n3 = n2;
        }
        if (n2 < 0 || n3 <= 0) {
            throw new IllegalArgumentException();
        }
        if (n2 <= 1) {
            return this.append0(new UnpaddedNumber(dateTimeFieldType, n3, false));
        }
        return this.append0(new PaddedNumber(dateTimeFieldType, n3, false, n2));
    }

    public DateTimeFormatterBuilder appendFixedDecimal(DateTimeFieldType dateTimeFieldType, int n2) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Illegal number of digits: " + n2);
        }
        return this.append0(new FixedNumber(dateTimeFieldType, n2, false));
    }

    public DateTimeFormatterBuilder appendSignedDecimal(DateTimeFieldType dateTimeFieldType, int n2, int n3) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (n3 < n2) {
            n3 = n2;
        }
        if (n2 < 0 || n3 <= 0) {
            throw new IllegalArgumentException();
        }
        if (n2 <= 1) {
            return this.append0(new UnpaddedNumber(dateTimeFieldType, n3, true));
        }
        return this.append0(new PaddedNumber(dateTimeFieldType, n3, true, n2));
    }

    public DateTimeFormatterBuilder appendFixedSignedDecimal(DateTimeFieldType dateTimeFieldType, int n2) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Illegal number of digits: " + n2);
        }
        return this.append0(new FixedNumber(dateTimeFieldType, n2, true));
    }

    public DateTimeFormatterBuilder appendText(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        return this.append0(new TextField(dateTimeFieldType, false));
    }

    public DateTimeFormatterBuilder appendShortText(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        return this.append0(new TextField(dateTimeFieldType, true));
    }

    public DateTimeFormatterBuilder appendFraction(DateTimeFieldType dateTimeFieldType, int n2, int n3) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (n3 < n2) {
            n3 = n2;
        }
        if (n2 < 0 || n3 <= 0) {
            throw new IllegalArgumentException();
        }
        return this.append0(new Fraction(dateTimeFieldType, n2, n3));
    }

    public DateTimeFormatterBuilder appendFractionOfSecond(int n2, int n3) {
        return this.appendFraction(DateTimeFieldType.secondOfDay(), n2, n3);
    }

    public DateTimeFormatterBuilder appendFractionOfMinute(int n2, int n3) {
        return this.appendFraction(DateTimeFieldType.minuteOfDay(), n2, n3);
    }

    public DateTimeFormatterBuilder appendFractionOfHour(int n2, int n3) {
        return this.appendFraction(DateTimeFieldType.hourOfDay(), n2, n3);
    }

    public DateTimeFormatterBuilder appendFractionOfDay(int n2, int n3) {
        return this.appendFraction(DateTimeFieldType.dayOfYear(), n2, n3);
    }

    public DateTimeFormatterBuilder appendMillisOfSecond(int n2) {
        return this.appendDecimal(DateTimeFieldType.millisOfSecond(), n2, 3);
    }

    public DateTimeFormatterBuilder appendMillisOfDay(int n2) {
        return this.appendDecimal(DateTimeFieldType.millisOfDay(), n2, 8);
    }

    public DateTimeFormatterBuilder appendSecondOfMinute(int n2) {
        return this.appendDecimal(DateTimeFieldType.secondOfMinute(), n2, 2);
    }

    public DateTimeFormatterBuilder appendSecondOfDay(int n2) {
        return this.appendDecimal(DateTimeFieldType.secondOfDay(), n2, 5);
    }

    public DateTimeFormatterBuilder appendMinuteOfHour(int n2) {
        return this.appendDecimal(DateTimeFieldType.minuteOfHour(), n2, 2);
    }

    public DateTimeFormatterBuilder appendMinuteOfDay(int n2) {
        return this.appendDecimal(DateTimeFieldType.minuteOfDay(), n2, 4);
    }

    public DateTimeFormatterBuilder appendHourOfDay(int n2) {
        return this.appendDecimal(DateTimeFieldType.hourOfDay(), n2, 2);
    }

    public DateTimeFormatterBuilder appendClockhourOfDay(int n2) {
        return this.appendDecimal(DateTimeFieldType.clockhourOfDay(), n2, 2);
    }

    public DateTimeFormatterBuilder appendHourOfHalfday(int n2) {
        return this.appendDecimal(DateTimeFieldType.hourOfHalfday(), n2, 2);
    }

    public DateTimeFormatterBuilder appendClockhourOfHalfday(int n2) {
        return this.appendDecimal(DateTimeFieldType.clockhourOfHalfday(), n2, 2);
    }

    public DateTimeFormatterBuilder appendDayOfWeek(int n2) {
        return this.appendDecimal(DateTimeFieldType.dayOfWeek(), n2, 1);
    }

    public DateTimeFormatterBuilder appendDayOfMonth(int n2) {
        return this.appendDecimal(DateTimeFieldType.dayOfMonth(), n2, 2);
    }

    public DateTimeFormatterBuilder appendDayOfYear(int n2) {
        return this.appendDecimal(DateTimeFieldType.dayOfYear(), n2, 3);
    }

    public DateTimeFormatterBuilder appendWeekOfWeekyear(int n2) {
        return this.appendDecimal(DateTimeFieldType.weekOfWeekyear(), n2, 2);
    }

    public DateTimeFormatterBuilder appendWeekyear(int n2, int n3) {
        return this.appendSignedDecimal(DateTimeFieldType.weekyear(), n2, n3);
    }

    public DateTimeFormatterBuilder appendMonthOfYear(int n2) {
        return this.appendDecimal(DateTimeFieldType.monthOfYear(), n2, 2);
    }

    public DateTimeFormatterBuilder appendYear(int n2, int n3) {
        return this.appendSignedDecimal(DateTimeFieldType.year(), n2, n3);
    }

    public DateTimeFormatterBuilder appendTwoDigitYear(int n2) {
        return this.appendTwoDigitYear(n2, false);
    }

    public DateTimeFormatterBuilder appendTwoDigitYear(int n2, boolean bl2) {
        return this.append0(new TwoDigitYear(DateTimeFieldType.year(), n2, bl2));
    }

    public DateTimeFormatterBuilder appendTwoDigitWeekyear(int n2) {
        return this.appendTwoDigitWeekyear(n2, false);
    }

    public DateTimeFormatterBuilder appendTwoDigitWeekyear(int n2, boolean bl2) {
        return this.append0(new TwoDigitYear(DateTimeFieldType.weekyear(), n2, bl2));
    }

    public DateTimeFormatterBuilder appendYearOfEra(int n2, int n3) {
        return this.appendDecimal(DateTimeFieldType.yearOfEra(), n2, n3);
    }

    public DateTimeFormatterBuilder appendYearOfCentury(int n2, int n3) {
        return this.appendDecimal(DateTimeFieldType.yearOfCentury(), n2, n3);
    }

    public DateTimeFormatterBuilder appendCenturyOfEra(int n2, int n3) {
        return this.appendSignedDecimal(DateTimeFieldType.centuryOfEra(), n2, n3);
    }

    public DateTimeFormatterBuilder appendHalfdayOfDayText() {
        return this.appendText(DateTimeFieldType.halfdayOfDay());
    }

    public DateTimeFormatterBuilder appendDayOfWeekText() {
        return this.appendText(DateTimeFieldType.dayOfWeek());
    }

    public DateTimeFormatterBuilder appendDayOfWeekShortText() {
        return this.appendShortText(DateTimeFieldType.dayOfWeek());
    }

    public DateTimeFormatterBuilder appendMonthOfYearText() {
        return this.appendText(DateTimeFieldType.monthOfYear());
    }

    public DateTimeFormatterBuilder appendMonthOfYearShortText() {
        return this.appendShortText(DateTimeFieldType.monthOfYear());
    }

    public DateTimeFormatterBuilder appendEraText() {
        return this.appendText(DateTimeFieldType.era());
    }

    public DateTimeFormatterBuilder appendTimeZoneName() {
        return this.append0(new TimeZoneName(0, null), null);
    }

    public DateTimeFormatterBuilder appendTimeZoneName(Map<String, DateTimeZone> map) {
        TimeZoneName timeZoneName = new TimeZoneName(0, map);
        return this.append0(timeZoneName, timeZoneName);
    }

    public DateTimeFormatterBuilder appendTimeZoneShortName() {
        return this.append0(new TimeZoneName(1, null), null);
    }

    public DateTimeFormatterBuilder appendTimeZoneShortName(Map<String, DateTimeZone> map) {
        TimeZoneName timeZoneName = new TimeZoneName(1, map);
        return this.append0(timeZoneName, timeZoneName);
    }

    public DateTimeFormatterBuilder appendTimeZoneId() {
        return this.append0(TimeZoneId.INSTANCE, TimeZoneId.INSTANCE);
    }

    public DateTimeFormatterBuilder appendTimeZoneOffset(String string, boolean bl2, int n2, int n3) {
        return this.append0(new TimeZoneOffset(string, string, bl2, n2, n3));
    }

    public DateTimeFormatterBuilder appendTimeZoneOffset(String string, String string2, boolean bl2, int n2, int n3) {
        return this.append0(new TimeZoneOffset(string, string2, bl2, n2, n3));
    }

    public DateTimeFormatterBuilder appendPattern(String string) {
        DateTimeFormat.appendPatternTo(this, string);
        return this;
    }

    private Object getFormatter() {
        Object object = this.iFormatter;
        if (object == null) {
            if (this.iElementPairs.size() == 2) {
                Object object2 = this.iElementPairs.get(0);
                Object object3 = this.iElementPairs.get(1);
                if (object2 != null) {
                    if (object2 == object3 || object3 == null) {
                        object = object2;
                    }
                } else {
                    object = object3;
                }
            }
            if (object == null) {
                object = new Composite(this.iElementPairs);
            }
            this.iFormatter = object;
        }
        return object;
    }

    private boolean isPrinter(Object object) {
        if (object instanceof InternalPrinter) {
            if (object instanceof Composite) {
                return ((Composite)object).isPrinter();
            }
            return true;
        }
        return false;
    }

    private boolean isParser(Object object) {
        if (object instanceof InternalParser) {
            if (object instanceof Composite) {
                return ((Composite)object).isParser();
            }
            return true;
        }
        return false;
    }

    private boolean isFormatter(Object object) {
        return this.isPrinter(object) || this.isParser(object);
    }

    static void appendUnknownString(Appendable appendable, int n2) throws IOException {
        int n3 = n2;
        while (--n3 >= 0) {
            appendable.append('\ufffd');
        }
    }

    static int csCompare(CharSequence charSequence, int n2, String string) {
        int n3 = charSequence.length() - n2;
        int n4 = string.length();
        int n5 = Math.min(n3, n4);
        for (int i2 = 0; i2 < n5; ++i2) {
            int n6 = string.charAt(i2) - charSequence.charAt(n2 + i2);
            if (n6 == 0) continue;
            return n6;
        }
        return n4 - n3;
    }

    static boolean csStartsWith(CharSequence charSequence, int n2, String string) {
        int n3 = string.length();
        if (charSequence.length() - n2 < n3) {
            return false;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (charSequence.charAt(n2 + i2) == string.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    static boolean csStartsWithIgnoreCase(CharSequence charSequence, int n2, String string) {
        int n3 = string.length();
        if (charSequence.length() - n2 < n3) {
            return false;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2;
            char c3;
            char c4;
            char c5 = charSequence.charAt(n2 + i2);
            if (c5 == (c4 = string.charAt(i2)) || (c3 = Character.toUpperCase(c5)) == (c2 = Character.toUpperCase(c4)) || Character.toLowerCase(c3) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    static class MatchingParser
    implements InternalParser {
        private final InternalParser[] iParsers;
        private final int iParsedLengthEstimate;

        MatchingParser(InternalParser[] internalParserArray) {
            this.iParsers = internalParserArray;
            int n2 = 0;
            int n3 = internalParserArray.length;
            while (--n3 >= 0) {
                int n4;
                InternalParser internalParser = internalParserArray[n3];
                if (internalParser == null || (n4 = internalParser.estimateParsedLength()) <= n2) continue;
                n2 = n4;
            }
            this.iParsedLengthEstimate = n2;
        }

        public int estimateParsedLength() {
            return this.iParsedLengthEstimate;
        }

        public int parseInto(DateTimeParserBucket dateTimeParserBucket, CharSequence charSequence, int n2) {
            InternalParser[] internalParserArray = this.iParsers;
            int n3 = internalParserArray.length;
            Object object = dateTimeParserBucket.saveState();
            boolean bl2 = false;
            int n4 = n2;
            Object object2 = null;
            int n5 = n2;
            for (int i2 = 0; i2 < n3; ++i2) {
                InternalParser internalParser = internalParserArray[i2];
                if (internalParser == null) {
                    if (n4 <= n2) {
                        return n2;
                    }
                    bl2 = true;
                    break;
                }
                int n6 = internalParser.parseInto(dateTimeParserBucket, charSequence, n2);
                if (n6 >= n2) {
                    if (n6 > n4) {
                        if (n6 >= charSequence.length() || i2 + 1 >= n3 || internalParserArray[i2 + 1] == null) {
                            return n6;
                        }
                        n4 = n6;
                        object2 = dateTimeParserBucket.saveState();
                    }
                } else if (n6 < 0 && (n6 ^= 0xFFFFFFFF) > n5) {
                    n5 = n6;
                }
                dateTimeParserBucket.restoreState(object);
            }
            if (n4 > n2 || n4 == n2 && bl2) {
                if (object2 != null) {
                    dateTimeParserBucket.restoreState(object2);
                }
                return n4;
            }
            return ~n5;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Composite
    implements InternalPrinter,
    InternalParser {
        private final InternalPrinter[] iPrinters;
        private final InternalParser[] iParsers;
        private final int iPrintedLengthEstimate;
        private final int iParsedLengthEstimate;

        Composite(List<Object> list) {
            Object object;
            int n2;
            int n3;
            int n4;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            this.decompose(list, arrayList, arrayList2);
            if (arrayList.contains(null) || arrayList.isEmpty()) {
                this.iPrinters = null;
                this.iPrintedLengthEstimate = 0;
            } else {
                n4 = arrayList.size();
                this.iPrinters = new InternalPrinter[n4];
                n3 = 0;
                for (n2 = 0; n2 < n4; ++n2) {
                    object = (InternalPrinter)arrayList.get(n2);
                    n3 += object.estimatePrintedLength();
                    this.iPrinters[n2] = object;
                }
                this.iPrintedLengthEstimate = n3;
            }
            if (arrayList2.contains(null) || arrayList2.isEmpty()) {
                this.iParsers = null;
                this.iParsedLengthEstimate = 0;
            } else {
                n4 = arrayList2.size();
                this.iParsers = new InternalParser[n4];
                n3 = 0;
                for (n2 = 0; n2 < n4; ++n2) {
                    object = (InternalParser)arrayList2.get(n2);
                    n3 += object.estimateParsedLength();
                    this.iParsers[n2] = object;
                }
                this.iParsedLengthEstimate = n3;
            }
        }

        @Override
        public int estimatePrintedLength() {
            return this.iPrintedLengthEstimate;
        }

        @Override
        public void printTo(Appendable appendable, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            InternalPrinter[] internalPrinterArray = this.iPrinters;
            if (internalPrinterArray == null) {
                throw new UnsupportedOperationException();
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            int n3 = internalPrinterArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                internalPrinterArray[i2].printTo(appendable, l2, chronology, n2, dateTimeZone, locale);
            }
        }

        @Override
        public void printTo(Appendable appendable, ReadablePartial readablePartial, Locale locale) throws IOException {
            InternalPrinter[] internalPrinterArray = this.iPrinters;
            if (internalPrinterArray == null) {
                throw new UnsupportedOperationException();
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            int n2 = internalPrinterArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                internalPrinterArray[i2].printTo(appendable, readablePartial, locale);
            }
        }

        @Override
        public int estimateParsedLength() {
            return this.iParsedLengthEstimate;
        }

        @Override
        public int parseInto(DateTimeParserBucket dateTimeParserBucket, CharSequence charSequence, int n2) {
            InternalParser[] internalParserArray = this.iParsers;
            if (internalParserArray == null) {
                throw new UnsupportedOperationException();
            }
            int n3 = internalParserArray.length;
            for (int i2 = 0; i2 < n3 && n2 >= 0; ++i2) {
                n2 = internalParserArray[i2].parseInto(dateTimeParserBucket, charSequence, n2);
            }
            return n2;
        }

        boolean isPrinter() {
            return this.iPrinters != null;
        }

        boolean isParser() {
            return this.iParsers != null;
        }

        private void decompose(List<Object> list, List<Object> list2, List<Object> list3) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; i2 += 2) {
                Object object = list.get(i2);
                if (object instanceof Composite) {
                    this.addArrayToList(list2, ((Composite)object).iPrinters);
                } else {
                    list2.add(object);
                }
                object = list.get(i2 + 1);
                if (object instanceof Composite) {
                    this.addArrayToList(list3, ((Composite)object).iParsers);
                    continue;
                }
                list3.add(object);
            }
        }

        private void addArrayToList(List<Object> list, Object[] objectArray) {
            if (objectArray != null) {
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    list.add(objectArray[i2]);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TimeZoneId implements InternalPrinter,
    InternalParser
    {
        INSTANCE;

        private static final List<String> ALL_IDS;
        static final int MAX_LENGTH;

        @Override
        public int estimatePrintedLength() {
            return MAX_LENGTH;
        }

        @Override
        public void printTo(Appendable appendable, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            appendable.append(dateTimeZone != null ? dateTimeZone.getID() : "");
        }

        @Override
        public void printTo(Appendable appendable, ReadablePartial readablePartial, Locale locale) throws IOException {
        }

        @Override
        public int estimateParsedLength() {
            return MAX_LENGTH;
        }

        @Override
        public int parseInto(DateTimeParserBucket dateTimeParserBucket, CharSequence charSequence, int n2) {
            int n3;
            String string;
            String string2 = null;
            for (int i2 = n3 = TimeZoneId.prefixedStartPosition(charSequence, n2); i2 < ALL_IDS.size() && DateTimeFormatterBuilder.csStartsWith(charSequence, n2, string = ALL_IDS.get(i2)); ++i2) {
                if (string2 != null && string.length() <= string2.length()) continue;
                string2 = string;
            }
            if (string2 != null) {
                dateTimeParserBucket.setZone(DateTimeZone.forID(string2));
                return n2 + string2.length();
            }
            return ~n2;
        }

        private static int prefixedStartPosition(CharSequence charSequence, int n2) {
            int n3 = 0;
            int n4 = ALL_IDS.size() - 1;
            while (n3 <= n4) {
                int n5 = n3 + n4 >>> 1;
                String string = ALL_IDS.get(n5);
                int n6 = DateTimeFormatterBuilder.csCompare(charSequence, n2, string);
                if (n6 > 0) {
                    n4 = n5 - 1;
                    continue;
                }
                if (n6 < 0) {
                    n3 = n5 + 1;
                    continue;
                }
                return n5;
            }
            return n3;
        }

        static {
            ALL_IDS = new ArrayList<String>(DateTimeZone.getAvailableIDs());
            Collections.sort(ALL_IDS);
            int n2 = 0;
            for (String string : ALL_IDS) {
                n2 = Math.max(n2, string.length());
            }
            MAX_LENGTH = n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TimeZoneName
    implements InternalPrinter,
    InternalParser {
        static final int LONG_NAME = 0;
        static final int SHORT_NAME = 1;
        private final Map<String, DateTimeZone> iParseLookup;
        private final int iType;

        TimeZoneName(int n2, Map<String, DateTimeZone> map) {
            this.iType = n2;
            this.iParseLookup = map;
        }

        @Override
        public int estimatePrintedLength() {
            return this.iType == 1 ? 4 : 20;
        }

        @Override
        public void printTo(Appendable appendable, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            appendable.append(this.print(l2 - (long)n2, dateTimeZone, locale));
        }

        private String print(long l2, DateTimeZone dateTimeZone, Locale locale) {
            if (dateTimeZone == null) {
                return "";
            }
            switch (this.iType) {
                case 0: {
                    return dateTimeZone.getName(l2, locale);
                }
                case 1: {
                    return dateTimeZone.getShortName(l2, locale);
                }
            }
            return "";
        }

        @Override
        public void printTo(Appendable appendable, ReadablePartial readablePartial, Locale locale) throws IOException {
        }

        @Override
        public int estimateParsedLength() {
            return this.iType == 1 ? 4 : 20;
        }

        @Override
        public int parseInto(DateTimeParserBucket dateTimeParserBucket, CharSequence charSequence, int n2) {
            Map<String, DateTimeZone> map = this.iParseLookup;
            map = map != null ? map : DateTimeUtils.getDefaultTimeZoneNames();
            String string = null;
            for (String string2 : map.keySet()) {
                if (!DateTimeFormatterBuilder.csStartsWith(charSequence, n2, string2) || string != null && string2.length() <= string.length()) continue;
                string = string2;
            }
            if (string != null) {
                dateTimeParserBucket.setZone(map.get(string));
                return n2 + string.length();
            }
            return ~n2;
        }
    }

    static class TimeZoneOffset
    implements InternalPrinter,
    InternalParser {
        private final String iZeroOffsetPrintText;
        private final String iZeroOffsetParseText;
        private final boolean iShowSeparators;
        private final int iMinFields;
        private final int iMaxFields;

        TimeZoneOffset(String string, String string2, boolean bl2, int n2, int n3) {
            this.iZeroOffsetPrintText = string;
            this.iZeroOffsetParseText = string2;
            this.iShowSeparators = bl2;
            if (n2 <= 0 || n3 < n2) {
                throw new IllegalArgumentException();
            }
            if (n2 > 4) {
                n2 = 4;
                n3 = 4;
            }
            this.iMinFields = n2;
            this.iMaxFields = n3;
        }

        public int estimatePrintedLength() {
            int n2 = 1 + this.iMinFields << 1;
            if (this.iShowSeparators) {
                n2 += this.iMinFields - 1;
            }
            if (this.iZeroOffsetPrintText != null && this.iZeroOffsetPrintText.length() > n2) {
                n2 = this.iZeroOffsetPrintText.length();
            }
            return n2;
        }

        public void printTo(Appendable appendable, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            if (dateTimeZone == null) {
                return;
            }
            if (n2 == 0 && this.iZeroOffsetPrintText != null) {
                appendable.append(this.iZeroOffsetPrintText);
                return;
            }
            if (n2 >= 0) {
                appendable.append('+');
            } else {
                appendable.append('-');
                n2 = -n2;
            }
            int n3 = n2 / 3600000;
            FormatUtils.appendPaddedInteger(appendable, n3, 2);
            if (this.iMaxFields == 1) {
                return;
            }
            if ((n2 -= n3 * 3600000) == 0 && this.iMinFields <= 1) {
                return;
            }
            int n4 = n2 / 60000;
            if (this.iShowSeparators) {
                appendable.append(':');
            }
            FormatUtils.appendPaddedInteger(appendable, n4, 2);
            if (this.iMaxFields == 2) {
                return;
            }
            if ((n2 -= n4 * 60000) == 0 && this.iMinFields <= 2) {
                return;
            }
            int n5 = n2 / 1000;
            if (this.iShowSeparators) {
                appendable.append(':');
            }
            FormatUtils.appendPaddedInteger(appendable, n5, 2);
            if (this.iMaxFields == 3) {
                return;
            }
            if ((n2 -= n5 * 1000) == 0 && this.iMinFields <= 3) {
                return;
            }
            if (this.iShowSeparators) {
                appendable.append('.');
            }
            FormatUtils.appendPaddedInteger(appendable, n2, 3);
        }

        public void printTo(Appendable appendable, ReadablePartial readablePartial, Locale locale) throws IOException {
        }

        public int estimateParsedLength() {
            return this.estimatePrintedLength();
        }

        public int parseInto(DateTimeParserBucket dateTimeParserBucket, CharSequence charSequence, int n2) {
            int n3;
            char c2;
            block24: {
                int n4;
                boolean bl2;
                block28: {
                    int n5;
                    block27: {
                        block26: {
                            char c3;
                            block25: {
                                n5 = charSequence.length() - n2;
                                if (this.iZeroOffsetParseText != null) {
                                    if (this.iZeroOffsetParseText.length() == 0) {
                                        if (n5 <= 0 || (c2 = charSequence.charAt(n2)) != '-' && c2 != '+') {
                                            dateTimeParserBucket.setOffset((Integer)0);
                                            return n2;
                                        }
                                    } else if (DateTimeFormatterBuilder.csStartsWithIgnoreCase(charSequence, n2, this.iZeroOffsetParseText)) {
                                        dateTimeParserBucket.setOffset((Integer)0);
                                        return n2 + this.iZeroOffsetParseText.length();
                                    }
                                }
                                if (n5 <= 1) {
                                    return ~n2;
                                }
                                c3 = charSequence.charAt(n2);
                                if (c3 == '-') {
                                    c2 = '\u0001';
                                } else if (c3 == '+') {
                                    c2 = '\u0000';
                                } else {
                                    return ~n2;
                                }
                                --n5;
                                if (this.digitCount(charSequence, ++n2, 2) < 2) {
                                    return ~n2;
                                }
                                int n6 = FormatUtils.parseTwoDigits(charSequence, n2);
                                if (n6 > 23) {
                                    return ~n2;
                                }
                                n3 = n6 * 3600000;
                                n2 += 2;
                                if ((n5 -= 2) <= 0) break block24;
                                c3 = charSequence.charAt(n2);
                                if (c3 != ':') break block25;
                                bl2 = true;
                                --n5;
                                ++n2;
                                break block26;
                            }
                            if (c3 < '0' || c3 > '9') break block24;
                            bl2 = false;
                        }
                        n4 = this.digitCount(charSequence, n2, 2);
                        if (n4 == 0 && !bl2) break block24;
                        if (n4 < 2) {
                            return ~n2;
                        }
                        int n7 = FormatUtils.parseTwoDigits(charSequence, n2);
                        if (n7 > 59) {
                            return ~n2;
                        }
                        n3 += n7 * 60000;
                        n2 += 2;
                        if ((n5 -= 2) <= 0) break block24;
                        if (!bl2) break block27;
                        if (charSequence.charAt(n2) != ':') break block24;
                        --n5;
                        ++n2;
                    }
                    if ((n4 = this.digitCount(charSequence, n2, 2)) == 0 && !bl2) break block24;
                    if (n4 < 2) {
                        return ~n2;
                    }
                    int n8 = FormatUtils.parseTwoDigits(charSequence, n2);
                    if (n8 > 59) {
                        return ~n2;
                    }
                    n3 += n8 * 1000;
                    n2 += 2;
                    if ((n5 -= 2) <= 0) break block24;
                    if (!bl2) break block28;
                    if (charSequence.charAt(n2) != '.' && charSequence.charAt(n2) != ',') break block24;
                    --n5;
                    ++n2;
                }
                if ((n4 = this.digitCount(charSequence, n2, 3)) != 0 || bl2) {
                    if (n4 < 1) {
                        return ~n2;
                    }
                    n3 += (charSequence.charAt(n2++) - 48) * 100;
                    if (n4 > 1) {
                        n3 += (charSequence.charAt(n2++) - 48) * 10;
                        if (n4 > 2) {
                            n3 += charSequence.charAt(n2++) - 48;
                        }
                    }
                }
            }
            dateTimeParserBucket.setOffset((Integer)(c2 != '\u0000' ? -n3 : n3));
            return n2;
        }

        private int digitCount(CharSequence charSequence, int n2, int n3) {
            char c2;
            int n4 = Math.min(charSequence.length() - n2, n3);
            n3 = 0;
            while (n4 > 0 && (c2 = charSequence.charAt(n2 + n3)) >= '0' && c2 <= '9') {
                ++n3;
                --n4;
            }
            return n3;
        }
    }

    static class Fraction
    implements InternalPrinter,
    InternalParser {
        private final DateTimeFieldType iFieldType;
        protected int iMinDigits;
        protected int iMaxDigits;

        protected Fraction(DateTimeFieldType dateTimeFieldType, int n2, int n3) {
            this.iFieldType = dateTimeFieldType;
            if (n3 > 18) {
                n3 = 18;
            }
            this.iMinDigits = n2;
            this.iMaxDigits = n3;
        }

        public int estimatePrintedLength() {
            return this.iMaxDigits;
        }

        public void printTo(Appendable appendable, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            this.printTo(appendable, l2, chronology);
        }

        public void printTo(Appendable appendable, ReadablePartial readablePartial, Locale locale) throws IOException {
            long l2 = readablePartial.getChronology().set(readablePartial, 0L);
            this.printTo(appendable, l2, readablePartial.getChronology());
        }

        protected void printTo(Appendable appendable, long l2, Chronology chronology) throws IOException {
            int n2;
            long l3;
            DateTimeField dateTimeField = this.iFieldType.getField(chronology);
            int n3 = this.iMinDigits;
            try {
                l3 = dateTimeField.remainder(l2);
            }
            catch (RuntimeException runtimeException) {
                DateTimeFormatterBuilder.appendUnknownString(appendable, n3);
                return;
            }
            if (l3 == 0L) {
                while (--n3 >= 0) {
                    appendable.append('0');
                }
                return;
            }
            long[] lArray = this.getFractionData(l3, dateTimeField);
            long l4 = lArray[0];
            int n4 = (int)lArray[1];
            String string = (l4 & Integer.MAX_VALUE) == l4 ? Integer.toString((int)l4) : Long.toString(l4);
            int n5 = string.length();
            for (n2 = n4; n5 < n2; --n2) {
                appendable.append('0');
                --n3;
            }
            if (n3 < n2) {
                while (n3 < n2 && n5 > 1 && string.charAt(n5 - 1) == '0') {
                    --n2;
                    --n5;
                }
                if (n5 < string.length()) {
                    for (int i2 = 0; i2 < n5; ++i2) {
                        appendable.append(string.charAt(i2));
                    }
                    return;
                }
            }
            appendable.append(string);
        }

        private long[] getFractionData(long l2, DateTimeField dateTimeField) {
            long l3;
            long l4 = dateTimeField.getDurationField().getUnitMillis();
            int n2 = this.iMaxDigits;
            while (true) {
                switch (n2) {
                    default: {
                        l3 = 1L;
                        break;
                    }
                    case 1: {
                        l3 = 10L;
                        break;
                    }
                    case 2: {
                        l3 = 100L;
                        break;
                    }
                    case 3: {
                        l3 = 1000L;
                        break;
                    }
                    case 4: {
                        l3 = 10000L;
                        break;
                    }
                    case 5: {
                        l3 = 100000L;
                        break;
                    }
                    case 6: {
                        l3 = 1000000L;
                        break;
                    }
                    case 7: {
                        l3 = 10000000L;
                        break;
                    }
                    case 8: {
                        l3 = 100000000L;
                        break;
                    }
                    case 9: {
                        l3 = 1000000000L;
                        break;
                    }
                    case 10: {
                        l3 = 10000000000L;
                        break;
                    }
                    case 11: {
                        l3 = 100000000000L;
                        break;
                    }
                    case 12: {
                        l3 = 1000000000000L;
                        break;
                    }
                    case 13: {
                        l3 = 10000000000000L;
                        break;
                    }
                    case 14: {
                        l3 = 100000000000000L;
                        break;
                    }
                    case 15: {
                        l3 = 1000000000000000L;
                        break;
                    }
                    case 16: {
                        l3 = 10000000000000000L;
                        break;
                    }
                    case 17: {
                        l3 = 100000000000000000L;
                        break;
                    }
                    case 18: {
                        l3 = 1000000000000000000L;
                    }
                }
                if (l4 * l3 / l3 == l4) break;
                --n2;
            }
            return new long[]{l2 * l3 / l4, n2};
        }

        public int estimateParsedLength() {
            return this.iMaxDigits;
        }

        public int parseInto(DateTimeParserBucket dateTimeParserBucket, CharSequence charSequence, int n2) {
            char c2;
            DateTimeField dateTimeField = this.iFieldType.getField(dateTimeParserBucket.getChronology());
            int n3 = Math.min(this.iMaxDigits, charSequence.length() - n2);
            long l2 = 0L;
            long l3 = dateTimeField.getDurationField().getUnitMillis() * 10L;
            int n4 = 0;
            while (n4 < n3 && (c2 = charSequence.charAt(n2 + n4)) >= '0' && c2 <= '9') {
                ++n4;
                long l4 = l3 / 10L;
                l2 += (long)(c2 - 48) * l4;
                l3 = l4;
            }
            l2 /= 10L;
            if (n4 == 0) {
                return ~n2;
            }
            if (l2 > Integer.MAX_VALUE) {
                return ~n2;
            }
            PreciseDateTimeField preciseDateTimeField = new PreciseDateTimeField(DateTimeFieldType.millisOfSecond(), MillisDurationField.INSTANCE, dateTimeField.getDurationField());
            dateTimeParserBucket.saveField(preciseDateTimeField, (int)l2);
            return n2 + n4;
        }
    }

    static class TextField
    implements InternalPrinter,
    InternalParser {
        private static Map<Locale, Map<DateTimeFieldType, Object[]>> cParseCache = new ConcurrentHashMap<Locale, Map<DateTimeFieldType, Object[]>>();
        private final DateTimeFieldType iFieldType;
        private final boolean iShort;

        TextField(DateTimeFieldType dateTimeFieldType, boolean bl2) {
            this.iFieldType = dateTimeFieldType;
            this.iShort = bl2;
        }

        public int estimatePrintedLength() {
            return this.iShort ? 6 : 20;
        }

        public void printTo(Appendable appendable, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            try {
                appendable.append(this.print(l2, chronology, locale));
            }
            catch (RuntimeException runtimeException) {
                appendable.append('\ufffd');
            }
        }

        public void printTo(Appendable appendable, ReadablePartial readablePartial, Locale locale) throws IOException {
            try {
                appendable.append(this.print(readablePartial, locale));
            }
            catch (RuntimeException runtimeException) {
                appendable.append('\ufffd');
            }
        }

        private String print(long l2, Chronology chronology, Locale locale) {
            DateTimeField dateTimeField = this.iFieldType.getField(chronology);
            if (this.iShort) {
                return dateTimeField.getAsShortText(l2, locale);
            }
            return dateTimeField.getAsText(l2, locale);
        }

        private String print(ReadablePartial readablePartial, Locale locale) {
            if (readablePartial.isSupported(this.iFieldType)) {
                DateTimeField dateTimeField = this.iFieldType.getField(readablePartial.getChronology());
                if (this.iShort) {
                    return dateTimeField.getAsShortText(readablePartial, locale);
                }
                return dateTimeField.getAsText(readablePartial, locale);
            }
            return "\ufffd";
        }

        public int estimateParsedLength() {
            return this.estimatePrintedLength();
        }

        public int parseInto(DateTimeParserBucket dateTimeParserBucket, CharSequence charSequence, int n2) {
            int n3;
            Object[] objectArray;
            Locale locale = dateTimeParserBucket.getLocale();
            Map<String, Boolean> map = null;
            int n4 = 0;
            Map<DateTimeFieldType, Object[]> map2 = cParseCache.get(locale);
            if (map2 == null) {
                map2 = new ConcurrentHashMap<DateTimeFieldType, Object[]>();
                cParseCache.put(locale, map2);
            }
            if ((objectArray = map2.get(this.iFieldType)) == null) {
                map = new ConcurrentHashMap(32);
                MutableDateTime mutableDateTime = new MutableDateTime(0L, DateTimeZone.UTC);
                MutableDateTime.Property property = mutableDateTime.property(this.iFieldType);
                int n5 = property.getMinimumValueOverall();
                int n6 = property.getMaximumValueOverall();
                if (n6 - n5 > 32) {
                    return ~n2;
                }
                n4 = property.getMaximumTextLength(locale);
                for (int i2 = n5; i2 <= n6; ++i2) {
                    property.set(i2);
                    map.put(property.getAsShortText(locale), Boolean.TRUE);
                    map.put(property.getAsShortText(locale).toLowerCase(locale), Boolean.TRUE);
                    map.put(property.getAsShortText(locale).toUpperCase(locale), Boolean.TRUE);
                    map.put(property.getAsText(locale), Boolean.TRUE);
                    map.put(property.getAsText(locale).toLowerCase(locale), Boolean.TRUE);
                    map.put(property.getAsText(locale).toUpperCase(locale), Boolean.TRUE);
                }
                if ("en".equals(locale.getLanguage()) && this.iFieldType == DateTimeFieldType.era()) {
                    map.put("BCE", Boolean.TRUE);
                    map.put("bce", Boolean.TRUE);
                    map.put("CE", Boolean.TRUE);
                    map.put("ce", Boolean.TRUE);
                    n4 = 3;
                }
                objectArray = new Object[]{map, n4};
                map2.put(this.iFieldType, objectArray);
            } else {
                map = (Map)objectArray[0];
                n4 = (Integer)objectArray[1];
            }
            for (int i3 = n3 = Math.min(charSequence.length(), n2 + n4); i3 > n2; --i3) {
                String string = ((Object)charSequence.subSequence(n2, i3)).toString();
                if (!map.containsKey(string)) continue;
                dateTimeParserBucket.saveField(this.iFieldType, string, locale);
                return i3;
            }
            return ~n2;
        }
    }

    static class TwoDigitYear
    implements InternalPrinter,
    InternalParser {
        private final DateTimeFieldType iType;
        private final int iPivot;
        private final boolean iLenientParse;

        TwoDigitYear(DateTimeFieldType dateTimeFieldType, int n2, boolean bl2) {
            this.iType = dateTimeFieldType;
            this.iPivot = n2;
            this.iLenientParse = bl2;
        }

        public int estimateParsedLength() {
            return this.iLenientParse ? 4 : 2;
        }

        public int parseInto(DateTimeParserBucket dateTimeParserBucket, CharSequence charSequence, int n2) {
            int n3;
            int n4;
            char c2;
            int n5;
            int n6 = charSequence.length() - n2;
            if (!this.iLenientParse) {
                if ((n6 = Math.min(2, n6)) < 2) {
                    return ~n2;
                }
            } else {
                n5 = 0;
                c2 = '\u0000';
                n4 = 0;
                while (n4 < n6) {
                    n3 = charSequence.charAt(n2 + n4);
                    if (n4 == 0 && (n3 == 45 || n3 == 43)) {
                        n5 = 1;
                        char c3 = c2 = n3 == 45 ? (char)'\u0001' : '\u0000';
                        if (c2 != '\u0000') {
                            ++n4;
                            continue;
                        }
                        ++n2;
                        --n6;
                        continue;
                    }
                    if (n3 < 48 || n3 > 57) break;
                    ++n4;
                }
                if (n4 == 0) {
                    return ~n2;
                }
                if (n5 != 0 || n4 != 2) {
                    if (n4 >= 9) {
                        n3 = Integer.parseInt(((Object)charSequence.subSequence(n2, n2 += n4)).toString());
                    } else {
                        int n7 = n2;
                        if (c2 != '\u0000') {
                            ++n7;
                        }
                        try {
                            n3 = charSequence.charAt(n7++) - 48;
                        }
                        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                            return ~n2;
                        }
                        n2 += n4;
                        while (n7 < n2) {
                            n3 = (n3 << 3) + (n3 << 1) + charSequence.charAt(n7++) - 48;
                        }
                        if (c2 != '\u0000') {
                            n3 = -n3;
                        }
                    }
                    dateTimeParserBucket.saveField(this.iType, n3);
                    return n2;
                }
            }
            if ((c2 = charSequence.charAt(n2)) < '0' || c2 > '9') {
                return ~n2;
            }
            n5 = c2 - 48;
            c2 = charSequence.charAt(n2 + 1);
            if (c2 < '0' || c2 > '9') {
                return ~n2;
            }
            n5 = (n5 << 3) + (n5 << 1) + c2 - 48;
            n4 = this.iPivot;
            if (dateTimeParserBucket.getPivotYear() != null) {
                n4 = dateTimeParserBucket.getPivotYear();
            }
            int n8 = (n3 = n4 - 50) >= 0 ? n3 % 100 : 99 + (n3 + 1) % 100;
            dateTimeParserBucket.saveField(this.iType, n5 += n3 + (n5 < n8 ? 100 : 0) - n8);
            return n2 + 2;
        }

        public int estimatePrintedLength() {
            return 2;
        }

        public void printTo(Appendable appendable, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            int n3 = this.getTwoDigitYear(l2, chronology);
            if (n3 < 0) {
                appendable.append('\ufffd');
                appendable.append('\ufffd');
            } else {
                FormatUtils.appendPaddedInteger(appendable, n3, 2);
            }
        }

        private int getTwoDigitYear(long l2, Chronology chronology) {
            try {
                int n2 = this.iType.getField(chronology).get(l2);
                if (n2 < 0) {
                    n2 = -n2;
                }
                return n2 % 100;
            }
            catch (RuntimeException runtimeException) {
                return -1;
            }
        }

        public void printTo(Appendable appendable, ReadablePartial readablePartial, Locale locale) throws IOException {
            int n2 = this.getTwoDigitYear(readablePartial);
            if (n2 < 0) {
                appendable.append('\ufffd');
                appendable.append('\ufffd');
            } else {
                FormatUtils.appendPaddedInteger(appendable, n2, 2);
            }
        }

        private int getTwoDigitYear(ReadablePartial readablePartial) {
            if (readablePartial.isSupported(this.iType)) {
                try {
                    int n2 = readablePartial.get(this.iType);
                    if (n2 < 0) {
                        n2 = -n2;
                    }
                    return n2 % 100;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return -1;
        }
    }

    static class FixedNumber
    extends PaddedNumber {
        protected FixedNumber(DateTimeFieldType dateTimeFieldType, int n2, boolean bl2) {
            super(dateTimeFieldType, n2, bl2, n2);
        }

        public int parseInto(DateTimeParserBucket dateTimeParserBucket, CharSequence charSequence, int n2) {
            int n3 = super.parseInto(dateTimeParserBucket, charSequence, n2);
            if (n3 < 0) {
                return n3;
            }
            int n4 = n2 + this.iMaxParsedDigits;
            if (n3 != n4) {
                char c2;
                if (this.iSigned && ((c2 = charSequence.charAt(n2)) == '-' || c2 == '+')) {
                    ++n4;
                }
                if (n3 > n4) {
                    return ~(n4 + 1);
                }
                if (n3 < n4) {
                    return ~n3;
                }
            }
            return n3;
        }
    }

    static class PaddedNumber
    extends NumberFormatter {
        protected final int iMinPrintedDigits;

        protected PaddedNumber(DateTimeFieldType dateTimeFieldType, int n2, boolean bl2, int n3) {
            super(dateTimeFieldType, n2, bl2);
            this.iMinPrintedDigits = n3;
        }

        public int estimatePrintedLength() {
            return this.iMaxParsedDigits;
        }

        public void printTo(Appendable appendable, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            try {
                DateTimeField dateTimeField = this.iFieldType.getField(chronology);
                FormatUtils.appendPaddedInteger(appendable, dateTimeField.get(l2), this.iMinPrintedDigits);
            }
            catch (RuntimeException runtimeException) {
                DateTimeFormatterBuilder.appendUnknownString(appendable, this.iMinPrintedDigits);
            }
        }

        public void printTo(Appendable appendable, ReadablePartial readablePartial, Locale locale) throws IOException {
            if (readablePartial.isSupported(this.iFieldType)) {
                try {
                    FormatUtils.appendPaddedInteger(appendable, readablePartial.get(this.iFieldType), this.iMinPrintedDigits);
                }
                catch (RuntimeException runtimeException) {
                    DateTimeFormatterBuilder.appendUnknownString(appendable, this.iMinPrintedDigits);
                }
            } else {
                DateTimeFormatterBuilder.appendUnknownString(appendable, this.iMinPrintedDigits);
            }
        }
    }

    static class UnpaddedNumber
    extends NumberFormatter {
        protected UnpaddedNumber(DateTimeFieldType dateTimeFieldType, int n2, boolean bl2) {
            super(dateTimeFieldType, n2, bl2);
        }

        public int estimatePrintedLength() {
            return this.iMaxParsedDigits;
        }

        public void printTo(Appendable appendable, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            try {
                DateTimeField dateTimeField = this.iFieldType.getField(chronology);
                FormatUtils.appendUnpaddedInteger(appendable, dateTimeField.get(l2));
            }
            catch (RuntimeException runtimeException) {
                appendable.append('\ufffd');
            }
        }

        public void printTo(Appendable appendable, ReadablePartial readablePartial, Locale locale) throws IOException {
            if (readablePartial.isSupported(this.iFieldType)) {
                try {
                    FormatUtils.appendUnpaddedInteger(appendable, readablePartial.get(this.iFieldType));
                }
                catch (RuntimeException runtimeException) {
                    appendable.append('\ufffd');
                }
            } else {
                appendable.append('\ufffd');
            }
        }
    }

    static abstract class NumberFormatter
    implements InternalPrinter,
    InternalParser {
        protected final DateTimeFieldType iFieldType;
        protected final int iMaxParsedDigits;
        protected final boolean iSigned;

        NumberFormatter(DateTimeFieldType dateTimeFieldType, int n2, boolean bl2) {
            this.iFieldType = dateTimeFieldType;
            this.iMaxParsedDigits = n2;
            this.iSigned = bl2;
        }

        public int estimateParsedLength() {
            return this.iMaxParsedDigits;
        }

        public int parseInto(DateTimeParserBucket dateTimeParserBucket, CharSequence charSequence, int n2) {
            int n3;
            int n4 = Math.min(this.iMaxParsedDigits, charSequence.length() - n2);
            boolean bl2 = false;
            boolean bl3 = false;
            int n5 = 0;
            while (n5 < n4) {
                n3 = charSequence.charAt(n2 + n5);
                if (n5 == 0 && (n3 == 45 || n3 == 43) && this.iSigned) {
                    bl2 = n3 == 45;
                    boolean bl4 = bl3 = n3 == 43;
                    if (n5 + 1 >= n4) break;
                    char c2 = charSequence.charAt(n2 + n5 + 1);
                    n3 = c2;
                    if (c2 < '0' || n3 > 57) break;
                    ++n5;
                    n4 = Math.min(n4 + 1, charSequence.length() - n2);
                    continue;
                }
                if (n3 < 48 || n3 > 57) break;
                ++n5;
            }
            if (n5 == 0) {
                return ~n2;
            }
            if (n5 >= 9) {
                n3 = bl3 ? Integer.parseInt(((Object)charSequence.subSequence(n2 + 1, n2 += n5)).toString()) : Integer.parseInt(((Object)charSequence.subSequence(n2, n2 += n5)).toString());
            } else {
                int n6 = n2;
                if (bl2 || bl3) {
                    ++n6;
                }
                try {
                    n3 = charSequence.charAt(n6++) - 48;
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    return ~n2;
                }
                n2 += n5;
                while (n6 < n2) {
                    n3 = (n3 << 3) + (n3 << 1) + charSequence.charAt(n6++) - 48;
                }
                if (bl2) {
                    n3 = -n3;
                }
            }
            dateTimeParserBucket.saveField(this.iFieldType, n3);
            return n2;
        }
    }

    static class StringLiteral
    implements InternalPrinter,
    InternalParser {
        private final String iValue;

        StringLiteral(String string) {
            this.iValue = string;
        }

        public int estimatePrintedLength() {
            return this.iValue.length();
        }

        public void printTo(Appendable appendable, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            appendable.append(this.iValue);
        }

        public void printTo(Appendable appendable, ReadablePartial readablePartial, Locale locale) throws IOException {
            appendable.append(this.iValue);
        }

        public int estimateParsedLength() {
            return this.iValue.length();
        }

        public int parseInto(DateTimeParserBucket dateTimeParserBucket, CharSequence charSequence, int n2) {
            if (DateTimeFormatterBuilder.csStartsWithIgnoreCase(charSequence, n2, this.iValue)) {
                return n2 + this.iValue.length();
            }
            return ~n2;
        }
    }

    static class CharacterLiteral
    implements InternalPrinter,
    InternalParser {
        private final char iValue;

        CharacterLiteral(char c2) {
            this.iValue = c2;
        }

        public int estimatePrintedLength() {
            return 1;
        }

        public void printTo(Appendable appendable, long l2, Chronology chronology, int n2, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            appendable.append(this.iValue);
        }

        public void printTo(Appendable appendable, ReadablePartial readablePartial, Locale locale) throws IOException {
            appendable.append(this.iValue);
        }

        public int estimateParsedLength() {
            return 1;
        }

        public int parseInto(DateTimeParserBucket dateTimeParserBucket, CharSequence charSequence, int n2) {
            char c2;
            if (n2 >= charSequence.length()) {
                return ~n2;
            }
            char c3 = charSequence.charAt(n2);
            if (c3 != (c2 = this.iValue) && (c3 = Character.toUpperCase(c3)) != (c2 = Character.toUpperCase(c2)) && (c3 = Character.toLowerCase(c3)) != (c2 = Character.toLowerCase(c2))) {
                return ~n2;
            }
            return n2 + 1;
        }
    }
}

