/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.field.BaseDateTimeField;
import org.joda.time.field.BaseDurationField;
import org.joda.time.field.FieldUtils;

public abstract class ImpreciseDateTimeField
extends BaseDateTimeField {
    private static final long serialVersionUID = 7190739608550251860L;
    final long iUnitMillis;
    private final DurationField iDurationField;

    public ImpreciseDateTimeField(DateTimeFieldType dateTimeFieldType, long l2) {
        super(dateTimeFieldType);
        this.iUnitMillis = l2;
        this.iDurationField = new LinkedDurationField(dateTimeFieldType.getDurationType());
    }

    public abstract int get(long var1);

    public abstract long set(long var1, int var3);

    public abstract long add(long var1, int var3);

    public abstract long add(long var1, long var3);

    public int getDifference(long l2, long l3) {
        return FieldUtils.safeToInt(this.getDifferenceAsLong(l2, l3));
    }

    public long getDifferenceAsLong(long l2, long l3) {
        if (l2 < l3) {
            return -this.getDifferenceAsLong(l3, l2);
        }
        long l4 = (l2 - l3) / this.iUnitMillis;
        if (this.add(l3, l4) < l2) {
            while (this.add(l3, ++l4) <= l2) {
            }
            --l4;
        } else if (this.add(l3, l4) > l2) {
            while (this.add(l3, --l4) > l2) {
            }
        }
        return l4;
    }

    public final DurationField getDurationField() {
        return this.iDurationField;
    }

    public abstract DurationField getRangeDurationField();

    public abstract long roundFloor(long var1);

    protected final long getDurationUnitMillis() {
        return this.iUnitMillis;
    }

    private final class LinkedDurationField
    extends BaseDurationField {
        private static final long serialVersionUID = -203813474600094134L;

        LinkedDurationField(DurationFieldType durationFieldType) {
            super(durationFieldType);
        }

        public boolean isPrecise() {
            return false;
        }

        public long getUnitMillis() {
            return ImpreciseDateTimeField.this.iUnitMillis;
        }

        public int getValue(long l2, long l3) {
            return ImpreciseDateTimeField.this.getDifference(l3 + l2, l3);
        }

        public long getValueAsLong(long l2, long l3) {
            return ImpreciseDateTimeField.this.getDifferenceAsLong(l3 + l2, l3);
        }

        public long getMillis(int n2, long l2) {
            return ImpreciseDateTimeField.this.add(l2, n2) - l2;
        }

        public long getMillis(long l2, long l3) {
            return ImpreciseDateTimeField.this.add(l3, l2) - l3;
        }

        public long add(long l2, int n2) {
            return ImpreciseDateTimeField.this.add(l2, n2);
        }

        public long add(long l2, long l3) {
            return ImpreciseDateTimeField.this.add(l2, l3);
        }

        public int getDifference(long l2, long l3) {
            return ImpreciseDateTimeField.this.getDifference(l2, l3);
        }

        public long getDifferenceAsLong(long l2, long l3) {
            return ImpreciseDateTimeField.this.getDifferenceAsLong(l2, l3);
        }
    }
}

