/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.IllegalInstantException;
import org.joda.time.JodaTimePermission;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.UTCDateTimeZone;
import org.joda.time.chrono.BaseChronology;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.FormatUtils;
import org.joda.time.tz.DefaultNameProvider;
import org.joda.time.tz.FixedDateTimeZone;
import org.joda.time.tz.NameProvider;
import org.joda.time.tz.Provider;
import org.joda.time.tz.UTCProvider;
import org.joda.time.tz.ZoneInfoProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DateTimeZone
implements Serializable {
    private static final long serialVersionUID = 5546345482340108586L;
    public static final DateTimeZone UTC = UTCDateTimeZone.INSTANCE;
    private static final int MAX_MILLIS = 86399999;
    private static final AtomicReference<Provider> cProvider = new AtomicReference();
    private static final AtomicReference<NameProvider> cNameProvider = new AtomicReference();
    private static final AtomicReference<DateTimeZone> cDefault = new AtomicReference();
    private final String iID;

    public static DateTimeZone getDefault() {
        DateTimeZone dateTimeZone = cDefault.get();
        if (dateTimeZone == null) {
            try {
                try {
                    String string = System.getProperty("user.timezone");
                    if (string != null) {
                        dateTimeZone = DateTimeZone.forID(string);
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (dateTimeZone == null) {
                    dateTimeZone = DateTimeZone.forTimeZone(TimeZone.getDefault());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (dateTimeZone == null) {
                dateTimeZone = UTC;
            }
            if (!cDefault.compareAndSet(null, dateTimeZone)) {
                dateTimeZone = cDefault.get();
            }
        }
        return dateTimeZone;
    }

    public static void setDefault(DateTimeZone dateTimeZone) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("DateTimeZone.setDefault"));
        }
        if (dateTimeZone == null) {
            throw new IllegalArgumentException("The datetime zone must not be null");
        }
        cDefault.set(dateTimeZone);
    }

    @FromString
    public static DateTimeZone forID(String string) {
        if (string == null) {
            return DateTimeZone.getDefault();
        }
        if (string.equals("UTC")) {
            return UTC;
        }
        DateTimeZone dateTimeZone = DateTimeZone.getProvider().getZone(string);
        if (dateTimeZone != null) {
            return dateTimeZone;
        }
        if (string.startsWith("+") || string.startsWith("-")) {
            int n2 = DateTimeZone.parseOffset(string);
            if ((long)n2 == 0L) {
                return UTC;
            }
            string = DateTimeZone.printOffset(n2);
            return DateTimeZone.fixedOffsetZone(string, n2);
        }
        throw new IllegalArgumentException("The datetime zone id '" + string + "' is not recognised");
    }

    public static DateTimeZone forOffsetHours(int n2) throws IllegalArgumentException {
        return DateTimeZone.forOffsetHoursMinutes(n2, 0);
    }

    public static DateTimeZone forOffsetHoursMinutes(int n2, int n3) throws IllegalArgumentException {
        if (n2 == 0 && n3 == 0) {
            return UTC;
        }
        if (n2 < -23 || n2 > 23) {
            throw new IllegalArgumentException("Hours out of range: " + n2);
        }
        if (n3 < -59 || n3 > 59) {
            throw new IllegalArgumentException("Minutes out of range: " + n3);
        }
        if (n2 > 0 && n3 < 0) {
            throw new IllegalArgumentException("Positive hours must not have negative minutes: " + n3);
        }
        int n4 = 0;
        try {
            int n5 = n2 * 60;
            n3 = n5 < 0 ? n5 - Math.abs(n3) : n5 + n3;
            n4 = FieldUtils.safeMultiply(n3, 60000);
        }
        catch (ArithmeticException arithmeticException) {
            throw new IllegalArgumentException("Offset is too large");
        }
        return DateTimeZone.forOffsetMillis(n4);
    }

    public static DateTimeZone forOffsetMillis(int n2) {
        if (n2 < -86399999 || n2 > 86399999) {
            throw new IllegalArgumentException("Millis out of range: " + n2);
        }
        String string = DateTimeZone.printOffset(n2);
        return DateTimeZone.fixedOffsetZone(string, n2);
    }

    public static DateTimeZone forTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            return DateTimeZone.getDefault();
        }
        String string = timeZone.getID();
        if (string == null) {
            throw new IllegalArgumentException("The TimeZone id must not be null");
        }
        if (string.equals("UTC")) {
            return UTC;
        }
        DateTimeZone dateTimeZone = null;
        String string2 = DateTimeZone.getConvertedId(string);
        Provider provider = DateTimeZone.getProvider();
        if (string2 != null) {
            dateTimeZone = provider.getZone(string2);
        }
        if (dateTimeZone == null) {
            dateTimeZone = provider.getZone(string);
        }
        if (dateTimeZone != null) {
            return dateTimeZone;
        }
        if (string2 == null && ((string2 = string).startsWith("GMT+") || string2.startsWith("GMT-"))) {
            int n2 = DateTimeZone.parseOffset(string2 = string2.substring(3));
            if ((long)n2 == 0L) {
                return UTC;
            }
            string2 = DateTimeZone.printOffset(n2);
            return DateTimeZone.fixedOffsetZone(string2, n2);
        }
        throw new IllegalArgumentException("The datetime zone id '" + string + "' is not recognised");
    }

    private static DateTimeZone fixedOffsetZone(String string, int n2) {
        if (n2 == 0) {
            return UTC;
        }
        return new FixedDateTimeZone(string, null, n2, n2);
    }

    public static Set<String> getAvailableIDs() {
        return DateTimeZone.getProvider().getAvailableIDs();
    }

    public static Provider getProvider() {
        Provider provider = cProvider.get();
        if (provider == null && !cProvider.compareAndSet(null, provider = DateTimeZone.getDefaultProvider())) {
            provider = cProvider.get();
        }
        return provider;
    }

    public static void setProvider(Provider provider) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("DateTimeZone.setProvider"));
        }
        if (provider == null) {
            provider = DateTimeZone.getDefaultProvider();
        } else {
            DateTimeZone.validateProvider(provider);
        }
        cProvider.set(provider);
    }

    private static Provider validateProvider(Provider provider) {
        Set<String> set = provider.getAvailableIDs();
        if (set == null || set.size() == 0) {
            throw new IllegalArgumentException("The provider doesn't have any available ids");
        }
        if (!set.contains("UTC")) {
            throw new IllegalArgumentException("The provider doesn't support UTC");
        }
        if (!UTC.equals(provider.getZone("UTC"))) {
            throw new IllegalArgumentException("Invalid UTC zone provided");
        }
        return provider;
    }

    private static Provider getDefaultProvider() {
        Object object;
        try {
            object = System.getProperty("org.joda.time.DateTimeZone.Provider");
            if (object != null) {
                try {
                    Provider provider = (Provider)Class.forName((String)object).newInstance();
                    return DateTimeZone.validateProvider(provider);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            object = System.getProperty("org.joda.time.DateTimeZone.Folder");
            if (object != null) {
                try {
                    ZoneInfoProvider zoneInfoProvider = new ZoneInfoProvider(new File((String)object));
                    return DateTimeZone.validateProvider(zoneInfoProvider);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            object = new ZoneInfoProvider("org/joda/time/tz/data");
            return DateTimeZone.validateProvider((Provider)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new UTCProvider();
        }
    }

    public static NameProvider getNameProvider() {
        NameProvider nameProvider = cNameProvider.get();
        if (nameProvider == null && !cNameProvider.compareAndSet(null, nameProvider = DateTimeZone.getDefaultNameProvider())) {
            nameProvider = cNameProvider.get();
        }
        return nameProvider;
    }

    public static void setNameProvider(NameProvider nameProvider) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("DateTimeZone.setNameProvider"));
        }
        if (nameProvider == null) {
            nameProvider = DateTimeZone.getDefaultNameProvider();
        }
        cNameProvider.set(nameProvider);
    }

    private static NameProvider getDefaultNameProvider() {
        NameProvider nameProvider;
        block5: {
            nameProvider = null;
            try {
                String string = System.getProperty("org.joda.time.DateTimeZone.NameProvider");
                if (string == null) break block5;
                try {
                    nameProvider = (NameProvider)Class.forName(string).newInstance();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (nameProvider == null) {
            nameProvider = new DefaultNameProvider();
        }
        return nameProvider;
    }

    private static String getConvertedId(String string) {
        return LazyInit.CONVERSION_MAP.get(string);
    }

    private static int parseOffset(String string) {
        return -((int)LazyInit.OFFSET_FORMATTER.parseMillis(string));
    }

    private static String printOffset(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 >= 0) {
            stringBuffer.append('+');
        } else {
            stringBuffer.append('-');
            n2 = -n2;
        }
        int n3 = n2 / 3600000;
        FormatUtils.appendPaddedInteger(stringBuffer, n3, 2);
        int n4 = (n2 -= n3 * 3600000) / 60000;
        stringBuffer.append(':');
        FormatUtils.appendPaddedInteger(stringBuffer, n4, 2);
        if ((n2 -= n4 * 60000) == 0) {
            return stringBuffer.toString();
        }
        int n5 = n2 / 1000;
        stringBuffer.append(':');
        FormatUtils.appendPaddedInteger(stringBuffer, n5, 2);
        if ((n2 -= n5 * 1000) == 0) {
            return stringBuffer.toString();
        }
        stringBuffer.append('.');
        FormatUtils.appendPaddedInteger(stringBuffer, n2, 3);
        return stringBuffer.toString();
    }

    protected DateTimeZone(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Id must not be null");
        }
        this.iID = string;
    }

    @ToString
    public final String getID() {
        return this.iID;
    }

    public abstract String getNameKey(long var1);

    public final String getShortName(long l2) {
        return this.getShortName(l2, null);
    }

    public String getShortName(long l2, Locale locale) {
        String string;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((string = this.getNameKey(l2)) == null) {
            return this.iID;
        }
        NameProvider nameProvider = DateTimeZone.getNameProvider();
        String string2 = nameProvider instanceof DefaultNameProvider ? ((DefaultNameProvider)nameProvider).getShortName(locale, this.iID, string, this.isStandardOffset(l2)) : nameProvider.getShortName(locale, this.iID, string);
        if (string2 != null) {
            return string2;
        }
        return DateTimeZone.printOffset(this.getOffset(l2));
    }

    public final String getName(long l2) {
        return this.getName(l2, null);
    }

    public String getName(long l2, Locale locale) {
        String string;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((string = this.getNameKey(l2)) == null) {
            return this.iID;
        }
        NameProvider nameProvider = DateTimeZone.getNameProvider();
        String string2 = nameProvider instanceof DefaultNameProvider ? ((DefaultNameProvider)nameProvider).getName(locale, this.iID, string, this.isStandardOffset(l2)) : nameProvider.getName(locale, this.iID, string);
        if (string2 != null) {
            return string2;
        }
        return DateTimeZone.printOffset(this.getOffset(l2));
    }

    public abstract int getOffset(long var1);

    public final int getOffset(ReadableInstant readableInstant) {
        if (readableInstant == null) {
            return this.getOffset(DateTimeUtils.currentTimeMillis());
        }
        return this.getOffset(readableInstant.getMillis());
    }

    public abstract int getStandardOffset(long var1);

    public boolean isStandardOffset(long l2) {
        return this.getOffset(l2) == this.getStandardOffset(l2);
    }

    public int getOffsetFromLocal(long l2) {
        int n2;
        int n3;
        long l3;
        long l4;
        int n4;
        int n5 = this.getOffset(l2);
        if (n5 != (n4 = this.getOffset(l4 = l2 - (long)n5))) {
            if (n5 - n4 < 0) {
                long l5;
                long l6 = this.nextTransition(l4);
                if (l6 == l2 - (long)n5) {
                    l6 = Long.MAX_VALUE;
                }
                if ((l5 = this.nextTransition(l2 - (long)n4)) == l2 - (long)n4) {
                    l5 = Long.MAX_VALUE;
                }
                if (l6 != l5) {
                    return n5;
                }
            }
        } else if (n5 >= 0 && (l3 = this.previousTransition(l4)) < l4 && l4 - l3 <= (long)(n3 = (n2 = this.getOffset(l3)) - n5)) {
            return n2;
        }
        return n4;
    }

    public long convertUTCToLocal(long l2) {
        int n2 = this.getOffset(l2);
        long l3 = l2 + (long)n2;
        if ((l2 ^ l3) < 0L && (l2 ^ (long)n2) >= 0L) {
            throw new ArithmeticException("Adding time zone offset caused overflow");
        }
        return l3;
    }

    public long convertLocalToUTC(long l2, boolean bl2, long l3) {
        int n2 = this.getOffset(l3);
        long l4 = l2 - (long)n2;
        int n3 = this.getOffset(l4);
        if (n3 == n2) {
            return l4;
        }
        return this.convertLocalToUTC(l2, bl2);
    }

    public long convertLocalToUTC(long l2, boolean bl2) {
        long l3;
        int n2;
        int n3 = this.getOffset(l2);
        if (n3 != (n2 = this.getOffset(l2 - (long)n3)) && (bl2 || n3 < 0)) {
            long l4;
            l3 = this.nextTransition(l2 - (long)n3);
            if (l3 == l2 - (long)n3) {
                l3 = Long.MAX_VALUE;
            }
            if ((l4 = this.nextTransition(l2 - (long)n2)) == l2 - (long)n2) {
                l4 = Long.MAX_VALUE;
            }
            if (l3 != l4) {
                if (bl2) {
                    throw new IllegalInstantException(l2, this.getID());
                }
                n2 = n3;
            }
        }
        if ((l2 ^ (l3 = l2 - (long)n2)) < 0L && (l2 ^ (long)n2) < 0L) {
            throw new ArithmeticException("Subtracting time zone offset caused overflow");
        }
        return l3;
    }

    public long getMillisKeepLocal(DateTimeZone dateTimeZone, long l2) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if (dateTimeZone == this) {
            return l2;
        }
        long l3 = this.convertUTCToLocal(l2);
        return dateTimeZone.convertLocalToUTC(l3, false, l2);
    }

    public boolean isLocalDateTimeGap(LocalDateTime localDateTime) {
        if (this.isFixed()) {
            return false;
        }
        try {
            localDateTime.toDateTime(this);
            return false;
        }
        catch (IllegalInstantException illegalInstantException) {
            return true;
        }
    }

    public long adjustOffset(long l2, boolean bl2) {
        long l3;
        long l4 = l2 - 10800000L;
        long l5 = l2 + 10800000L;
        long l6 = this.getOffset(l4);
        if (l6 <= (l3 = (long)this.getOffset(l5))) {
            return l2;
        }
        long l7 = l6 - l3;
        long l8 = this.nextTransition(l4);
        long l9 = l8 - l7;
        long l10 = l8 + l7;
        if (l2 < l9 || l2 >= l10) {
            return l2;
        }
        long l11 = l2 - l9;
        if (l11 >= l7) {
            return bl2 ? l2 : l2 - l7;
        }
        return bl2 ? l2 + l7 : l2;
    }

    public abstract boolean isFixed();

    public abstract long nextTransition(long var1);

    public abstract long previousTransition(long var1);

    public TimeZone toTimeZone() {
        return TimeZone.getTimeZone(this.iID);
    }

    public abstract boolean equals(Object var1);

    public int hashCode() {
        return 57 + this.getID().hashCode();
    }

    public String toString() {
        return this.getID();
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new Stub(this.iID);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LazyInit {
        static final Map<String, String> CONVERSION_MAP = LazyInit.buildMap();
        static final DateTimeFormatter OFFSET_FORMATTER = LazyInit.buildFormatter();

        LazyInit() {
        }

        private static DateTimeFormatter buildFormatter() {
            BaseChronology baseChronology = new BaseChronology(){
                private static final long serialVersionUID = -3128740902654445468L;

                public DateTimeZone getZone() {
                    return null;
                }

                public Chronology withUTC() {
                    return this;
                }

                public Chronology withZone(DateTimeZone dateTimeZone) {
                    return this;
                }

                public String toString() {
                    return this.getClass().getName();
                }
            };
            return new DateTimeFormatterBuilder().appendTimeZoneOffset(null, true, 2, 4).toFormatter().withChronology(baseChronology);
        }

        private static Map<String, String> buildMap() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("GMT", "UTC");
            hashMap.put("WET", "WET");
            hashMap.put("CET", "CET");
            hashMap.put("MET", "CET");
            hashMap.put("ECT", "CET");
            hashMap.put("EET", "EET");
            hashMap.put("MIT", "Pacific/Apia");
            hashMap.put("HST", "Pacific/Honolulu");
            hashMap.put("AST", "America/Anchorage");
            hashMap.put("PST", "America/Los_Angeles");
            hashMap.put("MST", "America/Denver");
            hashMap.put("PNT", "America/Phoenix");
            hashMap.put("CST", "America/Chicago");
            hashMap.put("EST", "America/New_York");
            hashMap.put("IET", "America/Indiana/Indianapolis");
            hashMap.put("PRT", "America/Puerto_Rico");
            hashMap.put("CNT", "America/St_Johns");
            hashMap.put("AGT", "America/Argentina/Buenos_Aires");
            hashMap.put("BET", "America/Sao_Paulo");
            hashMap.put("ART", "Africa/Cairo");
            hashMap.put("CAT", "Africa/Harare");
            hashMap.put("EAT", "Africa/Addis_Ababa");
            hashMap.put("NET", "Asia/Yerevan");
            hashMap.put("PLT", "Asia/Karachi");
            hashMap.put("IST", "Asia/Kolkata");
            hashMap.put("BST", "Asia/Dhaka");
            hashMap.put("VST", "Asia/Ho_Chi_Minh");
            hashMap.put("CTT", "Asia/Shanghai");
            hashMap.put("JST", "Asia/Tokyo");
            hashMap.put("ACT", "Australia/Darwin");
            hashMap.put("AET", "Australia/Sydney");
            hashMap.put("SST", "Pacific/Guadalcanal");
            hashMap.put("NST", "Pacific/Auckland");
            return Collections.unmodifiableMap(hashMap);
        }
    }

    private static final class Stub
    implements Serializable {
        private static final long serialVersionUID = -6471952376487863581L;
        private transient String iID;

        Stub(String string) {
            this.iID = string;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeUTF(this.iID);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException {
            this.iID = objectInputStream.readUTF();
        }

        private Object readResolve() throws ObjectStreamException {
            return DateTimeZone.forID(this.iID);
        }
    }
}

