/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.util;

import java.sql.Connection;
import java.sql.SQLException;
import org.firebirdsql.gds.impl.GDSServerVersion;
import org.firebirdsql.gds.ng.FbAttachment;
import org.firebirdsql.jdbc.FirebirdConnection;

public final class FirebirdSupportInfo {
    private final GDSServerVersion serverVersion;

    private FirebirdSupportInfo(GDSServerVersion serverVersion) {
        if (serverVersion == null) {
            throw new NullPointerException("serverVersion");
        }
        if (serverVersion.equals(GDSServerVersion.INVALID_VERSION)) {
            throw new IllegalArgumentException("serverVersion is an invalid version (GDSServerVersion.INVALID_VERSION)");
        }
        this.serverVersion = serverVersion;
    }

    public boolean isVersionEqualOrAbove(int majorVersion, int minorVersion) {
        return this.serverVersion.isEqualOrAbove(majorVersion, minorVersion);
    }

    public boolean isVersionBelow(int majorVersion, int minorVersion) {
        return !this.isVersionEqualOrAbove(majorVersion, minorVersion);
    }

    public boolean supportsBigint() {
        return this.isVersionEqualOrAbove(1, 5);
    }

    public boolean supportsBoolean() {
        return this.isVersionEqualOrAbove(3, 0);
    }

    public boolean supportsComment() {
        return this.isVersionEqualOrAbove(2, 0);
    }

    public boolean supportsGetSetContext() {
        return this.isVersionEqualOrAbove(2, 0);
    }

    public boolean supportsCase() {
        return this.isVersionEqualOrAbove(1, 5);
    }

    public boolean reportsBlobCharSetInDescriptor() {
        return this.isVersionEqualOrAbove(2, 1);
    }

    public boolean reportsByteLengthInDescriptor() {
        return this.isVersionEqualOrAbove(1, 5);
    }

    public boolean supportsInsertReturning() {
        return this.isVersionEqualOrAbove(2, 0);
    }

    public boolean supportsUpdateReturning() {
        return this.isVersionEqualOrAbove(2, 1);
    }

    public boolean supportsUtf8() {
        return this.isVersionEqualOrAbove(1, 5);
    }

    public boolean supportsSavepoint() {
        return this.isVersionEqualOrAbove(1, 5);
    }

    public boolean supportsExecuteBlock() {
        return this.isVersionEqualOrAbove(2, 0);
    }

    public boolean supportsSqlUserManagement() {
        return this.isVersionEqualOrAbove(2, 5);
    }

    public boolean supportsCancelOperation() {
        return this.isVersionEqualOrAbove(2, 5);
    }

    public boolean supportsTableAlias() {
        return this.isVersionEqualOrAbove(2, 0);
    }

    public boolean supportsNullDataType() {
        return this.isVersionEqualOrAbove(2, 5);
    }

    public boolean supportsUserAndGroupIdInUser() {
        return this.serverVersion.getMajorVersion() < 3;
    }

    public boolean supportsProtocol(int protocolVersion) {
        switch (protocolVersion) {
            case 10: {
                return true;
            }
            case 11: {
                return this.isVersionEqualOrAbove(2, 1);
            }
            case 12: {
                return this.isVersionEqualOrAbove(2, 5);
            }
            case 13: {
                return this.isVersionEqualOrAbove(3, 0);
            }
        }
        return false;
    }

    public boolean supportsCustomExceptionMessages() {
        return this.isVersionEqualOrAbove(1, 5);
    }

    public boolean supportsParametrizedExceptions() {
        return this.isVersionEqualOrAbove(3, 0);
    }

    public boolean supportsMonitoringTables() {
        return this.isVersionEqualOrAbove(2, 1);
    }

    public boolean supportsGlobalTemporaryTables() {
        return this.isVersionEqualOrAbove(2, 5);
    }

    public boolean supportsFullSearchableBlobs() {
        return this.isVersionEqualOrAbove(2, 1);
    }

    public boolean supportsIdentityColumns() {
        return this.isVersionEqualOrAbove(3, 0);
    }

    public int maxIdentifierLengthCharacters() {
        if (this.isVersionEqualOrAbove(4, 0)) {
            return 63;
        }
        return 31;
    }

    public int maxIdentifierLengthBytes() {
        if (this.isVersionEqualOrAbove(4, 0)) {
            return 252;
        }
        return 31;
    }

    public int maxReportedIdentifierLengthBytes() {
        if (this.isVersionEqualOrAbove(4, 0)) {
            return 252;
        }
        if (this.reportsByteLengthInDescriptor()) {
            return 93;
        }
        return 31;
    }

    public int reportedMetadataCharacterSetId() {
        if (this.isVersionEqualOrAbove(4, 0)) {
            return 4;
        }
        return 3;
    }

    public boolean supportsPageSize(int pageSize) {
        switch (pageSize) {
            case 1024: {
                return !this.isVersionEqualOrAbove(2, 1);
            }
            case 2048: {
                return !this.isVersionEqualOrAbove(2, 1);
            }
            case 4096: {
                return true;
            }
            case 8192: {
                return true;
            }
            case 16384: {
                return this.isVersionEqualOrAbove(2, 0);
            }
            case 32768: {
                return this.isVersionEqualOrAbove(4, 0);
            }
        }
        return false;
    }

    public boolean supportsWireEncryption() {
        return this.isVersionEqualOrAbove(3, 0);
    }

    public boolean supportsNativeUserDefinedFunctions() {
        return this.isVersionBelow(4, 0);
    }

    public boolean supportsCaseSensitiveUserNames() {
        return this.isVersionEqualOrAbove(3, 0);
    }

    public static FirebirdSupportInfo supportInfoFor(GDSServerVersion serverVersion) {
        return new FirebirdSupportInfo(serverVersion);
    }

    public static FirebirdSupportInfo supportInfoFor(FbAttachment attachment) {
        return FirebirdSupportInfo.supportInfoFor(attachment.getServerVersion());
    }

    public static FirebirdSupportInfo supportInfoFor(Connection connection) {
        try {
            if (connection.isWrapperFor(FirebirdConnection.class)) {
                return FirebirdSupportInfo.supportInfoFor(connection.unwrap(FirebirdConnection.class).getFbDatabase());
            }
            throw new IllegalArgumentException("connection needs to be (or unwrap to) an org.firebirdsql.jdbc.FBConnection");
        }
        catch (SQLException e2) {
            throw new IllegalStateException(e2);
        }
    }
}

