/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.pool;

public class BlockingStack {
    protected Node top = null;
    protected int waiting = 0;
    protected Object topLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.topLock;
        synchronized (object) {
            return this.top == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        Object object = this.topLock;
        synchronized (object) {
            return this.top == null ? null : this.top.getObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object extract() {
        Object result = null;
        Object object = this.topLock;
        synchronized (object) {
            if (this.top != null) {
                Node item = this.top;
                this.top = item.getNext();
                result = item.getObject();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pop() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object result = this.extract();
        if (result == null) {
            Object object = this.topLock;
            synchronized (object) {
                try {
                    ++this.waiting;
                    this.topLock.wait();
                    result = this.extract();
                }
                catch (InterruptedException e2) {
                    --this.waiting;
                    this.topLock.notify();
                    throw e2;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pop(long msec) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object result = this.extract();
        if (result == null) {
            Object object = this.topLock;
            synchronized (object) {
                try {
                    long wait = msec <= 0L ? 0L : msec;
                    long start = System.currentTimeMillis();
                    while (wait > 0L) {
                        ++this.waiting;
                        this.topLock.wait(msec);
                        wait = msec - (System.currentTimeMillis() - start);
                        result = this.extract();
                    }
                }
                catch (InterruptedException e2) {
                    --this.waiting;
                    this.topLock.notify();
                    throw e2;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Object item) throws InterruptedException {
        if (item == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.topLock;
        synchronized (object) {
            this.top = new Node(item, this.top);
            if (this.waiting > 0) {
                this.topLock.notify();
            }
        }
    }

    protected class Node {
        private Node next = null;
        private Object object = null;

        public Node() {
            this.object = null;
            this.next = null;
        }

        public Node(Object object) {
            this.object = object;
        }

        public Node(Object object, Node next) {
            this.object = object;
            this.next = next;
        }

        public Node getNext() {
            return this.next;
        }

        public Object getObject() {
            return this.object;
        }

        public void setNext(Node next) {
            this.next = next;
        }

        public void setObject(Object object) {
            this.object = object;
        }
    }
}

