/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.pool;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import org.firebirdsql.ds.ReflectionHelper;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.pool.PingablePooledConnection;
import org.firebirdsql.pool.PoolDebugConfiguration;
import org.firebirdsql.pool.PooledConnectionEventListener;
import org.firebirdsql.pool.PooledConnectionHandler;
import org.firebirdsql.pool.PooledConnectionQueue;
import org.firebirdsql.pool.PooledObject;
import org.firebirdsql.pool.PooledPreparedStatementHandler;
import org.firebirdsql.pool.XCachablePreparedStatement;
import org.firebirdsql.pool.XConnectionManager;
import org.firebirdsql.pool.XPingableConnection;
import org.firebirdsql.pool.XPreparedStatementCache;
import org.firebirdsql.pool.XPreparedStatementModel;
import org.firebirdsql.pool.XStatementManager;
import org.firebirdsql.util.SQLExceptionChainBuilder;

public abstract class AbstractPingablePooledConnection
implements PooledConnection,
PooledObject,
XConnectionManager,
XPingableConnection,
XStatementManager {
    private static final boolean LOG_PREPARE_STATEMENT = PoolDebugConfiguration.DEBUG_STMT_POOL;
    private static final boolean LOG_POOL_CLEANING = PoolDebugConfiguration.DEBUG_STMT_POOL;
    private static final boolean LOG_META_DATA = PoolDebugConfiguration.LOG_DEBUG_INFO;
    private static final Logger log = LoggerFactory.getLogger(PingablePooledConnection.class, false);
    protected Connection jdbcConnection;
    private final HashSet eventListeners = new HashSet();
    private boolean invalid;
    private boolean inPool;
    private long instantInPool = -1L;
    private PooledConnectionHandler currentConnection;
    private String pingStatement;
    private long lastPingTime = System.currentTimeMillis();
    private int pingInterval = 0;
    private int maxStatements;
    private boolean keepStatements;
    private boolean supportsStatementsAccrossCommit;
    private boolean supportsStatementsAccrossRollback;
    private boolean statementPooling;
    private int transactionIsolation = -1;
    private final HashMap statements = new HashMap();
    private final WeakReference<PooledConnectionQueue> owningQueue;

    protected Logger getLogChannel() {
        return log;
    }

    protected AbstractPingablePooledConnection(Connection connection, boolean statementPooling, int maxStatements, boolean keepStatements, PooledConnectionQueue owningQueue) throws SQLException {
        this.jdbcConnection = connection;
        this.statementPooling = statementPooling;
        this.maxStatements = maxStatements;
        this.keepStatements = keepStatements;
        this.owningQueue = new WeakReference<PooledConnectionQueue>(owningQueue);
        this.supportsStatementsAccrossCommit = connection.getMetaData().supportsOpenStatementsAcrossCommit();
        if (LOG_META_DATA && this.getLogChannel() != null) {
            this.getLogChannel().info("Pool supports open statements across commit : " + this.supportsStatementsAccrossCommit);
        }
        this.supportsStatementsAccrossRollback = connection.getMetaData().supportsOpenStatementsAcrossRollback();
        if (LOG_META_DATA && this.getLogChannel() != null) {
            this.getLogChannel().info("Pool supports open statements across rollback : " + this.supportsStatementsAccrossRollback);
        }
    }

    protected AbstractPingablePooledConnection(Connection connection, String pingStatement, int pingInterval, boolean statementPooling, int maxStatements, boolean keepStatements, PooledConnectionQueue owningQueue) throws SQLException {
        this(connection, statementPooling, maxStatements, keepStatements, owningQueue);
        this.pingStatement = pingStatement;
        this.pingInterval = pingInterval;
    }

    public void setDefaultTransactionIsolation(int isolation) {
        this.transactionIsolation = isolation;
    }

    @Override
    public long getLastPingTime() {
        return this.lastPingTime;
    }

    public boolean isStatementPooling() {
        return this.statementPooling;
    }

    public boolean isKeepStatements() {
        return this.keepStatements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean ping() {
        boolean bl2;
        block7: {
            if (this.pingStatement == null) {
                return false;
            }
            Statement stmt = null;
            try {
                stmt = this.jdbcConnection.createStatement();
                ResultSet rs = stmt.executeQuery(this.pingStatement);
                bl2 = rs.next();
                if (stmt == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    this.lastPingTime = System.currentTimeMillis();
                    throw throwable;
                }
                catch (SQLException sqlex) {
                    return false;
                }
            }
            stmt.close();
        }
        this.lastPingTime = System.currentTimeMillis();
        return bl2;
    }

    private void invalidate() {
        this.invalid = true;
    }

    private void checkValidity() {
        if (this.invalid) {
            throw new IllegalStateException("Cannot execute desired operation because pooled connection has invalid state.");
        }
    }

    @Override
    public boolean isValid() {
        if (this.invalid) {
            return false;
        }
        if (this.pingInterval > 0 && System.currentTimeMillis() - this.lastPingTime > (long)this.pingInterval && this.pingStatement != null) {
            return this.ping();
        }
        return true;
    }

    public synchronized boolean isInPool() {
        return this.inPool;
    }

    public synchronized void setInPool(boolean inPool) {
        this.inPool = inPool;
        this.instantInPool = inPool ? System.currentTimeMillis() : -1L;
    }

    public synchronized long getInstantInPool() {
        return this.instantInPool;
    }

    private synchronized void checkInPool() throws SQLException {
        if (this.inPool) {
            throw new FBSQLException("Physical connection is currently in pool, you cannot allocate logical connections now.");
        }
    }

    @Override
    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        this.eventListeners.add(listener);
    }

    @Override
    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        this.eventListeners.remove(listener);
    }

    @Override
    public void close() throws SQLException {
        this.internalClose();
        ConnectionEvent event = new ConnectionEvent(this);
        ArrayList tempListeners = new ArrayList(this.eventListeners);
        for (ConnectionEventListener listener : tempListeners) {
            if (!(listener instanceof PooledConnectionEventListener)) continue;
            PooledConnectionEventListener pooledEventListener = (PooledConnectionEventListener)listener;
            pooledEventListener.physicalConnectionClosed(event);
        }
    }

    protected void internalClose() throws SQLException {
        this.checkValidity();
        if (this.currentConnection != null) {
            this.currentConnection.deallocate();
        }
        this.jdbcConnection.close();
        this.statements.clear();
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deallocate() {
        try {
            this.internalClose();
        }
        catch (SQLException ex) {
            if (log != null) {
                log.warn("Could not cleanly deallocate connection.", ex);
            }
        }
        finally {
            ConnectionEvent event = new ConnectionEvent(this);
            ArrayList tempListeners = new ArrayList(this.eventListeners);
            for (ConnectionEventListener listener : tempListeners) {
                if (!(listener instanceof PooledConnectionEventListener)) continue;
                PooledConnectionEventListener pooledEventListener = (PooledConnectionEventListener)listener;
                pooledEventListener.physicalConnectionDeallocated(event);
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkValidity();
        this.checkInPool();
        if (this.currentConnection != null) {
            throw new IllegalStateException("Cannot provide new connection while old one is still in use.");
        }
        this.currentConnection = new PooledConnectionHandler(this.jdbcConnection, this);
        Connection result = this.currentConnection.getProxy();
        this.configureConnectionDefaults(result);
        return result;
    }

    protected void configureConnectionDefaults(Connection connection) throws SQLException {
        connection.setAutoCommit(true);
        connection.setReadOnly(false);
        if (this.transactionIsolation != -1) {
            connection.setTransactionIsolation(this.transactionIsolation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement getPreparedStatement(String statement, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (!this.isStatementPooling()) {
            return this.jdbcConnection.prepareStatement(statement, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        HashMap hashMap = this.statements;
        synchronized (hashMap) {
            XPreparedStatementModel key = new XPreparedStatementModel(statement, resultSetType, resultSetConcurrency, resultSetHoldability);
            XPreparedStatementCache stmtCache = (XPreparedStatementCache)this.statements.get(key);
            if (stmtCache == null) {
                stmtCache = new XPreparedStatementCache((XStatementManager)this, key, this.maxStatements);
                this.statements.put(key, stmtCache);
            }
            XCachablePreparedStatement stmt = stmtCache.take(this.currentConnection.getProxy());
            return stmt;
        }
    }

    @Override
    public PreparedStatement getPreparedStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.getPreparedStatement(sql, resultSetType, resultSetConcurrency, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement getPreparedStatement(String statement, int[] keyIndexes, String[] keyColumns) throws SQLException {
        if (!this.isStatementPooling()) {
            if (keyIndexes == null && keyColumns == null) {
                return this.jdbcConnection.prepareStatement(statement, 1);
            }
            if (keyIndexes != null) {
                return this.jdbcConnection.prepareStatement(statement, keyIndexes);
            }
            if (keyColumns != null) {
                return this.jdbcConnection.prepareStatement(statement, keyColumns);
            }
            throw new IllegalStateException();
        }
        HashMap hashMap = this.statements;
        synchronized (hashMap) {
            XPreparedStatementModel key;
            if (keyIndexes == null && keyColumns == null) {
                key = new XPreparedStatementModel(statement, 1);
            } else if (keyIndexes != null) {
                key = new XPreparedStatementModel(statement, keyIndexes);
            } else if (keyColumns != null) {
                key = new XPreparedStatementModel(statement, keyColumns);
            } else {
                throw new IllegalStateException();
            }
            XPreparedStatementCache stmtCache = (XPreparedStatementCache)this.statements.get(key);
            if (stmtCache == null) {
                stmtCache = new XPreparedStatementCache((XStatementManager)this, key, this.maxStatements);
                this.statements.put(key, stmtCache);
            }
            XCachablePreparedStatement stmt = stmtCache.take(this.currentConnection.getProxy());
            return stmt;
        }
    }

    public XCachablePreparedStatement prepareStatement(XPreparedStatementModel key, boolean cached) throws SQLException {
        if (LOG_PREPARE_STATEMENT && this.getLogChannel() != null) {
            this.getLogChannel().info("Prepared statement for SQL '" + key.getSql() + "'");
        }
        if (!key.isGeneratedKeys()) {
            return this.prepareStatementNoGeneratedKeys(key, cached);
        }
        return this.prepareStatementGeneratedKeys(key, cached);
    }

    @Override
    public XCachablePreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, boolean cached) throws SQLException {
        return this.prepareStatement(new XPreparedStatementModel(sql, resultSetType, resultSetConcurrency, 2), cached);
    }

    private XCachablePreparedStatement prepareStatementNoGeneratedKeys(XPreparedStatementModel key, boolean cached) throws SQLException {
        PreparedStatement stmt = this.jdbcConnection.prepareStatement(key.getSql(), key.getResultSetType(), key.getResultSetConcurrency(), key.getResultSetHoldability());
        return this.wrapPreparedStatement(key, cached, stmt);
    }

    private XCachablePreparedStatement prepareStatementGeneratedKeys(XPreparedStatementModel key, boolean cached) throws SQLException {
        PreparedStatement stmt;
        if (key.getKeyIndexes() == null && key.getKeyColumns() == null) {
            stmt = this.jdbcConnection.prepareStatement(key.getSql(), 1);
        } else if (key.getKeyIndexes() != null) {
            stmt = this.jdbcConnection.prepareStatement(key.getSql(), key.getKeyIndexes());
        } else if (key.getKeyColumns() != null) {
            stmt = this.jdbcConnection.prepareStatement(key.getSql(), key.getKeyColumns());
        } else {
            throw new IllegalArgumentException();
        }
        return this.wrapPreparedStatement(key, cached, stmt);
    }

    private XCachablePreparedStatement wrapPreparedStatement(XPreparedStatementModel key, boolean cached, PreparedStatement stmt) {
        Class[] implementedInterfaces = ReflectionHelper.getAllInterfaces(stmt.getClass());
        PooledPreparedStatementHandler handler = new PooledPreparedStatementHandler(key, stmt, (XStatementManager)this, cached);
        Class[] interfacesToImplement = new Class[implementedInterfaces.length + 1];
        System.arraycopy(implementedInterfaces, 0, interfacesToImplement, 0, implementedInterfaces.length);
        interfacesToImplement[implementedInterfaces.length] = XCachablePreparedStatement.class;
        return (XCachablePreparedStatement)Proxy.newProxyInstance(this.getClass().getClassLoader(), interfacesToImplement, (InvocationHandler)handler);
    }

    @Override
    public void statementClosed(String sql, Object proxy) throws SQLException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanCache() throws SQLException {
        if (LOG_POOL_CLEANING && this.getLogChannel() != null) {
            this.getLogChannel().info("Prepared statement cache cleaned.");
        }
        SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
        HashMap hashMap = this.statements;
        synchronized (hashMap) {
            Iterator iter = this.statements.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry item = iter.next();
                XPreparedStatementCache stmtCache = (XPreparedStatementCache)item.getValue();
                iter.remove();
                try {
                    stmtCache.invalidate();
                }
                catch (SQLException ex) {
                    chain.append(ex);
                }
            }
        }
        if (chain.hasException()) {
            throw chain.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statementClosed(XPreparedStatementModel key, Object proxy) throws SQLException {
        HashMap hashMap = this.statements;
        synchronized (hashMap) {
            XPreparedStatementCache stmtCache = (XPreparedStatementCache)this.statements.get(key);
            if (stmtCache == null) {
                if (this.getLogChannel() != null) {
                    this.getLogChannel().error("Cannot find statement cache for SQL \"" + key.getSql() + "\". Trying to close statement to release resources.");
                }
                if (proxy instanceof XCachablePreparedStatement) {
                    ((XCachablePreparedStatement)proxy).forceClose();
                }
            } else {
                stmtCache.put(proxy);
            }
        }
    }

    protected boolean isRollbackAllowed() {
        return true;
    }

    @Override
    public void connectionClosed(PooledConnectionHandler connection) throws SQLException {
        if (connection != this.currentConnection) {
            throw new IllegalArgumentException("Notified about a connection that is not under my control.");
        }
        if (!this.keepStatements) {
            this.cleanCache();
        }
        try {
            if (this.isRollbackAllowed() && !this.jdbcConnection.getAutoCommit() && !connection.isClosed()) {
                this.jdbcConnection.rollback();
            }
        }
        catch (SQLException ex) {
            if (log != null && log.isWarnEnabled()) {
                log.warn("Exception while trying to rollback transaction before returning connection to pool.", ex);
            }
            this.close();
            throw ex;
        }
        this.currentConnection = null;
        ConnectionEvent event = new ConnectionEvent(this);
        ArrayList tempListeners = new ArrayList(this.eventListeners);
        Iterator iter = tempListeners.iterator();
        while (iter.hasNext()) {
            ((ConnectionEventListener)iter.next()).connectionClosed(event);
        }
    }

    @Override
    public void connectionErrorOccured(PooledConnectionHandler connection, SQLException ex) {
        ConnectionEvent event = new ConnectionEvent(this, ex);
        ArrayList tempListeners = new ArrayList(this.eventListeners);
        Iterator iter = tempListeners.iterator();
        while (iter.hasNext()) {
            ((ConnectionEventListener)iter.next()).connectionErrorOccurred(event);
        }
    }

    @Override
    public boolean isValid(PooledConnectionHandler connection) {
        return connection == this.currentConnection;
    }

    @Override
    public void connectionCommitted(PooledConnectionHandler connection) throws SQLException {
        if (connection != this.currentConnection) {
            throw new IllegalArgumentException("Specified connection does not correspond current physical connection");
        }
        if (!this.supportsStatementsAccrossCommit) {
            this.cleanCache();
        }
    }

    @Override
    public void connectionRolledBack(PooledConnectionHandler connection) throws SQLException {
        if (connection != this.currentConnection) {
            throw new IllegalArgumentException("Specified connection does not correspond current physical connection");
        }
        if (!this.supportsStatementsAccrossRollback) {
            this.cleanCache();
        }
    }

    public PooledConnectionQueue getOwningQueue() {
        return (PooledConnectionQueue)this.owningQueue.get();
    }
}

