/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.logging;

import java.io.PrintStream;
import org.firebirdsql.logging.Logger;

public class ConsoleLogger
extends Logger {
    private static final boolean debugEnabled = false;
    private static final boolean traceEnabled = true;
    private static final boolean infoEnabled = true;
    private static final boolean warnEnabled = true;
    private static final boolean errEnabled = true;
    private static final boolean fatalEnabled = true;
    private String name;

    public ConsoleLogger(String name) {
        int lastPoint = name.lastIndexOf(46);
        this.name = lastPoint == -1 ? name : name.substring(lastPoint + 1);
    }

    public boolean isDebugEnabled() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void out(Object message, Throwable t2) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.out.println("[" + this.name + "]" + message);
            if (t2 != null) {
                t2.printStackTrace(System.out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void err(Object message, Throwable t2) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.err.println("[" + this.name + "]" + message);
            if (t2 != null) {
                t2.printStackTrace(System.err);
            }
        }
    }

    public void debug(Object message) {
        this.debug(message, null);
    }

    public void debug(Object message, Throwable t2) {
        if (this.isDebugEnabled()) {
            this.out(message, t2);
        }
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public void trace(Object message, Throwable t2) {
        if (this.isTraceEnabled()) {
            this.out(message, t2);
        }
    }

    public void trace(Object message) {
        this.trace(message, null);
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void info(Object message) {
        this.info(message, null);
    }

    public void info(Object message, Throwable t2) {
        if (this.isInfoEnabled()) {
            this.out(message, t2);
        }
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(Object message) {
        this.warn(message, null);
    }

    public void warn(Object message, Throwable t2) {
        if (this.isWarnEnabled()) {
            this.err(message, t2);
        }
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(Object message) {
        this.error(message, null);
    }

    public void error(Object message, Throwable t2) {
        if (this.isErrorEnabled()) {
            this.err(message, t2);
        }
    }

    public boolean isFatalEnabled() {
        return true;
    }

    public void fatal(Object message) {
        this.fatal(message, null);
    }

    public void fatal(Object message, Throwable t2) {
        if (this.isFatalEnabled()) {
            this.err(message, t2);
        }
    }
}

