/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.jdbc.FBSQLException;

class TranslatingReader
extends InputStreamReader {
    private char[] charMap;

    static TranslatingReader getInstance(InputStream in, String charsetName, String mappingPath) throws SQLException {
        try {
            if (charsetName != null) {
                return new TranslatingReader(in, charsetName, mappingPath);
            }
            return new TranslatingReader(in, mappingPath);
        }
        catch (UnsupportedEncodingException ex) {
            throw new FBSQLException("Cannot set character stream because the unsupported encoding is detected in the JVM: " + charsetName + ". Please report this to the driver developers.");
        }
    }

    private TranslatingReader(InputStream in, String charsetName, String mappingPath) throws UnsupportedEncodingException, SQLException {
        super(in, charsetName);
        this.charMap = (char[])(mappingPath != null ? EncodingFactory.getTranslator(mappingPath).getMapping() : null);
    }

    private TranslatingReader(InputStream in, String mappingPath) throws UnsupportedEncodingException, SQLException {
        super(in);
        this.charMap = (char[])(mappingPath != null ? EncodingFactory.getTranslator(mappingPath).getMapping() : null);
    }

    public int read() throws IOException {
        if (this.charMap == null) {
            return super.read();
        }
        return this.charMap[super.read()];
    }

    public int read(char[] cbuf, int offset, int length) throws IOException {
        int result = super.read(cbuf, offset, length);
        if (this.charMap != null) {
            for (int i2 = 0; i2 < cbuf.length; ++i2) {
                cbuf[i2] = this.charMap[cbuf[i2]];
            }
        }
        return result;
    }
}

