/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.DataTruncation;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.jdbc.field.TypeConversionException;
import org.firebirdsql.util.IOUtils;

public class FBBinaryField
extends FBField {
    FBBinaryField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
    }

    @Override
    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeString(this.getFieldData(), this.getDatatypeCoder().getEncodingFactory().getDefaultEncoding(), this.mappingPath);
    }

    @Override
    public void setString(String value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setBytes(this.getDatatypeCoder().encodeString(value, this.getDatatypeCoder().getEncodingFactory().getDefaultEncoding(), this.mappingPath));
    }

    @Override
    public byte[] getBytes() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return (byte[])this.getFieldData().clone();
    }

    @Override
    public void setBytes(byte[] value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        if (value.length > this.fieldDescriptor.getLength()) {
            throw new DataTruncation(this.fieldDescriptor.getPosition() + 1, true, false, value.length, this.fieldDescriptor.getLength());
        }
        this.setFieldData(value);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new ByteArrayInputStream(this.getFieldData());
    }

    protected void setBinaryStreamInternal(InputStream in, long length) throws SQLException {
        if (in == null) {
            this.setNull();
            return;
        }
        if (length > (long)this.fieldDescriptor.getLength()) {
            throw new DataTruncation(this.fieldDescriptor.getPosition() + 1, true, false, (int)length, this.fieldDescriptor.getLength());
        }
        try {
            this.setBytes(IOUtils.toBytes(in, (int)length));
        }
        catch (IOException ioex) {
            throw new TypeConversionException("Error converting to binary stream.");
        }
    }

    protected void setCharacterStreamInternal(Reader in, long length) throws SQLException {
        if (in == null) {
            this.setNull();
            return;
        }
        if (length > (long)this.fieldDescriptor.getLength()) {
            throw new DataTruncation(this.fieldDescriptor.getPosition() + 1, true, false, (int)length, this.fieldDescriptor.getLength());
        }
        try {
            this.setString(IOUtils.toString(in, (int)length));
        }
        catch (IOException ioex) {
            throw new TypeConversionException("Error converting to character stream.");
        }
    }
}

