/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.escape;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.firebirdsql.jdbc.escape.FBEscapedParser;
import org.firebirdsql.jdbc.escape.FBSQLParseException;

public class FBEscapedFunctionHelper {
    private static final Map<String, String> FUNCTION_MAP;
    private static final Set<String> SUPPORTED_NUMERIC_FUNCTIONS;
    private static final Set<String> SUPPORTED_STRING_FUNCTIONS;
    private static final Set<String> SUPPORTED_TIME_DATE_FUNCTIONS;
    private static final Set<String> SUPPORTED_SYSTEM_FUNCTIONS;

    private static void checkSyntax(String functionCall) throws FBSQLParseException {
        int parenthesisStart = functionCall.indexOf(40);
        if (parenthesisStart != -1 && functionCall.charAt(functionCall.length() - 1) != ')') {
            throw new FBSQLParseException("No closing parenthesis found, not a function call.");
        }
    }

    public static String parseFunction(String functionCall) throws FBSQLParseException {
        functionCall = functionCall.trim();
        FBEscapedFunctionHelper.checkSyntax(functionCall);
        int parenthesisStart = functionCall.indexOf(40);
        return parenthesisStart != -1 ? functionCall.substring(0, parenthesisStart) : functionCall;
    }

    public static List<String> parseArguments(String functionCall) throws FBSQLParseException {
        functionCall = functionCall.trim();
        FBEscapedFunctionHelper.checkSyntax(functionCall);
        int parenthesisStart = functionCall.indexOf(40);
        if (parenthesisStart == -1) {
            return Collections.emptyList();
        }
        String paramsString = functionCall.substring(parenthesisStart + 1, functionCall.length() - 1);
        ArrayList<String> params = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean inQuotes = false;
        boolean inDoubleQuotes = false;
        boolean coalesceSpace = true;
        int nestedParentheses = 0;
        int n2 = paramsString.length();
        block7: for (int i2 = 0; i2 < n2; ++i2) {
            char currentChar = paramsString.charAt(i2);
            if (Character.isWhitespace(currentChar)) {
                if (inQuotes || inDoubleQuotes) {
                    sb.append(currentChar);
                    continue;
                }
                if (coalesceSpace) continue;
                sb.append(' ');
                coalesceSpace = true;
                continue;
            }
            switch (currentChar) {
                case '\'': {
                    sb.append(currentChar);
                    if (!inDoubleQuotes) {
                        inQuotes = !inQuotes;
                    }
                    coalesceSpace = false;
                    continue block7;
                }
                case '\"': {
                    sb.append(currentChar);
                    if (!inQuotes) {
                        inDoubleQuotes = !inDoubleQuotes;
                    }
                    coalesceSpace = false;
                    continue block7;
                }
                case '(': {
                    if (!inQuotes && !inDoubleQuotes) {
                        ++nestedParentheses;
                    }
                    sb.append('(');
                    coalesceSpace = false;
                    continue block7;
                }
                case ')': {
                    if (!inQuotes && !inDoubleQuotes && --nestedParentheses < 0) {
                        throw new FBSQLParseException("Unbalanced parentheses in parameters at position " + i2);
                    }
                    sb.append(')');
                    coalesceSpace = false;
                    continue block7;
                }
                case ',': {
                    if (inQuotes || inDoubleQuotes || nestedParentheses > 0) {
                        sb.append(currentChar);
                        continue block7;
                    }
                    params.add(sb.toString());
                    sb.setLength(0);
                    coalesceSpace = true;
                    continue block7;
                }
                default: {
                    sb.append(currentChar);
                    coalesceSpace = false;
                }
            }
        }
        if (sb.length() > 0) {
            params.add(sb.toString());
        }
        if (inQuotes || inDoubleQuotes) {
            throw new FBSQLParseException("String literal is not properly closed.");
        }
        if (nestedParentheses != 0) {
            throw new FBSQLParseException("Unbalanced parentheses in parameters.");
        }
        return params;
    }

    public static String convertTemplate(String functionCall, FBEscapedParser.EscapeParserMode mode) throws FBSQLParseException {
        String functionName = FBEscapedFunctionHelper.parseFunction(functionCall).toUpperCase();
        String[] params = FBEscapedFunctionHelper.parseArguments(functionCall).toArray(new String[0]);
        if (!FUNCTION_MAP.containsKey(functionName)) {
            throw new FBSQLParseException("Unsupported JDBC function escape: " + functionName);
        }
        String firebirdTemplate = FUNCTION_MAP.get(functionName);
        if (firebirdTemplate != null) {
            return MessageFormat.format(firebirdTemplate, params);
        }
        if (mode == FBEscapedParser.EscapeParserMode.USE_STANDARD_UDF) {
            return FBEscapedFunctionHelper.convertUsingStandardUDF(functionName, params);
        }
        return null;
    }

    private static String convertUsingStandardUDF(String name, String[] params) throws FBSQLParseException {
        try {
            name = name.toLowerCase();
            Method method = FBEscapedFunctionHelper.class.getMethod(name, String[].class);
            return (String)method.invoke(null, new Object[]{params});
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (Exception ex) {
            throw new FBSQLParseException("Error when converting function " + name + ". Error " + ex.getClass().getName() + " : " + ex.getMessage());
        }
    }

    public static String abs(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function abs : " + params.length);
        }
        return "abs(" + params[0] + ")";
    }

    public static String acos(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function acos : " + params.length);
        }
        return "acos(" + params[0] + ")";
    }

    public static String asin(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function asin : " + params.length);
        }
        return "asin(" + params[0] + ")";
    }

    public static String atan(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function atan : " + params.length);
        }
        return "atan(" + params[0] + ")";
    }

    public static String atan2(String[] params) throws FBSQLParseException {
        if (params.length != 2) {
            throw new FBSQLParseException("Incorrect number of parameters of function atan2 : " + params.length);
        }
        return "atan2(" + params[0] + ", " + params[1] + ")";
    }

    public static String ceiling(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function ceiling : " + params.length);
        }
        return "ceiling(" + params[0] + ")";
    }

    public static String cos(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function cos : " + params.length);
        }
        return "cos(" + params[0] + ")";
    }

    public static String cot(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function cot : " + params.length);
        }
        return "cot(" + params[0] + ")";
    }

    public static String floor(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function floor : " + params.length);
        }
        return "floor(" + params[0] + ")";
    }

    public static String log10(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function log10 : " + params.length);
        }
        return "log10(" + params[0] + ")";
    }

    public static String mod(String[] params) throws FBSQLParseException {
        if (params.length != 2) {
            throw new FBSQLParseException("Incorrect number of parameters of function mod : " + params.length);
        }
        return "mod(" + params[0] + ", " + params[1] + ")";
    }

    public static String pi(String[] params) throws FBSQLParseException {
        if (params.length != 0) {
            throw new FBSQLParseException("Incorrect number of parameters of function pi : " + params.length);
        }
        return "pi()";
    }

    public static String rand(String[] params) throws FBSQLParseException {
        if (params.length != 0) {
            throw new FBSQLParseException("Incorrect number of parameters of function rand : " + params.length);
        }
        return "rand()";
    }

    public static String sign(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function sign : " + params.length);
        }
        return "sign(" + params[0] + ")";
    }

    public static String sin(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function sin : " + params.length);
        }
        return "sin(" + params[0] + ")";
    }

    public static String sqrt(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function sqrt : " + params.length);
        }
        return "sqrt(" + params[0] + ")";
    }

    public static String tan(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function tan : " + params.length);
        }
        return "tan(" + params[0] + ")";
    }

    public static Set<String> getSupportedNumericFunctions() {
        return SUPPORTED_NUMERIC_FUNCTIONS;
    }

    public static Set<String> getSupportedStringFunctions() {
        return SUPPORTED_STRING_FUNCTIONS;
    }

    public static Set<String> getSupportedTimeDateFunctions() {
        return SUPPORTED_TIME_DATE_FUNCTIONS;
    }

    public static Set<String> getSupportedSystemFunctions() {
        return SUPPORTED_SYSTEM_FUNCTIONS;
    }

    static {
        HashMap<String, String> functionMap = new HashMap<String, String>();
        functionMap.put("ABS", null);
        functionMap.put("ACOS", null);
        functionMap.put("ASIN", null);
        functionMap.put("ATAN", null);
        functionMap.put("ATAN2", null);
        functionMap.put("CEILING", null);
        functionMap.put("COS", null);
        functionMap.put("COT", null);
        functionMap.put("EXP", null);
        functionMap.put("FLOOR", null);
        functionMap.put("LOG", "LN({0})");
        functionMap.put("LOG10", null);
        functionMap.put("MOD", null);
        functionMap.put("PI", null);
        functionMap.put("POWER", null);
        functionMap.put("ROUND", null);
        functionMap.put("SIGN", null);
        functionMap.put("SIN", null);
        functionMap.put("SQRT", null);
        functionMap.put("TAN", null);
        functionMap.put("TRUNCATE", "TRUNC({0},{1})");
        SUPPORTED_NUMERIC_FUNCTIONS = Collections.unmodifiableSet(new HashSet(functionMap.keySet()));
        functionMap.put("ASCII", "ASCII_VAL({0})");
        functionMap.put("CHAR", "ASCII_CHAR({0})");
        functionMap.put("CHAR_LENGTH", "CHAR_LENGTH({0})");
        functionMap.put("CHARACTER_LENGTH", "CHAR_LENGTH({0})");
        functionMap.put("CONCAT", "{0}||{1}");
        functionMap.put("INSERT", "OVERLAY({0} PLACING {3} FROM {1} FOR {2})");
        functionMap.put("LCASE", "LOWER({0})");
        functionMap.put("LEFT", null);
        functionMap.put("LENGTH", "CHAR_LENGTH(TRIM(TRAILING FROM {0}))");
        functionMap.put("LOCATE", "POSITION({0},{1},{2})");
        functionMap.put("LTRIM", "TRIM(LEADING FROM {0})");
        functionMap.put("OCTET_LENGTH", null);
        functionMap.put("POSITION", null);
        functionMap.put("REPEAT", "RPAD('''',{1},{0})");
        functionMap.put("REPLACE", null);
        functionMap.put("RIGHT", null);
        functionMap.put("RTRIM", "TRIM(TRAILING FROM {0})");
        functionMap.put("SPACE", "RPAD('''',{0})");
        functionMap.put("SUBSTRING", "SUBSTRING({0} FROM {1} FOR {2})");
        functionMap.put("UCASE", "UPPER({0})");
        HashSet supportedStringFunctions = new HashSet(functionMap.keySet());
        supportedStringFunctions.removeAll(SUPPORTED_NUMERIC_FUNCTIONS);
        SUPPORTED_STRING_FUNCTIONS = Collections.unmodifiableSet(new HashSet(supportedStringFunctions));
        functionMap.put("CURRENT_DATE", "CURRENT_DATE");
        functionMap.put("CURRENT_TIME", "CURRENT_TIME");
        functionMap.put("CURRENT_TIMESTAMP", "CURRENT_TIMESTAMP");
        functionMap.put("CURDATE", "CURRENT_DATE");
        functionMap.put("CURTIME", "CURRENT_TIME");
        functionMap.put("DAYOFMONTH", "EXTRACT(DAY FROM {0})");
        functionMap.put("DAYOFWEEK", "EXTRACT(WEEKDAY FROM {0})+1");
        functionMap.put("DAYOFYEAR", "EXTRACT(YEARDAY FROM {0})+1");
        functionMap.put("EXTRACT", null);
        functionMap.put("HOUR", "EXTRACT(HOUR FROM {0})");
        functionMap.put("MINUTE", "EXTRACT(MINUTE FROM {0})");
        functionMap.put("MONTH", "EXTRACT(MONTH FROM {0})");
        functionMap.put("NOW", "CURRENT_TIMESTAMP");
        functionMap.put("SECOND", "EXTRACT(SECOND FROM {0})");
        functionMap.put("TIMESTAMPADD", null);
        functionMap.put("TIMESTAMPDIFF", null);
        functionMap.put("WEEK", "EXTRACT(WEEK FROM {0})");
        functionMap.put("YEAR", "EXTRACT(YEAR FROM {0})");
        HashSet supportedTimeDateFunctions = new HashSet(functionMap.keySet());
        supportedTimeDateFunctions.removeAll(SUPPORTED_NUMERIC_FUNCTIONS);
        supportedTimeDateFunctions.removeAll(SUPPORTED_STRING_FUNCTIONS);
        SUPPORTED_TIME_DATE_FUNCTIONS = Collections.unmodifiableSet(new HashSet(supportedTimeDateFunctions));
        functionMap.put("IFNULL", "COALESCE({0}, {1})");
        functionMap.put("USER", "USER");
        HashSet supportedSystemFunctions = new HashSet(functionMap.keySet());
        supportedSystemFunctions.removeAll(SUPPORTED_NUMERIC_FUNCTIONS);
        supportedSystemFunctions.removeAll(SUPPORTED_STRING_FUNCTIONS);
        supportedSystemFunctions.removeAll(SUPPORTED_TIME_DATE_FUNCTIONS);
        SUPPORTED_SYSTEM_FUNCTIONS = Collections.unmodifiableSet(new HashSet(supportedSystemFunctions));
        functionMap.put("CONVERT", "CAST({0} AS {1})");
        functionMap.put("DEGREES", null);
        functionMap.put("RADIANS", null);
        functionMap.put("RAND", null);
        functionMap.put("DIFFERENCE", null);
        functionMap.put("SOUNDEX", null);
        functionMap.put("DAYNAME", null);
        functionMap.put("MONTHNAME", null);
        functionMap.put("QUARTER", null);
        functionMap.put("DATABASE", null);
        FUNCTION_MAP = Collections.unmodifiableMap(functionMap);
    }
}

