/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jdbc.FBConnectionHelper;
import org.firebirdsql.jdbc.FBDriverPropertyManager;
import org.firebirdsql.jdbc.FBTpbMapper;
import org.firebirdsql.jdbc.FirebirdConnectionProperties;

public class FBConnectionProperties
implements FirebirdConnectionProperties,
Serializable {
    public static final String DATABASE_PROPERTY = "database";
    public static final String TYPE_PROPERTY = "type";
    public static final String ISOLATION_PROPERTY = "isolation";
    public static final String DEFAULT_ISOLATION_PROPERTY = "defaultIsolation";
    public static final String BLOB_BUFFER_SIZE_PROPERTY = "blobBufferSize";
    public static final String LOCAL_ENCODING_PROPERTY = "localEncoding";
    public static final String ENCODING_PROPERTY = "encoding";
    public static final String ROLE_NAME_PROPERTY = "roleName";
    public static final String SQL_DIALECT_PROPERTY = "sqlDialect";
    public static final String USE_TRANSLATION_PROPERTY = "useTranslation";
    public static final String USE_STREAM_BLOBS_PROPERTY = "useStreamBlobs";
    public static final String USE_STANDARD_UDF_PROPERTY = "useStandardUdf";
    public static final String SOCKET_BUFFER_SIZE_PROPERTY = "socketBufferSize";
    public static final String TIMESTAMP_USES_LOCAL_TIMEZONE_PROPERTY = "timestampUsesLocalTimezone";
    public static final String USER_NAME_PROPERTY = "userName";
    public static final String PASSWORD_PROPERTY = "password";
    public static final String BUFFERS_NUMBER_PROPERTY = "buffersNumber";
    private HashMap properties = new HashMap();
    private String type;
    private String database;
    private String tpbMapping;
    private int defaultTransactionIsolation = 2;
    private HashMap customMapping = new HashMap();
    private FBTpbMapper mapper;

    private int getIntProperty(String name) {
        Integer value = (Integer)this.properties.get(this.getCanonicalName(name));
        if (value == null) {
            return 0;
        }
        return value;
    }

    private String getCanonicalName(String propertyName) {
        return FBDriverPropertyManager.getCanonicalName(propertyName);
    }

    private String getStringProperty(String name) {
        Object value = this.properties.get(this.getCanonicalName(name));
        if (value instanceof Byte) {
            return value.toString();
        }
        if (value instanceof Integer) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        return (String)value;
    }

    private boolean getBooleanProperty(String name) {
        return this.properties.containsKey(this.getCanonicalName(name));
    }

    private void setIntProperty(String name, int value) {
        this.properties.put(this.getCanonicalName(name), new Integer(value));
    }

    private void setStringProperty(String name, String value) {
        if (DATABASE_PROPERTY.equals(name)) {
            this.setDatabase(value);
        } else if (TYPE_PROPERTY.equals(name)) {
            this.setType(value);
        }
        name = this.getCanonicalName(name);
        Object objValue = FBConnectionHelper.parseDpbString(name, value);
        this.properties.put(name, objValue);
    }

    private void setBooleanProperty(String name) {
        this.properties.put(this.getCanonicalName(name), null);
    }

    public int hashCode() {
        int result = 17;
        result ^= this.properties.hashCode();
        result ^= this.type != null ? this.type.hashCode() : 0;
        result ^= this.database != null ? this.database.hashCode() : 0;
        result ^= this.tpbMapping != null ? this.tpbMapping.hashCode() : 0;
        result ^= this.defaultTransactionIsolation;
        return result ^= this.customMapping.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FBConnectionProperties)) {
            return false;
        }
        FBConnectionProperties that = (FBConnectionProperties)obj;
        boolean result = true;
        result &= this.properties.equals(that.properties);
        result &= this.type != null ? this.type.equals(that.type) : that.type == null;
        result &= this.database != null ? this.database.equals(that.database) : that.database == null;
        result &= this.tpbMapping != null ? this.tpbMapping.equals(that.tpbMapping) : that.tpbMapping == null;
        result &= this.defaultTransactionIsolation == that.defaultTransactionIsolation;
        return result &= this.customMapping.equals(that.customMapping);
    }

    public Object clone() {
        FBConnectionProperties clone = new FBConnectionProperties();
        clone.properties.putAll(this.properties);
        clone.type = this.type;
        clone.database = this.database;
        clone.tpbMapping = this.tpbMapping;
        clone.defaultTransactionIsolation = this.defaultTransactionIsolation;
        clone.customMapping.putAll(this.customMapping);
        return clone;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getBlobBufferSize() {
        return this.getIntProperty(BLOB_BUFFER_SIZE_PROPERTY);
    }

    public void setBlobBufferSize(int bufferSize) {
        this.setIntProperty(BLOB_BUFFER_SIZE_PROPERTY, bufferSize);
    }

    public String getCharSet() {
        return this.getStringProperty(LOCAL_ENCODING_PROPERTY);
    }

    public void setCharSet(String charSet) {
        this.setStringProperty(LOCAL_ENCODING_PROPERTY, charSet);
        String encoding = this.getStringProperty(LOCAL_ENCODING_PROPERTY);
        if (encoding != null) {
            return;
        }
        encoding = FBConnectionHelper.getIscEncoding(charSet);
        if (encoding != null) {
            this.setStringProperty(ENCODING_PROPERTY, encoding);
        }
    }

    public String getEncoding() {
        return this.getStringProperty(ENCODING_PROPERTY);
    }

    public void setEncoding(String encoding) {
        this.setStringProperty(ENCODING_PROPERTY, encoding);
        String charSet = this.getStringProperty(LOCAL_ENCODING_PROPERTY);
        if (charSet != null) {
            return;
        }
        charSet = FBConnectionHelper.getJavaEncoding(encoding);
        if (charSet != null) {
            this.setStringProperty(LOCAL_ENCODING_PROPERTY, charSet);
        }
    }

    public String getRoleName() {
        return this.getStringProperty(ROLE_NAME_PROPERTY);
    }

    public void setRoleName(String roleName) {
        this.setStringProperty(ROLE_NAME_PROPERTY, roleName);
    }

    public String getSqlDialect() {
        return this.getStringProperty(SQL_DIALECT_PROPERTY);
    }

    public void setSqlDialect(String sqlDialect) {
        this.setStringProperty(SQL_DIALECT_PROPERTY, sqlDialect);
    }

    public String getUseTranslation() {
        return this.getStringProperty(USE_TRANSLATION_PROPERTY);
    }

    public void setUseTranslation(String translationPath) {
        this.setStringProperty(USE_TRANSLATION_PROPERTY, translationPath);
    }

    public boolean isUseStreamBlobs() {
        return this.getBooleanProperty(USE_STREAM_BLOBS_PROPERTY);
    }

    public void setUseStreamBlobs(boolean useStreamBlobs) {
        this.setBooleanProperty(USE_STREAM_BLOBS_PROPERTY);
    }

    public boolean isUseStandardUdf() {
        return this.getBooleanProperty(USE_STANDARD_UDF_PROPERTY);
    }

    public void setUseStandardUdf(boolean useStandardUdf) {
        this.setBooleanProperty(USE_STANDARD_UDF_PROPERTY);
    }

    public int getSocketBufferSize() {
        return this.getIntProperty(SOCKET_BUFFER_SIZE_PROPERTY);
    }

    public void setSocketBufferSize(int socketBufferSize) {
        this.setIntProperty(SOCKET_BUFFER_SIZE_PROPERTY, socketBufferSize);
    }

    public boolean isTimestampUsesLocalTimezone() {
        return this.getBooleanProperty(TIMESTAMP_USES_LOCAL_TIMEZONE_PROPERTY);
    }

    public void setTimestampUsesLocalTimezone(boolean timestampUsesLocalTimezone) {
        this.setBooleanProperty(TIMESTAMP_USES_LOCAL_TIMEZONE_PROPERTY);
    }

    public String getUserName() {
        return this.getStringProperty(USER_NAME_PROPERTY);
    }

    public void setUserName(String userName) {
        this.setStringProperty(USER_NAME_PROPERTY, userName);
    }

    public String getPassword() {
        return this.getStringProperty(PASSWORD_PROPERTY);
    }

    public void setPassword(String password) {
        this.setStringProperty(PASSWORD_PROPERTY, password);
    }

    public int getBuffersNumber() {
        return this.getIntProperty(BUFFERS_NUMBER_PROPERTY);
    }

    public void setBuffersNumber(int buffersNumber) {
        this.setIntProperty(BUFFERS_NUMBER_PROPERTY, buffersNumber);
    }

    public String getNonStandardProperty(String key) {
        return this.getStringProperty(key);
    }

    public void setNonStandardProperty(String key, String value) {
        if (ISOLATION_PROPERTY.equals(key) || DEFAULT_ISOLATION_PROPERTY.equals(key)) {
            this.setDefaultIsolation(value);
        } else {
            this.setStringProperty(key, value);
        }
    }

    public void setNonStandardProperty(String propertyMapping) {
        char[] chars = propertyMapping.toCharArray();
        StringBuffer key = new StringBuffer();
        StringBuffer value = new StringBuffer();
        boolean keyProcessed = false;
        for (int i2 = 0; i2 < chars.length; ++i2) {
            boolean isSeparator;
            char ch = chars[i2];
            boolean bl2 = isSeparator = Character.isWhitespace(ch) || ch == '=' || ch == ':';
            if (key.length() == 0 && isSeparator) continue;
            if (!keyProcessed && !isSeparator) {
                key.append(ch);
                continue;
            }
            if (!keyProcessed && isSeparator) {
                keyProcessed = true;
                continue;
            }
            if (keyProcessed && value.length() == 0 && isSeparator || !keyProcessed) continue;
            value.append(ch);
        }
        String keyStr = key.toString().trim();
        String valueStr = value.length() > 0 ? value.toString().trim() : null;
        this.setNonStandardProperty(keyStr, valueStr);
    }

    public DatabaseParameterBuffer getDatabaseParameterBuffer() throws SQLException {
        GDSType gdsType = GDSType.getType(this.type);
        if (gdsType == null && this.type != null) {
            throw new IllegalArgumentException("Unknown GDS type " + this.type);
        }
        GDS gds = gdsType != null ? GDSFactory.getGDSForType(gdsType) : GDSFactory.getDefaultGDS();
        DatabaseParameterBuffer dpb = gds.createDatabaseParameterBuffer();
        for (Map.Entry entry : this.properties.entrySet()) {
            String propertyName = (String)entry.getKey();
            Object value = entry.getValue();
            Integer dpbType = FBConnectionHelper.getDpbKey(propertyName);
            if (dpbType == null) continue;
            if (value instanceof Boolean) {
                if (!((Boolean)value).booleanValue()) continue;
                dpb.addArgument(dpbType);
                continue;
            }
            if (value instanceof Byte) {
                dpb.addArgument((int)dpbType, new byte[]{(Byte)value});
                continue;
            }
            if (value instanceof Integer) {
                dpb.addArgument((int)dpbType, (Integer)value);
                continue;
            }
            if (value instanceof String) {
                dpb.addArgument((int)dpbType, (String)value);
                continue;
            }
            if (value != null) continue;
            dpb.addArgument(dpbType);
        }
        return dpb;
    }

    public String getTpbMapping() {
        return this.tpbMapping;
    }

    public void setTpbMapping(String tpbMapping) {
        if (this.mapper != null) {
            throw new IllegalStateException("Properties are already initialized.");
        }
        this.tpbMapping = tpbMapping;
    }

    public int getDefaultTransactionIsolation() {
        if (this.mapper != null) {
            return this.mapper.getDefaultTransactionIsolation();
        }
        return this.defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolation(int defaultIsolationLevel) {
        if (this.mapper != null) {
            this.mapper.setDefaultTransactionIsolation(defaultIsolationLevel);
        } else {
            this.defaultTransactionIsolation = defaultIsolationLevel;
        }
    }

    public String getDefaultIsolation() {
        return FBTpbMapper.getTransactionIsolationName(this.getDefaultTransactionIsolation());
    }

    public void setDefaultIsolation(String isolation) {
        this.setDefaultTransactionIsolation(FBTpbMapper.getTransactionIsolationLevel(isolation));
    }

    public TransactionParameterBuffer getTransactionParameters(int isolation) {
        if (this.mapper != null) {
            return this.mapper.getMapping(isolation);
        }
        return (TransactionParameterBuffer)this.customMapping.get(new Integer(isolation));
    }

    public void setTransactionParameters(int isolation, TransactionParameterBuffer tpb) {
        if (this.mapper != null) {
            this.mapper.setMapping(isolation, tpb);
        } else {
            this.customMapping.put(new Integer(isolation), tpb);
        }
    }

    public FBTpbMapper getMapper() throws FBResourceException {
        if (this.mapper != null) {
            return this.mapper;
        }
        GDSType gdsType = GDSType.getType(this.type);
        if (gdsType == null && this.type != null) {
            throw new IllegalArgumentException("Unknown GDS type " + this.type);
        }
        GDS gds = gdsType != null ? GDSFactory.getGDSForType(gdsType) : GDSFactory.getDefaultGDS();
        this.mapper = this.tpbMapping == null ? FBTpbMapper.getDefaultMapper(gds) : new FBTpbMapper(gds, this.tpbMapping, this.getClass().getClassLoader());
        this.mapper.setDefaultTransactionIsolation(this.defaultTransactionIsolation);
        for (Map.Entry entry : this.customMapping.entrySet()) {
            Integer isolation = (Integer)entry.getKey();
            TransactionParameterBuffer tpb = (TransactionParameterBuffer)entry.getValue();
            this.mapper.setMapping(isolation, tpb);
        }
        return this.mapper;
    }
}

