/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.gds.impl.AbstractIscStmtHandle;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBFetcher;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FBFlushableField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

class FBCachedFetcher
implements FBFetcher {
    private boolean forwardOnly;
    private Object[] rowsArray;
    private int rowNum = 0;
    private int fetchSize;
    private FBObjectListener.FetcherListener fetcherListener;

    FBCachedFetcher(GDSHelper gdsHelper, int fetchSize, int maxRows, AbstractIscStmtHandle stmt_handle, FBObjectListener.FetcherListener fetcherListener, boolean forwardOnly) throws SQLException {
        this.fetcherListener = fetcherListener;
        this.forwardOnly = forwardOnly;
        ArrayList<byte[][][]> rowsSets = new ArrayList<byte[][][]>(100);
        AbstractIscStmtHandle stmt = stmt_handle;
        byte[][] localRow = null;
        XSQLVAR[] xsqlvars = stmt_handle.getOutSqlda().sqlvar;
        boolean[] isBlob = new boolean[xsqlvars.length];
        boolean hasBlobs = false;
        for (int i2 = 0; i2 < xsqlvars.length; ++i2) {
            boolean bl2 = isBlob[i2] = FBField.isType(xsqlvars[i2], 2004) || FBField.isType(xsqlvars[i2], -2) || FBField.isType(xsqlvars[i2], -1);
            if (!isBlob[i2]) continue;
            hasBlobs = true;
        }
        int rowsCount = 0;
        try {
            if (fetchSize == 0) {
                fetchSize = 400;
            }
            this.fetchSize = fetchSize;
            if (!stmt.isAllRowsFetched() && stmt.size() == 0) {
                do {
                    if (maxRows != 0 && fetchSize > maxRows - stmt.size()) {
                        fetchSize = maxRows - stmt.size();
                    }
                    gdsHelper.fetch(stmt, fetchSize);
                    if (stmt.size() <= 0) continue;
                    rowsSets.add(stmt.getRows());
                    rowsCount += stmt.size();
                    stmt.removeRows();
                } while (!stmt.isAllRowsFetched() && (maxRows == 0 || rowsCount < maxRows));
                int rowCount = 0;
                this.rowsArray = new Object[rowsCount];
                for (int i3 = 0; i3 < rowsSets.size(); ++i3) {
                    Object[] oneSet = (Object[])rowsSets.get(i3);
                    if (oneSet.length > rowsCount - rowCount) {
                        System.arraycopy(oneSet, 0, this.rowsArray, rowCount, rowsCount - rowCount);
                        rowCount = rowsCount;
                        continue;
                    }
                    System.arraycopy(oneSet, 0, this.rowsArray, rowCount, oneSet.length);
                    rowCount += oneSet.length;
                }
                rowsSets.clear();
            } else {
                this.rowsArray = (Object[])stmt.getRows();
                stmt.removeRows();
            }
            if (hasBlobs) {
                for (int i4 = 0; i4 < this.rowsArray.length; ++i4) {
                    localRow = (byte[][])this.rowsArray[i4];
                    for (int j2 = 0; j2 < localRow.length; ++j2) {
                        if (!isBlob[j2] || localRow[j2] == null) continue;
                        final byte[] tempData = localRow[j2];
                        FieldDataProvider dataProvider = new FieldDataProvider(){

                            public byte[] getFieldData() {
                                return tempData;
                            }

                            public void setFieldData(byte[] data) {
                                throw new UnsupportedOperationException();
                            }
                        };
                        FBField localField = FBField.createField(xsqlvars[j2], dataProvider, gdsHelper, false);
                        FBFlushableField blob = (FBFlushableField)((Object)localField);
                        localRow[j2] = blob.getCachedObject();
                    }
                }
            }
            gdsHelper.closeStatement(stmt, false);
        }
        catch (GDSException ge) {
            throw new FBSQLException(ge);
        }
    }

    FBCachedFetcher(ArrayList rows, FBObjectListener.FetcherListener fetcherListener) throws SQLException {
        this.rowsArray = rows.toArray();
        this.fetcherListener = fetcherListener;
    }

    public boolean next() throws SQLException {
        if (this.isEmpty()) {
            return false;
        }
        ++this.rowNum;
        if (this.isAfterLast()) {
            this.fetcherListener.rowChanged(this, null);
            this.rowNum = this.rowsArray.length + 1;
            return false;
        }
        this.fetcherListener.rowChanged(this, (byte[][])this.rowsArray[this.rowNum - 1]);
        return true;
    }

    public boolean previous() throws SQLException {
        if (this.forwardOnly) {
            throw new FBDriverNotCapableException("Result set is TYPE_FORWARD_ONLY");
        }
        if (this.isEmpty()) {
            return false;
        }
        --this.rowNum;
        if (this.isBeforeFirst()) {
            this.fetcherListener.rowChanged(this, null);
            this.rowNum = 0;
            return false;
        }
        this.fetcherListener.rowChanged(this, (byte[][])this.rowsArray[this.rowNum - 1]);
        return true;
    }

    public boolean absolute(int row) throws SQLException {
        if (this.forwardOnly) {
            throw new FBDriverNotCapableException("Result set is TYPE_FORWARD_ONLY");
        }
        return this.absolute(row, false);
    }

    private boolean absolute(int row, boolean internal) throws SQLException {
        if (this.forwardOnly && !internal) {
            throw new FBDriverNotCapableException("Result set is TYPE_FORWARD_ONLY");
        }
        if (row < 0) {
            row = this.rowsArray.length + row + 1;
        }
        if (row == 0 && !internal) {
            throw new FBSQLException("You cannot position to the row 0 with absolute() method.");
        }
        if (this.isEmpty()) {
            return false;
        }
        this.rowNum = row;
        if (this.isBeforeFirst()) {
            this.fetcherListener.rowChanged(this, null);
            this.rowNum = 0;
            return false;
        }
        if (this.isAfterLast()) {
            this.fetcherListener.rowChanged(this, null);
            this.rowNum = this.rowsArray.length + 1;
            return false;
        }
        this.fetcherListener.rowChanged(this, (byte[][])this.rowsArray[this.rowNum - 1]);
        return true;
    }

    public boolean first() throws SQLException {
        if (this.forwardOnly) {
            throw new FBDriverNotCapableException("Result set is TYPE_FORWARD_ONLY");
        }
        return this.absolute(1, true);
    }

    public boolean last() throws SQLException {
        if (this.forwardOnly) {
            throw new FBDriverNotCapableException("Result set is TYPE_FORWARD_ONLY");
        }
        return this.absolute(-1, true);
    }

    public boolean relative(int row) throws SQLException {
        if (this.forwardOnly) {
            throw new FBDriverNotCapableException("Result set is TYPE_FORWARD_ONLY");
        }
        return this.absolute(this.rowNum + row, true);
    }

    public void beforeFirst() throws SQLException {
        this.first();
        this.previous();
    }

    public void afterLast() throws SQLException {
        this.last();
        this.next();
    }

    public void close() throws SQLException {
    }

    public int getRowNum() {
        return this.rowNum;
    }

    public boolean isEmpty() {
        return this.rowsArray == null || this.rowsArray.length == 0;
    }

    public boolean isBeforeFirst() {
        return !this.isEmpty() && this.rowNum < 1;
    }

    public boolean isFirst() {
        return this.rowNum == 1;
    }

    public boolean isLast() {
        return this.rowsArray != null ? this.rowNum == this.rowsArray.length : false;
    }

    public boolean isAfterLast() {
        return this.rowNum > this.rowsArray.length;
    }

    public void deleteRow() throws SQLException {
        Object[] newRows = new Object[this.rowsArray.length - 1];
        System.arraycopy(this.rowsArray, 0, newRows, 0, this.rowNum - 1);
        if (this.rowNum < this.rowsArray.length) {
            System.arraycopy(this.rowsArray, this.rowNum, newRows, this.rowNum - 1, this.rowsArray.length - this.rowNum);
        }
        this.rowsArray = newRows;
        if (this.isAfterLast()) {
            this.fetcherListener.rowChanged(this, null);
        } else if (this.isBeforeFirst()) {
            this.fetcherListener.rowChanged(this, null);
        } else {
            this.fetcherListener.rowChanged(this, (byte[][])this.rowsArray[this.rowNum - 1]);
        }
    }

    public void insertRow(byte[][] data) throws SQLException {
        Object[] newRows = new Object[this.rowsArray.length + 1];
        if (this.rowNum == 0) {
            ++this.rowNum;
        }
        System.arraycopy(this.rowsArray, 0, newRows, 0, this.rowNum - 1);
        System.arraycopy(this.rowsArray, this.rowNum - 1, newRows, this.rowNum, this.rowsArray.length - this.rowNum + 1);
        newRows[this.rowNum - 1] = data;
        this.rowsArray = newRows;
        if (this.isAfterLast()) {
            this.fetcherListener.rowChanged(this, null);
        } else if (this.isBeforeFirst()) {
            this.fetcherListener.rowChanged(this, null);
        } else {
            this.fetcherListener.rowChanged(this, (byte[][])this.rowsArray[this.rowNum - 1]);
        }
    }

    public void updateRow(byte[][] data) throws SQLException {
        if (!this.isAfterLast() && !this.isBeforeFirst()) {
            this.rowsArray[this.rowNum - 1] = data;
            this.fetcherListener.rowChanged(this, data);
        }
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }
}

