/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.IscBlobHandle;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdBlob;

public class FBBlobInputStream
extends InputStream
implements FirebirdBlob.BlobInputStream {
    private byte[] buffer = null;
    private IscBlobHandle blobHandle;
    private int pos = 0;
    private boolean closed;
    private FBBlob owner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FBBlobInputStream(FBBlob owner) throws SQLException {
        Object syncObject;
        this.owner = owner;
        this.closed = false;
        if (owner.isNew) {
            throw new FBSQLException("You can't read a new blob");
        }
        Object object = syncObject = owner.getSynchronizationObject();
        synchronized (object) {
            try {
                this.blobHandle = owner.gdsHelper.openBlob(owner.blob_id, true);
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
        }
    }

    @Override
    public FirebirdBlob getBlob() {
        return this.owner;
    }

    @Override
    public void seek(int position) throws IOException {
        this.seek(position, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seek(int position, int seekMode) throws IOException {
        Object syncObject;
        Object object = syncObject = this.owner.getSynchronizationObject();
        synchronized (object) {
            this.checkClosed();
            try {
                this.owner.gdsHelper.seekBlob(this.blobHandle, position, seekMode);
            }
            catch (GDSException ex) {
                throw new IOException(ex.getMessage());
            }
        }
    }

    @Override
    public long length() throws IOException {
        Object syncObject;
        Object object = syncObject = this.owner.getSynchronizationObject();
        synchronized (object) {
            this.checkClosed();
            try {
                byte[] info = this.owner.gdsHelper.getBlobInfo(this.blobHandle, new byte[]{6}, 20);
                return this.owner.interpretLength(info, 0);
            }
            catch (GDSException ex) {
                throw new IOException(ex.getMessage());
            }
            catch (SQLException ex) {
                throw new IOException(ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        Object syncObject;
        Object object = syncObject = this.owner.getSynchronizationObject();
        synchronized (object) {
            this.checkClosed();
            if (this.buffer == null) {
                if (this.blobHandle.isEof()) {
                    return -1;
                }
                try {
                    this.buffer = this.owner.gdsHelper.getBlobSegment(this.blobHandle, this.owner.bufferlength);
                }
                catch (GDSException ge) {
                    throw new IOException("Blob read problem: " + ge.toString());
                }
                this.pos = 0;
                if (this.buffer.length == 0) {
                    return -1;
                }
            }
            return this.buffer.length - this.pos;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.available() <= 0) {
            return -1;
        }
        int result = this.buffer[this.pos++] & 0xFF;
        if (this.pos == this.buffer.length) {
            this.buffer = null;
        }
        return result;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int result = this.available();
        if (result <= 0) {
            return -1;
        }
        if (result > len) {
            System.arraycopy(this.buffer, this.pos, b2, off, len);
            this.pos += len;
            return len;
        }
        System.arraycopy(this.buffer, this.pos, b2, off, result);
        this.buffer = null;
        this.pos = 0;
        return result;
    }

    @Override
    public void readFully(byte[] b2, int off, int len) throws IOException {
        int counter = 0;
        int pos = 0;
        byte[] buffer = new byte[Math.min(32768, len)];
        for (int toRead = len; toRead > 0 && (counter = this.read(buffer, 0, toRead)) != -1; toRead -= counter) {
            System.arraycopy(buffer, 0, b2, pos, counter);
            pos += counter;
        }
        if (counter == -1) {
            throw new EOFException();
        }
    }

    @Override
    public void readFully(byte[] b2) throws IOException {
        this.readFully(b2, 0, b2.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object syncObject;
        Object object = syncObject = this.owner.getSynchronizationObject();
        synchronized (object) {
            if (this.blobHandle != null) {
                try {
                    this.owner.gdsHelper.closeBlob(this.blobHandle);
                    this.owner.inputStreams.remove(this);
                }
                catch (GDSException ge) {
                    throw new IOException("couldn't close blob: " + ge);
                }
                this.blobHandle = null;
                this.closed = true;
            }
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Input stream is already closed.");
        }
    }
}

