/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.XSQLDA;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBMissingParameterException;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBResultSetMetaData;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FBStatement;
import org.firebirdsql.jdbc.FirebirdPreparedStatement;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FBFlushableField;
import org.firebirdsql.jdbc.field.FBWorkaroundStringField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

public abstract class AbstractPreparedStatement
extends FBStatement
implements FirebirdPreparedStatement {
    private boolean metaDataQuery;
    protected boolean[] isParamSet;
    private FBField[] fields = null;
    private boolean isExecuteProcedureStatement;
    private boolean trimStrings;
    private FBObjectListener.BlobListener blobListener;
    private LinkedList batchList = new LinkedList();

    protected AbstractPreparedStatement(GDSHelper c2, int rsType, int rsConcurrency, int rsHoldability, FBObjectListener.StatementListener statementListener, FBObjectListener.BlobListener blobListener) throws SQLException {
        super(c2, rsType, rsConcurrency, rsHoldability, statementListener);
        this.blobListener = blobListener;
    }

    protected AbstractPreparedStatement(GDSHelper c2, String sql, int rsType, int rsConcurrency, int rsHoldability, FBObjectListener.StatementListener statementListener, FBObjectListener.BlobListener blobListener, boolean metaDataQuery) throws SQLException {
        super(c2, rsType, rsConcurrency, rsHoldability, statementListener);
        this.blobListener = blobListener;
        this.metaDataQuery = metaDataQuery;
        this.notifyStatementStarted();
        try {
            this.prepareFixedStatement(sql, true);
        }
        catch (GDSException ge) {
            throw new FBSQLException(ge);
        }
    }

    public void completeStatement() throws SQLException {
        if (!this.metaDataQuery) {
            this.closeResultSet(false);
        }
        if (!this.completed) {
            this.notifyStatementCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery() throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            this.notifyStatementStarted();
            if (!this.internalExecute(this.isExecuteProcedureStatement)) {
                throw new FBSQLException("No resultset for sql", "07005");
            }
            return this.getResultSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            int n2;
            this.notifyStatementStarted();
            try {
                if (this.internalExecute(this.isExecuteProcedureStatement)) {
                    throw new FBSQLException("Update statement returned results.");
                }
                n2 = this.getUpdateCount();
            }
            catch (Throwable throwable) {
                this.notifyStatementCompleted();
                throw throwable;
            }
            this.notifyStatementCompleted();
            return n2;
        }
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.getField(parameterIndex).setNull();
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setBinaryStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        this.getField(parameterIndex).setBinaryStream(inputStream, length);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setBytes(int parameterIndex, byte[] x2) throws SQLException {
        this.getField(parameterIndex).setBytes(x2);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setBoolean(int parameterIndex, boolean x2) throws SQLException {
        this.getField(parameterIndex).setBoolean(x2);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setByte(int parameterIndex, byte x2) throws SQLException {
        this.getField(parameterIndex).setByte(x2);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setDate(int parameterIndex, Date x2) throws SQLException {
        this.getField(parameterIndex).setDate(x2);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setDouble(int parameterIndex, double x2) throws SQLException {
        this.getField(parameterIndex).setDouble(x2);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setFloat(int parameterIndex, float x2) throws SQLException {
        this.getField(parameterIndex).setFloat(x2);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setInt(int parameterIndex, int x2) throws SQLException {
        this.getField(parameterIndex).setInteger(x2);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setLong(int parameterIndex, long x2) throws SQLException {
        this.getField(parameterIndex).setLong(x2);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setObject(int parameterIndex, Object x2) throws SQLException {
        this.getField(parameterIndex).setObject(x2);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setShort(int parameterIndex, short x2) throws SQLException {
        this.getField(parameterIndex).setShort(x2);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setString(int parameterIndex, String x2) throws SQLException {
        this.getField(parameterIndex).setString(x2);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setStringForced(int parameterIndex, String x2) throws SQLException {
        FBField field = this.getField(parameterIndex);
        if (field instanceof FBWorkaroundStringField) {
            ((FBWorkaroundStringField)field).setStringForced(x2);
        } else {
            field.setString(x2);
        }
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setTime(int parameterIndex, Time x2) throws SQLException {
        this.getField(parameterIndex).setTime(x2);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setTimestamp(int parameterIndex, Timestamp x2) throws SQLException {
        this.getField(parameterIndex).setTimestamp(x2);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x2) throws SQLException {
        this.getField(parameterIndex).setBigDecimal(x2);
        this.isParamSet[parameterIndex - 1] = true;
    }

    protected XSQLVAR getXsqlvar(int columnIndex) {
        return this.fixedStmt.getInSqlda().sqlvar[columnIndex - 1];
    }

    protected FBField getField(int columnIndex) throws SQLException {
        if (columnIndex > this.fields.length) {
            throw new FBSQLException("Invalid column index.", "HY002");
        }
        return this.fields[columnIndex - 1];
    }

    public void setAsciiStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x2, length);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setUnicodeStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x2, length);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void clearParameters() throws SQLException {
        if (this.isParamSet == null) {
            return;
        }
        for (int i2 = 0; i2 < this.isParamSet.length; ++i2) {
            this.isParamSet[i2] = false;
        }
        XSQLVAR[] xsqlvar = this.fixedStmt.getInSqlda().sqlvar;
        for (int i3 = 0; i3 < xsqlvar.length; ++i3) {
            xsqlvar[i3].sqldata = null;
        }
    }

    public void setObject(int parameterIndex, Object x2, int targetSqlType, int scale) throws SQLException {
        this.setObject(parameterIndex, x2);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setObject(int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x2);
        this.isParamSet[parameterIndex - 1] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            this.notifyStatementStarted();
            boolean hasResultSet = this.internalExecute(this.isExecuteProcedureStatement);
            if (!hasResultSet) {
                this.notifyStatementCompleted();
            }
            return hasResultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultSet executeMetaDataQuery() throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            this.notifyStatementStarted();
            boolean hasResultSet = this.internalExecute(this.isExecuteProcedureStatement);
            if (!hasResultSet) {
                throw new FBSQLException("No result set is available.");
            }
            return this.getResultSet(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean internalExecute(boolean sendOutParams) throws SQLException {
        Object syncObject;
        boolean canExecute = true;
        for (int i2 = 0; i2 < this.isParamSet.length; ++i2) {
            canExecute = canExecute && this.isParamSet[i2];
        }
        if (!canExecute) {
            throw new FBMissingParameterException("Not all parameters were set.", this.isParamSet);
        }
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            this.flushFields();
            try {
                this.gdsHelper.executeStatement(this.fixedStmt, sendOutParams);
                this.isResultSet = this.fixedStmt.getOutSqlda().sqld > 0;
                boolean bl2 = this.fixedStmt.getOutSqlda().sqld > 0;
                return bl2;
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
            finally {
                this.hasMoreResults = true;
            }
        }
    }

    private void flushFields() throws SQLException {
        for (int i2 = 0; i2 < this.isParamSet.length; ++i2) {
            FBField field = this.getField(i2 + 1);
            if (!(field instanceof FBFlushableField)) continue;
            ((FBFlushableField)((Object)field)).flushCachedData();
        }
    }

    public void addBatch() throws SQLException {
        boolean allParamsSet = true;
        for (int i2 = 0; i2 < this.isParamSet.length; ++i2) {
            allParamsSet &= this.isParamSet[i2];
        }
        if (!allParamsSet) {
            throw new FBSQLException("Not all parameters set.");
        }
        XSQLVAR[] oldXsqlvar = this.fixedStmt.getInSqlda().sqlvar;
        XSQLVAR[] newXsqlvar = new XSQLVAR[oldXsqlvar.length];
        for (int i3 = 0; i3 < newXsqlvar.length; ++i3) {
            newXsqlvar[i3] = oldXsqlvar[i3].deepCopy();
        }
        this.batchList.add(newXsqlvar);
    }

    public void clearBatch() throws SQLException {
        this.batchList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            boolean commit = false;
            try {
                int[] nArray;
                this.notifyStatementStarted();
                ArrayList<Integer> results = new ArrayList<Integer>(this.batchList.size());
                Iterator iter = this.batchList.iterator();
                try {
                    while (iter.hasNext()) {
                        XSQLVAR[] data = (XSQLVAR[])iter.next();
                        XSQLVAR[] vars = this.fixedStmt.getInSqlda().sqlvar;
                        for (int i2 = 0; i2 < vars.length; ++i2) {
                            vars[i2].copyFrom(data[i2]);
                            this.isParamSet[i2] = true;
                        }
                        try {
                            if (this.internalExecute(this.isExecuteProcedureStatement)) {
                                throw new BatchUpdateException(this.toArray(results));
                            }
                            int updateCount = this.getUpdateCount();
                            results.add(new Integer(updateCount));
                        }
                        catch (SQLException ex) {
                            throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), this.toArray(results));
                        }
                    }
                    commit = true;
                    nArray = this.toArray(results);
                }
                catch (Throwable throwable) {
                    this.clearBatch();
                    throw throwable;
                }
                this.clearBatch();
                return nArray;
            }
            finally {
                this.notifyStatementCompleted(commit);
            }
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.getField(parameterIndex).setCharacterStream(reader, length);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setRef(int i2, Ref x2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void setBlob(int parameterIndex, Blob blob) throws SQLException {
        if (!(blob instanceof FBBlob)) {
            FBBlob fbb = new FBBlob(this.gdsHelper, this.blobListener);
            fbb.copyStream(blob.getBinaryStream());
            blob = fbb;
        }
        this.getField(parameterIndex).setBlob((FBBlob)blob);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setClob(int i2, Clob x2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public void setArray(int i2, Array x2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new FBResultSetMetaData(this.fixedStmt.getOutSqlda().sqlvar, this.gdsHelper);
    }

    public void setDate(int parameterIndex, Date x2, Calendar cal) throws SQLException {
        this.getField(parameterIndex).setDate(x2, cal);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setTime(int parameterIndex, Time x2, Calendar cal) throws SQLException {
        this.getField(parameterIndex).setTime(x2, cal);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setTimestamp(int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        this.getField(parameterIndex).setTimestamp(x2, cal);
        this.isParamSet[parameterIndex - 1] = true;
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
        this.isParamSet[parameterIndex - 1] = true;
    }

    protected void prepareFixedStatement(String sql, boolean describeBind) throws GDSException, SQLException {
        super.prepareFixedStatement(sql, describeBind);
        XSQLDA inSqlda = this.fixedStmt.getInSqlda();
        if (!describeBind && inSqlda == null) {
            inSqlda = new XSQLDA();
            inSqlda.sqln = 0;
            inSqlda.sqlvar = new XSQLVAR[0];
        }
        this.isParamSet = new boolean[inSqlda.sqln];
        this.fields = new FBField[inSqlda.sqln];
        for (int i2 = 0; i2 < this.isParamSet.length; ++i2) {
            this.isParamSet[i2] = false;
            final int fieldPos = i2;
            FieldDataProvider dataProvider = new FieldDataProvider(){

                public byte[] getFieldData() {
                    return AbstractPreparedStatement.this.getXsqlvar((int)(fieldPos + 1)).sqldata;
                }

                public void setFieldData(byte[] data) {
                    AbstractPreparedStatement.this.getXsqlvar((int)(fieldPos + 1)).sqldata = data;
                }
            };
            this.fields[i2] = FBField.createField(this.getXsqlvar(i2 + 1), dataProvider, this.gdsHelper, false);
            if (!(this.fields[i2] instanceof FBWorkaroundStringField)) continue;
            ((FBWorkaroundStringField)this.fields[i2]).setTrimString(this.trimStrings);
        }
        this.isExecuteProcedureStatement = this.isExecuteProcedureStatement(sql);
    }

    public String getExecutionPlan() throws FBSQLException {
        return super.getExecutionPlan();
    }

    public int getStatementType() throws FBSQLException {
        return super.getStatementType();
    }
}

