/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version10;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.SQLWarning;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.StatementState;
import org.firebirdsql.gds.ng.StatementType;
import org.firebirdsql.gds.ng.TransactionHelper;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.fields.BlrCalculator;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.fields.FieldValue;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.wire.AbstractFbWireStatement;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireStatement;
import org.firebirdsql.gds.ng.wire.FetchResponse;
import org.firebirdsql.gds.ng.wire.GenericResponse;
import org.firebirdsql.gds.ng.wire.Response;
import org.firebirdsql.gds.ng.wire.SqlResponse;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class V10Statement
extends AbstractFbWireStatement
implements FbWireStatement {
    private static final int NULL_INDICATOR_NOT_NULL = 0;
    private static final int NULL_INDICATOR_NULL = -1;
    private static final Logger log = LoggerFactory.getLogger(V10Statement.class);

    public V10Statement(FbWireDatabase database) {
        super(database);
    }

    @Override
    public byte[] getSqlInfo(byte[] requestItems, int bufferLength) throws SQLException {
        try {
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                this.checkStatementValid();
                try {
                    this.sendInfoSql(requestItems, bufferLength);
                    this.getXdrOut().flush();
                }
                catch (IOException ex) {
                    this.switchState(StatementState.ERROR);
                    throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
                }
                try {
                    return this.processInfoSqlResponse(this.getDatabase().readGenericResponse(this.getStatementWarningCallback()));
                }
                catch (IOException ex) {
                    this.switchState(StatementState.ERROR);
                    throw new FbExceptionBuilder().exception(335544726).cause(ex).toSQLException();
                }
            }
        }
        catch (SQLException e2) {
            this.exceptionListenerDispatcher.errorOccurred(e2);
            throw e2;
        }
    }

    protected void sendInfoSql(byte[] requestItems, int bufferLength) throws IOException, SQLException {
        XdrOutputStream xdrOut = this.getXdrOut();
        xdrOut.writeInt(70);
        xdrOut.writeInt(this.getHandle());
        xdrOut.writeInt(0);
        xdrOut.writeBuffer(requestItems);
        xdrOut.writeInt(bufferLength);
    }

    protected byte[] processInfoSqlResponse(GenericResponse response) {
        return response.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void free(int option) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            try {
                this.doFreePacket(option);
                this.getXdrOut().flush();
            }
            catch (IOException ex) {
                this.switchState(StatementState.ERROR);
                throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
            }
            try {
                this.processFreeResponse(this.getDatabase().readResponse(this.getStatementWarningCallback()));
            }
            catch (IOException ex) {
                this.switchState(StatementState.ERROR);
                throw new FbExceptionBuilder().exception(335544726).cause(ex).toSQLException();
            }
        }
    }

    protected void doFreePacket(int option) throws SQLException, IOException {
        this.sendFree(option);
        this.reset(option == 2);
    }

    protected void sendFree(int option) throws IOException, SQLException {
        XdrOutputStream xdrOut = this.getXdrOut();
        xdrOut.writeInt(67);
        xdrOut.writeInt(this.getHandle());
        xdrOut.writeInt(option);
    }

    protected void processFreeResponse(Response response) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(String statementText) throws SQLException {
        try {
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                TransactionHelper.checkTransactionActive(this.getTransaction());
                StatementState currentState = this.getState();
                if (!this.isPrepareAllowed(currentState)) {
                    throw new SQLNonTransientException(String.format("Current statement state (%s) does not allow call to prepare", new Object[]{currentState}));
                }
                this.resetAll();
                FbWireDatabase db = this.getDatabase();
                if (currentState == StatementState.NEW) {
                    try {
                        this.sendAllocate();
                        this.getXdrOut().flush();
                    }
                    catch (IOException ex) {
                        this.switchState(StatementState.ERROR);
                        throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
                    }
                    try {
                        this.processAllocateResponse(db.readGenericResponse(this.getStatementWarningCallback()));
                    }
                    catch (IOException ex) {
                        this.switchState(StatementState.ERROR);
                        throw new FbExceptionBuilder().exception(335544726).cause(ex).toSQLException();
                    }
                }
                this.checkStatementValid();
                try {
                    this.sendPrepare(statementText);
                    this.getXdrOut().flush();
                }
                catch (IOException ex) {
                    this.switchState(StatementState.ERROR);
                    throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
                }
                try {
                    this.processPrepareResponse(db.readGenericResponse(this.getStatementWarningCallback()));
                }
                catch (IOException ex) {
                    this.switchState(StatementState.ERROR);
                    throw new FbExceptionBuilder().exception(335544726).cause(ex).toSQLException();
                }
            }
        }
        catch (SQLException e2) {
            this.exceptionListenerDispatcher.errorOccurred(e2);
            throw e2;
        }
    }

    protected void sendPrepare(String statementText) throws SQLException, IOException {
        XdrOutputStream xdrOut = this.getXdrOut();
        xdrOut.writeInt(68);
        xdrOut.writeInt(this.getTransaction().getHandle());
        xdrOut.writeInt(this.getHandle());
        xdrOut.writeInt(this.getDatabase().getConnectionDialect());
        xdrOut.writeString(statementText, this.getDatabase().getEncoding());
        xdrOut.writeBuffer(this.getStatementInfoRequestItems());
        xdrOut.writeInt(this.getDefaultSqlInfoSize());
    }

    protected void processPrepareResponse(GenericResponse genericResponse) throws SQLException {
        this.parseStatementInfo(genericResponse.getData());
        this.switchState(StatementState.PREPARED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCursorName(String cursorName) throws SQLException {
        try {
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                this.checkStatementValid();
                try {
                    XdrOutputStream xdrOut = this.getXdrOut();
                    xdrOut.writeInt(69);
                    xdrOut.writeInt(this.getHandle());
                    xdrOut.writeString(cursorName + '\u0000', this.getDatabase().getEncoding());
                    xdrOut.writeInt(0);
                    xdrOut.flush();
                }
                catch (IOException ex) {
                    this.switchState(StatementState.ERROR);
                    throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
                }
                try {
                    this.getDatabase().readGenericResponse(this.getStatementWarningCallback());
                }
                catch (IOException ex) {
                    this.switchState(StatementState.ERROR);
                    throw new FbExceptionBuilder().exception(335544726).cause(ex).toSQLException();
                }
            }
        }
        catch (SQLException e2) {
            this.exceptionListenerDispatcher.errorOccurred(e2);
            throw e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(RowValue parameters) throws SQLException {
        StatementState initialState = this.getState();
        try {
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                this.checkStatementValid();
                TransactionHelper.checkTransactionActive(this.getTransaction());
                this.validateParameters(parameters);
                this.reset(false);
                this.switchState(StatementState.EXECUTING);
                StatementType statementType = this.getType();
                boolean hasSingletonResult = this.hasSingletonResult();
                int expectedResponseCount = 0;
                try {
                    if (hasSingletonResult) {
                        ++expectedResponseCount;
                    }
                    this.sendExecute(hasSingletonResult ? 76 : 63, parameters);
                    ++expectedResponseCount;
                    this.getXdrOut().flush();
                }
                catch (IOException ex) {
                    this.switchState(StatementState.ERROR);
                    throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
                }
                WarningMessageCallback statementWarningCallback = this.getStatementWarningCallback();
                try {
                    FbWireDatabase db = this.getDatabase();
                    try {
                        --expectedResponseCount;
                        Response response = db.readResponse(statementWarningCallback);
                        if (hasSingletonResult) {
                            this.statementListenerDispatcher.statementExecuted(this, false, true);
                            if (response instanceof SqlResponse) {
                                this.processExecuteSingletonResponse((SqlResponse)response);
                                --expectedResponseCount;
                                response = db.readResponse(statementWarningCallback);
                            } else {
                                expectedResponseCount = 0;
                                SQLWarning sqlWarning = new SQLWarning("Expected an SqlResponse, instead received a " + response.getClass().getName());
                                log.warn(sqlWarning.getMessage(), sqlWarning);
                                statementWarningCallback.processWarning(sqlWarning);
                            }
                            this.setAllRowsFetched(true);
                        } else {
                            this.statementListenerDispatcher.statementExecuted(this, this.hasFields(), false);
                        }
                        this.processExecuteResponse((GenericResponse)response);
                    }
                    finally {
                        db.consumePackets(expectedResponseCount, this.getStatementWarningCallback());
                    }
                    if (this.getState() != StatementState.ERROR) {
                        this.switchState(statementType.isTypeWithCursor() ? StatementState.CURSOR_OPEN : StatementState.PREPARED);
                    }
                }
                catch (IOException ex) {
                    this.switchState(StatementState.ERROR);
                    throw new FbExceptionBuilder().exception(335544726).cause(ex).toSQLException();
                }
            }
        }
        catch (SQLException e2) {
            if (this.getState() != StatementState.ERROR) {
                this.switchState(initialState);
            }
            this.exceptionListenerDispatcher.errorOccurred(e2);
            throw e2;
        }
    }

    protected void sendExecute(int operation, RowValue parameters) throws IOException, SQLException {
        assert (operation == 63 || operation == 76) : "Needs to be called with operation op_execute or op_execute2";
        XdrOutputStream xdrOut = this.getXdrOut();
        xdrOut.writeInt(operation);
        xdrOut.writeInt(this.getHandle());
        xdrOut.writeInt(this.getTransaction().getHandle());
        if (parameters != null && parameters.getCount() > 0) {
            RowDescriptor parameterDescriptor = this.getParameterDescriptor();
            xdrOut.writeBuffer(this.calculateBlr(parameterDescriptor, parameters));
            xdrOut.writeInt(0);
            xdrOut.writeInt(1);
            this.writeSqlData(parameterDescriptor, parameters);
        } else {
            xdrOut.writeBuffer(null);
            xdrOut.writeInt(0);
            xdrOut.writeInt(0);
        }
        if (operation == 76) {
            RowDescriptor fieldDescriptor = this.getFieldDescriptor();
            xdrOut.writeBuffer(fieldDescriptor != null && fieldDescriptor.getCount() > 0 ? this.calculateBlr(fieldDescriptor) : null);
            xdrOut.writeInt(0);
        }
    }

    protected void processExecuteSingletonResponse(SqlResponse sqlResponse) throws SQLException, IOException {
        if (sqlResponse.getCount() > 0) {
            this.queueRowData(this.readSqlData());
        }
    }

    protected void processExecuteResponse(GenericResponse genericResponse) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetchRows(int fetchSize) throws SQLException {
        try {
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                this.checkStatementValid();
                if (!this.getState().isCursorOpen()) {
                    throw new FbExceptionBuilder().exception(335544834).toSQLException();
                }
                if (this.isAllRowsFetched()) {
                    return;
                }
                try {
                    this.sendFetch(fetchSize);
                    this.getXdrOut().flush();
                }
                catch (IOException ex) {
                    this.switchState(StatementState.ERROR);
                    throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
                }
                try {
                    this.processFetchResponse();
                }
                catch (IOException ex) {
                    this.switchState(StatementState.ERROR);
                    throw new FbExceptionBuilder().exception(335544726).cause(ex).toSQLException();
                }
            }
        }
        catch (SQLException e2) {
            this.exceptionListenerDispatcher.errorOccurred(e2);
            throw e2;
        }
    }

    protected void processFetchResponse() throws IOException, SQLException {
        Response response;
        while (!this.isAllRowsFetched() && (response = this.getDatabase().readResponse(this.getStatementWarningCallback())) instanceof FetchResponse) {
            FetchResponse fetchResponse = (FetchResponse)response;
            if (fetchResponse.getCount() > 0 && fetchResponse.getStatus() == 0) {
                this.queueRowData(this.readSqlData());
                continue;
            }
            if (fetchResponse.getStatus() != 100) break;
            this.setAllRowsFetched(true);
        }
    }

    protected void sendFetch(int fetchSize) throws SQLException, IOException {
        XdrOutputStream xdrOut = this.getXdrOut();
        xdrOut.writeInt(65);
        xdrOut.writeInt(this.getHandle());
        xdrOut.writeBuffer(this.calculateBlr(this.getFieldDescriptor()));
        xdrOut.writeInt(0);
        xdrOut.writeInt(fetchSize);
    }

    protected RowValue readSqlData() throws SQLException, IOException {
        RowDescriptor rowDescriptor = this.getFieldDescriptor();
        RowValue rowValue = rowDescriptor.createDefaultFieldValues();
        BlrCalculator blrCalculator = this.getDatabase().getBlrCalculator();
        XdrInputStream xdrIn = this.getXdrIn();
        for (int idx = 0; idx < rowDescriptor.getCount(); ++idx) {
            FieldDescriptor fieldDescriptor = rowDescriptor.getFieldDescriptor(idx);
            FieldValue fieldValue = rowValue.getFieldValue(idx);
            int len = blrCalculator.calculateIoLength(fieldDescriptor);
            byte[] buffer = this.readColumnData(xdrIn, len);
            if (xdrIn.readInt() == -1) {
                buffer = null;
            }
            fieldValue.setFieldData(buffer);
        }
        return rowValue;
    }

    protected byte[] readColumnData(XdrInputStream xdrIn, int len) throws IOException {
        byte[] buffer;
        if (len == 0) {
            len = xdrIn.readInt();
            buffer = new byte[len];
            xdrIn.readFully(buffer, 0, len);
            xdrIn.skipPadding(len);
        } else if (len < 0) {
            buffer = new byte[-len];
            xdrIn.readFully(buffer, 0, -len);
        } else {
            buffer = new byte[--len];
            xdrIn.readFully(buffer, 0, len);
            xdrIn.skipPadding(len);
        }
        return buffer;
    }

    protected void writeSqlData(RowDescriptor rowDescriptor, RowValue fieldValues) throws IOException, SQLException {
        XdrOutputStream xdrOut = this.getXdrOut();
        BlrCalculator blrCalculator = this.getDatabase().getBlrCalculator();
        for (int idx = 0; idx < fieldValues.getCount(); ++idx) {
            FieldValue fieldValue = fieldValues.getFieldValue(idx);
            FieldDescriptor fieldDescriptor = rowDescriptor.getFieldDescriptor(idx);
            int len = blrCalculator.calculateIoLength(fieldDescriptor, fieldValue);
            byte[] buffer = fieldValue.getFieldData();
            int fieldType = fieldDescriptor.getType();
            this.writeColumnData(xdrOut, len, buffer, fieldType);
            xdrOut.writeInt(buffer != null ? 0 : -1);
        }
    }

    protected void writeColumnData(XdrOutputStream xdrOut, int len, byte[] buffer, int fieldType) throws IOException {
        int tempType = fieldType & 0xFFFFFFFE;
        if (tempType != 32766) {
            if (len == 0) {
                if (buffer != null) {
                    len = buffer.length;
                    xdrOut.writeInt(len);
                    xdrOut.write(buffer, 0, len, 4 - len & 3);
                } else {
                    xdrOut.writeInt(0);
                }
            } else if (len < 0) {
                if (buffer != null) {
                    xdrOut.write(buffer, 0, -len);
                } else {
                    xdrOut.writeZeroPadding(-len);
                }
            } else {
                --len;
                if (buffer != null) {
                    int buflen = buffer.length;
                    if (buflen >= len) {
                        xdrOut.write(buffer, 0, len, 4 - len & 3);
                    } else {
                        xdrOut.write(buffer, 0, buflen, 0);
                        xdrOut.writeSpacePadding(len - buflen + (4 - len & 3));
                    }
                } else {
                    xdrOut.writeSpacePadding(len + (4 - len & 3));
                }
            }
        }
    }

    protected void sendAllocate() throws SQLException, IOException {
        XdrOutputStream xdrOut = this.getXdrOut();
        xdrOut.writeInt(62);
        xdrOut.writeInt(this.getDatabase().getHandle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAllocateResponse(GenericResponse response) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.setHandle(response.getObjectHandle());
            this.setAllRowsFetched(false);
            this.switchState(StatementState.ALLOCATED);
            this.setType(StatementType.NONE);
        }
    }

    @Override
    public int getDefaultSqlInfoSize() {
        return this.getMaxSqlInfoSize();
    }

    @Override
    public int getMaxSqlInfoSize() {
        return Short.MAX_VALUE;
    }
}

