/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version10;

import java.io.IOException;
import java.sql.SQLException;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.ParameterBuffer;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.listeners.DatabaseListener;
import org.firebirdsql.gds.ng.wire.AbstractFbWireOutputBlob;
import org.firebirdsql.gds.ng.wire.FbWireBlob;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireTransaction;
import org.firebirdsql.gds.ng.wire.GenericResponse;

public class V10OutputBlob
extends AbstractFbWireOutputBlob
implements FbWireBlob,
DatabaseListener {
    public V10OutputBlob(FbWireDatabase database, FbWireTransaction transaction, BlobParameterBuffer blobParameterBuffer) {
        super(database, transaction, blobParameterBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws SQLException {
        try {
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                this.checkDatabaseAttached();
                this.checkTransactionActive();
                this.checkBlobClosed();
                if (this.getBlobId() != 0L) {
                    throw new FbExceptionBuilder().nonTransientException(335544368).toSQLException();
                }
                FbWireDatabase database = this.getDatabase();
                try {
                    XdrOutputStream xdrOut = database.getXdrStreamAccess().getXdrOut();
                    BlobParameterBuffer blobParameterBuffer = this.getBlobParameterBuffer();
                    if (blobParameterBuffer == null) {
                        xdrOut.writeInt(34);
                    } else {
                        xdrOut.writeInt(57);
                        xdrOut.writeTyped((ParameterBuffer)((Object)blobParameterBuffer));
                    }
                    xdrOut.writeInt(this.getTransaction().getHandle());
                    xdrOut.writeLong(0L);
                    xdrOut.flush();
                }
                catch (IOException e2) {
                    throw new FbExceptionBuilder().exception(335544727).cause(e2).toSQLException();
                }
                try {
                    GenericResponse genericResponse = database.readGenericResponse(null);
                    this.setHandle(genericResponse.getObjectHandle());
                    this.setBlobId(genericResponse.getBlobId());
                    this.setOpen(true);
                }
                catch (IOException e3) {
                    throw new FbExceptionBuilder().exception(335544726).cause(e3).toSQLException();
                }
            }
        }
        catch (SQLException e4) {
            this.exceptionListenerDispatcher.errorOccurred(e4);
            throw e4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putSegment(byte[] segment) throws SQLException {
        try {
            if (segment.length == 0) {
                throw new FbExceptionBuilder().exception(337248258).toSQLException();
            }
            if (segment.length > this.getMaximumSegmentSize()) {
                throw new FbExceptionBuilder().exception(337248259).toSQLException();
            }
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                this.checkDatabaseAttached();
                this.checkTransactionActive();
                this.checkBlobOpen();
                FbWireDatabase database = this.getDatabase();
                try {
                    XdrOutputStream xdrOut = database.getXdrStreamAccess().getXdrOut();
                    xdrOut.writeInt(37);
                    xdrOut.writeInt(this.getHandle());
                    xdrOut.writeInt(segment.length);
                    xdrOut.writeBuffer(segment);
                    xdrOut.flush();
                }
                catch (IOException e2) {
                    throw new FbExceptionBuilder().exception(335544727).cause(e2).toSQLException();
                }
                try {
                    database.readResponse(null);
                }
                catch (IOException e3) {
                    throw new FbExceptionBuilder().exception(335544726).cause(e3).toSQLException();
                }
            }
        }
        catch (SQLException e4) {
            this.exceptionListenerDispatcher.errorOccurred(e4);
            throw e4;
        }
    }
}

