/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version10;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.ParameterBuffer;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.FbBlob;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.listeners.DatabaseListener;
import org.firebirdsql.gds.ng.wire.AbstractFbWireInputBlob;
import org.firebirdsql.gds.ng.wire.FbWireBlob;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireTransaction;
import org.firebirdsql.gds.ng.wire.GenericResponse;

public class V10InputBlob
extends AbstractFbWireInputBlob
implements FbWireBlob,
DatabaseListener {
    public V10InputBlob(FbWireDatabase database, FbWireTransaction transaction, BlobParameterBuffer blobParameterBuffer, long blobId) {
        super(database, transaction, blobParameterBuffer, blobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws SQLException {
        try {
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                this.checkDatabaseAttached();
                this.checkTransactionActive();
                this.checkBlobClosed();
                FbWireDatabase database = this.getDatabase();
                try {
                    XdrOutputStream xdrOut = database.getXdrStreamAccess().getXdrOut();
                    BlobParameterBuffer blobParameterBuffer = this.getBlobParameterBuffer();
                    if (blobParameterBuffer == null) {
                        xdrOut.writeInt(35);
                    } else {
                        xdrOut.writeInt(56);
                        xdrOut.writeTyped((ParameterBuffer)((Object)blobParameterBuffer));
                    }
                    xdrOut.writeInt(this.getTransaction().getHandle());
                    xdrOut.writeLong(this.getBlobId());
                    xdrOut.flush();
                }
                catch (IOException e2) {
                    throw new FbExceptionBuilder().exception(335544727).cause(e2).toSQLException();
                }
                try {
                    GenericResponse genericResponse = database.readGenericResponse(null);
                    this.setHandle(genericResponse.getObjectHandle());
                    this.setOpen(true);
                    this.resetEof();
                }
                catch (IOException e3) {
                    throw new FbExceptionBuilder().exception(335544726).cause(e3).toSQLException();
                }
            }
        }
        catch (SQLException e4) {
            this.exceptionListenerDispatcher.errorOccurred(e4);
            throw e4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getSegment(int sizeRequested) throws SQLException {
        try {
            if (sizeRequested <= 0) {
                throw new FbExceptionBuilder().exception(337248257).messageParameter(sizeRequested).toSQLException();
            }
            int actualSize = 2 + Math.min(sizeRequested, this.getMaximumSegmentSize());
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                int segmentLength;
                GenericResponse response;
                this.checkDatabaseAttached();
                this.checkTransactionActive();
                this.checkBlobOpen();
                FbWireDatabase database = this.getDatabase();
                try {
                    XdrOutputStream xdrOut = database.getXdrStreamAccess().getXdrOut();
                    xdrOut.writeInt(36);
                    xdrOut.writeInt(this.getHandle());
                    xdrOut.writeInt(actualSize);
                    xdrOut.writeInt(0);
                    xdrOut.flush();
                }
                catch (IOException e2) {
                    throw new FbExceptionBuilder().exception(335544727).cause(e2).toSQLException();
                }
                try {
                    response = database.readGenericResponse(null);
                    if (response.getObjectHandle() == 2) {
                        this.setEof();
                    }
                }
                catch (IOException e3) {
                    throw new FbExceptionBuilder().exception(335544726).cause(e3).toSQLException();
                }
                byte[] responseBuffer = response.getData();
                if (responseBuffer.length == 0) {
                    return responseBuffer;
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream(actualSize);
                for (int position = 0; position < responseBuffer.length; position += segmentLength) {
                    segmentLength = VaxEncoding.iscVaxInteger2(responseBuffer, position);
                    bos.write(responseBuffer, position += 2, segmentLength);
                }
                return bos.toByteArray();
            }
        }
        catch (SQLException e4) {
            this.exceptionListenerDispatcher.errorOccurred(e4);
            throw e4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seek(int offset, FbBlob.SeekMode seekMode) throws SQLException {
        try {
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                this.checkDatabaseAttached();
                this.checkTransactionActive();
                FbWireDatabase database = this.getDatabase();
                try {
                    XdrOutputStream xdrOut = database.getXdrStreamAccess().getXdrOut();
                    xdrOut.writeInt(61);
                    xdrOut.writeInt(this.getHandle());
                    xdrOut.writeInt(seekMode.getSeekModeId());
                    xdrOut.writeInt(offset);
                    xdrOut.flush();
                }
                catch (IOException e2) {
                    throw new FbExceptionBuilder().exception(335544727).cause(e2).toSQLException();
                }
                try {
                    database.readResponse(null);
                }
                catch (IOException e3) {
                    throw new FbExceptionBuilder().exception(335544726).cause(e3).toSQLException();
                }
            }
        }
        catch (SQLException e4) {
            this.exceptionListenerDispatcher.errorOccurred(e4);
            throw e4;
        }
    }
}

