/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.crypt.arc4;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.wire.auth.ClientAuthBlock;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionIdentifier;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionInitInfo;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionPlugin;
import org.firebirdsql.gds.ng.wire.crypt.arc4.Arc4EncryptionPluginSpi;
import org.firebirdsql.util.SQLExceptionChainBuilder;

public final class Arc4EncryptionPlugin
implements EncryptionPlugin {
    private final ClientAuthBlock clientAuthBlock;

    public Arc4EncryptionPlugin(ClientAuthBlock clientAuthBlock) {
        this.clientAuthBlock = clientAuthBlock;
    }

    @Override
    public EncryptionIdentifier getEncryptionIdentifier() {
        return Arc4EncryptionPluginSpi.ARC4_ID;
    }

    @Override
    public EncryptionInitInfo initializeEncryption() {
        SQLExceptionChainBuilder<SQLException> chainBuilder = new SQLExceptionChainBuilder<SQLException>();
        byte[] key = this.getKey(chainBuilder);
        Cipher encryptionCipher = this.createEncryptionCipher(key, chainBuilder);
        Cipher decryptionCipher = this.createDecryptionCipher(key, chainBuilder);
        if (chainBuilder.hasException()) {
            return EncryptionInitInfo.failure(this.getEncryptionIdentifier(), chainBuilder.getException());
        }
        return EncryptionInitInfo.success(this.getEncryptionIdentifier(), encryptionCipher, decryptionCipher);
    }

    private byte[] getKey(SQLExceptionChainBuilder<SQLException> chainBuilder) {
        byte[] key = null;
        try {
            key = this.getKey(this.clientAuthBlock);
        }
        catch (SQLException e2) {
            chainBuilder.append(e2);
        }
        return key;
    }

    private Cipher createEncryptionCipher(byte[] key, SQLExceptionChainBuilder<SQLException> chainBuilder) {
        return this.createCipher(1, key, chainBuilder);
    }

    private Cipher createDecryptionCipher(byte[] key, SQLExceptionChainBuilder<SQLException> chainBuilder) {
        return this.createCipher(2, key, chainBuilder);
    }

    private byte[] getKey(ClientAuthBlock clientAuthBlock) throws SQLException {
        if (!clientAuthBlock.supportsEncryption()) {
            throw new FbExceptionBuilder().nonTransientException(337248280).messageParameter(this.getEncryptionIdentifier().toString()).toFlatSQLException();
        }
        return clientAuthBlock.getSessionKey();
    }

    private Cipher createCipher(int mode, byte[] key, SQLExceptionChainBuilder<SQLException> chainBuilder) {
        try {
            return this.createCipher(mode, key);
        }
        catch (SQLException e2) {
            chainBuilder.append(e2);
            return null;
        }
    }

    private Cipher createCipher(int mode, byte[] key) throws SQLException {
        try {
            Cipher rc4Cipher = Cipher.getInstance("ARCFOUR");
            SecretKeySpec rc4Key = new SecretKeySpec(key, "ARCFOUR");
            rc4Cipher.init(mode, rc4Key);
            return rc4Cipher;
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e2) {
            throw new FbExceptionBuilder().nonTransientException(337248281).messageParameter(this.getEncryptionIdentifier().toString()).cause(e2).toFlatSQLException();
        }
        catch (InvalidKeyException e3) {
            throw new FbExceptionBuilder().nonTransientException(337248282).messageParameter(this.getEncryptionIdentifier().toString()).cause(e3).toFlatSQLException();
        }
    }
}

