/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.listeners;

import java.sql.SQLWarning;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.SqlCountHolder;
import org.firebirdsql.gds.ng.StatementState;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.listeners.AbstractListenerDispatcher;
import org.firebirdsql.gds.ng.listeners.StatementListener;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public final class StatementListenerDispatcher
extends AbstractListenerDispatcher<StatementListener>
implements StatementListener {
    private static final Logger log = LoggerFactory.getLogger(StatementListenerDispatcher.class);

    @Override
    public void receivedRow(FbStatement sender, RowValue rowValue) {
        for (StatementListener listener : this) {
            try {
                listener.receivedRow(sender, rowValue);
            }
            catch (Exception e2) {
                log.error("Error on notify receivedRow to listener " + listener, e2);
            }
        }
    }

    @Override
    public void allRowsFetched(FbStatement sender) {
        for (StatementListener listener : this) {
            try {
                listener.allRowsFetched(sender);
            }
            catch (Exception e2) {
                log.error("Error on notify allRowsFetched to listener " + listener, e2);
            }
        }
    }

    @Override
    public void statementExecuted(FbStatement sender, boolean hasResultSet, boolean hasSingletonResult) {
        for (StatementListener listener : this) {
            try {
                listener.statementExecuted(sender, hasResultSet, hasSingletonResult);
            }
            catch (Exception e2) {
                log.error("Error on notify statementExecuted to listener " + listener, e2);
            }
        }
    }

    @Override
    public void statementStateChanged(FbStatement sender, StatementState newState, StatementState previousState) {
        for (StatementListener listener : this) {
            try {
                listener.statementStateChanged(sender, newState, previousState);
            }
            catch (Exception e2) {
                log.error("Error on notify statementStateChanged to listener " + listener, e2);
            }
        }
    }

    @Override
    public void warningReceived(FbStatement sender, SQLWarning warning) {
        for (StatementListener listener : this) {
            try {
                listener.warningReceived(sender, warning);
            }
            catch (Exception e2) {
                log.error("Error on notify warningReceived to listener " + listener, e2);
            }
        }
    }

    @Override
    public void sqlCounts(FbStatement sender, SqlCountHolder sqlCounts) {
        for (StatementListener listener : this) {
            try {
                listener.sqlCounts(sender, sqlCounts);
            }
            catch (Exception e2) {
                log.error("Error on notify sqlCounts to listener " + listener, e2);
            }
        }
    }
}

