/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.listeners;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.firebirdsql.gds.ng.listeners.ExceptionListener;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public final class ExceptionListenerDispatcher
implements Iterable<ExceptionListener>,
ExceptionListener {
    private static final Logger log = LoggerFactory.getLogger(ExceptionListenerDispatcher.class);
    private static final Object PRESENT = new Object();
    private final Map<ExceptionListener, Object> listeners = Collections.synchronizedMap(new WeakHashMap());
    private final Object source;
    private volatile boolean shutdown = false;

    public ExceptionListenerDispatcher(Object source) {
        this.source = source;
    }

    @Override
    public void errorOccurred(Object source, SQLException exception) {
        this.errorOccurred(exception);
    }

    public void errorOccurred(SQLException exception) {
        for (ExceptionListener listener : this) {
            try {
                listener.errorOccurred(this.source, exception);
            }
            catch (Exception e2) {
                log.error("Error on notify errorOccurred to listener " + listener, e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ExceptionListener listener) {
        if (listener == this) {
            throw new IllegalArgumentException("Adding this instance to itself is not allowed");
        }
        Map<ExceptionListener, Object> map = this.listeners;
        synchronized (map) {
            if (this.isShutdown()) {
                return;
            }
            this.listeners.put(listener, PRESENT);
        }
    }

    public void removeListener(ExceptionListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public void shutdown() {
        this.shutdown = true;
        this.removeAllListeners();
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ExceptionListener> iterator() {
        Map<ExceptionListener, Object> map = this.listeners;
        synchronized (map) {
            return new ArrayList<ExceptionListener>(this.listeners.keySet()).iterator();
        }
    }
}

