/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.listeners;

import java.sql.SQLWarning;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.listeners.AbstractListenerDispatcher;
import org.firebirdsql.gds.ng.listeners.DatabaseListener;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public final class DatabaseListenerDispatcher
extends AbstractListenerDispatcher<DatabaseListener>
implements DatabaseListener {
    private static final Logger log = LoggerFactory.getLogger(DatabaseListenerDispatcher.class);

    @Override
    public void detaching(FbDatabase database) {
        for (DatabaseListener listener : this) {
            try {
                listener.detaching(database);
            }
            catch (Exception e2) {
                log.error("Error on notify detaching to listener " + listener, e2);
            }
        }
    }

    @Override
    public void detached(FbDatabase database) {
        for (DatabaseListener listener : this) {
            try {
                listener.detached(database);
            }
            catch (Exception e2) {
                log.error("Error on notify detached to listener " + listener, e2);
            }
        }
    }

    @Override
    public void warningReceived(FbDatabase database, SQLWarning warning) {
        for (DatabaseListener listener : this) {
            try {
                listener.warningReceived(database, warning);
            }
            catch (Exception e2) {
                log.error("Error on notify warningReceived to listener " + listener, e2);
            }
        }
    }
}

