/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import com.sun.jna.Memory;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.ShortByReference;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import org.firebirdsql.gds.ng.AbstractFbStatement;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.StatementState;
import org.firebirdsql.gds.ng.StatementType;
import org.firebirdsql.gds.ng.TransactionHelper;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.fields.FieldValue;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.fields.RowValueBuilder;
import org.firebirdsql.gds.ng.jna.JnaDatabase;
import org.firebirdsql.gds.ng.jna.JnaTransaction;
import org.firebirdsql.jna.fbclient.FbClientLibrary;
import org.firebirdsql.jna.fbclient.ISC_STATUS;
import org.firebirdsql.jna.fbclient.XSQLDA;
import org.firebirdsql.jna.fbclient.XSQLVAR;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class JnaStatement
extends AbstractFbStatement {
    private static final Logger log = LoggerFactory.getLogger(JnaStatement.class);
    private final IntByReference handle = new IntByReference(0);
    private JnaDatabase database;
    private final ISC_STATUS[] statusVector = new ISC_STATUS[20];
    private final FbClientLibrary clientLibrary;
    private XSQLDA inXSqlDa;
    private XSQLDA outXSqlDa;

    public JnaStatement(JnaDatabase database) {
        super(database.getSynchronizationObject());
        this.database = database;
        this.clientLibrary = database.getClientLibrary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setParameterDescriptor(RowDescriptor parameterDescriptor) {
        XSQLDA xsqlda = this.allocateXSqlDa(parameterDescriptor);
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.inXSqlDa = xsqlda;
            super.setParameterDescriptor(parameterDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setFieldDescriptor(RowDescriptor fieldDescriptor) {
        XSQLDA xsqlda = this.allocateXSqlDa(fieldDescriptor);
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.outXSqlDa = xsqlda;
            super.setFieldDescriptor(fieldDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void free(int option) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.clientLibrary.isc_dsql_free_statement(this.statusVector, this.handle, (short)option);
            this.processStatusVector();
            this.reset(option == 2);
        }
    }

    @Override
    protected boolean isValidTransactionClass(Class<? extends FbTransaction> transactionClass) {
        return JnaTransaction.class.isAssignableFrom(transactionClass);
    }

    @Override
    public JnaDatabase getDatabase() {
        return this.database;
    }

    @Override
    public int getHandle() {
        return this.handle.getValue();
    }

    @Override
    public JnaTransaction getTransaction() {
        return (JnaTransaction)super.getTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(String statementText) throws SQLException {
        try {
            byte[] statementArray = this.getDatabase().getEncoding().encodeToCharset(statementText);
            if (statementArray.length > 65536) {
                throw FbExceptionBuilder.forException(337248275).messageParameter(65536).messageParameter(statementArray.length).toFlatSQLException();
            }
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                TransactionHelper.checkTransactionActive(this.getTransaction());
                StatementState currentState = this.getState();
                if (!this.isPrepareAllowed(currentState)) {
                    throw new SQLNonTransientException(String.format("Current statement state (%s) does not allow call to prepare", new Object[]{currentState}));
                }
                this.resetAll();
                JnaDatabase db = this.getDatabase();
                if (currentState == StatementState.NEW) {
                    this.clientLibrary.isc_dsql_allocate_statement(this.statusVector, db.getJnaHandle(), this.handle);
                    this.processStatusVector();
                    this.setAllRowsFetched(false);
                    this.switchState(StatementState.ALLOCATED);
                    this.setType(StatementType.NONE);
                } else {
                    this.checkStatementValid();
                }
                XSQLDA tempXSqlDa = new XSQLDA();
                tempXSqlDa.setAutoRead(false);
                this.clientLibrary.isc_dsql_prepare(this.statusVector, this.getTransaction().getJnaHandle(), this.handle, (short)statementArray.length, statementArray, db.getConnectionDialect(), tempXSqlDa);
                this.processStatusVector();
                byte[] statementInfoRequestItems = this.getStatementInfoRequestItems();
                int responseLength = this.getDefaultSqlInfoSize();
                byte[] statementInfo = this.getSqlInfo(statementInfoRequestItems, responseLength);
                this.parseStatementInfo(statementInfo);
                this.switchState(StatementState.PREPARED);
            }
        }
        catch (SQLException e2) {
            this.exceptionListenerDispatcher.errorOccurred(e2);
            throw e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(RowValue parameters) throws SQLException {
        StatementState initialState = this.getState();
        try {
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                this.checkStatementValid();
                TransactionHelper.checkTransactionActive(this.getTransaction());
                this.validateParameters(parameters);
                this.reset(false);
                this.switchState(StatementState.EXECUTING);
                this.setXSqlDaData(this.inXSqlDa, this.getParameterDescriptor(), parameters);
                StatementType statementType = this.getType();
                boolean hasSingletonResult = this.hasSingletonResult();
                if (hasSingletonResult) {
                    this.clientLibrary.isc_dsql_execute2(this.statusVector, this.getTransaction().getJnaHandle(), this.handle, this.inXSqlDa.version, this.inXSqlDa, this.outXSqlDa);
                } else {
                    this.clientLibrary.isc_dsql_execute(this.statusVector, this.getTransaction().getJnaHandle(), this.handle, this.inXSqlDa.version, this.inXSqlDa);
                }
                if (hasSingletonResult) {
                    this.statementListenerDispatcher.statementExecuted(this, false, true);
                    this.processStatusVector();
                    this.queueRowData(this.toRowValue(this.getFieldDescriptor(), this.outXSqlDa));
                    this.setAllRowsFetched(true);
                } else {
                    this.statementListenerDispatcher.statementExecuted(this, this.hasFields(), false);
                    this.processStatusVector();
                }
                if (this.getState() != StatementState.ERROR) {
                    this.switchState(statementType.isTypeWithCursor() ? StatementState.CURSOR_OPEN : StatementState.PREPARED);
                }
            }
        }
        catch (SQLException e2) {
            if (this.getState() != StatementState.ERROR) {
                this.switchState(initialState);
            }
            this.exceptionListenerDispatcher.errorOccurred(e2);
            throw e2;
        }
    }

    protected void setXSqlDaData(XSQLDA xSqlDa, RowDescriptor rowDescriptor, RowValue parameters) {
        for (int idx = 0; idx < parameters.getCount(); ++idx) {
            XSQLVAR xSqlVar = xSqlDa.sqlvar[idx];
            xSqlVar.getSqlData().clear();
            FieldValue value = parameters.getFieldValue(idx);
            byte[] fieldData = value.getFieldData();
            if (fieldData == null) {
                xSqlVar.sqlind.setValue((short)-1);
                continue;
            }
            xSqlVar.sqlind.setValue((short)0);
            FieldDescriptor fieldDescriptor = rowDescriptor.getFieldDescriptor(idx);
            int bufferOffset = 0;
            if (fieldDescriptor.isVarying()) {
                xSqlVar.sqllen = (short)Math.min(fieldDescriptor.getLength(), fieldData.length);
                xSqlVar.writeField("sqllen");
                xSqlVar.sqldata.setShort(0L, (short)fieldData.length);
                bufferOffset = 2;
            } else if (fieldDescriptor.isFbType(452)) {
                xSqlVar.sqllen = (short)Math.min(fieldDescriptor.getLength(), fieldData.length);
                xSqlVar.writeField("sqllen");
                if (fieldDescriptor.getSubType() != 1) {
                    xSqlVar.sqldata.setMemory(0L, (long)(xSqlVar.sqllen & 0xFF), (byte)32);
                }
            }
            xSqlVar.sqldata.write((long)bufferOffset, fieldData, 0, fieldData.length);
        }
    }

    protected XSQLDA allocateXSqlDa(RowDescriptor rowDescriptor) {
        if (rowDescriptor == null || rowDescriptor.getCount() == 0) {
            XSQLDA xSqlDa = new XSQLDA(1);
            xSqlDa.setAutoSynch(false);
            xSqlDa.sqln = 0;
            xSqlDa.sqld = 0;
            xSqlDa.write();
            return xSqlDa;
        }
        XSQLDA xSqlDa = new XSQLDA(rowDescriptor.getCount());
        xSqlDa.setAutoSynch(false);
        for (int idx = 0; idx < rowDescriptor.getCount(); ++idx) {
            FieldDescriptor fieldDescriptor = rowDescriptor.getFieldDescriptor(idx);
            XSQLVAR xSqlVar = xSqlDa.sqlvar[idx];
            this.populateXSqlVar(fieldDescriptor, xSqlVar);
        }
        xSqlDa.write();
        return xSqlDa;
    }

    private void populateXSqlVar(FieldDescriptor fieldDescriptor, XSQLVAR xSqlVar) {
        xSqlVar.setAutoSynch(false);
        xSqlVar.sqltype = (short)(fieldDescriptor.getType() | 1);
        xSqlVar.sqlsubtype = (short)fieldDescriptor.getSubType();
        xSqlVar.sqlscale = (short)fieldDescriptor.getScale();
        xSqlVar.sqllen = (short)fieldDescriptor.getLength();
        xSqlVar.sqlind = new ShortByReference();
        int requiredDataSize = fieldDescriptor.isVarying() ? fieldDescriptor.getLength() + 3 : fieldDescriptor.getLength() + 1;
        xSqlVar.sqldata = new Memory((long)requiredDataSize);
        xSqlVar.write();
    }

    protected RowValue toRowValue(RowDescriptor rowDescriptor, XSQLDA xSqlDa) {
        RowValueBuilder row = new RowValueBuilder(rowDescriptor);
        for (int idx = 0; idx < xSqlDa.sqlvar.length; ++idx) {
            XSQLVAR xSqlVar = xSqlDa.sqlvar[idx];
            row.setFieldIndex(idx);
            if (xSqlVar.sqlind.getValue() == -1) {
                row.set(null);
                continue;
            }
            int bufferOffset = 0;
            int bufferLength = xSqlVar.sqllen;
            if (rowDescriptor.getFieldDescriptor(idx).isVarying()) {
                bufferOffset = 2;
                bufferLength = xSqlVar.sqldata.getShort(0L) & 0xFFFF;
            }
            byte[] data = new byte[bufferLength];
            xSqlVar.sqldata.read((long)bufferOffset, data, 0, bufferLength);
            row.set(data);
        }
        return row.toRowValue(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetchRows(int fetchSize) throws SQLException {
        try {
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                this.checkStatementValid();
                if (!this.getState().isCursorOpen()) {
                    throw new FbExceptionBuilder().exception(335544834).toSQLException();
                }
                if (this.isAllRowsFetched()) {
                    return;
                }
                ISC_STATUS fetchStatus = this.clientLibrary.isc_dsql_fetch(this.statusVector, this.handle, this.outXSqlDa.version, this.outXSqlDa);
                this.processStatusVector();
                int fetchStatusInt = fetchStatus.intValue();
                if (fetchStatusInt == 0) {
                    this.queueRowData(this.toRowValue(this.getFieldDescriptor(), this.outXSqlDa));
                } else if (fetchStatusInt == 100) {
                    this.setAllRowsFetched(true);
                } else {
                    String message = "Unexpected fetch status (expected 0 or 100): " + fetchStatusInt;
                    log.error(message);
                    throw new SQLException(message);
                }
            }
        }
        catch (SQLException e2) {
            this.exceptionListenerDispatcher.errorOccurred(e2);
            throw e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getSqlInfo(byte[] requestItems, int bufferLength) throws SQLException {
        try {
            ByteBuffer responseBuffer = ByteBuffer.allocateDirect(bufferLength);
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                this.checkStatementValid();
                this.clientLibrary.isc_dsql_sql_info(this.statusVector, this.handle, (short)requestItems.length, requestItems, (short)bufferLength, responseBuffer);
                this.processStatusVector();
            }
            byte[] responseArr = new byte[bufferLength];
            responseBuffer.get(responseArr);
            return responseArr;
        }
        catch (SQLException e2) {
            this.exceptionListenerDispatcher.errorOccurred(e2);
            throw e2;
        }
    }

    @Override
    public int getDefaultSqlInfoSize() {
        return this.getMaxSqlInfoSize();
    }

    @Override
    public int getMaxSqlInfoSize() {
        return Short.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCursorName(String cursorName) throws SQLException {
        try {
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                this.checkStatementValid();
                JnaDatabase db = this.getDatabase();
                this.clientLibrary.isc_dsql_set_cursor_name(this.statusVector, this.handle, db.getEncoding().encodeToCharset(cursorName + '\u0000'), (short)0);
                this.processStatusVector();
            }
        }
        catch (SQLException e2) {
            this.exceptionListenerDispatcher.errorOccurred(e2);
            throw e2;
        }
    }

    @Override
    public final RowDescriptor emptyRowDescriptor() {
        return this.database.emptyRowDescriptor();
    }

    private void processStatusVector() throws SQLException {
        this.getDatabase().processStatusVector(this.statusVector, this.getStatementWarningCallback());
    }
}

