/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import com.sun.jna.Pointer;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Objects;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.gds.ng.AbstractConnection;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.IAttachProperties;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.jna.BigEndianDatatypeCoder;
import org.firebirdsql.gds.ng.jna.JnaAttachment;
import org.firebirdsql.gds.ng.jna.LittleEndianDatatypeCoder;
import org.firebirdsql.jna.fbclient.FbClientLibrary;
import org.firebirdsql.jna.fbclient.ISC_STATUS;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public abstract class JnaConnection<T extends IAttachProperties<T>, C extends JnaAttachment>
extends AbstractConnection<T, C> {
    private static final Logger log = LoggerFactory.getLogger(JnaConnection.class);
    private static final boolean bigEndian = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    private final FbClientLibrary clientLibrary;

    protected JnaConnection(FbClientLibrary clientLibrary, T attachProperties, IEncodingFactory encodingFactory) throws SQLException {
        super(attachProperties, encodingFactory);
        this.clientLibrary = Objects.requireNonNull(clientLibrary, "parameter clientLibrary cannot be null");
    }

    public final FbClientLibrary getClientLibrary() {
        return this.clientLibrary;
    }

    protected void processStatusVector(ISC_STATUS[] statusVector, WarningMessageCallback warningMessageCallback) throws SQLException {
        if (warningMessageCallback == null) {
            throw new NullPointerException("warningMessageCallback is null");
        }
        boolean debug = log.isDebugEnabled();
        FbExceptionBuilder builder = new FbExceptionBuilder();
        int vectorIndex = 0;
        block8: while (vectorIndex < statusVector.length) {
            int arg = statusVector[vectorIndex++].intValue();
            switch (arg) {
                case 1: {
                    int errorCode = statusVector[vectorIndex++].intValue();
                    if (debug) {
                        log.debug("readStatusVector arg:isc_arg_gds int: " + errorCode);
                    }
                    if (errorCode == 0) continue block8;
                    builder.exception(errorCode);
                    continue block8;
                }
                case 18: {
                    int errorCode = statusVector[vectorIndex++].intValue();
                    if (debug) {
                        log.debug("readStatusVector arg:isc_arg_warning int: " + errorCode);
                    }
                    if (errorCode == 0) continue block8;
                    builder.warning(errorCode);
                    continue block8;
                }
                case 2: 
                case 5: 
                case 19: {
                    long stringPointerAddress = statusVector[vectorIndex++].longValue();
                    if (stringPointerAddress == 0L) {
                        log.warn("Received NULL pointer address for isc_arg_interpreted, isc_arg_string or isc_arg_sql_state");
                        break block8;
                    }
                    Pointer stringPointer = new Pointer(stringPointerAddress);
                    String stringValue = stringPointer.getString(0L, this.getEncodingDefinition().getJavaEncodingName());
                    if (arg != 19) {
                        if (debug) {
                            log.debug("readStatusVector string: " + stringValue);
                        }
                        builder.messageParameter(stringValue);
                        continue block8;
                    }
                    if (debug) {
                        log.debug("readStatusVector sqlstate: " + stringValue);
                    }
                    builder.sqlState(stringValue);
                    continue block8;
                }
                case 3: {
                    int stringLength = statusVector[vectorIndex++].intValue();
                    long cStringPointerAddress = statusVector[vectorIndex++].longValue();
                    Pointer cStringPointer = new Pointer(cStringPointerAddress);
                    byte[] stringData = cStringPointer.getByteArray(0L, stringLength);
                    String cStringValue = this.getEncoding().decodeFromCharset(stringData);
                    builder.messageParameter(cStringValue);
                    continue block8;
                }
                case 4: {
                    int intValue = statusVector[vectorIndex++].intValue();
                    if (debug) {
                        log.debug("readStatusVector arg:isc_arg_number int: " + intValue);
                    }
                    builder.messageParameter(intValue);
                    continue block8;
                }
                case 0: {
                    break block8;
                }
                default: {
                    int e2 = statusVector[vectorIndex++].intValue();
                    if (debug) {
                        log.debug("readStatusVector arg: " + arg + " int: " + e2);
                    }
                    builder.messageParameter(e2);
                    continue block8;
                }
            }
        }
        if (!builder.isEmpty()) {
            SQLException exception = builder.toFlatSQLException();
            if (exception instanceof SQLWarning) {
                warningMessageCallback.processWarning((SQLWarning)exception);
            } else {
                throw exception;
            }
        }
    }

    final DatatypeCoder createDatatypeCoder() {
        if (bigEndian) {
            return new BigEndianDatatypeCoder(this.getEncodingFactory());
        }
        return new LittleEndianDatatypeCoder(this.getEncodingFactory());
    }

    public String getAttachUrl() {
        StringBuilder sb = new StringBuilder();
        if (this.getServerName() != null) {
            boolean ipv6;
            boolean bl2 = ipv6 = this.getServerName().indexOf(58) != -1;
            if (ipv6) {
                sb.append('[').append(this.getServerName()).append(']');
            } else {
                sb.append(this.getServerName());
            }
            sb.append('/').append(this.getPortNumber()).append(':');
        }
        sb.append(this.getAttachObjectName());
        return sb.toString();
    }
}

