/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.fields;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.firebirdsql.gds.ng.fields.FieldValue;
import org.firebirdsql.gds.ng.fields.RowDescriptor;

public final class RowValue
implements Iterable<FieldValue> {
    public static final RowValue EMPTY_ROW_VALUE = new RowValue(new FieldValue[0]);
    private final FieldValue[] fieldValues;

    public RowValue(FieldValue[] fieldValues) {
        this.fieldValues = (FieldValue[])fieldValues.clone();
    }

    public int getCount() {
        return this.fieldValues.length;
    }

    public FieldValue getFieldValue(int index) {
        return this.fieldValues[index];
    }

    @Override
    public Iterator<FieldValue> iterator() {
        return new RowValuesIterator();
    }

    public static RowValue of(FieldValue ... fieldValues) {
        return new RowValue(fieldValues);
    }

    public static RowValue of(RowDescriptor rowDescriptor, byte[] ... rowData) {
        if (rowDescriptor.getCount() != rowData.length) {
            throw new IllegalArgumentException("Expected RowDescriptor count and rowData length to be the same");
        }
        RowValue rowValue = rowDescriptor.createDefaultFieldValues();
        for (int i2 = 0; i2 < rowData.length; ++i2) {
            rowValue.getFieldValue(i2).setFieldData(rowData[i2]);
        }
        return rowValue;
    }

    public RowValue deepCopy() {
        FieldValue[] fieldValueCopy = new FieldValue[this.fieldValues.length];
        for (int i2 = 0; i2 < this.fieldValues.length; ++i2) {
            fieldValueCopy[i2] = this.fieldValues[i2].clone();
        }
        return new RowValue(fieldValueCopy);
    }

    private final class RowValuesIterator
    implements Iterator<FieldValue> {
        private int index = 0;

        private RowValuesIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < RowValue.this.fieldValues.length;
        }

        @Override
        public FieldValue next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return RowValue.this.fieldValues[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() method is not supported");
        }
    }
}

