/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.fields;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.fields.FieldValue;
import org.firebirdsql.gds.ng.fields.RowValue;

public final class RowDescriptor
implements Iterable<FieldDescriptor> {
    private static final FieldDescriptor[] NO_DESCRIPTORS = new FieldDescriptor[0];
    private final FieldDescriptor[] fieldDescriptors;
    private final DatatypeCoder datatypeCoder;
    private int hash;

    private RowDescriptor(FieldDescriptor[] fieldDescriptors, DatatypeCoder datatypeCoder) {
        assert (datatypeCoder != null) : "dataTypeCoder should not be null";
        this.fieldDescriptors = (FieldDescriptor[])fieldDescriptors.clone();
        this.datatypeCoder = datatypeCoder;
    }

    public DatatypeCoder getDatatypeCoder() {
        return this.datatypeCoder;
    }

    public IEncodingFactory getEncodingFactory() {
        return this.datatypeCoder.getEncodingFactory();
    }

    public int getCount() {
        return this.fieldDescriptors.length;
    }

    public FieldDescriptor getFieldDescriptor(int index) {
        return this.fieldDescriptors[index];
    }

    public List<FieldDescriptor> getFieldDescriptors() {
        return Collections.unmodifiableList(Arrays.asList(this.fieldDescriptors));
    }

    public RowValue createDefaultFieldValues() {
        if (this.getCount() == 0) {
            return RowValue.EMPTY_ROW_VALUE;
        }
        FieldValue[] fieldValues = new FieldValue[this.getCount()];
        for (int i2 = 0; i2 < this.fieldDescriptors.length; ++i2) {
            fieldValues[i2] = this.fieldDescriptors[i2].createDefaultFieldValue();
        }
        return new RowValue(fieldValues);
    }

    @Override
    public Iterator<FieldDescriptor> iterator() {
        return new RowDescriptorIterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RowDescriptor: [");
        for (int idx = 0; idx < this.fieldDescriptors.length; ++idx) {
            sb.append(idx).append('=');
            FieldDescriptor descriptor = this.fieldDescriptors[idx];
            if (descriptor != null) {
                descriptor.appendFieldDescriptor(sb);
            } else {
                sb.append("[null]");
            }
            sb.append(',');
        }
        if (this.fieldDescriptors.length > 0) {
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RowDescriptor)) {
            return false;
        }
        RowDescriptor other = (RowDescriptor)obj;
        return Arrays.equals(this.fieldDescriptors, other.fieldDescriptors);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Arrays.hashCode(this.fieldDescriptors);
        }
        return this.hash;
    }

    public static RowDescriptor createRowDescriptor(FieldDescriptor[] fieldDescriptors, DatatypeCoder datatypeCoder) {
        if (fieldDescriptors.length == 0) {
            return RowDescriptor.empty(datatypeCoder);
        }
        return new RowDescriptor(fieldDescriptors, datatypeCoder);
    }

    public static RowDescriptor empty(DatatypeCoder datatypeCoder) {
        return new RowDescriptor(NO_DESCRIPTORS, datatypeCoder);
    }

    private class RowDescriptorIterator
    implements Iterator<FieldDescriptor> {
        private int index = 0;

        private RowDescriptorIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < RowDescriptor.this.fieldDescriptors.length;
        }

        @Override
        public FieldDescriptor next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return RowDescriptor.this.fieldDescriptors[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() method is not supported");
        }
    }
}

