/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.gds.ng.DatatypeCoder;

public class DefaultDatatypeCoder
implements DatatypeCoder {
    private final IEncodingFactory encodingFactory;

    public DefaultDatatypeCoder(IEncodingFactory encodingFactory) {
        if (encodingFactory == null) {
            throw new NullPointerException("encodingFactory should not be null");
        }
        this.encodingFactory = encodingFactory;
    }

    @Override
    public byte[] encodeShort(short value) {
        return this.intToBytes(value);
    }

    @Override
    public byte[] encodeShort(int value) {
        return this.encodeShort((short)value);
    }

    @Override
    public short decodeShort(byte[] byte_int) {
        return (short)this.decodeInt(byte_int);
    }

    @Override
    public byte[] encodeInt(int value) {
        return this.intToBytes(value);
    }

    protected byte[] intToBytes(int value) {
        byte[] ret = new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        return ret;
    }

    @Override
    public int decodeInt(byte[] byte_int) {
        int b1 = byte_int[0] & 0xFF;
        int b2 = byte_int[1] & 0xFF;
        int b3 = byte_int[2] & 0xFF;
        int b4 = byte_int[3] & 0xFF;
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    @Override
    public byte[] encodeLong(long value) {
        byte[] ret = new byte[]{(byte)(value >>> 56 & 0xFFL), (byte)(value >>> 48 & 0xFFL), (byte)(value >>> 40 & 0xFFL), (byte)(value >>> 32 & 0xFFL), (byte)(value >>> 24 & 0xFFL), (byte)(value >>> 16 & 0xFFL), (byte)(value >>> 8 & 0xFFL), (byte)(value & 0xFFL)};
        return ret;
    }

    @Override
    public long decodeLong(byte[] byte_int) {
        long b1 = byte_int[0] & 0xFF;
        long b2 = byte_int[1] & 0xFF;
        long b3 = byte_int[2] & 0xFF;
        long b4 = byte_int[3] & 0xFF;
        long b5 = byte_int[4] & 0xFF;
        long b6 = byte_int[5] & 0xFF;
        long b7 = byte_int[6] & 0xFF;
        long b8 = byte_int[7] & 0xFF;
        return (b1 << 56) + (b2 << 48) + (b3 << 40) + (b4 << 32) + (b5 << 24) + (b6 << 16) + (b7 << 8) + b8;
    }

    @Override
    public byte[] encodeFloat(float value) {
        return this.encodeInt(Float.floatToIntBits(value));
    }

    @Override
    public float decodeFloat(byte[] byte_int) {
        return Float.intBitsToFloat(this.decodeInt(byte_int));
    }

    @Override
    public byte[] encodeDouble(double value) {
        return this.encodeLong(Double.doubleToLongBits(value));
    }

    @Override
    public double decodeDouble(byte[] byte_int) {
        return Double.longBitsToDouble(this.decodeLong(byte_int));
    }

    @Override
    public byte[] encodeString(String value, String javaEncoding, String mappingPath) throws SQLException {
        return this.encodingFactory.getEncodingForCharsetAlias(javaEncoding).withTranslation(this.encodingFactory.getCharacterTranslator(mappingPath)).encodeToCharset(value);
    }

    @Override
    public byte[] encodeString(String value, Encoding encoding, String mappingPath) throws SQLException {
        return encoding.withTranslation(this.encodingFactory.getCharacterTranslator(mappingPath)).encodeToCharset(value);
    }

    @Override
    public String decodeString(byte[] value, String javaEncoding, String mappingPath) throws SQLException {
        return this.decodeString(value, this.encodingFactory.getEncodingForCharsetAlias(javaEncoding), mappingPath);
    }

    @Override
    public String decodeString(byte[] value, Encoding encoding, String mappingPath) throws SQLException {
        return encoding.withTranslation(this.encodingFactory.getCharacterTranslator(mappingPath)).decodeFromCharset(value);
    }

    @Override
    public Timestamp encodeTimestamp(Timestamp value, Calendar cal) {
        return this.encodeTimestamp(value, cal, false);
    }

    @Override
    public Timestamp encodeTimestamp(Timestamp value, Calendar cal, boolean invertTimeZone) {
        if (cal == null) {
            return value;
        }
        long time = value.getTime() + (long)((invertTimeZone ? -1 : 1) * (cal.getTimeZone().getRawOffset() - Calendar.getInstance().getTimeZone().getRawOffset()));
        return new Timestamp(time);
    }

    @Override
    public byte[] encodeTimestamp(Timestamp value) {
        return this.encodeTimestampCalendar(value, new GregorianCalendar());
    }

    @Override
    public byte[] encodeTimestampRaw(DatatypeCoder.RawDateTimeStruct raw) {
        return new datetime(raw).toTimestampBytes();
    }

    @Override
    public byte[] encodeTimestampCalendar(Timestamp value, Calendar c2) {
        datetime d2 = new datetime(value, c2);
        return d2.toTimestampBytes();
    }

    @Override
    public Timestamp decodeTimestamp(Timestamp value, Calendar cal) {
        return this.decodeTimestamp(value, cal, false);
    }

    @Override
    public Timestamp decodeTimestamp(Timestamp value, Calendar cal, boolean invertTimeZone) {
        if (cal == null) {
            return value;
        }
        long time = value.getTime() - (long)((invertTimeZone ? -1 : 1) * (cal.getTimeZone().getRawOffset() - Calendar.getInstance().getTimeZone().getRawOffset()));
        return new Timestamp(time);
    }

    @Override
    public Timestamp decodeTimestamp(byte[] byte_long) {
        return this.decodeTimestampCalendar(byte_long, new GregorianCalendar());
    }

    @Override
    public DatatypeCoder.RawDateTimeStruct decodeTimestampRaw(byte[] byte_long) {
        datetime d2 = this.fromLongBytes(byte_long);
        return d2.getRaw();
    }

    @Override
    public Timestamp decodeTimestampCalendar(byte[] byte_long, Calendar c2) {
        datetime d2 = this.fromLongBytes(byte_long);
        return d2.toTimestamp(c2);
    }

    @Override
    public Time encodeTime(Time d2, Calendar cal, boolean invertTimeZone) {
        if (cal == null) {
            return d2;
        }
        long time = d2.getTime() + (long)((invertTimeZone ? -1 : 1) * (cal.getTimeZone().getRawOffset() - Calendar.getInstance().getTimeZone().getRawOffset()));
        return new Time(time);
    }

    @Override
    public byte[] encodeTime(Time d2) {
        return this.encodeTimeCalendar(d2, new GregorianCalendar());
    }

    @Override
    public byte[] encodeTimeRaw(DatatypeCoder.RawDateTimeStruct raw) {
        return new datetime(raw).toTimeBytes();
    }

    @Override
    public byte[] encodeTimeCalendar(Time d2, Calendar c2) {
        datetime dt = new datetime(d2, c2);
        return dt.toTimeBytes();
    }

    @Override
    public Time decodeTime(Time d2, Calendar cal, boolean invertTimeZone) {
        if (cal == null) {
            return d2;
        }
        long time = d2.getTime() - (long)((invertTimeZone ? -1 : 1) * (cal.getTimeZone().getRawOffset() - Calendar.getInstance().getTimeZone().getRawOffset()));
        return new Time(time);
    }

    @Override
    public Time decodeTime(byte[] int_byte) {
        return this.decodeTimeCalendar(int_byte, new GregorianCalendar());
    }

    @Override
    public DatatypeCoder.RawDateTimeStruct decodeTimeRaw(byte[] int_byte) {
        datetime d2 = new datetime(null, int_byte);
        return d2.getRaw();
    }

    @Override
    public Time decodeTimeCalendar(byte[] int_byte, Calendar c2) {
        datetime dt = new datetime(null, int_byte);
        return dt.toTime(c2);
    }

    @Override
    public Date encodeDate(Date d2, Calendar cal) {
        if (cal == null) {
            return d2;
        }
        cal.setTime(d2);
        return new Date(cal.getTime().getTime());
    }

    @Override
    public byte[] encodeDate(Date d2) {
        return this.encodeDateCalendar(d2, new GregorianCalendar());
    }

    @Override
    public byte[] encodeDateRaw(DatatypeCoder.RawDateTimeStruct raw) {
        return new datetime(raw).toDateBytes();
    }

    @Override
    public byte[] encodeDateCalendar(Date d2, Calendar c2) {
        datetime dt = new datetime(d2, c2);
        return dt.toDateBytes();
    }

    @Override
    public Date decodeDate(Date d2, Calendar cal) {
        if (cal == null || d2 == null) {
            return d2;
        }
        cal.setTime(d2);
        return new Date(cal.getTime().getTime());
    }

    @Override
    public Date decodeDate(byte[] byte_int) {
        return this.decodeDateCalendar(byte_int, new GregorianCalendar());
    }

    @Override
    public DatatypeCoder.RawDateTimeStruct decodeDateRaw(byte[] byte_int) {
        datetime d2 = new datetime(byte_int, null);
        return d2.getRaw();
    }

    @Override
    public Date decodeDateCalendar(byte[] byte_int, Calendar c2) {
        datetime dt = new datetime(byte_int, null);
        return dt.toDate(c2);
    }

    @Override
    public boolean decodeBoolean(byte[] data) {
        return data[0] != 0;
    }

    @Override
    public byte[] encodeBoolean(boolean value) {
        return new byte[]{(byte)(value ? 1 : 0)};
    }

    @Override
    public byte[] encodeLocalTime(int hour, int minute, int second, int nanos) {
        datetime dt = new datetime(0, 0, 0, hour, minute, second, nanos);
        return dt.toTimeBytes();
    }

    @Override
    public byte[] encodeLocalDate(int year, int month, int day) {
        datetime dt = new datetime(year, month, day, 0, 0, 0, 0);
        return dt.toDateBytes();
    }

    @Override
    public byte[] encodeLocalDateTime(int year, int month, int day, int hour, int minute, int second, int nanos) {
        datetime dt = new datetime(year, month, day, hour, minute, second, nanos);
        return dt.toTimestampBytes();
    }

    @Override
    public IEncodingFactory getEncodingFactory() {
        return this.encodingFactory;
    }

    private datetime fromLongBytes(byte[] byte_long) {
        if (byte_long.length != 8) {
            throw new IllegalArgumentException("Bad parameter to decode, require byte array of length 8");
        }
        byte[] date = new byte[4];
        byte[] time = new byte[4];
        System.arraycopy(byte_long, 0, date, 0, 4);
        System.arraycopy(byte_long, 4, time, 0, 4);
        return new datetime(date, time);
    }

    private class datetime {
        private DatatypeCoder.RawDateTimeStruct raw = new DatatypeCoder.RawDateTimeStruct();

        datetime(int year, int month, int day, int hour, int minute, int second, int nanos) {
            this.raw.year = year;
            this.raw.month = month;
            this.raw.day = day;
            this.raw.hour = hour;
            this.raw.minute = minute;
            this.raw.second = second;
            this.raw.fractions = nanos / 100000 % 10000;
        }

        datetime(Timestamp value, Calendar cOrig) {
            Calendar c2 = (Calendar)cOrig.clone();
            c2.setTime(value);
            this.raw.year = c2.get(1);
            this.raw.month = c2.get(2) + 1;
            this.raw.day = c2.get(5);
            this.raw.hour = c2.get(11);
            this.raw.minute = c2.get(12);
            this.raw.second = c2.get(13);
            this.raw.fractions = value.getNanos() / 100000;
        }

        datetime(Date value, Calendar cOrig) {
            Calendar c2 = (Calendar)cOrig.clone();
            c2.setTime(value);
            this.raw.year = c2.get(1);
            this.raw.month = c2.get(2) + 1;
            this.raw.day = c2.get(5);
            this.raw.hour = 0;
            this.raw.minute = 0;
            this.raw.second = 0;
            this.raw.fractions = 0;
        }

        datetime(Time value, Calendar cOrig) {
            Calendar c2 = (Calendar)cOrig.clone();
            c2.setTime(value);
            this.raw.year = 0;
            this.raw.month = 0;
            this.raw.day = 0;
            this.raw.hour = c2.get(11);
            this.raw.minute = c2.get(12);
            this.raw.second = c2.get(13);
            this.raw.fractions = c2.get(14) * 10;
        }

        datetime(byte[] date, byte[] time) {
            if (date != null) {
                int sql_date = DefaultDatatypeCoder.this.decodeInt(date);
                int century = (4 * (sql_date += 678882) - 1) / 146097;
                sql_date = 4 * sql_date - 1 - 146097 * century;
                this.raw.day = sql_date / 4;
                sql_date = (4 * this.raw.day + 3) / 1461;
                this.raw.day = 4 * this.raw.day + 3 - 1461 * sql_date;
                this.raw.day = (this.raw.day + 4) / 4;
                this.raw.month = (5 * this.raw.day - 3) / 153;
                this.raw.day = 5 * this.raw.day - 3 - 153 * this.raw.month;
                this.raw.day = (this.raw.day + 5) / 5;
                this.raw.year = 100 * century + sql_date;
                if (this.raw.month < 10) {
                    this.raw.month += 3;
                } else {
                    this.raw.month -= 9;
                    ++this.raw.year;
                }
            }
            if (time != null) {
                int fractionsInDay = DefaultDatatypeCoder.this.decodeInt(time);
                this.raw.hour = fractionsInDay / 36000000;
                this.raw.minute = (fractionsInDay -= this.raw.hour * 36000000) / 600000;
                this.raw.second = (fractionsInDay -= this.raw.minute * 600000) / 10000;
                this.raw.fractions = fractionsInDay - this.raw.second * 10000;
            }
        }

        datetime(DatatypeCoder.RawDateTimeStruct raw) {
            this.raw = new DatatypeCoder.RawDateTimeStruct(raw);
        }

        DatatypeCoder.RawDateTimeStruct getRaw() {
            return new DatatypeCoder.RawDateTimeStruct(this.raw);
        }

        byte[] toTimeBytes() {
            int fractionsInDay = this.raw.hour * 36000000 + this.raw.minute * 600000 + this.raw.second * 10000 + this.raw.fractions;
            return DefaultDatatypeCoder.this.encodeInt(fractionsInDay);
        }

        byte[] toDateBytes() {
            int cpMonth = this.raw.month;
            int cpYear = this.raw.year;
            if (cpMonth > 2) {
                cpMonth -= 3;
            } else {
                cpMonth += 9;
                --cpYear;
            }
            int c2 = cpYear / 100;
            int ya = cpYear - 100 * c2;
            int value = 146097 * c2 / 4 + 1461 * ya / 4 + (153 * cpMonth + 2) / 5 + this.raw.day + 1721119 - 2400001;
            return DefaultDatatypeCoder.this.encodeInt(value);
        }

        byte[] toTimestampBytes() {
            byte[] date = this.toDateBytes();
            byte[] time = this.toTimeBytes();
            byte[] result = new byte[8];
            System.arraycopy(date, 0, result, 0, 4);
            System.arraycopy(time, 0, result, 4, 4);
            return result;
        }

        Time toTime(Calendar cOrig) {
            Calendar c2 = (Calendar)cOrig.clone();
            c2.set(1, 1970);
            c2.set(2, 0);
            c2.set(5, 1);
            c2.set(11, this.raw.hour);
            c2.set(12, this.raw.minute);
            c2.set(13, this.raw.second);
            c2.set(14, this.raw.fractions / 10);
            return new Time(c2.getTimeInMillis());
        }

        Timestamp toTimestamp(Calendar cOrig) {
            Calendar c2 = (Calendar)cOrig.clone();
            c2.set(1, this.raw.year);
            c2.set(2, this.raw.month - 1);
            c2.set(5, this.raw.day);
            c2.set(11, this.raw.hour);
            c2.set(12, this.raw.minute);
            c2.set(13, this.raw.second);
            Timestamp timestamp = new Timestamp(c2.getTimeInMillis());
            timestamp.setNanos(this.raw.fractions * 100000);
            return timestamp;
        }

        Date toDate(Calendar cOrig) {
            Calendar c2 = (Calendar)cOrig.clone();
            c2.set(1, this.raw.year);
            c2.set(2, this.raw.month - 1);
            c2.set(5, this.raw.day);
            c2.set(11, 0);
            c2.set(12, 0);
            c2.set(13, 0);
            c2.set(14, 0);
            return new Date(c2.getTimeInMillis());
        }
    }
}

