/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import java.util.Iterator;
import org.firebirdsql.gds.ConnectionParameterBuffer;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.Parameter;
import org.firebirdsql.gds.ParameterBuffer;
import org.firebirdsql.gds.ServiceParameterBuffer;
import org.firebirdsql.gds.impl.DatabaseParameterBufferImp;
import org.firebirdsql.gds.impl.ServiceParameterBufferImp;
import org.firebirdsql.gds.ng.AbstractConnection;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.gds.ng.IServiceProperties;
import org.firebirdsql.gds.ng.ParameterConverter;

public abstract class AbstractParameterConverter<D extends AbstractConnection<IConnectionProperties, ?>, S extends AbstractConnection<IServiceProperties, ?>>
implements ParameterConverter<D, S> {
    protected DatabaseParameterBuffer createDatabaseParameterBuffer(D connection) {
        return new DatabaseParameterBufferImp(DatabaseParameterBufferImp.DpbMetaData.DPB_VERSION_1, ((AbstractConnection)connection).getEncoding());
    }

    protected ServiceParameterBuffer createServiceParameterBuffer(S connection) {
        return new ServiceParameterBufferImp(ServiceParameterBufferImp.SpbMetaData.SPB_VERSION_2_ATTACH, ((AbstractConnection)connection).getEncoding());
    }

    @Override
    public final DatabaseParameterBuffer toDatabaseParameterBuffer(D connection) throws SQLException {
        DatabaseParameterBuffer dpb = this.createDatabaseParameterBuffer(connection);
        this.populateDefaultProperties(connection, dpb);
        this.populateNonStandardProperties(connection, dpb);
        return dpb;
    }

    protected void populateDefaultProperties(D connection, DatabaseParameterBuffer dpb) throws SQLException {
        dpb.addArgument(48, ((AbstractConnection)connection).getEncodingDefinition().getFirebirdEncodingName());
        IConnectionProperties props = (IConnectionProperties)((AbstractConnection)connection).getAttachProperties();
        if (props.getPageCacheSize() != 0) {
            dpb.addArgument(5, props.getPageCacheSize());
        }
        this.populateAuthenticationProperties((AbstractConnection)connection, (ConnectionParameterBuffer)((Object)dpb));
        if (props.getRoleName() != null) {
            dpb.addArgument(60, props.getRoleName());
        }
        dpb.addArgument(63, props.getConnectionDialect());
        if (props.getConnectTimeout() != -1) {
            dpb.addArgument(57, props.getConnectTimeout());
        }
    }

    protected abstract void populateAuthenticationProperties(AbstractConnection var1, ConnectionParameterBuffer var2) throws SQLException;

    protected void populateNonStandardProperties(D connection, DatabaseParameterBuffer dpb) {
        Iterator iterator = ((IConnectionProperties)((AbstractConnection)connection).getAttachProperties()).getExtraDatabaseParameters().iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            parameter.copyTo((ParameterBuffer)((Object)dpb), dpb.getDefaultEncoding());
        }
    }

    @Override
    public final ServiceParameterBuffer toServiceParameterBuffer(S connection) throws SQLException {
        ServiceParameterBuffer spb = this.createServiceParameterBuffer(connection);
        this.populateDefaultProperties(connection, spb);
        return spb;
    }

    protected void populateDefaultProperties(S connection, ServiceParameterBuffer spb) throws SQLException {
        this.populateAuthenticationProperties((AbstractConnection)connection, (ConnectionParameterBuffer)((Object)spb));
        IServiceProperties props = (IServiceProperties)((AbstractConnection)connection).getAttachProperties();
        if (props.getRoleName() != null) {
            spb.addArgument(60, props.getRoleName());
        }
        if (props.getConnectTimeout() != -1) {
            spb.addArgument(57, props.getConnectTimeout());
        }
    }
}

