/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.firebirdsql.gds.ServiceParameterBuffer;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.ng.AbstractConnection;
import org.firebirdsql.gds.ng.AbstractFbAttachment;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbService;
import org.firebirdsql.gds.ng.IServiceProperties;
import org.firebirdsql.gds.ng.InfoProcessor;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.listeners.ServiceListener;
import org.firebirdsql.gds.ng.listeners.ServiceListenerDispatcher;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public abstract class AbstractFbService<T extends AbstractConnection<IServiceProperties, ? extends FbService>>
extends AbstractFbAttachment<T>
implements FbService {
    private static final Logger log = LoggerFactory.getLogger(AbstractFbService.class);
    private final ServiceListenerDispatcher serviceListenerDispatcher = new ServiceListenerDispatcher();
    private final WarningMessageCallback serviceWarningCallback = new WarningMessageCallback(){

        @Override
        public void processWarning(SQLWarning warning) {
            AbstractFbService.this.serviceListenerDispatcher.warningReceived(AbstractFbService.this, warning);
        }
    };

    protected AbstractFbService(T connection, DatatypeCoder datatypeCoder) {
        super(connection, datatypeCoder);
    }

    public final <R> R getServiceInfo(ServiceParameterBuffer serviceParameterBuffer, ServiceRequestBuffer serviceRequestBuffer, int bufferLength, InfoProcessor<R> infoProcessor) throws SQLException {
        byte[] responseBuffer = this.getServiceInfo(serviceParameterBuffer, serviceRequestBuffer, bufferLength);
        try {
            return infoProcessor.process(responseBuffer);
        }
        catch (SQLException e2) {
            this.exceptionListenerDispatcher.errorOccurred(e2);
            throw e2;
        }
    }

    @Override
    public final void addServiceListener(ServiceListener listener) {
        this.serviceListenerDispatcher.addListener(listener);
    }

    @Override
    public final void removeServiceListener(ServiceListener listener) {
        this.serviceListenerDispatcher.removeListener(listener);
    }

    protected abstract void internalDetach() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SQLException {
        try {
            this.checkConnected();
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                this.serviceListenerDispatcher.detaching(this);
                try {
                    this.internalDetach();
                }
                finally {
                    this.serviceListenerDispatcher.detached(this);
                    this.serviceListenerDispatcher.shutdown();
                }
            }
        }
        catch (SQLException e2) {
            this.exceptionListenerDispatcher.errorOccurred(e2);
            throw e2;
        }
        finally {
            this.exceptionListenerDispatcher.shutdown();
        }
    }

    protected final WarningMessageCallback getServiceWarningCallback() {
        return this.serviceWarningCallback;
    }

    protected ServiceRequestBuffer getDescribeServiceRequestBuffer() {
        ServiceRequestBuffer srb = this.createServiceRequestBuffer();
        srb.addArgument(55);
        return srb;
    }

    protected InfoProcessor<FbService> getServiceInformationProcessor() {
        return new ServiceInformationProcessor();
    }

    private class ServiceInformationProcessor
    implements InfoProcessor<FbService> {
        private ServiceInformationProcessor() {
        }

        @Override
        public FbService process(byte[] info) throws SQLException {
            boolean debug = log.isDebugEnabled();
            if (info.length == 0) {
                throw new SQLException("Response buffer for service information request is empty");
            }
            if (debug) {
                log.debug(String.format("ServiceInformationProcessor.process: first 2 bytes are %04X or: %02X, %02X", VaxEncoding.iscVaxInteger2(info, 0), info[0], info[1]));
            }
            int i2 = 0;
            block4: while (info[i2] != 1) {
                switch (info[i2++]) {
                    case 55: {
                        int len = VaxEncoding.iscVaxInteger2(info, i2);
                        String firebirdVersion = new String(info, i2 += 2, len, StandardCharsets.UTF_8);
                        i2 += len;
                        AbstractFbService.this.setServerVersion(firebirdVersion);
                        if (!debug) continue block4;
                        log.debug("isc_info_svc_server_version:" + firebirdVersion);
                        continue block4;
                    }
                    case 2: {
                        log.debug("isc_info_truncated ");
                        return AbstractFbService.this;
                    }
                }
                throw new FbExceptionBuilder().exception(335544341).toSQLException();
            }
            return AbstractFbService.this;
        }
    }
}

