/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.impl.BlobParameterBufferImp;
import org.firebirdsql.gds.impl.TransactionParameterBufferImpl;
import org.firebirdsql.gds.ng.AbstractConnection;
import org.firebirdsql.gds.ng.AbstractFbAttachment;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.gds.ng.InfoProcessor;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.listeners.DatabaseListener;
import org.firebirdsql.gds.ng.listeners.DatabaseListenerDispatcher;
import org.firebirdsql.gds.ng.listeners.TransactionListener;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public abstract class AbstractFbDatabase<T extends AbstractConnection<IConnectionProperties, ? extends FbDatabase>>
extends AbstractFbAttachment<T>
implements FbDatabase,
TransactionListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractFbDatabase.class);
    private static final byte[] DESCRIBE_DATABASE_INFO_BLOCK = new byte[]{62, 103, 32, 33, 1};
    private final DatabaseListenerDispatcher databaseListenerDispatcher = new DatabaseListenerDispatcher();
    private final Set<FbTransaction> activeTransactions = Collections.synchronizedSet(new HashSet());
    private final WarningMessageCallback warningCallback = new WarningMessageCallback(){

        @Override
        public void processWarning(SQLWarning warning) {
            AbstractFbDatabase.this.databaseListenerDispatcher.warningReceived(AbstractFbDatabase.this, warning);
        }
    };
    private final RowDescriptor emptyRowDescriptor;
    private short databaseDialect;
    private int odsMajor;
    private int odsMinor;

    protected AbstractFbDatabase(T connection, DatatypeCoder datatypeCoder) {
        super(connection, datatypeCoder);
        this.emptyRowDescriptor = RowDescriptor.empty(datatypeCoder);
    }

    public final WarningMessageCallback getDatabaseWarningCallback() {
        return this.warningCallback;
    }

    public final int getActiveTransactionCount() {
        return this.activeTransactions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void transactionAdded(FbTransaction transaction) {
        Set<FbTransaction> set = this.activeTransactions;
        synchronized (set) {
            if (transaction.getState() == TransactionState.ACTIVE) {
                this.activeTransactions.add(transaction);
            }
            transaction.addTransactionListener(this);
            transaction.addExceptionListener(this.exceptionListenerDispatcher);
        }
    }

    @Override
    public final short getConnectionDialect() {
        return ((IConnectionProperties)this.connection.getAttachProperties()).getConnectionDialect();
    }

    @Override
    public final short getDatabaseDialect() {
        return this.databaseDialect;
    }

    protected final void setDatabaseDialect(short dialect) {
        this.databaseDialect = dialect;
    }

    @Override
    public final void addDatabaseListener(DatabaseListener listener) {
        this.databaseListenerDispatcher.addListener(listener);
    }

    @Override
    public final void addWeakDatabaseListener(DatabaseListener listener) {
        this.databaseListenerDispatcher.addWeakListener(listener);
    }

    @Override
    public final void removeDatabaseListener(DatabaseListener listener) {
        this.databaseListenerDispatcher.removeListener(listener);
    }

    protected abstract void internalDetach() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SQLException {
        try {
            this.checkConnected();
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                if (this.getActiveTransactionCount() > 0) {
                    throw new FbExceptionBuilder().exception(335544357).messageParameter(this.getActiveTransactionCount()).toSQLException();
                }
                this.databaseListenerDispatcher.detaching(this);
                try {
                    this.internalDetach();
                }
                finally {
                    this.databaseListenerDispatcher.detached(this);
                    this.databaseListenerDispatcher.shutdown();
                    this.exceptionListenerDispatcher.shutdown();
                }
            }
        }
        catch (SQLException ex) {
            this.exceptionListenerDispatcher.errorOccurred(ex);
            throw ex;
        }
        finally {
            this.exceptionListenerDispatcher.shutdown();
        }
    }

    @Override
    public final int getOdsMajor() {
        return this.odsMajor;
    }

    protected final void setOdsMajor(int odsMajor) {
        this.odsMajor = odsMajor;
    }

    @Override
    public final int getOdsMinor() {
        return this.odsMinor;
    }

    protected final void setOdsMinor(int odsMinor) {
        this.odsMinor = odsMinor;
    }

    public final byte[] getStatementInfoRequestItems() {
        return this.getServerVersionInformation().getStatementInfoRequestItems();
    }

    public final byte[] getParameterDescriptionInfoRequestItems() {
        return this.getServerVersionInformation().getParameterDescriptionInfoRequestItems();
    }

    public final <R> R getDatabaseInfo(byte[] requestItems, int bufferLength, InfoProcessor<R> infoProcessor) throws SQLException {
        byte[] responseBuffer = this.getDatabaseInfo(requestItems, bufferLength);
        try {
            return infoProcessor.process(responseBuffer);
        }
        catch (SQLException ex) {
            this.exceptionListenerDispatcher.errorOccurred(ex);
            throw ex;
        }
    }

    protected byte[] getDescribeDatabaseInfoBlock() {
        return DESCRIBE_DATABASE_INFO_BLOCK;
    }

    protected InfoProcessor<FbDatabase> getDatabaseInformationProcessor() {
        return new DatabaseInformationProcessor();
    }

    @Override
    public final void transactionStateChanged(FbTransaction transaction, TransactionState newState, TransactionState previousState) {
        switch (newState) {
            case PREPARED: {
                this.activeTransactions.remove(transaction);
                break;
            }
            case COMMITTING: 
            case ROLLING_BACK: {
                this.activeTransactions.remove(transaction);
                break;
            }
            case COMMITTED: 
            case ROLLED_BACK: {
                this.activeTransactions.remove(transaction);
                transaction.removeTransactionListener(this);
                break;
            }
        }
    }

    @Override
    public BlobParameterBuffer createBlobParameterBuffer() {
        return new BlobParameterBufferImp();
    }

    @Override
    public TransactionParameterBufferImpl createTransactionParameterBuffer() {
        return new TransactionParameterBufferImpl();
    }

    @Override
    public IConnectionProperties getConnectionProperties() {
        return ((IConnectionProperties)this.connection.getAttachProperties()).asImmutable();
    }

    @Override
    public final RowDescriptor emptyRowDescriptor() {
        return this.emptyRowDescriptor;
    }

    private class DatabaseInformationProcessor
    implements InfoProcessor<FbDatabase> {
        private DatabaseInformationProcessor() {
        }

        @Override
        public FbDatabase process(byte[] info) throws SQLException {
            boolean debug = log.isDebugEnabled();
            if (info.length == 0) {
                throw new SQLException("Response buffer for database information request is empty");
            }
            if (debug) {
                log.debug(String.format("DatabaseInformationProcessor.process: first 2 bytes are %04X or: %02X, %02X", VaxEncoding.iscVaxInteger2(info, 0), info[0], info[1]));
            }
            int i2 = 0;
            block7: while (info[i2] != 1) {
                switch (info[i2++]) {
                    case 62: {
                        int len = VaxEncoding.iscVaxInteger2(info, i2);
                        int value = VaxEncoding.iscVaxInteger(info, i2 += 2, len);
                        i2 += len;
                        AbstractFbDatabase.this.setDatabaseDialect((short)value);
                        if (!debug) continue block7;
                        log.debug("isc_info_db_sql_dialect:" + value);
                        continue block7;
                    }
                    case 32: {
                        int len = VaxEncoding.iscVaxInteger2(info, i2);
                        int value = VaxEncoding.iscVaxInteger(info, i2 += 2, len);
                        i2 += len;
                        AbstractFbDatabase.this.setOdsMajor(value);
                        if (!debug) continue block7;
                        log.debug("isc_info_ods_version:" + value);
                        continue block7;
                    }
                    case 33: {
                        int len = VaxEncoding.iscVaxInteger2(info, i2);
                        int value = VaxEncoding.iscVaxInteger(info, i2 += 2, len);
                        i2 += len;
                        AbstractFbDatabase.this.setOdsMinor(value);
                        if (!debug) continue block7;
                        log.debug("isc_info_ods_minor_version:" + value);
                        continue block7;
                    }
                    case 103: {
                        int len = VaxEncoding.iscVaxInteger2(info, i2);
                        int expectedIndex = (i2 += 2) + len;
                        int versionCount = info[i2++] & 0xFF;
                        Object[] versionParts = new String[versionCount];
                        for (int versionIndex = 0; versionIndex < versionCount; ++versionIndex) {
                            int versionLength = info[i2++] & 0xFF;
                            versionParts[versionIndex] = new String(info, i2, versionLength, StandardCharsets.UTF_8);
                            i2 += versionLength;
                        }
                        assert (i2 == expectedIndex) : "Parsing version information lead to wrong index";
                        AbstractFbDatabase.this.setServerVersion((String[])versionParts);
                        if (!debug) continue block7;
                        log.debug("isc_info_firebird_version: " + Arrays.toString(versionParts));
                        continue block7;
                    }
                    case 2: {
                        if (debug) {
                            log.debug("isc_info_truncated ");
                        }
                        return AbstractFbDatabase.this;
                    }
                }
                throw new FbExceptionBuilder().exception(335544341).toSQLException();
            }
            return AbstractFbDatabase.this;
        }
    }
}

