/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.wire;

import org.firebirdsql.gds.XSQLDA;
import org.firebirdsql.gds.impl.AbstractIscStmtHandle;
import org.firebirdsql.gds.impl.wire.JavaGDSImpl;
import org.firebirdsql.gds.impl.wire.isc_db_handle_impl;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public final class isc_stmt_handle_impl
extends AbstractIscStmtHandle {
    private static Logger log = LoggerFactory.getLogger(JavaGDSImpl.class, false);
    private int rsr_id;
    private isc_db_handle_impl rsr_rdb;
    private XSQLDA in_sqlda = null;
    private XSQLDA out_sqlda = null;
    private byte[][][] rows;
    private int size;
    private boolean allRowsFetched = false;
    private boolean isSingletonResult = false;
    private boolean hasOpenResultSet;
    private int statementType;
    private int insertCount;
    private int updateCount;
    private int deleteCount;
    private int selectCount;

    public XSQLDA getInSqlda() {
        return this.in_sqlda;
    }

    public XSQLDA getOutSqlda() {
        return this.out_sqlda;
    }

    public void setInSqlda(XSQLDA xsqlda) {
        this.in_sqlda = xsqlda;
    }

    public void setOutSqlda(XSQLDA xsqlda) {
        this.out_sqlda = xsqlda;
    }

    public void ensureCapacity(int maxSize) {
        if (this.rows == null || this.rows.length < maxSize) {
            this.rows = new byte[maxSize][][];
        }
        this.size = 0;
    }

    public void clearRows() {
        this.size = 0;
        if (this.rows != null) {
            this.rows = null;
        }
        this.allRowsFetched = false;
        this.hasOpenResultSet = false;
    }

    public void setStatementType(int value) {
        this.statementType = value;
    }

    public int getStatementType() {
        return this.statementType;
    }

    public void setInsertCount(int value) {
        this.insertCount = value;
    }

    public int getInsertCount() {
        return this.insertCount;
    }

    public void setUpdateCount(int value) {
        this.updateCount = value;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public void setDeleteCount(int value) {
        this.deleteCount = value;
    }

    public int getDeleteCount() {
        return this.deleteCount;
    }

    public void setSelectCount(int value) {
        this.selectCount = value;
    }

    public int getSelectCount() {
        return this.selectCount;
    }

    public boolean isAllRowsFetched() {
        return this.allRowsFetched;
    }

    public void setAllRowsFetched(boolean value) {
        this.allRowsFetched = value;
    }

    public boolean isSingletonResult() {
        return this.isSingletonResult;
    }

    public void setSingletonResult(boolean value) {
        this.isSingletonResult = value;
    }

    public int getRsr_id() {
        return this.rsr_id;
    }

    public void setRsr_id(int value) {
        this.rsr_id = value;
    }

    public boolean isValid() {
        return this.rsr_rdb != null && this.rsr_rdb.isValid();
    }

    public boolean hasOpenResultSet() {
        return this.hasOpenResultSet;
    }

    void notifyOpenResultSet() {
        this.hasOpenResultSet = true;
    }

    public isc_db_handle_impl getRsr_rdb() {
        return this.rsr_rdb;
    }

    public void setRsr_rdb(isc_db_handle_impl value) {
        this.rsr_rdb = value;
    }

    public int size() {
        return this.size;
    }

    public byte[][][] getRows() {
        return this.rows;
    }

    public void removeRows() {
        this.rows = null;
        this.size = 0;
    }

    public void addRow(byte[][] row) {
        this.rows[this.size++] = row;
    }

    public static void printRow(byte[][] row) {
        StringBuffer sb = new StringBuffer();
        sb.append("\t");
        if (row == null) {
            sb.append("null");
        } else {
            for (int i2 = 0; i2 < row.length; ++i2) {
                if (row[i2] == null) {
                    sb.append("null");
                } else {
                    for (int j2 = 0; j2 < row[i2].length; ++j2) {
                        String hexValue = Integer.toHexString(row[i2][j2] & 0xFF);
                        if (hexValue.length() == 1) {
                            hexValue = "0" + hexValue;
                        }
                        sb.append(hexValue);
                        if (j2 >= row[i2].length - 1) continue;
                        sb.append(" ");
                    }
                }
                if (i2 >= row.length - 1) continue;
                sb.append(", ");
            }
        }
        if (log != null) {
            log.debug(sb.toString());
        }
    }
}

