/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.wire;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.firebirdsql.gds.impl.wire.isc_stmt_handle_impl;

public class XdrInputStream {
    protected static final byte[] pad = new byte[8];
    protected InputStream in = null;
    protected static int defaultBufferSize = 16384;
    protected byte[] buf;
    protected int count;
    protected int pos;

    protected XdrInputStream() {
    }

    public XdrInputStream(InputStream in) {
        this.buf = new byte[defaultBufferSize];
        this.in = in;
    }

    public byte[] readBuffer() throws IOException {
        int len = this.readInt();
        byte[] buffer = new byte[len];
        this.readFully(buffer, 0, len);
        this.readFully(pad, 0, 4 - len & 3);
        return buffer;
    }

    public String readString() throws IOException {
        int len = this.readInt();
        byte[] buffer = new byte[len];
        this.readFully(buffer, 0, len);
        this.readFully(pad, 0, 4 - len & 3);
        return new String(buffer);
    }

    public void readSQLData(int[] ioLength, isc_stmt_handle_impl stmt) throws IOException {
        int numCols = ioLength.length;
        byte[][] row = new byte[numCols][];
        for (int i2 = 0; i2 < numCols; ++i2) {
            byte[] buffer;
            int len = ioLength[i2];
            if (len == 0) {
                len = this.readInt();
                buffer = new byte[len];
                this.readFully(buffer, 0, len);
                this.readFully(pad, 0, 4 - len & 3);
            } else if (len < 0) {
                buffer = new byte[-len];
                this.readFully(buffer, 0, -len);
            } else {
                buffer = new byte[--len];
                this.readFully(buffer, 0, len);
                this.readFully(pad, 0, 4 - len & 3);
            }
            if (this.readInt() == -1) {
                buffer = null;
            }
            row[i2] = buffer;
        }
        if (stmt != null) {
            stmt.addRow(row);
        }
    }

    public long readLong() throws IOException {
        return this.read() << 56 | this.read() << 48 | this.read() << 40 | this.read() << 32 | this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read() << 0;
    }

    public int readInt() throws IOException {
        return this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read() << 0;
    }

    public void readFully(byte[] b2, int off, int len) throws IOException {
        if (len <= this.count - this.pos) {
            System.arraycopy(this.buf, this.pos, b2, off, len);
            this.pos += len;
        } else {
            int cnt;
            for (int n2 = 0; n2 < len; n2 += cnt) {
                int lenN;
                int avail;
                if (this.count <= this.pos) {
                    this.count = 0;
                    this.pos = 0;
                    int readn = this.in.read(this.buf, 0, defaultBufferSize);
                    if (readn > 0) {
                        this.count = readn;
                    } else {
                        throw new EOFException();
                    }
                }
                cnt = (avail = this.count - this.pos) < (lenN = len - n2) ? avail : lenN;
                System.arraycopy(this.buf, this.pos, b2, off + n2, cnt);
                this.pos += cnt;
            }
        }
    }

    public int read() throws IOException {
        if (this.pos >= this.count) {
            this.count = 0;
            this.pos = 0;
            int readn = this.in.read(this.buf, 0, defaultBufferSize);
            if (readn > 0) {
                this.count = readn;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
        this.in = null;
        this.buf = null;
    }
}

