/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.jni;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.gds.impl.jni.XSQLVARImpl;

public class XSQLVARLittleEndianImpl
extends XSQLVARImpl {
    public XSQLVARLittleEndianImpl() {
    }

    public XSQLVAR deepCopy() {
        XSQLVARLittleEndianImpl result = new XSQLVARLittleEndianImpl();
        result.copyFrom(this);
        return result;
    }

    public XSQLVARLittleEndianImpl(int sqltype, int sqlscale, int sqlsubtype, int sqllen, byte[] sqldata, String sqlname, String relname, String ownname, String aliasname) {
        super(sqltype, sqlscale, sqlsubtype, sqllen, sqldata, sqlname, relname, ownname, aliasname);
    }

    public byte[] encodeShort(short value) {
        byte[] ret = new byte[]{(byte)(value >>> 0 & 0xFF), (byte)(value >>> 8 & 0xFF)};
        return ret;
    }

    public short decodeShort(byte[] byte_int) {
        int b1 = byte_int[0] & 0xFF;
        int b2 = byte_int[1] & 0xFF;
        return (short)((b1 << 0) + (b2 << 8));
    }

    public byte[] encodeInt(int value) {
        byte[] ret = new byte[]{(byte)(value >>> 0 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 24 & 0xFF)};
        return ret;
    }

    public int decodeInt(byte[] byte_int) {
        int b1 = byte_int[0] & 0xFF;
        int b2 = byte_int[1] & 0xFF;
        int b3 = byte_int[2] & 0xFF;
        int b4 = byte_int[3] & 0xFF;
        return (b1 << 0) + (b2 << 8) + (b3 << 16) + (b4 << 24);
    }

    public byte[] encodeLong(long value) {
        byte[] ret = new byte[]{(byte)(value >>> 0 & 0xFFL), (byte)(value >>> 8 & 0xFFL), (byte)(value >>> 16 & 0xFFL), (byte)(value >>> 24 & 0xFFL), (byte)(value >>> 32 & 0xFFL), (byte)(value >>> 40 & 0xFFL), (byte)(value >>> 48 & 0xFFL), (byte)(value >>> 56 & 0xFFL)};
        return ret;
    }

    public long decodeLong(byte[] byte_int) {
        long b1 = byte_int[0] & 0xFF;
        long b2 = byte_int[1] & 0xFF;
        long b3 = byte_int[2] & 0xFF;
        long b4 = byte_int[3] & 0xFF;
        long b5 = byte_int[4] & 0xFF;
        long b6 = byte_int[5] & 0xFF;
        long b7 = byte_int[6] & 0xFF;
        long b8 = byte_int[7] & 0xFF;
        return (b1 << 0) + (b2 << 8) + (b3 << 16) + (b4 << 24) + (b5 << 32) + (b6 << 40) + (b7 << 48) + (b8 << 56);
    }

    public byte[] encodeFloat(float value) {
        return this.encodeInt(Float.floatToIntBits(value));
    }

    public float decodeFloat(byte[] byte_int) {
        return Float.intBitsToFloat(this.decodeInt(byte_int));
    }

    public byte[] encodeDouble(double value) {
        return this.encodeLong(Double.doubleToLongBits(value));
    }

    public double decodeDouble(byte[] byte_int) {
        return Double.longBitsToDouble(this.decodeLong(byte_int));
    }

    public byte[] encodeString(String value, String encoding, String mappingPath) throws SQLException {
        if (this.coder == null) {
            this.coder = EncodingFactory.getEncoding(encoding, mappingPath);
        }
        return this.coder.encodeToCharset(value);
    }

    public byte[] encodeString(byte[] value, String encoding, String mappingPath) throws SQLException {
        if (encoding == null) {
            return value;
        }
        if (this.coder == null) {
            this.coder = EncodingFactory.getEncoding(encoding, mappingPath);
        }
        return this.coder.encodeToCharset(this.coder.decodeFromCharset(value));
    }

    public String decodeString(byte[] value, String encoding, String mappingPath) throws SQLException {
        if (this.coder == null) {
            this.coder = EncodingFactory.getEncoding(encoding, mappingPath);
        }
        return this.coder.decodeFromCharset(value);
    }

    public Timestamp encodeTimestamp(Timestamp value, Calendar cal) {
        if (cal == null) {
            return value;
        }
        long time = value.getTime() - (long)cal.getTimeZone().getRawOffset();
        return new Timestamp(time);
    }

    public byte[] encodeTimestamp(Timestamp value) {
        datetime d2 = new datetime(value);
        byte[] date = d2.toDateBytes();
        byte[] time = d2.toTimeBytes();
        byte[] result = new byte[8];
        System.arraycopy(date, 0, result, 0, 4);
        System.arraycopy(time, 0, result, 4, 4);
        return result;
    }

    public Timestamp decodeTimestamp(Timestamp value, Calendar cal) {
        if (cal == null) {
            return value;
        }
        long time = value.getTime() + (long)cal.getTimeZone().getRawOffset();
        return new Timestamp(time);
    }

    public Timestamp decodeTimestamp(byte[] byte_int) {
        if (byte_int.length != 8) {
            throw new IllegalArgumentException("Bad parameter to decode");
        }
        byte[] date = new byte[4];
        byte[] time = new byte[4];
        System.arraycopy(byte_int, 0, date, 0, 4);
        System.arraycopy(byte_int, 4, time, 0, 4);
        datetime d2 = new datetime(date, time);
        return d2.toTimestamp();
    }

    public Time encodeTime(Time d2, Calendar cal) {
        if (cal == null) {
            return d2;
        }
        cal.setTime(d2);
        return new Time(cal.getTime().getTime());
    }

    public byte[] encodeTime(Time d2) {
        datetime dt = new datetime(d2);
        return dt.toTimeBytes();
    }

    public Time decodeTime(Time d2, Calendar cal) {
        if (cal == null) {
            return d2;
        }
        cal.setTime(d2);
        return new Time(cal.getTime().getTime());
    }

    public Time decodeTime(byte[] int_byte) {
        datetime dt = new datetime(null, int_byte);
        return dt.toTime();
    }

    public java.sql.Date encodeDate(java.sql.Date d2, Calendar cal) {
        if (cal == null) {
            return d2;
        }
        cal.setTime(d2);
        return new java.sql.Date(cal.getTime().getTime());
    }

    public byte[] encodeDate(java.sql.Date d2) {
        datetime dt = new datetime(d2);
        return dt.toDateBytes();
    }

    public java.sql.Date decodeDate(java.sql.Date d2, Calendar cal) {
        if (cal == null || d2 == null) {
            return d2;
        }
        cal.setTime(d2);
        return new java.sql.Date(cal.getTime().getTime());
    }

    public java.sql.Date decodeDate(byte[] byte_int) {
        datetime dt = new datetime(byte_int, null);
        return dt.toDate();
    }

    private class datetime {
        int year;
        int month;
        int day;
        int hour;
        int minute;
        int second;
        int millisecond;

        datetime(Timestamp value) {
            GregorianCalendar c2 = new GregorianCalendar();
            c2.setTime(value);
            this.year = c2.get(1);
            this.month = c2.get(2) + 1;
            this.day = c2.get(5);
            this.hour = c2.get(11);
            this.minute = c2.get(12);
            this.second = c2.get(13);
            this.millisecond = value.getNanos() / 1000000;
        }

        datetime(Date value) {
            GregorianCalendar c2 = new GregorianCalendar();
            c2.setTime(value);
            this.year = c2.get(1);
            this.month = c2.get(2) + 1;
            this.day = c2.get(5);
            this.hour = 0;
            this.minute = 0;
            this.second = 0;
            this.millisecond = 0;
        }

        datetime(Time value) {
            GregorianCalendar c2 = new GregorianCalendar();
            c2.setTime(value);
            this.year = 0;
            this.month = 0;
            this.day = 0;
            this.hour = c2.get(11);
            this.minute = c2.get(12);
            this.second = c2.get(13);
            this.millisecond = c2.get(14);
        }

        datetime(byte[] date, byte[] time) {
            if (date != null) {
                int sql_date = XSQLVARLittleEndianImpl.this.decodeInt(date);
                int century = (4 * (sql_date += 678882) - 1) / 146097;
                sql_date = 4 * sql_date - 1 - 146097 * century;
                this.day = sql_date / 4;
                sql_date = (4 * this.day + 3) / 1461;
                this.day = 4 * this.day + 3 - 1461 * sql_date;
                this.day = (this.day + 4) / 4;
                this.month = (5 * this.day - 3) / 153;
                this.day = 5 * this.day - 3 - 153 * this.month;
                this.day = (this.day + 5) / 5;
                this.year = 100 * century + sql_date;
                if (this.month < 10) {
                    this.month += 3;
                } else {
                    this.month -= 9;
                    ++this.year;
                }
            }
            if (time != null) {
                int millisInDay = XSQLVARLittleEndianImpl.this.decodeInt(time) / 10;
                this.hour = millisInDay / 3600000;
                this.minute = (millisInDay - this.hour * 3600000) / 60000;
                this.second = (millisInDay - this.hour * 3600000 - this.minute * 60000) / 1000;
                this.millisecond = millisInDay - this.hour * 3600000 - this.minute * 60000 - this.second * 1000;
            }
        }

        byte[] toTimeBytes() {
            int millisInDay = (this.hour * 3600000 + this.minute * 60000 + this.second * 1000 + this.millisecond) * 10;
            return XSQLVARLittleEndianImpl.this.encodeInt(millisInDay);
        }

        byte[] toDateBytes() {
            int cpMonth = this.month;
            int cpYear = this.year;
            if (cpMonth > 2) {
                cpMonth -= 3;
            } else {
                cpMonth += 9;
                --cpYear;
            }
            int c2 = cpYear / 100;
            int ya = cpYear - 100 * c2;
            int value = 146097 * c2 / 4 + 1461 * ya / 4 + (153 * cpMonth + 2) / 5 + this.day + 1721119 - 2400001;
            return XSQLVARLittleEndianImpl.this.encodeInt(value);
        }

        Time toTime() {
            GregorianCalendar c2 = new GregorianCalendar();
            c2.set(1, 1970);
            c2.set(2, 0);
            c2.set(5, 1);
            c2.set(11, this.hour);
            c2.set(12, this.minute);
            c2.set(13, this.second);
            c2.set(14, this.millisecond);
            return new Time(c2.getTime().getTime());
        }

        Timestamp toTimestamp() {
            GregorianCalendar c2 = new GregorianCalendar();
            c2.set(1, this.year);
            c2.set(2, this.month - 1);
            c2.set(5, this.day);
            c2.set(11, this.hour);
            c2.set(12, this.minute);
            c2.set(13, this.second);
            c2.set(14, this.millisecond);
            return new Timestamp(c2.getTime().getTime());
        }

        java.sql.Date toDate() {
            GregorianCalendar c2 = new GregorianCalendar();
            c2.set(1, this.year);
            c2.set(2, this.month - 1);
            c2.set(5, this.day);
            c2.set(11, 0);
            c2.set(12, 0);
            c2.set(13, 0);
            c2.set(14, 0);
            return new java.sql.Date(c2.getTime().getTime());
        }
    }
}

