/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.jni;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

abstract class ParameterBufferBase
implements Serializable {
    private final List arguments = new ArrayList();

    ParameterBufferBase() {
    }

    public void addArgument(int argumentType, String value) {
        this.getArgumentsList().add(new StringArgument(argumentType, value));
    }

    public void addArgument(int argumentType, int value) {
        this.getArgumentsList().add(new NumericArgument(argumentType, value));
    }

    public void addArgument(int argumentType, byte value) {
        this.getArgumentsList().add(new NumericArgument(argumentType, value){

            protected void writeValue(ByteArrayOutputStream outputStream, int value) {
                outputStream.write((byte)value);
            }
        });
    }

    public void addArgument(int argumentType) {
        this.getArgumentsList().add(new SingleItem(argumentType));
    }

    public void addArgument(int type, byte[] content) {
        this.getArgumentsList().add(new ByteArrayArgument(type, content));
    }

    public String getArgumentAsString(int type) {
        List argumentsList = this.getArgumentsList();
        int n2 = argumentsList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Argument argument = (Argument)argumentsList.get(i2);
            if (argument.getType() != type) continue;
            return argument.getValueAsString();
        }
        return null;
    }

    public int getArgumentAsInt(int type) {
        List argumentsList = this.getArgumentsList();
        int n2 = argumentsList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Argument argument = (Argument)argumentsList.get(i2);
            if (argument.getType() != type) continue;
            return argument.getValueAsInt();
        }
        return 0;
    }

    public boolean hasArgument(int type) {
        List argumentsList = this.getArgumentsList();
        int n2 = argumentsList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Argument argument = (Argument)argumentsList.get(i2);
            if (argument.getType() != type) continue;
            return true;
        }
        return false;
    }

    public void removeArgument(int type) {
        List argumentsList = this.getArgumentsList();
        int n2 = argumentsList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Argument argument = (Argument)argumentsList.get(i2);
            if (argument.getType() != type) continue;
            argumentsList.remove(i2);
            return;
        }
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof ParameterBufferBase)) {
            return false;
        }
        ParameterBufferBase otherServiceBufferBase = (ParameterBufferBase)other;
        return ((Object)otherServiceBufferBase.getArgumentsList()).equals(this.getArgumentsList());
    }

    public int hashCode() {
        return ((Object)this.getArgumentsList()).hashCode();
    }

    protected void writeArgumentsTo(ByteArrayOutputStream outputStream) {
        int n2 = this.arguments.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Argument currentArgument = (Argument)this.arguments.get(i2);
            currentArgument.writeTo(outputStream);
        }
    }

    protected List getArgumentsList() {
        return this.arguments;
    }

    private static final class SingleItem
    extends Argument {
        private final int item;

        SingleItem(int item) {
            this.item = item;
        }

        void writeTo(ByteArrayOutputStream outputStream) {
            outputStream.write(this.item);
        }

        int getType() {
            return this.item;
        }

        public int hashCode() {
            return this.item;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof SingleItem)) {
                return false;
            }
            SingleItem otherSingleItem = (SingleItem)other;
            return this.item == otherSingleItem.item;
        }
    }

    private static final class ByteArrayArgument
    extends Argument {
        private final int type;
        private final byte[] value;

        ByteArrayArgument(int type, byte[] value) {
            this.type = type;
            this.value = value;
        }

        void writeTo(ByteArrayOutputStream outputStream) {
            outputStream.write(this.type);
            int valueLength = this.value.length;
            this.writeLength(valueLength, outputStream);
            for (int i2 = 0; i2 < valueLength; ++i2) {
                outputStream.write(this.value[i2]);
            }
        }

        protected void writeLength(int length, ByteArrayOutputStream outputStream) {
            outputStream.write(length);
        }

        int getType() {
            return this.type;
        }

        int getValueAsInt() {
            if (this.value.length == 1) {
                return this.value[0];
            }
            throw new UnsupportedOperationException("This method is not supported for byte arrays with length > 1");
        }

        public int hashCode() {
            return this.type;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof ByteArrayArgument)) {
                return false;
            }
            ByteArrayArgument otherByteArrayArgument = (ByteArrayArgument)other;
            return this.type == otherByteArrayArgument.type && Arrays.equals(this.value, otherByteArrayArgument.value);
        }
    }

    protected static class NumericArgument
    extends Argument {
        private final int type;
        private final int value;

        NumericArgument(int type, int value) {
            this.type = type;
            this.value = value;
        }

        void writeTo(ByteArrayOutputStream outputStream) {
            outputStream.write(this.type);
            int value = this.value;
            this.writeValue(outputStream, value);
        }

        protected void writeValue(ByteArrayOutputStream outputStream, int value) {
            outputStream.write(value);
            outputStream.write(value >> 8);
            outputStream.write(value >> 16);
            outputStream.write(value >> 24);
        }

        int getType() {
            return this.type;
        }

        int getValueAsInt() {
            return this.value;
        }

        public int hashCode() {
            return this.type;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof NumericArgument)) {
                return false;
            }
            NumericArgument otherNumericArgument = (NumericArgument)other;
            return this.type == otherNumericArgument.type && this.value == otherNumericArgument.value;
        }
    }

    protected static class StringArgument
    extends Argument {
        private final int type;
        private final String value;

        StringArgument(int type, String value) {
            this.type = type;
            this.value = value;
        }

        void writeTo(ByteArrayOutputStream outputStream) {
            outputStream.write(this.type);
            byte[] valueBytes = this.value.getBytes();
            int valueLength = valueBytes.length;
            this.writeLength(valueLength, outputStream);
            for (int i2 = 0; i2 < valueLength; ++i2) {
                outputStream.write(valueBytes[i2]);
            }
        }

        String getValueAsString() {
            return this.value;
        }

        int getValueAsInt() {
            return Integer.parseInt(this.value);
        }

        protected void writeLength(int length, ByteArrayOutputStream outputStream) {
            outputStream.write(length);
        }

        int getType() {
            return this.type;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof StringArgument)) {
                return false;
            }
            StringArgument otherStringArgument = (StringArgument)other;
            return this.type == otherStringArgument.type && this.value.equals(otherStringArgument.value);
        }
    }

    protected static abstract class Argument
    implements Serializable {
        protected Argument() {
        }

        abstract int getType();

        String getValueAsString() {
            throw new RuntimeException("Cannot get the value for this argument type as a string");
        }

        int getValueAsInt() {
            throw new RuntimeException("Cannot get the value of this argument type as int");
        }

        abstract void writeTo(ByteArrayOutputStream var1);
    }
}

