/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.jni;

import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.IscBlobHandle;
import org.firebirdsql.gds.IscDbHandle;
import org.firebirdsql.gds.IscStmtHandle;
import org.firebirdsql.gds.IscSvcHandle;
import org.firebirdsql.gds.IscTrHandle;
import org.firebirdsql.gds.XSQLDA;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.impl.jni.BaseGDSImpl;
import org.firebirdsql.gds.impl.jni.isc_blob_handle_impl;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public abstract class JniGDSImpl
extends BaseGDSImpl {
    public static final String JAYBIRD_JNI_LIBRARY = "jaybird2";
    private static Logger log = LoggerFactory.getLogger(JniGDSImpl.class, false);

    protected JniGDSImpl(GDSType gdsType) {
        super(gdsType);
    }

    protected JniGDSImpl() {
    }

    protected static void initJNIBridge() throws UnsatisfiedLinkError {
        boolean logging;
        boolean bl2 = logging = log != null;
        if (logging) {
            log.info("Attempting to load JNI library : [jaybird2]");
        }
        try {
            System.loadLibrary(JAYBIRD_JNI_LIBRARY);
        }
        catch (SecurityException ex) {
            if (logging) {
                log.error("No permission to load JNI libraries.", ex);
            }
            throw ex;
        }
        catch (UnsatisfiedLinkError ex) {
            if (logging) {
                log.error("No JNI library was found in the path.", ex);
            }
            throw ex;
        }
    }

    protected void attemptToLoadAClientLibraryFromList(String[] clientLibraryList) {
        boolean logging = log != null;
        int n2 = clientLibraryList.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String currentClientLibraryToTry = clientLibraryList[i2];
            try {
                this.nativeInitilize(currentClientLibraryToTry);
            }
            catch (Throwable th) {
                th.printStackTrace();
                if (logging) {
                    System.out.println("Failed to load client library # " + i2 + " - \"" + currentClientLibraryToTry + "\"." + th.toString());
                }
                if (i2 != clientLibraryList.length - 1) continue;
                throw new RuntimeException("Failed to initilize JayBird native library. This is most likley due to a failure to load the firebird client library.");
            }
            if (!logging) break;
            log.info("Successfully loaded client library # " + i2 + " - \"" + currentClientLibraryToTry + "\".");
            break;
        }
    }

    public native void nativeInitilize(String var1);

    public native void native_isc_attach_database(String var1, IscDbHandle var2, byte[] var3);

    public native byte[] native_isc_blob_info(isc_blob_handle_impl var1, byte[] var2, int var3) throws GDSException;

    public native void native_isc_close_blob(IscBlobHandle var1) throws GDSException;

    public native void native_isc_commit_retaining(IscTrHandle var1) throws GDSException;

    public native void native_isc_commit_transaction(IscTrHandle var1) throws GDSException;

    public native void native_isc_create_blob2(IscDbHandle var1, IscTrHandle var2, IscBlobHandle var3, byte[] var4);

    public native void native_isc_create_database(String var1, IscDbHandle var2, byte[] var3);

    public native void native_isc_database_info(IscDbHandle var1, int var2, byte[] var3, int var4, byte[] var5) throws GDSException;

    public native void native_isc_detach_database(IscDbHandle var1) throws GDSException;

    public native void native_isc_drop_database(IscDbHandle var1) throws GDSException;

    public native void native_isc_dsql_alloc_statement2(IscDbHandle var1, IscStmtHandle var2) throws GDSException;

    public native void native_isc_dsql_allocate_statement(IscDbHandle var1, IscStmtHandle var2) throws GDSException;

    public native XSQLDA native_isc_dsql_describe(IscStmtHandle var1, int var2) throws GDSException;

    public native XSQLDA native_isc_dsql_describe_bind(IscStmtHandle var1, int var2) throws GDSException;

    public native void native_isc_dsql_exec_immed2(IscDbHandle var1, IscTrHandle var2, byte[] var3, int var4, XSQLDA var5, XSQLDA var6) throws GDSException;

    public native void native_isc_dsql_execute2(IscTrHandle var1, IscStmtHandle var2, int var3, XSQLDA var4, XSQLDA var5) throws GDSException;

    public native boolean native_isc_dsql_fetch(IscStmtHandle var1, int var2, XSQLDA var3, int var4) throws GDSException;

    public native void native_isc_dsql_free_statement(IscStmtHandle var1, int var2) throws GDSException;

    public native XSQLDA native_isc_dsql_prepare(IscTrHandle var1, IscStmtHandle var2, byte[] var3, int var4) throws GDSException;

    public native void native_isc_dsql_set_cursor_name(IscStmtHandle var1, String var2, int var3) throws GDSException;

    public native byte[] native_isc_dsql_sql_info(IscStmtHandle var1, byte[] var2, int var3) throws GDSException;

    public native byte[] native_isc_get_segment(IscBlobHandle var1, int var2) throws GDSException;

    public native void native_isc_open_blob2(IscDbHandle var1, IscTrHandle var2, IscBlobHandle var3, byte[] var4);

    public native void native_isc_prepare_transaction(IscTrHandle var1) throws GDSException;

    public native void native_isc_prepare_transaction2(IscTrHandle var1, byte[] var2) throws GDSException;

    public native void native_isc_put_segment(IscBlobHandle var1, byte[] var2) throws GDSException;

    public native void native_isc_rollback_retaining(IscTrHandle var1) throws GDSException;

    public native void native_isc_rollback_transaction(IscTrHandle var1) throws GDSException;

    public native void native_isc_seek_blob(isc_blob_handle_impl var1, int var2, int var3) throws GDSException;

    public native void native_isc_service_attach(String var1, IscSvcHandle var2, byte[] var3) throws GDSException;

    public native void native_isc_service_detach(IscSvcHandle var1) throws GDSException;

    public native void native_isc_service_query(IscSvcHandle var1, byte[] var2, byte[] var3, byte[] var4) throws GDSException;

    public native void native_isc_service_start(IscSvcHandle var1, byte[] var2) throws GDSException;

    public native void native_isc_start_transaction(IscTrHandle var1, IscDbHandle var2, byte[] var3) throws GDSException;

    public native void native_isc_reconnect_transaction(IscDbHandle var1, IscTrHandle var2, byte[] var3) throws GDSException;

    public native byte[] native_isc_transaction_info(IscTrHandle var1, byte[] var2, int var3) throws GDSException;

    static {
        JniGDSImpl.initJNIBridge();
    }
}

