/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.jni;

import java.io.UnsupportedEncodingException;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.IscBlobHandle;
import org.firebirdsql.gds.IscDbHandle;
import org.firebirdsql.gds.IscStmtHandle;
import org.firebirdsql.gds.IscSvcHandle;
import org.firebirdsql.gds.IscTrHandle;
import org.firebirdsql.gds.ServiceParameterBuffer;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.XSQLDA;
import org.firebirdsql.gds.impl.AbstractGDS;
import org.firebirdsql.gds.impl.DatabaseParameterBufferExtension;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.impl.jni.BlobParameterBufferImp;
import org.firebirdsql.gds.impl.jni.DatabaseParameterBufferImp;
import org.firebirdsql.gds.impl.jni.ServiceParameterBufferImp;
import org.firebirdsql.gds.impl.jni.ServiceRequestBufferImp;
import org.firebirdsql.gds.impl.jni.TransactionParameterBufferImpl;
import org.firebirdsql.gds.impl.jni.isc_blob_handle_impl;
import org.firebirdsql.gds.impl.jni.isc_db_handle_impl;
import org.firebirdsql.gds.impl.jni.isc_stmt_handle_impl;
import org.firebirdsql.gds.impl.jni.isc_svc_handle_impl;
import org.firebirdsql.gds.impl.jni.isc_tr_handle_impl;
import org.firebirdsql.jdbc.FBConnectionHelper;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public abstract class BaseGDSImpl
extends AbstractGDS {
    private static Logger log = LoggerFactory.getLogger(BaseGDSImpl.class, false);
    protected static final byte[] DESCRIBE_DATABASE_INFO_BLOCK = new byte[]{62, 103, 32, 33, 11, 102, 13, 1};
    private static byte[] stmtInfo = new byte[]{23, 21, 1};
    private static int INFO_SIZE = 128;
    public int isc_api_handle;

    public BaseGDSImpl() {
    }

    public BaseGDSImpl(GDSType gdsType) {
        super(gdsType);
    }

    protected abstract String getServerUrl(String var1) throws GDSException;

    public BlobParameterBuffer createBlobParameterBuffer() {
        return new BlobParameterBufferImp();
    }

    public DatabaseParameterBuffer createDatabaseParameterBuffer() {
        return new DatabaseParameterBufferImp();
    }

    public synchronized IscBlobHandle createIscBlobHandle() {
        return new isc_blob_handle_impl();
    }

    public synchronized IscDbHandle createIscDbHandle() {
        return new isc_db_handle_impl();
    }

    public synchronized IscStmtHandle createIscStmtHandle() {
        return new isc_stmt_handle_impl();
    }

    public IscSvcHandle createIscSvcHandle() {
        return new isc_svc_handle_impl();
    }

    public synchronized IscTrHandle createIscTrHandle() {
        return new isc_tr_handle_impl();
    }

    public ServiceParameterBuffer createServiceParameterBuffer() {
        return new ServiceParameterBufferImp();
    }

    public ServiceRequestBuffer createServiceRequestBuffer(int taskIdentifier) {
        return new ServiceRequestBufferImp(taskIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscAttachDatabase(String file_name, IscDbHandle db_handle, DatabaseParameterBuffer databaseParameterBuffer) throws GDSException {
        if (db_handle == null) {
            throw new GDSException(0x14000004);
        }
        DatabaseParameterBuffer cleanDPB = ((DatabaseParameterBufferExtension)databaseParameterBuffer).removeExtensionParams();
        byte[] dpbBytes = databaseParameterBuffer == null ? null : ((DatabaseParameterBufferImp)cleanDPB).getBytesForNativeCode();
        BaseGDSImpl baseGDSImpl = this;
        synchronized (baseGDSImpl) {
            this.native_isc_attach_database(this.getServerUrl(file_name), db_handle, dpbBytes);
        }
        this.parseAttachDatabaseInfo(this.iscDatabaseInfo(db_handle, DESCRIBE_DATABASE_INFO_BLOCK, 1024), db_handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] iscBlobInfo(IscBlobHandle handle, byte[] items, int buffer_length) throws GDSException {
        isc_blob_handle_impl blob;
        isc_blob_handle_impl isc_blob_handle_impl2 = blob = (isc_blob_handle_impl)handle;
        synchronized (isc_blob_handle_impl2) {
            return this.native_isc_blob_info(blob, items, buffer_length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscCloseBlob(IscBlobHandle blob_handle) throws GDSException {
        isc_blob_handle_impl blob = (isc_blob_handle_impl)blob_handle;
        isc_db_handle_impl db = blob.getDb();
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        isc_tr_handle_impl tr = blob.getTr();
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = ((isc_blob_handle_impl)blob_handle).getDb();
        synchronized (isc_db_handle_impl2) {
            this.native_isc_close_blob(blob_handle);
        }
        tr.removeBlob(blob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscCommitRetaining(IscTrHandle tr_handle) throws GDSException {
        isc_db_handle_impl db;
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)tr.getDbHandle();
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 2 && tr.getState() != 4) {
                throw new GDSException(335544468);
            }
            tr.setState(5);
            this.native_isc_commit_retaining(tr_handle);
            tr.setState(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscCommitTransaction(IscTrHandle tr_handle) throws GDSException {
        isc_db_handle_impl db;
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)tr.getDbHandle();
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 2 && tr.getState() != 4) {
                throw new GDSException(335544468);
            }
            tr.setState(5);
            this.native_isc_commit_transaction(tr_handle);
            tr.setState(0);
            tr.unsetDbHandle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscCreateBlob2(IscDbHandle db_handle, IscTrHandle tr_handle, IscBlobHandle blob_handle, BlobParameterBuffer blobParameterBuffer) throws GDSException {
        isc_db_handle_impl db = (isc_db_handle_impl)db_handle;
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        isc_blob_handle_impl blob = (isc_blob_handle_impl)blob_handle;
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        if (tr == null) {
            throw new GDSException(335544332);
        }
        if (blob == null) {
            throw new GDSException(335544328);
        }
        byte[] bpb = blobParameterBuffer == null ? null : ((BlobParameterBufferImp)blobParameterBuffer).getBytesForNativeCode();
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            this.native_isc_create_blob2(db_handle, tr_handle, blob_handle, bpb);
            blob.setDb(db);
            blob.setTr(tr);
            tr.addBlob(blob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscCreateDatabase(String file_name, IscDbHandle db_handle, DatabaseParameterBuffer databaseParameterBuffer) throws GDSException {
        if (db_handle == null) {
            throw new GDSException(0x14000004);
        }
        byte[] dpbBytes = databaseParameterBuffer == null ? null : ((DatabaseParameterBufferImp)databaseParameterBuffer).getBytesForNativeCode();
        BaseGDSImpl baseGDSImpl = this;
        synchronized (baseGDSImpl) {
            this.native_isc_create_database(this.getServerUrl(file_name), db_handle, dpbBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] iscDatabaseInfo(IscDbHandle db_handle, byte[] items, int buffer_length) throws GDSException {
        IscDbHandle iscDbHandle = db_handle;
        synchronized (iscDbHandle) {
            byte[] returnValue = new byte[buffer_length];
            this.native_isc_database_info(db_handle, items.length, items, buffer_length, returnValue);
            return returnValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscDetachDatabase(IscDbHandle db_handle) throws GDSException {
        isc_db_handle_impl db = (isc_db_handle_impl)db_handle;
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        BaseGDSImpl baseGDSImpl = this;
        synchronized (baseGDSImpl) {
            this.native_isc_detach_database(db_handle);
            ((isc_db_handle_impl)db_handle).invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscDropDatabase(IscDbHandle db_handle) throws GDSException {
        if (db_handle == null) {
            throw new GDSException(0x14000004);
        }
        BaseGDSImpl baseGDSImpl = this;
        synchronized (baseGDSImpl) {
            this.native_isc_drop_database(db_handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscDsqlAllocateStatement(IscDbHandle db_handle, IscStmtHandle stmt_handle) throws GDSException {
        isc_db_handle_impl db = (isc_db_handle_impl)db_handle;
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        if (db_handle == null) {
            throw new GDSException(0x14000004);
        }
        if (stmt_handle == null) {
            throw new GDSException(335544327);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            this.native_isc_dsql_allocate_statement(db_handle, stmt_handle);
            stmt.setRsr_rdb((isc_db_handle_impl)db_handle);
            stmt.setAllRowsFetched(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSQLDA iscDsqlDescribe(IscStmtHandle stmt_handle, int da_version) throws GDSException {
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        if (stmt == null) {
            throw new GDSException(335544327);
        }
        isc_db_handle_impl isc_db_handle_impl2 = stmt.getRsr_rdb();
        synchronized (isc_db_handle_impl2) {
            stmt.setInSqlda(this.native_isc_dsql_describe(stmt_handle, da_version));
            return stmt_handle.getInSqlda();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSQLDA iscDsqlDescribeBind(IscStmtHandle stmt_handle, int da_version) throws GDSException {
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        isc_db_handle_impl isc_db_handle_impl2 = stmt.getRsr_rdb();
        synchronized (isc_db_handle_impl2) {
            stmt.setInSqlda(this.native_isc_dsql_describe_bind(stmt_handle, da_version));
            return stmt_handle.getInSqlda();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscDsqlExecImmed2(IscDbHandle db_handle, IscTrHandle tr_handle, byte[] statement, int dialect, XSQLDA in_xsqlda, XSQLDA out_xsqlda) throws GDSException {
        IscDbHandle iscDbHandle = db_handle;
        synchronized (iscDbHandle) {
            this.native_isc_dsql_exec_immed2(db_handle, tr_handle, this.getZeroTerminatedArray(statement), dialect, in_xsqlda, out_xsqlda);
        }
    }

    public void iscDsqlExecImmed2(IscDbHandle db_handle, IscTrHandle tr_handle, String statement, int dialect, XSQLDA in_xsqlda, XSQLDA out_xsqlda) throws GDSException {
        this.iscDsqlExecImmed2(db_handle, tr_handle, statement, "NONE", dialect, in_xsqlda, out_xsqlda);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscDsqlExecImmed2(IscDbHandle db_handle, IscTrHandle tr_handle, String statement, String encoding, int dialect, XSQLDA in_xsqlda, XSQLDA out_xsqlda) throws GDSException {
        try {
            IscDbHandle iscDbHandle = db_handle;
            synchronized (iscDbHandle) {
                this.native_isc_dsql_exec_immed2(db_handle, tr_handle, this.getByteArrayForString(statement, encoding), dialect, in_xsqlda, out_xsqlda);
            }
        }
        catch (UnsupportedEncodingException e2) {
            throw new GDSException("Unsupported encoding. " + e2.getMessage());
        }
    }

    public void iscDsqlExecute(IscTrHandle tr_handle, IscStmtHandle stmt_handle, int da_version, XSQLDA xsqlda) throws GDSException {
        this.iscDsqlExecute2(tr_handle, stmt_handle, da_version, xsqlda, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscDsqlExecute2(IscTrHandle tr_handle, IscStmtHandle stmt_handle, int da_version, XSQLDA in_xsqlda, XSQLDA out_xsqlda) throws GDSException {
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        isc_db_handle_impl isc_db_handle_impl2 = stmt.getRsr_rdb();
        synchronized (isc_db_handle_impl2) {
            this.native_isc_dsql_execute2(tr_handle, stmt_handle, da_version, in_xsqlda, out_xsqlda);
            if (stmt.getOutSqlda() != null) {
                stmt.notifyOpenResultSet();
            }
            if (out_xsqlda != null) {
                stmt.ensureCapacity(1);
                this.readSQLData(out_xsqlda, stmt);
                stmt.setAllRowsFetched(true);
                stmt.setSingletonResult(true);
            } else {
                stmt.setAllRowsFetched(false);
                stmt.setSingletonResult(false);
            }
        }
    }

    public void iscDsqlExecuteImmediate(IscDbHandle db_handle, IscTrHandle tr_handle, byte[] statement, int dialect, XSQLDA xsqlda) throws GDSException {
        this.iscDsqlExecImmed2(db_handle, tr_handle, statement, dialect, xsqlda, null);
    }

    public void iscDsqlExecuteImmediate(IscDbHandle db_handle, IscTrHandle tr_handle, String statement, int dialect, XSQLDA xsqlda) throws GDSException {
        this.iscDsqlExecImmed2(db_handle, tr_handle, statement, dialect, xsqlda, null);
    }

    public void iscDsqlExecuteImmediate(IscDbHandle db_handle, IscTrHandle tr_handle, String statement, String encoding, int dialect, XSQLDA xsqlda) throws GDSException {
        this.iscDsqlExecImmed2(db_handle, tr_handle, statement, encoding, dialect, xsqlda, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscDsqlFetch(IscStmtHandle stmt_handle, int da_version, XSQLDA xsqlda, int fetchSize) throws GDSException {
        isc_db_handle_impl db;
        fetchSize = 1;
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        isc_db_handle_impl isc_db_handle_impl2 = db = stmt.getRsr_rdb();
        synchronized (isc_db_handle_impl2) {
            if (stmt_handle == null) {
                throw new GDSException(335544327);
            }
            if (xsqlda == null) {
                throw new GDSException(335544583);
            }
            if (fetchSize <= 0) {
                throw new GDSException(335544583);
            }
            stmt.ensureCapacity(fetchSize);
            for (int i2 = 0; i2 < fetchSize; ++i2) {
                try {
                    boolean isRowPresent = this.native_isc_dsql_fetch(stmt_handle, da_version, xsqlda, fetchSize);
                    if (isRowPresent) {
                        this.readSQLData(xsqlda, stmt);
                        continue;
                    }
                    stmt.setAllRowsFetched(true);
                    return;
                }
                finally {
                    stmt.notifyOpenResultSet();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscDsqlFreeStatement(IscStmtHandle stmt_handle, int option) throws GDSException {
        isc_db_handle_impl db;
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        isc_db_handle_impl isc_db_handle_impl2 = db = stmt.getRsr_rdb();
        synchronized (isc_db_handle_impl2) {
            if (stmt_handle == null) {
                throw new GDSException(335544327);
            }
            if (stmt.isSingletonResult() && option == 1) {
                return;
            }
            if (option == 2) {
                stmt.setInSqlda(null);
                stmt.setOutSqlda(null);
                stmt.setRsr_rdb(null);
            }
            this.native_isc_dsql_free_statement(stmt_handle, option);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSQLDA iscDsqlPrepare(IscTrHandle tr_handle, IscStmtHandle stmt_handle, byte[] statement, int dialect) throws GDSException {
        isc_db_handle_impl db;
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        isc_db_handle_impl isc_db_handle_impl2 = db = stmt.getRsr_rdb();
        synchronized (isc_db_handle_impl2) {
            if (tr_handle == null) {
                throw new GDSException(335544332);
            }
            if (stmt_handle == null) {
                throw new GDSException(335544327);
            }
            stmt.setInSqlda(null);
            stmt.setOutSqlda(null);
            stmt.setOutSqlda(this.native_isc_dsql_prepare(tr_handle, stmt_handle, this.getZeroTerminatedArray(statement), dialect));
            return stmt_handle.getOutSqlda();
        }
    }

    public XSQLDA iscDsqlPrepare(IscTrHandle tr_handle, IscStmtHandle stmt_handle, String statement, int dialect) throws GDSException {
        return this.iscDsqlPrepare(tr_handle, stmt_handle, statement, "NONE", dialect);
    }

    public XSQLDA iscDsqlPrepare(IscTrHandle tr_handle, IscStmtHandle stmt_handle, String statement, String encoding, int dialect) throws GDSException {
        try {
            return this.iscDsqlPrepare(tr_handle, stmt_handle, this.getByteArrayForString(statement, encoding), dialect);
        }
        catch (UnsupportedEncodingException e2) {
            throw new GDSException("Unsupported encoding. " + e2.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscDsqlSetCursorName(IscStmtHandle stmt_handle, String cursor_name, int type) throws GDSException {
        isc_db_handle_impl db;
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        isc_db_handle_impl isc_db_handle_impl2 = db = stmt.getRsr_rdb();
        synchronized (isc_db_handle_impl2) {
            if (stmt_handle == null) {
                throw new GDSException(335544327);
            }
            this.native_isc_dsql_set_cursor_name(stmt_handle, cursor_name, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] iscDsqlSqlInfo(IscStmtHandle stmt_handle, byte[] items, int buffer_length) throws GDSException {
        isc_db_handle_impl isc_db_handle_impl2 = ((isc_stmt_handle_impl)stmt_handle).getRsr_rdb();
        synchronized (isc_db_handle_impl2) {
            return this.native_isc_dsql_sql_info(stmt_handle, items, buffer_length);
        }
    }

    public byte[] iscExpandDpb(byte[] dpb, int dpb_length, int param, Object[] params) throws GDSException {
        return dpb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] iscGetSegment(IscBlobHandle blob, int maxread) throws GDSException {
        isc_db_handle_impl isc_db_handle_impl2 = ((isc_blob_handle_impl)blob).getDb();
        synchronized (isc_db_handle_impl2) {
            return this.native_isc_get_segment(blob, maxread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscOpenBlob2(IscDbHandle db_handle, IscTrHandle tr_handle, IscBlobHandle blob_handle, BlobParameterBuffer blobParameterBuffer) throws GDSException {
        isc_db_handle_impl db = (isc_db_handle_impl)db_handle;
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        isc_blob_handle_impl blob = (isc_blob_handle_impl)blob_handle;
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        if (tr == null) {
            throw new GDSException(335544332);
        }
        if (blob == null) {
            throw new GDSException(335544328);
        }
        byte[] bpb = blobParameterBuffer == null ? null : ((BlobParameterBufferImp)blobParameterBuffer).getBytesForNativeCode();
        isc_db_handle_impl isc_db_handle_impl2 = db;
        synchronized (isc_db_handle_impl2) {
            this.native_isc_open_blob2(db_handle, tr_handle, blob_handle, bpb);
            blob.setDb(db);
            blob.setTr(tr);
            tr.addBlob(blob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscPrepareTransaction(IscTrHandle tr_handle) throws GDSException {
        isc_db_handle_impl db;
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)tr.getDbHandle();
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 2) {
                throw new GDSException(335544468);
            }
            tr.setState(3);
            this.native_isc_prepare_transaction(tr_handle);
            tr.setState(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscPrepareTransaction2(IscTrHandle tr_handle, byte[] bytes) throws GDSException {
        isc_db_handle_impl db;
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)tr.getDbHandle();
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 2) {
                throw new GDSException(335544468);
            }
            tr.setState(3);
            this.native_isc_prepare_transaction2(tr_handle, bytes);
            tr.setState(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscPutSegment(IscBlobHandle blob_handle, byte[] buffer) throws GDSException {
        isc_db_handle_impl isc_db_handle_impl2 = ((isc_blob_handle_impl)blob_handle).getDb();
        synchronized (isc_db_handle_impl2) {
            this.native_isc_put_segment(blob_handle, buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscReconnectTransaction(IscTrHandle tr_handle, IscDbHandle db_handle, long transactionId) throws GDSException {
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        byte[] buffer = new byte[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            buffer[i2] = (byte)(transactionId >>> i2 * 8);
        }
        IscDbHandle iscDbHandle = db_handle;
        synchronized (iscDbHandle) {
            tr.setState(1);
            this.native_isc_reconnect_transaction(db_handle, tr_handle, buffer);
            tr.setDbHandle((isc_db_handle_impl)db_handle);
            tr.setState(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscRollbackRetaining(IscTrHandle tr_handle) throws GDSException {
        isc_db_handle_impl db;
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)tr.getDbHandle();
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() != 2 && tr.getState() != 4) {
                throw new GDSException(335544468);
            }
            tr.setState(6);
            this.native_isc_rollback_retaining(tr_handle);
            tr.setState(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscRollbackTransaction(IscTrHandle tr_handle) throws GDSException {
        isc_db_handle_impl db;
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        if (tr == null) {
            throw new GDSException(335544332);
        }
        isc_db_handle_impl isc_db_handle_impl2 = db = (isc_db_handle_impl)tr.getDbHandle();
        synchronized (isc_db_handle_impl2) {
            if (tr.getState() == 0) {
                throw new GDSException(335544468);
            }
            tr.setState(6);
            this.native_isc_rollback_transaction(tr_handle);
            tr.setState(0);
            tr.unsetDbHandle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] iscTransactionInformation(IscTrHandle trHandle, byte[] requestBuffer, int bufferLen) throws GDSException {
        IscTrHandle iscTrHandle = trHandle;
        synchronized (iscTrHandle) {
            return this.native_isc_transaction_info(trHandle, requestBuffer, bufferLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscSeekBlob(IscBlobHandle handle, int position, int mode) throws GDSException {
        isc_blob_handle_impl blob = (isc_blob_handle_impl)handle;
        IscBlobHandle iscBlobHandle = handle;
        synchronized (iscBlobHandle) {
            this.native_isc_seek_blob(blob, position, mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscServiceAttach(String service, IscSvcHandle serviceHandle, ServiceParameterBuffer serviceParameterBuffer) throws GDSException {
        ServiceParameterBufferImp serviceParameterBufferImp = (ServiceParameterBufferImp)serviceParameterBuffer;
        byte[] serviceParameterBufferBytes = serviceParameterBufferImp == null ? null : serviceParameterBufferImp.toByteArray();
        IscSvcHandle iscSvcHandle = serviceHandle;
        synchronized (iscSvcHandle) {
            if (serviceHandle.isValid()) {
                throw new GDSException("serviceHandle is already attached.");
            }
            this.native_isc_service_attach(service, serviceHandle, serviceParameterBufferBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscServiceDetach(IscSvcHandle serviceHandle) throws GDSException {
        IscSvcHandle iscSvcHandle = serviceHandle;
        synchronized (iscSvcHandle) {
            if (serviceHandle.isNotValid()) {
                throw new GDSException("serviceHandle is not attached.");
            }
            this.native_isc_service_detach(serviceHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscServiceQuery(IscSvcHandle serviceHandle, ServiceParameterBuffer serviceParameterBuffer, ServiceRequestBuffer serviceRequestBuffer, byte[] resultBuffer) throws GDSException {
        ServiceParameterBufferImp serviceParameterBufferImp = (ServiceParameterBufferImp)serviceParameterBuffer;
        byte[] serviceParameterBufferBytes = serviceParameterBufferImp == null ? null : serviceParameterBufferImp.toByteArray();
        ServiceRequestBufferImp serviceRequestBufferImp = (ServiceRequestBufferImp)serviceRequestBuffer;
        byte[] serviceRequestBufferBytes = serviceRequestBufferImp == null ? null : serviceRequestBufferImp.toByteArray();
        IscSvcHandle iscSvcHandle = serviceHandle;
        synchronized (iscSvcHandle) {
            if (serviceHandle.isNotValid()) {
                throw new GDSException("serviceHandle is not attached.");
            }
            this.native_isc_service_query(serviceHandle, serviceParameterBufferBytes, serviceRequestBufferBytes, resultBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscServiceStart(IscSvcHandle serviceHandle, ServiceRequestBuffer serviceRequestBuffer) throws GDSException {
        ServiceRequestBufferImp serviceRequestBufferImp = (ServiceRequestBufferImp)serviceRequestBuffer;
        byte[] serviceRequestBufferBytes = serviceRequestBufferImp == null ? null : serviceRequestBufferImp.toByteArray();
        IscSvcHandle iscSvcHandle = serviceHandle;
        synchronized (iscSvcHandle) {
            if (serviceHandle.isNotValid()) {
                throw new GDSException("serviceHandle is not attached.");
            }
            this.native_isc_service_start(serviceHandle, serviceRequestBufferBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iscStartTransaction(IscTrHandle tr_handle, IscDbHandle db_handle, TransactionParameterBuffer tpb) throws GDSException {
        isc_tr_handle_impl tr = (isc_tr_handle_impl)tr_handle;
        isc_db_handle_impl db = (isc_db_handle_impl)db_handle;
        TransactionParameterBufferImpl tpbImpl = (TransactionParameterBufferImpl)tpb;
        if (tr == null) {
            throw new GDSException(335544332);
        }
        if (db == null) {
            throw new GDSException(0x14000004);
        }
        IscDbHandle iscDbHandle = db_handle;
        synchronized (iscDbHandle) {
            if (tr.getState() != 0) {
                throw new GDSException(335544468);
            }
            tr.setState(1);
            byte[] arg = tpbImpl.getBytesForNativeCode();
            this.native_isc_start_transaction(tr_handle, db_handle, arg);
            tr.setDbHandle((isc_db_handle_impl)db_handle);
            tr.setState(2);
        }
    }

    public int iscVaxInteger(byte[] buffer, int pos, int length) {
        int shift = 0;
        int value = 0;
        int i2 = pos;
        while (--length >= 0) {
            value += (buffer[i2++] & 0xFF) << shift;
            shift += 8;
        }
        return value;
    }

    public int iscVaxInteger2(byte[] buffer, int pos) {
        return buffer[pos] & 0xFF | (buffer[pos + 1] & 0xFF) << 8;
    }

    public abstract void native_isc_attach_database(String var1, IscDbHandle var2, byte[] var3);

    public abstract byte[] native_isc_blob_info(isc_blob_handle_impl var1, byte[] var2, int var3) throws GDSException;

    public abstract void native_isc_close_blob(IscBlobHandle var1) throws GDSException;

    public abstract void native_isc_commit_retaining(IscTrHandle var1) throws GDSException;

    public abstract void native_isc_commit_transaction(IscTrHandle var1) throws GDSException;

    public abstract void native_isc_create_blob2(IscDbHandle var1, IscTrHandle var2, IscBlobHandle var3, byte[] var4);

    public abstract void native_isc_create_database(String var1, IscDbHandle var2, byte[] var3);

    public abstract void native_isc_database_info(IscDbHandle var1, int var2, byte[] var3, int var4, byte[] var5) throws GDSException;

    public abstract void native_isc_detach_database(IscDbHandle var1) throws GDSException;

    public abstract void native_isc_drop_database(IscDbHandle var1) throws GDSException;

    public abstract void native_isc_dsql_alloc_statement2(IscDbHandle var1, IscStmtHandle var2) throws GDSException;

    public abstract void native_isc_dsql_allocate_statement(IscDbHandle var1, IscStmtHandle var2) throws GDSException;

    public abstract XSQLDA native_isc_dsql_describe(IscStmtHandle var1, int var2) throws GDSException;

    public abstract XSQLDA native_isc_dsql_describe_bind(IscStmtHandle var1, int var2) throws GDSException;

    public abstract void native_isc_dsql_exec_immed2(IscDbHandle var1, IscTrHandle var2, byte[] var3, int var4, XSQLDA var5, XSQLDA var6) throws GDSException;

    public abstract void native_isc_dsql_execute2(IscTrHandle var1, IscStmtHandle var2, int var3, XSQLDA var4, XSQLDA var5) throws GDSException;

    public abstract boolean native_isc_dsql_fetch(IscStmtHandle var1, int var2, XSQLDA var3, int var4) throws GDSException;

    public abstract void native_isc_dsql_free_statement(IscStmtHandle var1, int var2) throws GDSException;

    public abstract XSQLDA native_isc_dsql_prepare(IscTrHandle var1, IscStmtHandle var2, byte[] var3, int var4) throws GDSException;

    public abstract void native_isc_dsql_set_cursor_name(IscStmtHandle var1, String var2, int var3) throws GDSException;

    public abstract byte[] native_isc_dsql_sql_info(IscStmtHandle var1, byte[] var2, int var3) throws GDSException;

    public abstract byte[] native_isc_get_segment(IscBlobHandle var1, int var2) throws GDSException;

    public abstract void native_isc_open_blob2(IscDbHandle var1, IscTrHandle var2, IscBlobHandle var3, byte[] var4);

    public abstract void native_isc_prepare_transaction(IscTrHandle var1) throws GDSException;

    public abstract void native_isc_prepare_transaction2(IscTrHandle var1, byte[] var2) throws GDSException;

    public abstract void native_isc_put_segment(IscBlobHandle var1, byte[] var2) throws GDSException;

    public abstract void native_isc_rollback_retaining(IscTrHandle var1) throws GDSException;

    public abstract void native_isc_rollback_transaction(IscTrHandle var1) throws GDSException;

    public abstract void native_isc_seek_blob(isc_blob_handle_impl var1, int var2, int var3) throws GDSException;

    public abstract void native_isc_service_attach(String var1, IscSvcHandle var2, byte[] var3) throws GDSException;

    public abstract void native_isc_service_detach(IscSvcHandle var1) throws GDSException;

    public abstract void native_isc_service_query(IscSvcHandle var1, byte[] var2, byte[] var3, byte[] var4) throws GDSException;

    public abstract void native_isc_service_start(IscSvcHandle var1, byte[] var2) throws GDSException;

    public abstract void native_isc_start_transaction(IscTrHandle var1, IscDbHandle var2, byte[] var3) throws GDSException;

    public abstract void native_isc_reconnect_transaction(IscDbHandle var1, IscTrHandle var2, byte[] var3) throws GDSException;

    public abstract byte[] native_isc_transaction_info(IscTrHandle var1, byte[] var2, int var3) throws GDSException;

    public TransactionParameterBuffer newTransactionParameterBuffer() {
        return new TransactionParameterBufferImpl();
    }

    private void parseAttachDatabaseInfo(byte[] info, IscDbHandle handle) throws GDSException {
        boolean debug;
        boolean bl2 = debug = log != null && log.isDebugEnabled();
        if (debug) {
            log.debug("parseDatabaseInfo: first 2 bytes are " + this.iscVaxInteger(info, 0, 2) + " or: " + info[0] + ", " + info[1]);
        }
        int value = 0;
        int len = 0;
        int i2 = 0;
        isc_db_handle_impl db = (isc_db_handle_impl)handle;
        block10: while (info[i2] != 1) {
            switch (info[i2++]) {
                case 62: {
                    len = this.iscVaxInteger(info, i2, 2);
                    value = this.iscVaxInteger(info, i2 += 2, len);
                    i2 += len;
                    db.setDialect(value);
                    if (!debug) continue block10;
                    log.debug("isc_info_db_sql_dialect:" + value);
                    continue block10;
                }
                case 32: {
                    len = this.iscVaxInteger(info, i2, 2);
                    value = this.iscVaxInteger(info, i2 += 2, len);
                    i2 += len;
                    db.setODSMajorVersion(value);
                    if (!debug) continue block10;
                    log.debug("isc_info_ods_version:" + value);
                    continue block10;
                }
                case 33: {
                    len = this.iscVaxInteger(info, i2, 2);
                    value = this.iscVaxInteger(info, i2 += 2, len);
                    i2 += len;
                    db.setODSMinorVersion(value);
                    if (!debug) continue block10;
                    log.debug("isc_info_ods_minor_version:" + value);
                    continue block10;
                }
                case 103: {
                    len = this.iscVaxInteger(info, i2, 2);
                    byte[] fb_vers = new byte[len - 2];
                    System.arraycopy(info, (i2 += 2) + 2, fb_vers, 0, len - 2);
                    i2 += len;
                    String fb_versS = new String(fb_vers);
                    db.setVersion(fb_versS);
                    if (!debug) continue block10;
                    log.debug("isc_info_firebird_version:" + fb_versS);
                    continue block10;
                }
                case 11: {
                    len = this.iscVaxInteger(info, i2, 2);
                    byte[] impl = new byte[len - 2];
                    System.arraycopy(info, (i2 += 2) + 2, impl, 0, len - 2);
                    i2 += len;
                    continue block10;
                }
                case 102: {
                    len = this.iscVaxInteger(info, i2, 2);
                    byte[] db_class = new byte[len - 2];
                    System.arraycopy(info, (i2 += 2) + 2, db_class, 0, len - 2);
                    i2 += len;
                    continue block10;
                }
                case 13: {
                    len = this.iscVaxInteger(info, i2, 2);
                    byte[] base_level = new byte[len - 2];
                    System.arraycopy(info, (i2 += 2) + 2, base_level, 0, len - 2);
                    i2 += len;
                    continue block10;
                }
                case 2: {
                    if (debug) {
                        log.debug("isc_info_truncated ");
                    }
                    return;
                }
            }
            throw new GDSException(335544583);
        }
    }

    public void readSQLData(XSQLDA xsqlda, isc_stmt_handle_impl stmt) {
        int numCols = xsqlda.sqld;
        byte[][] row = new byte[numCols][];
        for (int i2 = 0; i2 < numCols; ++i2) {
            row[i2] = xsqlda.sqlvar[i2].sqldata;
        }
        if (stmt != null) {
            stmt.addRow(row);
        }
    }

    protected byte[] getByteArrayForString(String statement, String encoding) throws UnsupportedEncodingException {
        String javaEncoding = null;
        if (encoding != null && !"NONE".equals(encoding)) {
            javaEncoding = FBConnectionHelper.getJavaEncoding(encoding);
        }
        byte[] stringBytes = javaEncoding != null ? statement.getBytes(javaEncoding) : statement.getBytes();
        return this.getZeroTerminatedArray(stringBytes);
    }

    protected byte[] getZeroTerminatedArray(byte[] stringBytes) {
        byte[] zeroTermBytes = new byte[stringBytes.length + 1];
        System.arraycopy(stringBytes, 0, zeroTermBytes, 0, stringBytes.length);
        zeroTermBytes[stringBytes.length] = 0;
        return zeroTermBytes;
    }

    public void getSqlCounts(IscStmtHandle stmt_handle) throws GDSException {
        byte type;
        isc_stmt_handle_impl stmt = (isc_stmt_handle_impl)stmt_handle;
        byte[] buffer = this.iscDsqlSqlInfo(stmt, stmtInfo, INFO_SIZE);
        int pos = 0;
        block10: while ((type = buffer[pos++]) != 1) {
            int length = this.iscVaxInteger2(buffer, pos);
            pos += 2;
            switch (type) {
                case 23: {
                    byte t2;
                    while ((t2 = buffer[pos++]) != 1) {
                        int l2 = this.iscVaxInteger2(buffer, pos);
                        pos += 2;
                        switch (t2) {
                            case 14: {
                                stmt.setInsertCount(this.iscVaxInteger(buffer, pos, l2));
                                break;
                            }
                            case 15: {
                                stmt.setUpdateCount(this.iscVaxInteger(buffer, pos, l2));
                                break;
                            }
                            case 16: {
                                stmt.setDeleteCount(this.iscVaxInteger(buffer, pos, l2));
                                break;
                            }
                            case 13: {
                                stmt.setSelectCount(this.iscVaxInteger(buffer, pos, l2));
                                break;
                            }
                        }
                        pos += l2;
                    }
                    continue block10;
                }
                case 21: {
                    stmt.setStatementType(this.iscVaxInteger(buffer, pos, length));
                    pos += length;
                    continue block10;
                }
            }
            pos += length;
        }
    }
}

