/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.gds.Parameter;
import org.firebirdsql.gds.ParameterBuffer;
import org.firebirdsql.gds.impl.ParameterBufferMetaData;
import org.firebirdsql.gds.impl.argument.Argument;
import org.firebirdsql.gds.impl.argument.BigIntArgument;
import org.firebirdsql.gds.impl.argument.ByteArrayArgument;
import org.firebirdsql.gds.impl.argument.NumericArgument;
import org.firebirdsql.gds.impl.argument.SingleItem;
import org.firebirdsql.gds.impl.argument.StringArgument;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.impl.wire.Xdrable;

public abstract class ParameterBufferBase
implements ParameterBuffer,
Serializable {
    private final List<Argument> arguments = new ArrayList<Argument>();
    private final String defaultEncodingName;
    private final ParameterBufferMetaData parameterBufferMetaData;
    private transient Encoding defaultEncoding;

    protected ParameterBufferBase(ParameterBufferMetaData parameterBufferMetaData) {
        this(parameterBufferMetaData, EncodingFactory.getPlatformEncoding());
    }

    protected ParameterBufferBase(ParameterBufferMetaData parameterBufferMetaData, Encoding defaultEncoding) {
        this.parameterBufferMetaData = parameterBufferMetaData;
        this.defaultEncodingName = defaultEncoding.getCharsetName();
        this.defaultEncoding = defaultEncoding;
        parameterBufferMetaData.addPreamble(this);
    }

    public final Encoding getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public final ParameterBufferMetaData getParameterBufferMetaData() {
        return this.parameterBufferMetaData;
    }

    @Override
    public final int getType() {
        return this.parameterBufferMetaData.getType();
    }

    @Override
    public final void addArgument(int argumentType, String value) {
        this.addArgument(argumentType, value, this.defaultEncoding);
    }

    @Override
    public final void addArgument(int argumentType, String value, Encoding encoding) {
        this.getArgumentsList().add(new StringArgument(argumentType, this.parameterBufferMetaData.getStringArgumentType(argumentType), value, encoding));
    }

    @Override
    public final void addArgument(int argumentType, int value) {
        this.getArgumentsList().add(new NumericArgument(argumentType, this.parameterBufferMetaData.getIntegerArgumentType(argumentType), value));
    }

    @Override
    public final void addArgument(int argumentType, long value) {
        this.getArgumentsList().add(new BigIntArgument(argumentType, this.parameterBufferMetaData.getIntegerArgumentType(argumentType), value));
    }

    @Override
    public final void addArgument(int argumentType) {
        this.getArgumentsList().add(new SingleItem(argumentType));
    }

    @Override
    public final void addArgument(int type, byte[] content) {
        this.getArgumentsList().add(new ByteArrayArgument(type, this.parameterBufferMetaData.getByteArrayArgumentType(type), content));
    }

    @Override
    public final String getArgumentAsString(int type) {
        List<Argument> argumentsList = this.getArgumentsList();
        for (Argument argument : argumentsList) {
            if (argument.getType() != type) continue;
            return argument.getValueAsString();
        }
        return null;
    }

    @Override
    public final int getArgumentAsInt(int type) {
        List<Argument> argumentsList = this.getArgumentsList();
        for (Argument argument : argumentsList) {
            if (argument.getType() != type) continue;
            return argument.getValueAsInt();
        }
        return 0;
    }

    @Override
    public final boolean hasArgument(int type) {
        List<Argument> argumentsList = this.getArgumentsList();
        for (Argument argument : argumentsList) {
            if (argument.getType() != type) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void removeArgument(int type) {
        List<Argument> argumentsList = this.getArgumentsList();
        int n2 = argumentsList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Argument argument = argumentsList.get(i2);
            if (argument.getType() != type) continue;
            argumentsList.remove(i2);
            return;
        }
    }

    @Override
    public final Iterator<Parameter> iterator() {
        return new ArrayList<Argument>(this.arguments).iterator();
    }

    @Override
    public final void writeArgumentsTo(OutputStream outputStream) throws IOException {
        for (Argument currentArgument : this.arguments) {
            currentArgument.writeTo(outputStream);
        }
    }

    @Override
    public final Xdrable toXdrable() {
        return new ParameterBufferXdrable();
    }

    protected final int getLength() {
        List<Argument> argumentsList = this.getArgumentsList();
        int length = 0;
        for (Argument currentArgument : argumentsList) {
            length += currentArgument.getLength();
        }
        return length;
    }

    protected final List<Argument> getArgumentsList() {
        return this.arguments;
    }

    @Override
    public final byte[] toBytes() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            this.writeArgumentsTo(bout);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bout.toByteArray();
    }

    @Override
    public final byte[] toBytesWithType() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            bout.write(this.getType());
            this.writeArgumentsTo(bout);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bout.toByteArray();
    }

    @Override
    public final int size() {
        return this.arguments.size();
    }

    public final boolean equals(Object other) {
        if (other == null || !this.getClass().isAssignableFrom(other.getClass())) {
            return false;
        }
        ParameterBufferBase otherServiceBufferBase = (ParameterBufferBase)other;
        return otherServiceBufferBase.getArgumentsList().equals(this.getArgumentsList());
    }

    public final int hashCode() {
        return this.getArgumentsList().hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.defaultEncoding = EncodingFactory.getPlatformDefault().getEncodingForCharsetAlias(this.defaultEncodingName);
    }

    private class ParameterBufferXdrable
    implements Xdrable {
        private ParameterBufferXdrable() {
        }

        @Override
        public int getLength() {
            return ParameterBufferBase.this.getLength();
        }

        @Override
        public void read(XdrInputStream inputStream, int length) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void write(XdrOutputStream outputStream) throws IOException {
            ParameterBufferBase.this.writeArgumentsTo((OutputStream)((Object)outputStream));
        }
    }
}

