/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.encodings;

import java.io.UnsupportedEncodingException;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.EncodingFactory;

public abstract class Encoding_OneByte
implements Encoding {
    byte[] bufferB = new byte[128];
    char[] bufferC = new char[128];

    protected static void Initialize(String encoding, char[] byteToChar, byte[] charToByte) {
        Encoding_OneByte.Initialize(encoding, byteToChar, charToByte, EncodingFactory.DEFAULT_MAPPING);
    }

    protected static void Initialize(String encoding, char[] byteToChar, byte[] charToByte, char[] charMapping) {
        byte[] val = new byte[1];
        char[] charArray = null;
        for (int i2 = 0; i2 < 256; ++i2) {
            val[0] = (byte)i2;
            try {
                charArray = new String(val, 0, 1, encoding).toCharArray();
                char ch = charArray[0];
                byteToChar[i2] = charMapping[ch];
                charToByte[byteToChar[i2]] = (byte)i2;
                continue;
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
            }
        }
    }

    public byte[] encodeToCharset(String str) {
        if (this.bufferB.length < str.length()) {
            this.bufferB = new byte[str.length()];
        }
        int length = this.encodeToCharset(str.toCharArray(), 0, str.length(), this.bufferB);
        byte[] result = new byte[length];
        System.arraycopy(this.bufferB, 0, result, 0, length);
        return result;
    }

    public abstract int encodeToCharset(char[] var1, int var2, int var3, byte[] var4);

    public int encodeToCharset(byte[] charToByte, char[] in, int off, int len, byte[] out) {
        for (int i2 = off; i2 < off + len; ++i2) {
            out[i2] = charToByte[in[i2]];
        }
        return len;
    }

    public String decodeFromCharset(byte[] in) {
        if (this.bufferC.length < in.length) {
            this.bufferC = new char[in.length];
        }
        int length = this.decodeFromCharset(in, 0, in.length, this.bufferC);
        return new String(this.bufferC, 0, length);
    }

    public abstract int decodeFromCharset(byte[] var1, int var2, int var3, char[] var4);

    public int decodeFromCharset(char[] byteToChar, byte[] in, int off, int len, char[] out) {
        for (int i2 = off; i2 < off + len; ++i2) {
            out[i2] = byteToChar[in[i2] & 0xFF];
        }
        return len;
    }
}

