/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.encodings;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.firebirdsql.encodings.CharacterTranslator;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.Encoding_Cp1250;
import org.firebirdsql.encodings.Encoding_Cp1251;
import org.firebirdsql.encodings.Encoding_Cp1252;
import org.firebirdsql.encodings.Encoding_Cp1253;
import org.firebirdsql.encodings.Encoding_Cp1254;
import org.firebirdsql.encodings.Encoding_Cp1255;
import org.firebirdsql.encodings.Encoding_Cp1256;
import org.firebirdsql.encodings.Encoding_Cp1257;
import org.firebirdsql.encodings.Encoding_Cp437;
import org.firebirdsql.encodings.Encoding_Cp737;
import org.firebirdsql.encodings.Encoding_Cp775;
import org.firebirdsql.encodings.Encoding_Cp850;
import org.firebirdsql.encodings.Encoding_Cp852;
import org.firebirdsql.encodings.Encoding_Cp857;
import org.firebirdsql.encodings.Encoding_Cp858;
import org.firebirdsql.encodings.Encoding_Cp860;
import org.firebirdsql.encodings.Encoding_Cp861;
import org.firebirdsql.encodings.Encoding_Cp862;
import org.firebirdsql.encodings.Encoding_Cp863;
import org.firebirdsql.encodings.Encoding_Cp864;
import org.firebirdsql.encodings.Encoding_Cp865;
import org.firebirdsql.encodings.Encoding_Cp866;
import org.firebirdsql.encodings.Encoding_Cp869;
import org.firebirdsql.encodings.Encoding_ISO8859_1;
import org.firebirdsql.encodings.Encoding_ISO8859_13;
import org.firebirdsql.encodings.Encoding_ISO8859_2;
import org.firebirdsql.encodings.Encoding_ISO8859_3;
import org.firebirdsql.encodings.Encoding_ISO8859_4;
import org.firebirdsql.encodings.Encoding_ISO8859_5;
import org.firebirdsql.encodings.Encoding_ISO8859_6;
import org.firebirdsql.encodings.Encoding_ISO8859_7;
import org.firebirdsql.encodings.Encoding_ISO8859_8;
import org.firebirdsql.encodings.Encoding_ISO8859_9;
import org.firebirdsql.encodings.Encoding_NotOneByte;

public class EncodingFactory {
    public static final char[] DEFAULT_MAPPING = new char[65536];
    static String defaultEncoding;
    private static final Map translations;

    public static Encoding getEncoding(String encoding, String mappingPath) throws SQLException {
        if (mappingPath == null) {
            return EncodingFactory.getEncoding(encoding);
        }
        CharacterTranslator translator = EncodingFactory.getTranslator(mappingPath);
        return EncodingFactory.getEncoding(encoding, translator.getMapping());
    }

    public static CharacterTranslator getTranslator(String mappingPath) throws SQLException {
        CharacterTranslator translator = (CharacterTranslator)translations.get(mappingPath);
        if (translator == null) {
            translator = new CharacterTranslator();
            translator.init(mappingPath);
            translations.put(mappingPath, translator);
        }
        return translator;
    }

    public static Encoding getEncoding(String encoding) {
        if (encoding == null) {
            encoding = defaultEncoding;
        }
        return EncodingFactory.createEncoding(encoding);
    }

    public static Encoding createEncoding(String encoding) {
        if (encoding.equals("NONE")) {
            encoding = defaultEncoding;
        }
        if (encoding.equals("Cp1250")) {
            return new Encoding_Cp1250();
        }
        if (encoding.equals("Cp1251")) {
            return new Encoding_Cp1251();
        }
        if (encoding.equals("Cp1252")) {
            return new Encoding_Cp1252();
        }
        if (encoding.equals("Cp1253")) {
            return new Encoding_Cp1253();
        }
        if (encoding.equals("Cp1254")) {
            return new Encoding_Cp1254();
        }
        if (encoding.equals("Cp1255")) {
            return new Encoding_Cp1255();
        }
        if (encoding.equals("Cp1256")) {
            return new Encoding_Cp1256();
        }
        if (encoding.equals("Cp1257")) {
            return new Encoding_Cp1257();
        }
        if (encoding.equals("Cp437")) {
            return new Encoding_Cp437();
        }
        if (encoding.equals("Cp737")) {
            return new Encoding_Cp737();
        }
        if (encoding.equals("Cp775")) {
            return new Encoding_Cp775();
        }
        if (encoding.equals("Cp850")) {
            return new Encoding_Cp850();
        }
        if (encoding.equals("Cp852")) {
            return new Encoding_Cp852();
        }
        if (encoding.equals("Cp857")) {
            return new Encoding_Cp857();
        }
        if (encoding.equals("Cp858")) {
            return new Encoding_Cp858();
        }
        if (encoding.equals("Cp860")) {
            return new Encoding_Cp860();
        }
        if (encoding.equals("Cp861")) {
            return new Encoding_Cp861();
        }
        if (encoding.equals("Cp862")) {
            return new Encoding_Cp862();
        }
        if (encoding.equals("Cp863")) {
            return new Encoding_Cp863();
        }
        if (encoding.equals("Cp864")) {
            return new Encoding_Cp864();
        }
        if (encoding.equals("Cp865")) {
            return new Encoding_Cp865();
        }
        if (encoding.equals("Cp866")) {
            return new Encoding_Cp866();
        }
        if (encoding.equals("Cp869")) {
            return new Encoding_Cp869();
        }
        if (encoding.equals("ISO8859_1")) {
            return new Encoding_ISO8859_1();
        }
        if (encoding.equals("ISO8859_2")) {
            return new Encoding_ISO8859_2();
        }
        if (encoding.equals("ISO8859_3")) {
            return new Encoding_ISO8859_3();
        }
        if (encoding.equals("ISO8859_4")) {
            return new Encoding_ISO8859_4();
        }
        if (encoding.equals("ISO8859_5")) {
            return new Encoding_ISO8859_5();
        }
        if (encoding.equals("ISO8859_6")) {
            return new Encoding_ISO8859_6();
        }
        if (encoding.equals("ISO8859_7")) {
            return new Encoding_ISO8859_7();
        }
        if (encoding.equals("ISO8859_8")) {
            return new Encoding_ISO8859_8();
        }
        if (encoding.equals("ISO8859_9")) {
            return new Encoding_ISO8859_9();
        }
        if (encoding.equals("ISO8859_13")) {
            return new Encoding_ISO8859_13();
        }
        return new Encoding_NotOneByte(encoding);
    }

    public static Encoding getEncoding(String encoding, char[] charMapping) {
        if (encoding == null || encoding.equals("NONE")) {
            encoding = defaultEncoding;
        }
        if (encoding.equals("Cp1250")) {
            return new Encoding_Cp1250(charMapping);
        }
        if (encoding.equals("Cp1251")) {
            return new Encoding_Cp1251(charMapping);
        }
        if (encoding.equals("Cp1252")) {
            return new Encoding_Cp1252(charMapping);
        }
        if (encoding.equals("Cp1253")) {
            return new Encoding_Cp1253(charMapping);
        }
        if (encoding.equals("Cp1254")) {
            return new Encoding_Cp1254(charMapping);
        }
        if (encoding.equals("Cp1255")) {
            return new Encoding_Cp1255(charMapping);
        }
        if (encoding.equals("Cp1256")) {
            return new Encoding_Cp1256(charMapping);
        }
        if (encoding.equals("Cp1257")) {
            return new Encoding_Cp1257(charMapping);
        }
        if (encoding.equals("Cp437")) {
            return new Encoding_Cp437(charMapping);
        }
        if (encoding.equals("Cp737")) {
            return new Encoding_Cp737(charMapping);
        }
        if (encoding.equals("Cp775")) {
            return new Encoding_Cp775(charMapping);
        }
        if (encoding.equals("Cp850")) {
            return new Encoding_Cp850(charMapping);
        }
        if (encoding.equals("Cp852")) {
            return new Encoding_Cp852(charMapping);
        }
        if (encoding.equals("Cp857")) {
            return new Encoding_Cp857(charMapping);
        }
        if (encoding.equals("Cp858")) {
            return new Encoding_Cp858(charMapping);
        }
        if (encoding.equals("Cp860")) {
            return new Encoding_Cp860(charMapping);
        }
        if (encoding.equals("Cp861")) {
            return new Encoding_Cp861(charMapping);
        }
        if (encoding.equals("Cp862")) {
            return new Encoding_Cp862(charMapping);
        }
        if (encoding.equals("Cp863")) {
            return new Encoding_Cp863(charMapping);
        }
        if (encoding.equals("Cp864")) {
            return new Encoding_Cp864(charMapping);
        }
        if (encoding.equals("Cp865")) {
            return new Encoding_Cp865(charMapping);
        }
        if (encoding.equals("Cp866")) {
            return new Encoding_Cp866(charMapping);
        }
        if (encoding.equals("Cp869")) {
            return new Encoding_Cp869(charMapping);
        }
        if (encoding.equals("ISO8859_1")) {
            return new Encoding_ISO8859_1(charMapping);
        }
        if (encoding.equals("ISO8859_2")) {
            return new Encoding_ISO8859_2(charMapping);
        }
        if (encoding.equals("ISO8859_3")) {
            return new Encoding_ISO8859_3(charMapping);
        }
        if (encoding.equals("ISO8859_4")) {
            return new Encoding_ISO8859_4(charMapping);
        }
        if (encoding.equals("ISO8859_5")) {
            return new Encoding_ISO8859_5(charMapping);
        }
        if (encoding.equals("ISO8859_6")) {
            return new Encoding_ISO8859_6(charMapping);
        }
        if (encoding.equals("ISO8859_7")) {
            return new Encoding_ISO8859_7(charMapping);
        }
        if (encoding.equals("ISO8859_8")) {
            return new Encoding_ISO8859_8(charMapping);
        }
        if (encoding.equals("ISO8859_9")) {
            return new Encoding_ISO8859_9(charMapping);
        }
        if (encoding.equals("ISO8859_13")) {
            return new Encoding_ISO8859_13(charMapping);
        }
        return new Encoding_NotOneByte(encoding, charMapping);
    }

    static {
        for (int i2 = 0; i2 < DEFAULT_MAPPING.length; ++i2) {
            EncodingFactory.DEFAULT_MAPPING[i2] = (char)i2;
        }
        defaultEncoding = null;
        InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(new byte[2]));
        defaultEncoding = reader.getEncoding();
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        translations = Collections.synchronizedMap(new HashMap());
    }
}

