/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.encodings;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.EncodingDefinition;
import org.firebirdsql.encodings.EncodingGeneric;
import org.firebirdsql.encodings.EncodingSingleByte;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public final class DefaultEncodingDefinition
implements EncodingDefinition {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEncodingDefinition.class);
    private static final Encoding NOT_INITIALIZED = new EncodingGeneric(null);
    private final String charsetName;
    private final String firebirdEncodingName;
    private final int maxBytesPerChar;
    private final int firebirdCharacterSetId;
    private final boolean firebirdOnly;
    private Encoding encoding = NOT_INITIALIZED;
    private Charset charset;

    public DefaultEncodingDefinition(String firebirdEncodingName, Charset charset, int maxBytesPerChar, int firebirdCharacterSetId, boolean firebirdOnly) {
        this(firebirdEncodingName, charset != null ? charset.name() : null, maxBytesPerChar, firebirdCharacterSetId, firebirdOnly);
        this.charset = charset;
    }

    public DefaultEncodingDefinition(String firebirdEncodingName, String charsetName, int maxBytesPerChar, int firebirdCharacterSetId, boolean firebirdOnly) {
        this.firebirdEncodingName = firebirdEncodingName;
        this.charsetName = charsetName;
        if (charsetName == null) {
            this.encoding = null;
        }
        this.maxBytesPerChar = maxBytesPerChar;
        this.firebirdOnly = firebirdOnly;
        this.firebirdCharacterSetId = firebirdCharacterSetId;
    }

    @Override
    public int getMaxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    @Override
    public String getJavaEncodingName() {
        return this.charsetName;
    }

    @Override
    public Charset getJavaCharset() {
        if (this.charset == null && this.encoding == NOT_INITIALIZED) {
            this.initCharset();
        }
        return this.charset;
    }

    @Override
    public String getFirebirdEncodingName() {
        return this.firebirdEncodingName;
    }

    @Override
    public int getFirebirdCharacterSetId() {
        return this.firebirdCharacterSetId;
    }

    @Override
    public boolean isFirebirdOnly() {
        return this.firebirdOnly;
    }

    @Override
    public boolean isInformationOnly() {
        return this.charsetName == null || this.getJavaCharset() == null;
    }

    @Override
    public Encoding getEncoding() {
        if (this.encoding == NOT_INITIALIZED) {
            this.initEncoding();
        }
        return this.encoding;
    }

    public String toString() {
        return "[firebirdEncodingName='" + this.getFirebirdEncodingName() + "',javaEncodingName='" + this.getJavaEncodingName() + "',maxBytesPerChar=" + this.getMaxBytesPerChar() + ",firebirdOnly=" + this.isFirebirdOnly() + ",firebirdCharacterSetId=" + this.getFirebirdCharacterSetId() + "]";
    }

    private void initCharset() {
        try {
            this.charset = Charset.forName(this.charsetName);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e2) {
            this.encoding = null;
            logger.warn(String.format("charsetName=\"%s\" specified for Firebird encoding \"%s\" is an illegal or unsupported character set name, handling as information-only", this.charsetName, this.firebirdEncodingName), e2);
        }
    }

    private void initEncoding() {
        this.encoding = this.isInformationOnly() ? null : (this.getMaxBytesPerChar() == 1 && (!"NONE".equals(this.firebirdEncodingName) || !StandardCharsets.UTF_8.equals(this.getJavaCharset())) ? new EncodingSingleByte(this.getJavaCharset()) : new EncodingGeneric(this.getJavaCharset()));
    }
}

